/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexgenerator;

import cc.redberry.core.indexgenerator.IndexGenerator;
import cc.redberry.core.indexgenerator.IntGenerator;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesUtils;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.procedure.TByteObjectProcedure;
import java.util.Arrays;

public final class IndexGeneratorImpl
implements IndexGenerator {
    protected TByteObjectHashMap<IntGenerator> generators = new TByteObjectHashMap();

    public IndexGeneratorImpl() {
    }

    public IndexGeneratorImpl(Indices indices) {
        this(indices.getAllIndices().copy());
    }

    protected IndexGeneratorImpl(TByteObjectHashMap<IntGenerator> generators) {
        this.generators = generators;
    }

    public IndexGeneratorImpl(int[] indices) {
        if (indices.length == 0) {
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = IndicesUtils.getNameWithType(indices[i]);
        }
        Arrays.sort(indices);
        byte type = IndicesUtils.getType(indices[0]);
        indices[0] = IndicesUtils.getNameWithoutType(indices[0]);
        int prevIndex = 0;
        for (int i = 1; i < indices.length; ++i) {
            if (IndicesUtils.getType(indices[i]) != type) {
                this.generators.put(type, (Object)new IntGenerator(Arrays.copyOfRange(indices, prevIndex, i)));
                prevIndex = i;
                type = IndicesUtils.getType(indices[i]);
            }
            indices[i] = IndicesUtils.getNameWithoutType(indices[i]);
        }
        this.generators.put(type, (Object)new IntGenerator(Arrays.copyOfRange(indices, prevIndex, indices.length)));
    }

    public boolean contains(int index) {
        byte type = IndicesUtils.getType(index);
        IntGenerator intGen = (IntGenerator)this.generators.get(type);
        if (intGen == null) {
            return false;
        }
        return intGen.contains(IndicesUtils.getNameWithoutType(index));
    }

    public void mergeFrom(IndexGeneratorImpl other) {
        other.generators.forEachEntry((TByteObjectProcedure)new TByteObjectProcedure<IntGenerator>(){

            public boolean execute(byte a, IntGenerator b) {
                IntGenerator thisGenerator = (IntGenerator)IndexGeneratorImpl.this.generators.get(a);
                if (thisGenerator == null) {
                    IndexGeneratorImpl.this.generators.put(a, (Object)b.clone());
                } else {
                    thisGenerator.mergeFrom(b);
                }
                return true;
            }
        });
    }

    public int generate(IndexType type) {
        return this.generate(type.getType());
    }

    @Override
    public int generate(byte type) {
        IntGenerator ig = (IntGenerator)this.generators.get(type);
        if (ig == null) {
            ig = new IntGenerator();
            this.generators.put(type, (Object)ig);
        }
        return IndicesUtils.setType(type, ig.getNext());
    }

    public IndexGeneratorImpl clone() {
        final TByteObjectHashMap newMap = new TByteObjectHashMap(this.generators.size());
        this.generators.forEachEntry((TByteObjectProcedure)new TByteObjectProcedure<IntGenerator>(){

            public boolean execute(byte a, IntGenerator b) {
                newMap.put(a, (Object)b.clone());
                return true;
            }
        });
        return new IndexGeneratorImpl((TByteObjectHashMap<IntGenerator>)newMap);
    }
}

