/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.groups.permutations.InconsistentGeneratorsException;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.PermutationOneLineInt;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArray;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PermutationOneLineShort
implements Permutation {
    final short[] permutation;
    final short internalDegree;
    final boolean isIdentity;
    final boolean antisymmetry;

    public PermutationOneLineShort(boolean antisymmetry, short ... permutation) {
        if (!Permutations.testPermutationCorrectness(permutation, antisymmetry)) {
            throw new IllegalArgumentException("Inconsistent permutation.");
        }
        this.permutation = (short[])permutation.clone();
        this.antisymmetry = antisymmetry;
        this.isIdentity = Permutations.isIdentity(permutation);
        this.internalDegree = Permutations.internalDegree(permutation);
    }

    PermutationOneLineShort(boolean isIdentity, boolean antisymmetry, short internalDegree, short[] permutation) {
        this.isIdentity = isIdentity;
        this.permutation = permutation;
        this.antisymmetry = antisymmetry;
        this.internalDegree = internalDegree;
        if (antisymmetry && Permutations.orderOfPermutationIsOdd(permutation)) {
            throw new InconsistentGeneratorsException();
        }
    }

    PermutationOneLineShort(boolean isIdentity, boolean antisymmetry, short internalDegree, short[] permutation, boolean identity) {
        assert (identity);
        this.permutation = permutation;
        this.antisymmetry = antisymmetry;
        this.isIdentity = isIdentity;
        this.internalDegree = internalDegree;
    }

    public PermutationOneLineInt toIntRepresentation() {
        return new PermutationOneLineInt(this.isIdentity, this.antisymmetry, (int)this.internalDegree, ArraysUtils.short2int(this.permutation), true);
    }

    @Override
    public int length() {
        return this.permutation.length;
    }

    @Override
    public boolean antisymmetry() {
        return this.antisymmetry;
    }

    @Override
    public Permutation toSymmetry() {
        return this.antisymmetry ? new PermutationOneLineShort(this.isIdentity, false, this.internalDegree, this.permutation, true) : this;
    }

    @Override
    public PermutationOneLineShort negate() {
        return new PermutationOneLineShort(false, this.antisymmetry ^ true, this.internalDegree, this.permutation);
    }

    @Override
    public int[] oneLine() {
        return ArraysUtils.short2int(this.permutation);
    }

    @Override
    public IntArray oneLineImmutable() {
        return new IntArray(ArraysUtils.short2int(this.permutation));
    }

    @Override
    public int[][] cycles() {
        return Permutations.convertOneLineToCycles(this.permutation);
    }

    @Override
    public int newIndexOf(int i) {
        return i < this.internalDegree ? this.permutation[i] : i;
    }

    @Override
    public int imageOf(int i) {
        return i < this.internalDegree ? this.permutation[i] : i;
    }

    @Override
    public int[] imageOf(int[] set) {
        if (this.isIdentity) {
            return (int[])set.clone();
        }
        int[] result = new int[set.length];
        for (int i = 0; i < set.length; ++i) {
            result[i] = this.newIndexOf(set[i]);
        }
        return result;
    }

    @Override
    public int[] permute(int[] array) {
        if (this.isIdentity) {
            return (int[])array.clone();
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[this.newIndexOf(i)];
        }
        return result;
    }

    @Override
    public char[] permute(char[] array) {
        if (this.isIdentity) {
            return (char[])array.clone();
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[this.newIndexOf(i)];
        }
        return result;
    }

    @Override
    public <T> T[] permute(T[] array) {
        if (this.isIdentity) {
            return (Object[])array.clone();
        }
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[this.newIndexOf(i)];
        }
        return result;
    }

    @Override
    public <T> List<T> permute(List<T> set) {
        if (this.isIdentity) {
            return new ArrayList<T>(set);
        }
        ArrayList<T> list = new ArrayList<T>(set.size());
        for (int i = 0; i < set.size(); ++i) {
            list.add(set.get(this.newIndexOf(i)));
        }
        return list;
    }

    @Override
    public int newIndexOfUnderInverse(int i) {
        if (i >= this.permutation.length) {
            return i;
        }
        for (int j = this.permutation.length - 1; j >= 0; --j) {
            if (this.permutation[j] != i) continue;
            return j;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Permutation conjugate(Permutation p) {
        return this.inverse().composition(p, this);
    }

    @Override
    public Permutation commutator(Permutation p) {
        return this.inverse().composition(p.inverse(), this, p);
    }

    @Override
    public Permutation composition(Permutation other) {
        if (this.isIdentity) {
            return other;
        }
        if (other.isIdentity()) {
            return this;
        }
        short newLength = Math.max(this.degree(), other.degree());
        if (newLength > Short.MAX_VALUE) {
            return this.toIntRepresentation().composition(other);
        }
        short newInternalDegree = -1;
        short[] result = new short[newLength];
        boolean resultIsIdentity = true;
        for (short i = 0; i < newLength; i = (short)((short)(i + 1))) {
            result[i] = (short)other.newIndexOf(this.newIndexOf(i));
            resultIsIdentity &= result[i] == i;
            newInternalDegree = result[i] == i ? newInternalDegree : i;
        }
        try {
            return new PermutationOneLineShort(resultIsIdentity, this.antisymmetry ^ other.antisymmetry(), (short)(newInternalDegree + 1), result);
        }
        catch (InconsistentGeneratorsException ex) {
            throw new InconsistentGeneratorsException(this + " and " + other);
        }
    }

    @Override
    public Permutation composition(Permutation a, Permutation b) {
        if (this.isIdentity) {
            return a.composition(b);
        }
        if (a.isIdentity()) {
            return this.composition(b);
        }
        if (b.isIdentity()) {
            return this.composition(a);
        }
        short newLength = Math.max(Math.max(this.degree(), a.degree()), b.degree());
        if (newLength > Short.MAX_VALUE) {
            return this.toIntRepresentation().composition(a, b);
        }
        short newInternalDegree = -1;
        short[] result = new short[newLength];
        boolean resultIsIdentity = true;
        for (short i = 0; i < newLength; i = (short)((short)(i + 1))) {
            result[i] = (short)b.newIndexOf(a.newIndexOf(this.newIndexOf(i)));
            resultIsIdentity &= result[i] == i;
            newInternalDegree = result[i] == i ? newInternalDegree : i;
        }
        try {
            return new PermutationOneLineShort(resultIsIdentity, this.antisymmetry ^ a.antisymmetry() ^ b.antisymmetry(), (short)(newInternalDegree + 1), result);
        }
        catch (InconsistentGeneratorsException ex) {
            throw new InconsistentGeneratorsException(this + " and " + a + " and " + b);
        }
    }

    @Override
    public Permutation composition(Permutation a, Permutation b, Permutation c) {
        if (this.isIdentity) {
            return a.composition(b, c);
        }
        if (a.isIdentity()) {
            return this.composition(b, c);
        }
        if (b.isIdentity()) {
            return this.composition(a, c);
        }
        if (c.isIdentity()) {
            return this.composition(b, c);
        }
        short newLength = Math.max(c.degree(), Math.max(Math.max(this.degree(), a.degree()), b.degree()));
        if (newLength > Short.MAX_VALUE) {
            return this.toIntRepresentation().composition(a, b, c);
        }
        short[] result = new short[newLength];
        short newInternalDegree = -1;
        boolean resultIsIdentity = true;
        for (short i = 0; i < newLength; i = (short)((short)(i + 1))) {
            result[i] = (short)c.newIndexOf(b.newIndexOf(a.newIndexOf(this.newIndexOf(i))));
            resultIsIdentity &= result[i] == i;
            newInternalDegree = result[i] == i ? newInternalDegree : i;
        }
        try {
            return new PermutationOneLineShort(resultIsIdentity, this.antisymmetry ^ a.antisymmetry() ^ b.antisymmetry() ^ c.antisymmetry(), (short)(newInternalDegree + 1), result);
        }
        catch (InconsistentGeneratorsException ex) {
            throw new InconsistentGeneratorsException(this + " and " + a + " and " + b + " and " + c);
        }
    }

    @Override
    public Permutation compositionWithInverse(Permutation other) {
        if (this.isIdentity) {
            return other.inverse();
        }
        if (other.isIdentity()) {
            return this;
        }
        return this.composition(other.inverse());
    }

    @Override
    public Permutation inverse() {
        if (this.isIdentity) {
            return this;
        }
        short[] inv = new short[this.permutation.length];
        for (short i = (short)(this.permutation.length - 1); i >= 0; i = (short)(i - 1)) {
            inv[this.permutation[i]] = i;
        }
        return new PermutationOneLineShort(false, this.antisymmetry, this.internalDegree, inv, true);
    }

    @Override
    public boolean isIdentity() {
        return this.isIdentity;
    }

    @Override
    public Permutation getIdentity() {
        if (this.isIdentity) {
            return this;
        }
        return Permutations.createIdentityPermutation(this.permutation.length);
    }

    @Override
    public BigInteger order() {
        return Permutations.orderOfPermutation(this.permutation);
    }

    @Override
    public boolean orderIsOdd() {
        return !this.isIdentity && Permutations.orderOfPermutationIsOdd(this.permutation);
    }

    @Override
    public int degree() {
        return this.internalDegree;
    }

    @Override
    public Permutation pow(int exponent) {
        if (this.isIdentity) {
            return this;
        }
        if (exponent < 0) {
            return this.inverse().pow(-exponent);
        }
        Permutation base = this;
        Permutation result = this.getIdentity();
        while (exponent != 0) {
            if (exponent % 2 == 1) {
                result = result.composition(base);
            }
            base = base.composition(base);
            exponent >>= 1;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Permutation)) {
            return false;
        }
        Permutation that = (Permutation)o;
        if (this.antisymmetry != that.antisymmetry()) {
            return false;
        }
        if (this.internalDegree != that.degree()) {
            return false;
        }
        for (int i = 0; i < this.internalDegree; ++i) {
            if (this.newIndexOf(i) == that.newIndexOf(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.internalDegree; ++i) {
            result = 31 * result + this.permutation[i];
        }
        result = 31 * result + (this.antisymmetry ? 1 : 0);
        return result;
    }

    @Override
    public int parity() {
        return Permutations.parity(this.permutation);
    }

    @Override
    public Permutation moveRight(int size) {
        int i;
        if (size == 0) {
            return this;
        }
        if (size + this.permutation.length > Short.MAX_VALUE) {
            return this.toIntRepresentation().moveRight(size);
        }
        short[] p = new short[size + this.permutation.length];
        for (i = 1; i < size; i = (int)((short)(i + 1))) {
            p[i] = i;
        }
        int k = i;
        while (i < p.length) {
            p[i] = (short)(this.permutation[i - k] + size);
            i = (short)(i + 1);
        }
        return new PermutationOneLineShort(this.isIdentity, this.antisymmetry, (short)(size + this.internalDegree), p, true);
    }

    @Override
    public int[] lengthsOfCycles() {
        return Permutations.lengthsOfCycles(this.permutation);
    }

    public String toString() {
        return this.toStringCycles();
    }

    @Override
    public String toStringOneLine() {
        return (this.antisymmetry ? "-" : "+") + Arrays.toString(this.permutation);
    }

    @Override
    public String toStringCycles() {
        String cycles = Arrays.deepToString((Object[])this.cycles());
        return (this.antisymmetry ? "-" : "+") + cycles;
    }

    @Override
    public int compareTo(Permutation t) {
        int max = Math.max(this.degree(), t.degree());
        if (this.antisymmetry != t.antisymmetry()) {
            return this.antisymmetry ? -1 : 1;
        }
        for (int i = 0; i < max; ++i) {
            if (this.newIndexOf(i) < t.newIndexOf(i)) {
                return -1;
            }
            if (this.newIndexOf(i) <= t.newIndexOf(i)) continue;
            return 1;
        }
        return 0;
    }
}

