/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.groups.permutations.InconsistentGeneratorsException;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.PermutationOneLineInt;
import cc.redberry.core.groups.permutations.PermutationOneLineShort;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArray;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PermutationOneLineByte
implements Permutation {
    final byte[] permutation;
    final byte internalDegree;
    final boolean isIdentity;
    final boolean antisymmetry;

    public PermutationOneLineByte(boolean antisymmetry, byte ... permutation) {
        if (!Permutations.testPermutationCorrectness(permutation, antisymmetry)) {
            throw new IllegalArgumentException("Inconsistent permutation.");
        }
        this.permutation = (byte[])permutation.clone();
        this.antisymmetry = antisymmetry;
        this.isIdentity = Permutations.isIdentity(permutation);
        this.internalDegree = Permutations.internalDegree(permutation);
    }

    PermutationOneLineByte(boolean isIdentity, boolean antisymmetry, byte internalDegree, byte[] permutation) {
        this.isIdentity = isIdentity;
        this.permutation = permutation;
        this.antisymmetry = antisymmetry;
        this.internalDegree = internalDegree;
        if (antisymmetry && Permutations.orderOfPermutationIsOdd(permutation)) {
            throw new InconsistentGeneratorsException();
        }
    }

    PermutationOneLineByte(boolean isIdentity, boolean antisymmetry, byte internalDegree, byte[] permutation, boolean identity) {
        assert (identity);
        this.permutation = permutation;
        this.antisymmetry = antisymmetry;
        this.isIdentity = isIdentity;
        this.internalDegree = internalDegree;
    }

    public PermutationOneLineInt toIntRepresentation() {
        return new PermutationOneLineInt(this.isIdentity, this.antisymmetry, (int)this.internalDegree, ArraysUtils.byte2int(this.permutation), true);
    }

    public PermutationOneLineShort toShortRepresentation() {
        return new PermutationOneLineShort(this.isIdentity, this.antisymmetry, (short)this.internalDegree, ArraysUtils.byte2short(this.permutation), true);
    }

    public Permutation toLargerRepresentation(int newLength) {
        if (newLength <= Short.MAX_VALUE) {
            return this.toShortRepresentation();
        }
        return this.toIntRepresentation();
    }

    @Override
    public int length() {
        return this.permutation.length;
    }

    @Override
    public boolean antisymmetry() {
        return this.antisymmetry;
    }

    @Override
    public Permutation toSymmetry() {
        return this.antisymmetry ? new PermutationOneLineByte(this.isIdentity, false, this.internalDegree, this.permutation, true) : this;
    }

    @Override
    public PermutationOneLineByte negate() {
        return new PermutationOneLineByte(false, this.antisymmetry ^ true, this.internalDegree, this.permutation);
    }

    @Override
    public int[] oneLine() {
        return ArraysUtils.byte2int(this.permutation);
    }

    @Override
    public IntArray oneLineImmutable() {
        return new IntArray(ArraysUtils.byte2int(this.permutation));
    }

    @Override
    public int[][] cycles() {
        return Permutations.convertOneLineToCycles(this.permutation);
    }

    @Override
    public int newIndexOf(int i) {
        return i < this.internalDegree ? this.permutation[i] : i;
    }

    @Override
    public int imageOf(int i) {
        return i < this.internalDegree ? this.permutation[i] : i;
    }

    @Override
    public int[] imageOf(int[] set) {
        if (this.isIdentity) {
            return (int[])set.clone();
        }
        int[] result = new int[set.length];
        for (int i = 0; i < set.length; ++i) {
            result[i] = this.newIndexOf(set[i]);
        }
        return result;
    }

    @Override
    public int[] permute(int[] array) {
        if (this.isIdentity) {
            return (int[])array.clone();
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[this.newIndexOf(i)];
        }
        return result;
    }

    @Override
    public char[] permute(char[] array) {
        if (this.isIdentity) {
            return (char[])array.clone();
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[this.newIndexOf(i)];
        }
        return result;
    }

    @Override
    public <T> T[] permute(T[] array) {
        if (this.isIdentity) {
            return (Object[])array.clone();
        }
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[this.newIndexOf(i)];
        }
        return result;
    }

    @Override
    public <T> List<T> permute(List<T> set) {
        if (this.isIdentity) {
            return new ArrayList<T>(set);
        }
        ArrayList<T> list = new ArrayList<T>(set.size());
        for (int i = 0; i < set.size(); ++i) {
            list.add(set.get(this.newIndexOf(i)));
        }
        return list;
    }

    @Override
    public int newIndexOfUnderInverse(int i) {
        if (i >= this.permutation.length) {
            return i;
        }
        for (int j = this.permutation.length - 1; j >= 0; --j) {
            if (this.permutation[j] != i) continue;
            return j;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Permutation conjugate(Permutation p) {
        return this.inverse().composition(p, this);
    }

    @Override
    public Permutation commutator(Permutation p) {
        return this.inverse().composition(p.inverse(), this, p);
    }

    @Override
    public Permutation composition(Permutation other) {
        if (this.isIdentity) {
            return other;
        }
        if (other.isIdentity()) {
            return this;
        }
        byte newLength = Math.max(this.degree(), other.degree());
        if (newLength > 127) {
            return this.toLargerRepresentation(newLength).composition(other);
        }
        byte newInternalDegree = -1;
        byte[] result = new byte[newLength];
        boolean resultIsIdentity = true;
        for (byte i = 0; i < newLength; i = (byte)((byte)(i + 1))) {
            result[i] = (byte)other.newIndexOf(this.newIndexOf(i));
            resultIsIdentity &= result[i] == i;
            newInternalDegree = result[i] == i ? newInternalDegree : i;
        }
        try {
            return new PermutationOneLineByte(resultIsIdentity, this.antisymmetry ^ other.antisymmetry(), (byte)(newInternalDegree + 1), result);
        }
        catch (InconsistentGeneratorsException ex) {
            throw new InconsistentGeneratorsException(this + " and " + other);
        }
    }

    @Override
    public Permutation composition(Permutation a, Permutation b) {
        if (this.isIdentity) {
            return a.composition(b);
        }
        if (a.isIdentity()) {
            return this.composition(b);
        }
        if (b.isIdentity()) {
            return this.composition(a);
        }
        byte newLength = Math.max(Math.max(this.degree(), a.degree()), b.degree());
        if (newLength > 127) {
            return this.toLargerRepresentation(newLength).composition(a, b);
        }
        byte newInternalDegree = -1;
        byte[] result = new byte[newLength];
        boolean resultIsIdentity = true;
        for (byte i = 0; i < newLength; i = (byte)((byte)(i + 1))) {
            result[i] = (byte)b.newIndexOf(a.newIndexOf(this.newIndexOf(i)));
            resultIsIdentity &= result[i] == i;
            newInternalDegree = result[i] == i ? newInternalDegree : i;
        }
        try {
            return new PermutationOneLineByte(resultIsIdentity, this.antisymmetry ^ a.antisymmetry() ^ b.antisymmetry(), (byte)(newInternalDegree + 1), result);
        }
        catch (InconsistentGeneratorsException ex) {
            throw new InconsistentGeneratorsException(this + " and " + a + " and " + b);
        }
    }

    @Override
    public Permutation composition(Permutation a, Permutation b, Permutation c) {
        if (this.isIdentity) {
            return a.composition(b, c);
        }
        if (a.isIdentity()) {
            return this.composition(b, c);
        }
        if (b.isIdentity()) {
            return this.composition(a, c);
        }
        if (c.isIdentity()) {
            return this.composition(b, c);
        }
        byte newLength = Math.max(c.degree(), Math.max(Math.max(this.degree(), a.degree()), b.degree()));
        if (newLength > 127) {
            return this.toLargerRepresentation(newLength).composition(a, b, c);
        }
        byte[] result = new byte[newLength];
        byte newInternalDegree = -1;
        boolean resultIsIdentity = true;
        for (byte i = 0; i < newLength; i = (byte)((byte)(i + 1))) {
            result[i] = (byte)c.newIndexOf(b.newIndexOf(a.newIndexOf(this.newIndexOf(i))));
            resultIsIdentity &= result[i] == i;
            newInternalDegree = result[i] == i ? newInternalDegree : i;
        }
        try {
            return new PermutationOneLineByte(resultIsIdentity, this.antisymmetry ^ a.antisymmetry() ^ b.antisymmetry() ^ c.antisymmetry(), (byte)(newInternalDegree + 1), result);
        }
        catch (InconsistentGeneratorsException ex) {
            throw new InconsistentGeneratorsException(this + " and " + a + " and " + b + " and " + c);
        }
    }

    @Override
    public Permutation compositionWithInverse(Permutation other) {
        if (this.isIdentity) {
            return other.inverse();
        }
        if (other.isIdentity()) {
            return this;
        }
        return this.composition(other.inverse());
    }

    @Override
    public Permutation inverse() {
        if (this.isIdentity) {
            return this;
        }
        byte[] inv = new byte[this.permutation.length];
        for (byte i = (byte)(this.permutation.length - 1); i >= 0; i = (byte)(i - 1)) {
            inv[this.permutation[i]] = i;
        }
        return new PermutationOneLineByte(false, this.antisymmetry, this.internalDegree, inv, true);
    }

    @Override
    public boolean isIdentity() {
        return this.isIdentity;
    }

    @Override
    public Permutation getIdentity() {
        if (this.isIdentity) {
            return this;
        }
        return Permutations.createIdentityPermutation(this.permutation.length);
    }

    @Override
    public BigInteger order() {
        return Permutations.orderOfPermutation(this.permutation);
    }

    @Override
    public boolean orderIsOdd() {
        return !this.isIdentity && Permutations.orderOfPermutationIsOdd(this.permutation);
    }

    @Override
    public int degree() {
        return this.internalDegree;
    }

    @Override
    public Permutation pow(int exponent) {
        if (this.isIdentity) {
            return this;
        }
        if (exponent < 0) {
            return this.inverse().pow(-exponent);
        }
        Permutation base = this;
        Permutation result = this.getIdentity();
        while (exponent != 0) {
            if (exponent % 2 == 1) {
                result = result.composition(base);
            }
            base = base.composition(base);
            exponent >>= 1;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Permutation)) {
            return false;
        }
        Permutation that = (Permutation)o;
        if (this.antisymmetry != that.antisymmetry()) {
            return false;
        }
        if (this.internalDegree != that.degree()) {
            return false;
        }
        for (int i = 0; i < this.internalDegree; ++i) {
            if (this.newIndexOf(i) == that.newIndexOf(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.internalDegree; ++i) {
            result = 31 * result + this.permutation[i];
        }
        result = 31 * result + (this.antisymmetry ? 1 : 0);
        return result;
    }

    @Override
    public int parity() {
        return Permutations.parity(this.permutation);
    }

    @Override
    public Permutation moveRight(int size) {
        int i;
        if (size == 0) {
            return this;
        }
        if (size + this.permutation.length > 127) {
            return this.toIntRepresentation().moveRight(size);
        }
        byte[] p = new byte[size + this.permutation.length];
        for (i = 1; i < size; i = (int)((byte)(i + 1))) {
            p[i] = i;
        }
        int k = i;
        while (i < p.length) {
            p[i] = (byte)(this.permutation[i - k] + size);
            i = (byte)(i + 1);
        }
        return new PermutationOneLineByte(this.isIdentity, this.antisymmetry, (byte)(size + this.internalDegree), p, true);
    }

    @Override
    public int[] lengthsOfCycles() {
        return Permutations.lengthsOfCycles(this.permutation);
    }

    public String toString() {
        return this.toStringCycles();
    }

    @Override
    public String toStringOneLine() {
        return (this.antisymmetry ? "-" : "+") + Arrays.toString(this.permutation);
    }

    @Override
    public String toStringCycles() {
        String cycles = Arrays.deepToString((Object[])this.cycles());
        return (this.antisymmetry ? "-" : "+") + cycles;
    }

    @Override
    public int compareTo(Permutation t) {
        int max = Math.max(this.degree(), t.degree());
        if (this.antisymmetry != t.antisymmetry()) {
            return this.antisymmetry ? -1 : 1;
        }
        for (int i = 0; i < max; ++i) {
            if (this.newIndexOf(i) < t.newIndexOf(i)) {
                return -1;
            }
            if (this.newIndexOf(i) <= t.newIndexOf(i)) continue;
            return 1;
        }
        return 0;
    }
}

