/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.groups.permutations.AlgorithmsBase;
import cc.redberry.core.groups.permutations.BSGSCandidateElement;
import cc.redberry.core.groups.permutations.BSGSElement;
import cc.redberry.core.groups.permutations.BacktrackSearchPayload;
import cc.redberry.core.groups.permutations.BacktrackSearchTestFunction;
import cc.redberry.core.groups.permutations.InducedOrdering;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.Indicator;
import cc.redberry.core.utils.IntArrayList;
import java.util.ArrayList;
import java.util.List;

public final class AlgorithmsBacktrack {
    static long[] ____VISITED_NODES___ = new long[]{0L};

    private AlgorithmsBacktrack() {
    }

    public static void subgroupSearch(List<? extends BSGSElement> group, ArrayList<BSGSCandidateElement> subgroup, BacktrackSearchTestFunction testFunction, Indicator<Permutation> property) {
        AlgorithmsBacktrack.subgroupSearchWithPayload(group, subgroup, BacktrackSearchPayload.createDefaultPayload(testFunction), property);
    }

    public static void subgroupSearchWithPayload(List<? extends BSGSElement> group, ArrayList<BSGSCandidateElement> subgroup, BacktrackSearchPayload payload, Indicator<Permutation> property) {
        int[] base = AlgorithmsBase.getBaseAsArray(group);
        InducedOrdering ordering = new InducedOrdering(base);
        AlgorithmsBacktrack.subgroupSearchWithPayload(group, subgroup, payload, property, base, ordering);
    }

    public static void subgroupSearch(List<? extends BSGSElement> group, ArrayList<BSGSCandidateElement> subgroup, BacktrackSearchTestFunction testFunction, Indicator<Permutation> property, int[] base, InducedOrdering ordering) {
        AlgorithmsBacktrack.subgroupSearchWithPayload(group, subgroup, BacktrackSearchPayload.createDefaultPayload(testFunction), property, base, ordering);
    }

    public static void subgroupSearchWithPayload(List<? extends BSGSElement> group, ArrayList<BSGSCandidateElement> subgroup, BacktrackSearchPayload payload, Indicator<Permutation> property, int[] base, InducedOrdering ordering) {
        if (group.size() == 0 || group.get((int)0).stabilizerGenerators.isEmpty()) {
            throw new IllegalArgumentException("Empty group.");
        }
        AlgorithmsBacktrack.____VISITED_NODES___[0] = 0L;
        int degree = group.get(0).internalDegree();
        if (!subgroup.isEmpty() && subgroup.get(0).internalDegree() > degree) {
            throw new IllegalArgumentException("Specified subgroup is not a subgroup of specified group.");
        }
        int size = group.size();
        Permutation identity = group.get((int)0).stabilizerGenerators.get(0).getIdentity();
        if (subgroup.isEmpty()) {
            subgroup.add(new BSGSCandidateElement(base[0], new ArrayList<Permutation>(), degree));
        }
        int level = size - 1;
        Permutation[] word = new Permutation[size];
        int[][] cachedSortedOrbits = new int[size][];
        int[][] sortedOrbits = new int[size][];
        for (int i = 0; i < size; ++i) {
            cachedSortedOrbits[i] = group.get((int)i).orbitList.toArray();
            ArraysUtils.quickSort(cachedSortedOrbits[i], ordering);
            sortedOrbits[i] = cachedSortedOrbits[i];
            word[i] = identity;
        }
        payload.setWordReference(word);
        int[] tuple = new int[size];
        AlgorithmsBacktrack.rebaseWithRedundancy(subgroup, base, degree);
        int subgroupLevel = level;
        ArrayList<BSGSCandidateElement> subgroup_rebase = AlgorithmsBase.clone(subgroup);
        int[] maxImages = new int[size];
        maxImages[level] = ordering.minElement();
        int[] maxRepresentative = new int[size];
        maxRepresentative[level] = subgroup.get(level).orbitSize() <= 1 ? Integer.MAX_VALUE : sortedOrbits[level][sortedOrbits[level].length - subgroup.get(level).orbitSize() + 1];
        while (true) {
            int image = word[level].newIndexOf(base[level]);
            AlgorithmsBacktrack.replaceBasePointWithRedundancy(subgroup_rebase, level, image);
            while (level < size - 1 && AlgorithmsBacktrack.isMinimalInOrbit(subgroup_rebase.get((int)level).orbitList, image, ordering) && ordering.compare(image, maxImages[level]) > 0 && ordering.compare(image, maxRepresentative[level]) < 0 && payload.test(word[level], level)) {
                payload.beforeLevelIncrement(level);
                assert (AlgorithmsBacktrack.assertPartialBaseImage(level, word, base, subgroup_rebase));
                if (word[++level - 1].isIdentity()) {
                    sortedOrbits[level] = cachedSortedOrbits[level];
                } else {
                    sortedOrbits[level] = word[level - 1].imageOf(group.get((int)level).orbitList.toArray());
                    ArraysUtils.quickSort(sortedOrbits[level], ordering);
                }
                int max = ordering.minElement();
                for (int j = 0; j < level; ++j) {
                    if (!subgroup.get(j).belongsToOrbit(base[level])) continue;
                    max = ordering.max(max, word[j].newIndexOf(base[j]));
                }
                maxImages[level] = max;
                maxRepresentative[level] = subgroup.get(level).orbitSize() <= 1 ? Integer.MAX_VALUE : sortedOrbits[level][sortedOrbits[level].length - subgroup.get(level).orbitSize() + 1];
                tuple[level] = 0;
                word[level] = group.get(level).getTransversalOf(word[level - 1].newIndexOfUnderInverse(sortedOrbits[level][tuple[level]])).composition(word[level - 1]);
                image = word[level].newIndexOf(base[level]);
                AlgorithmsBacktrack.replaceBasePointWithRedundancy(subgroup_rebase, level, image);
                payload.afterLevelIncrement(level);
            }
            ____VISITED_NODES___[0] = ____VISITED_NODES___[0] + 1L;
            if (level == size - 1 && AlgorithmsBacktrack.isMinimalInOrbit(subgroup_rebase.get((int)level).orbitList, image, ordering) && ordering.compare(image, maxImages[level]) > 0 && ordering.compare(image, maxRepresentative[level]) < 0 && payload.test(word[level], level) && property.is(word[level])) {
                if (!AlgorithmsBase.membershipTest(subgroup, word[level])) {
                    subgroup.get(0).addStabilizer(word[level]);
                    AlgorithmsBase.SchreierSimsAlgorithm(subgroup);
                    subgroup_rebase = AlgorithmsBase.clone(subgroup);
                }
                level = subgroupLevel;
            }
            while (level >= 0 && tuple[level] == group.get((int)level).orbitList.size() - 1) {
                --level;
            }
            if (level == -1) {
                return;
            }
            if (level < subgroupLevel) {
                subgroupLevel = level;
                tuple[level] = 0;
                maxImages[level] = ordering.minElement();
                maxRepresentative[level] = subgroup.get(level).orbitSize() <= 1 ? Integer.MAX_VALUE : sortedOrbits[level][sortedOrbits[level].length - subgroup.get(level).orbitSize() + 1];
            }
            int n = level;
            tuple[n] = tuple[n] + 1;
            if (level == 0) {
                word[0] = group.get(0).getTransversalOf(sortedOrbits[0][tuple[0]]);
                continue;
            }
            word[level] = group.get(level).getTransversalOf(word[level - 1].newIndexOfUnderInverse(sortedOrbits[level][tuple[level]])).composition(word[level - 1]);
        }
    }

    public static Permutation[] leftCosetRepresentatives(List<? extends BSGSElement> group, List<? extends BSGSElement> subgroup) {
        int[] base = AlgorithmsBase.getBaseAsArray(group);
        InducedOrdering ordering = new InducedOrdering(base);
        return AlgorithmsBacktrack.leftCosetRepresentatives(group, subgroup, base, ordering);
    }

    public static Permutation[] leftCosetRepresentatives(List<? extends BSGSElement> group, List<? extends BSGSElement> subgroup, int[] base, InducedOrdering ordering) {
        if (group.size() == 0 || group.get((int)0).stabilizerGenerators.isEmpty()) {
            throw new IllegalArgumentException("Empty group.");
        }
        AlgorithmsBacktrack.____VISITED_NODES___[0] = 0L;
        ArrayList<BSGSCandidateElement> _subgroup = AlgorithmsBase.asBSGSCandidatesList(subgroup);
        Permutation[] coset = new Permutation[AlgorithmsBase.calculateOrder(group).divide(AlgorithmsBase.calculateOrder(subgroup)).intValue()];
        int cosetCounter = 0;
        int degree = group.get(0).internalDegree();
        int size = group.size();
        int level = size - 1;
        Permutation[] word = new Permutation[size];
        Permutation identity = group.get((int)0).stabilizerGenerators.get(0).getIdentity();
        int[][] cachedSortedOrbits = new int[size][];
        int[][] sortedOrbits = new int[size][];
        for (int i = 0; i < size; ++i) {
            cachedSortedOrbits[i] = group.get((int)i).orbitList.toArray();
            ArraysUtils.quickSort(cachedSortedOrbits[i], ordering);
            sortedOrbits[i] = cachedSortedOrbits[i];
            word[i] = identity;
        }
        int[] tuple = new int[size];
        AlgorithmsBacktrack.rebaseWithRedundancy(_subgroup, base, degree);
        ArrayList<BSGSCandidateElement> subgroup_rebase = AlgorithmsBase.clone(_subgroup);
        while (true) {
            int image = word[level].newIndexOf(base[level]);
            AlgorithmsBacktrack.replaceBasePointWithRedundancy(subgroup_rebase, level, image);
            while (level < size - 1 && AlgorithmsBacktrack.isMinimalInOrbit(subgroup_rebase.get((int)level).orbitList, image, ordering)) {
                assert (AlgorithmsBacktrack.assertPartialBaseImage(level, word, base, subgroup_rebase));
                if (word[++level - 1].isIdentity()) {
                    sortedOrbits[level] = cachedSortedOrbits[level];
                } else {
                    sortedOrbits[level] = word[level - 1].imageOf(group.get((int)level).orbitList.toArray());
                    ArraysUtils.quickSort(sortedOrbits[level], ordering);
                }
                tuple[level] = 0;
                word[level] = group.get(level).getTransversalOf(word[level - 1].newIndexOfUnderInverse(sortedOrbits[level][tuple[level]])).composition(word[level - 1]);
                image = word[level].newIndexOf(base[level]);
                AlgorithmsBacktrack.replaceBasePointWithRedundancy(subgroup_rebase, level, image);
            }
            ____VISITED_NODES___[0] = ____VISITED_NODES___[0] + 1L;
            if (level == size - 1 && AlgorithmsBacktrack.isMinimalInOrbit(subgroup_rebase.get((int)level).orbitList, image, ordering)) {
                coset[cosetCounter++] = word[level];
            }
            while (level >= 0 && tuple[level] == group.get((int)level).orbitList.size() - 1) {
                --level;
            }
            if (level == -1) {
                return coset;
            }
            int n = level;
            tuple[n] = tuple[n] + 1;
            if (level == 0) {
                word[0] = group.get(0).getTransversalOf(sortedOrbits[0][tuple[0]]);
                continue;
            }
            word[level] = group.get(level).getTransversalOf(word[level - 1].newIndexOfUnderInverse(sortedOrbits[level][tuple[level]])).composition(word[level - 1]);
        }
    }

    public static Permutation leftTransversalOf(Permutation element, List<? extends BSGSElement> group, List<? extends BSGSElement> subgroup) {
        int[] base = AlgorithmsBase.getBaseAsArray(group);
        InducedOrdering ordering = new InducedOrdering(base);
        return AlgorithmsBacktrack.leftTransversalOf(element, group, subgroup, base, ordering);
    }

    public static Permutation leftTransversalOf(Permutation element, List<? extends BSGSElement> group, List<? extends BSGSElement> subgroup, int[] base, InducedOrdering ordering) {
        if (group.size() == 0 || subgroup.size() == 0) {
            throw new IllegalArgumentException("Empty group.");
        }
        int degree = group.get(0).internalDegree();
        ArrayList<BSGSCandidateElement> _subgroup = AlgorithmsBase.asBSGSCandidatesList(subgroup);
        AlgorithmsBacktrack.rebaseWithRedundancy(_subgroup, base, degree);
        Permutation transversal = element;
        int[] minimalImage = new int[base.length];
        for (int level = 0; level < group.size(); ++level) {
            int image = transversal.newIndexOf(base[level]);
            minimalImage[level] = ordering.min(Permutations.getOrbitList(_subgroup.get((int)level).stabilizerGenerators, image, degree));
            AlgorithmsBacktrack.replaceBasePointWithRedundancy(_subgroup, level, image);
            transversal = transversal.composition(_subgroup.get(level).getTransversalOf(minimalImage[level]));
            AlgorithmsBacktrack.replaceBasePointWithRedundancy(_subgroup, level, minimalImage[level]);
        }
        return transversal;
    }

    public static void intersection(List<? extends BSGSElement> group1, List<? extends BSGSElement> group2, ArrayList<BSGSCandidateElement> intersection) {
        if (AlgorithmsBase.calculateOrder(group2).compareTo(AlgorithmsBase.calculateOrder(group1)) < 0) {
            AlgorithmsBacktrack.intersection(group2, group1, intersection);
            return;
        }
        ArrayList<BSGSCandidateElement> smaller = AlgorithmsBase.asBSGSCandidatesList(group1);
        final ArrayList<BSGSCandidateElement> larger = AlgorithmsBase.asBSGSCandidatesList(group2);
        int degree = larger.get(0).internalDegree();
        AlgorithmsBacktrack.rebaseWithRedundancy(smaller, AlgorithmsBase.getBaseAsArray(larger), degree);
        final int[] base = AlgorithmsBase.getBaseAsArray(smaller);
        AlgorithmsBacktrack.rebaseWithRedundancy(larger, base, degree);
        assert (smaller.size() == larger.size());
        Permutation identity = ((Permutation)smaller.get((int)0).stabilizerGenerators.get(0)).getIdentity();
        final Permutation[] intersectionWord = new Permutation[smaller.size()];
        for (int i = 0; i < intersectionWord.length; ++i) {
            intersectionWord[i] = identity;
        }
        BacktrackSearchPayload payload = new BacktrackSearchPayload(){

            @Override
            public void beforeLevelIncrement(int level) {
                int image = this.wordReference[level].newIndexOf(base[level]);
                intersectionWord[level] = level == 0 ? ((BSGSCandidateElement)larger.get(level)).getTransversalOf(image) : ((BSGSCandidateElement)larger.get(level)).getTransversalOf(intersectionWord[level - 1].newIndexOfUnderInverse(image)).composition(intersectionWord[level - 1]);
            }

            @Override
            public void afterLevelIncrement(int level) {
            }

            @Override
            public boolean test(Permutation permutation, int level) {
                return level == 0 ? ((BSGSCandidateElement)larger.get(level)).belongsToOrbit(this.wordReference[level].newIndexOf(base[level])) : ((BSGSCandidateElement)larger.get(level)).belongsToOrbit(intersectionWord[level - 1].newIndexOfUnderInverse(this.wordReference[level].newIndexOf(base[level])));
            }
        };
        Indicator<Permutation> intersectionProperty = new Indicator<Permutation>(){

            @Override
            public boolean is(Permutation p) {
                return AlgorithmsBase.membershipTest(larger, p);
            }
        };
        AlgorithmsBacktrack.subgroupSearchWithPayload(smaller, intersection, payload, intersectionProperty);
    }

    static void rebaseWithRedundancy(ArrayList<BSGSCandidateElement> group, int[] base, int degree) {
        AlgorithmsBase.rebase(group, base);
        if (group.size() < base.length) {
            for (int i = group.size(); i < base.length; ++i) {
                group.add(new BSGSCandidateElement(base[i], new ArrayList<Permutation>(), degree));
            }
        }
    }

    private static boolean isMinimalInOrbit(IntArrayList orbit, int point, InducedOrdering ordering) {
        boolean belongsToOrbit = false;
        for (int i = orbit.size() - 1; i >= 0; --i) {
            int compare = ordering.compare(orbit.get(i), point);
            if (compare < 0) {
                return false;
            }
            if (compare != 0) continue;
            belongsToOrbit = true;
        }
        return belongsToOrbit;
    }

    private static void replaceBasePointWithRedundancy(ArrayList<BSGSCandidateElement> group, int index, int newPoint) {
        if (group.get((int)index).basePoint == newPoint) {
            return;
        }
        int oldSize = group.size();
        AlgorithmsBase.changeBasePointWithTranspositions(group, index, newPoint);
        assert (group.size() >= oldSize);
        while (group.size() > oldSize && group.get((int)(group.size() - 1)).stabilizerGenerators.isEmpty()) {
            group.remove(group.size() - 1);
        }
    }

    private static boolean assertPartialBaseImage(int level, Permutation[] word, int[] base, ArrayList<? extends BSGSElement> subgroup_rebase) {
        for (int i = 0; i <= level; ++i) {
            if (subgroup_rebase.get((int)i).basePoint == word[i].newIndexOf(base[i])) continue;
            return false;
        }
        return true;
    }
}

