/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context.defaults;

import cc.redberry.core.context.IndexConverterException;
import cc.redberry.core.context.IndexSymbolConverter;
import cc.redberry.core.utils.ArraysUtils;
import java.util.Arrays;

abstract class SymbolArrayConverter
implements IndexSymbolConverter {
    private final String[] sortedSymbols;
    private final int[] coSortedCodes;
    private final String[] symbols;
    private final String[] utf;

    public SymbolArrayConverter(String[] symbols, String[] utf) {
        this.symbols = symbols;
        this.utf = utf;
        if (symbols.length != utf.length) {
            throw new RuntimeException();
        }
        this.sortedSymbols = (String[])symbols.clone();
        this.coSortedCodes = new int[symbols.length];
        for (int i = 0; i < this.coSortedCodes.length; ++i) {
            this.coSortedCodes[i] = i;
        }
        ArraysUtils.quickSort((Comparable[])this.sortedSymbols, (int[])this.coSortedCodes);
    }

    @Override
    public boolean applicableToSymbol(String symbol) {
        return Arrays.binarySearch(this.sortedSymbols, symbol) >= 0;
    }

    @Override
    public int getCode(String symbol) throws IndexConverterException {
        int codePosition = Arrays.binarySearch(this.sortedSymbols, symbol);
        if (codePosition < 0) {
            throw new IndexConverterException();
        }
        return this.coSortedCodes[codePosition];
    }

    @Override
    public int maxNumberOfSymbols() {
        return this.sortedSymbols.length - 1;
    }
}

