/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context.defaults;

import cc.redberry.core.context.IndexConverterException;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.context.defaults.SymbolArrayConverter;

public final class GreekLaTeXUpperCaseConverter
extends SymbolArrayConverter {
    private static final String[] symbols = new String[11];
    private static final String[] utf = new String[11];
    public static final GreekLaTeXUpperCaseConverter INSTANCE;
    public static final byte TYPE = 3;

    private GreekLaTeXUpperCaseConverter() {
        super(symbols, utf);
    }

    @Override
    public byte getType() {
        return 3;
    }

    @Override
    public String getSymbol(int code, OutputFormat mode) throws IndexConverterException {
        String symbol;
        try {
            if (mode.is(OutputFormat.UTF8)) {
                return utf[code];
            }
            symbol = symbols[code];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexConverterException();
        }
        if (mode.is(OutputFormat.WolframMathematica)) {
            symbol = "\\[Capital" + Character.toUpperCase(symbol.charAt(1)) + symbol.substring(2) + "]";
        }
        if (mode.is(OutputFormat.Maple)) {
            symbol = symbol.substring(1);
        }
        return symbol;
    }

    static {
        GreekLaTeXUpperCaseConverter.symbols[0] = "\\Gamma";
        GreekLaTeXUpperCaseConverter.symbols[1] = "\\Delta";
        GreekLaTeXUpperCaseConverter.symbols[2] = "\\Theta";
        GreekLaTeXUpperCaseConverter.symbols[3] = "\\Lambda";
        GreekLaTeXUpperCaseConverter.symbols[4] = "\\Xi";
        GreekLaTeXUpperCaseConverter.symbols[5] = "\\Pi";
        GreekLaTeXUpperCaseConverter.symbols[6] = "\\Sigma";
        GreekLaTeXUpperCaseConverter.symbols[7] = "\\Upsilon";
        GreekLaTeXUpperCaseConverter.symbols[8] = "\\Phi";
        GreekLaTeXUpperCaseConverter.symbols[9] = "\\Psi";
        GreekLaTeXUpperCaseConverter.symbols[10] = "\\Omega";
        GreekLaTeXUpperCaseConverter.utf[0] = Character.toString('\u0393');
        GreekLaTeXUpperCaseConverter.utf[1] = Character.toString('\u0394');
        GreekLaTeXUpperCaseConverter.utf[2] = Character.toString('\u0398');
        GreekLaTeXUpperCaseConverter.utf[3] = Character.toString('\u039b');
        GreekLaTeXUpperCaseConverter.utf[4] = Character.toString('\u039e');
        GreekLaTeXUpperCaseConverter.utf[5] = Character.toString('\u03a0');
        GreekLaTeXUpperCaseConverter.utf[6] = Character.toString('\u03a3');
        GreekLaTeXUpperCaseConverter.utf[7] = Character.toString('\u03a5');
        GreekLaTeXUpperCaseConverter.utf[8] = Character.toString('\u03a6');
        GreekLaTeXUpperCaseConverter.utf[9] = Character.toString('\u03a8');
        GreekLaTeXUpperCaseConverter.utf[10] = Character.toString('\u03a9');
        INSTANCE = new GreekLaTeXUpperCaseConverter();
    }
}

