/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context;

import cc.redberry.core.context.NameDescriptor;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.utils.ArraysUtils;
import java.util.Arrays;

public abstract class NameDescriptorForTensorField
extends NameDescriptor {
    final int[] orders;
    final String name;
    int[][] indicesPartitionMapping = null;

    NameDescriptorForTensorField(StructureOfIndices[] indexTypeStructures, int id, int[] orders, String name) {
        super(indexTypeStructures, id);
        this.orders = orders;
        this.name = name;
    }

    public int[] getDerivativeOrders() {
        return (int[])this.orders.clone();
    }

    public int getDerivativeOrder(int arg) {
        return this.orders[arg];
    }

    private void ensurePartitionInitialized() {
        if (this.indicesPartitionMapping != null) {
            return;
        }
        if (!this.isDerivative()) {
            int[][] ret = new int[this.structuresOfIndices.length][];
            Arrays.fill((Object[])ret, 1, ret.length, new int[0]);
            ret[0] = ArraysUtils.getSeriesFrom0(this.structuresOfIndices[0].size());
            this.indicesPartitionMapping = ret;
        }
        NameDescriptorForTensorField parent = this.getParent();
        StructureOfIndices[] partition = new StructureOfIndices[ArraysUtils.sum(this.orders) + 1];
        partition[0] = parent.getStructureOfIndices();
        int totalOrder = 1;
        for (int i = 0; i < this.structuresOfIndices.length - 1; ++i) {
            for (int j = this.orders[i] - 1; j >= 0; --j) {
                partition[totalOrder++] = parent.getArgStructureOfIndices(i);
            }
        }
        this.indicesPartitionMapping = this.structuresOfIndices[0].getPartitionMappings(partition);
    }

    public int[][] getIndicesPartitionMapping() {
        this.ensurePartitionInitialized();
        return ArraysUtils.deepClone(this.indicesPartitionMapping);
    }

    public abstract NameDescriptorForTensorField getParent();

    public abstract boolean isDerivative();

    public abstract NameDescriptorForTensorField getDerivative(int ... var1);
}

