/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.NameAndStructureOfIndices;
import cc.redberry.core.context.NameManager;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.IndicesSymmetries;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.StructureOfIndices;
import java.util.Arrays;

public abstract class NameDescriptor {
    final StructureOfIndices[] structuresOfIndices;
    private final int id;
    final IndicesSymmetries symmetries;
    NameManager nameManager = null;

    NameDescriptor(StructureOfIndices[] structuresOfIndices, int id) {
        if (structuresOfIndices.length == 0) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.structuresOfIndices = structuresOfIndices;
        this.symmetries = IndicesSymmetries.create(structuresOfIndices[0]);
    }

    void registerInNameManager(NameManager manager) {
        if (this.nameManager != null && manager != this.nameManager) {
            throw new IllegalStateException("Already registered in another name manager.");
        }
        this.nameManager = manager;
    }

    public int getId() {
        return this.id;
    }

    public IndicesSymmetries getSymmetries() {
        return this.symmetries;
    }

    public boolean isField() {
        return this.structuresOfIndices.length != 1;
    }

    public StructureOfIndices getStructureOfIndices() {
        return this.structuresOfIndices[0];
    }

    public StructureOfIndices getArgStructureOfIndices(int arg) {
        return this.structuresOfIndices[arg + 1];
    }

    public StructureOfIndices[] getStructuresOfIndices() {
        return this.structuresOfIndices;
    }

    abstract NameAndStructureOfIndices[] getKeys();

    public String getName(SimpleIndices indices) {
        return this.getName(indices, CC.getDefaultOutputFormat());
    }

    public abstract String getName(SimpleIndices var1, OutputFormat var2);

    public String toString() {
        return this.getName(null) + ":" + Arrays.toString(this.structuresOfIndices);
    }

    public static NameAndStructureOfIndices extractKey(NameDescriptor nd) {
        return nd.getKeys()[0];
    }
}

