/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context;

import cc.redberry.core.context.IndexConverterManager;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.parser.Parser;
import java.util.EnumSet;

public class ContextSettings {
    private OutputFormat defaultOutputFormat;
    private String kronecker = "d";
    private String metricName = "g";
    private EnumSet<IndexType> metricTypes = EnumSet.noneOf(IndexType.class);
    private Long nameManagerSeed;
    private IndexConverterManager converterManager = IndexConverterManager.DEFAULT;
    private Parser parser = Parser.DEFAULT;

    public ContextSettings(OutputFormat defaultOutputFormat, String kronecker) {
        this.defaultOutputFormat = defaultOutputFormat;
        this.kronecker = kronecker;
    }

    EnumSet<IndexType> getMetricTypes() {
        return this.metricTypes;
    }

    public void removeMetricIndexType(IndexType type) {
        this.metricTypes.remove((Object)type);
    }

    public void addMetricIndexType(IndexType type) {
        this.metricTypes.add(type);
    }

    public OutputFormat getDefaultOutputFormat() {
        return this.defaultOutputFormat;
    }

    public void setDefaultOutputFormat(OutputFormat defaultOutputFormat) {
        if (defaultOutputFormat == null) {
            throw new NullPointerException();
        }
        this.defaultOutputFormat = defaultOutputFormat;
    }

    public String getKronecker() {
        return this.kronecker;
    }

    public void setKronecker(String kronecker) {
        if (kronecker == null) {
            throw new NullPointerException();
        }
        if (kronecker.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.kronecker = kronecker;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        if (metricName == null) {
            throw new NullPointerException();
        }
        if (metricName.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.metricName = metricName;
    }

    public Long getNameManagerSeed() {
        return this.nameManagerSeed;
    }

    public void setNameManagerSeed(Long nameManagerSeed) {
        this.nameManagerSeed = nameManagerSeed;
    }

    public IndexConverterManager getConverterManager() {
        return this.converterManager;
    }

    public void setConverterManager(IndexConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public Parser getParser() {
        return this.parser;
    }
}

