/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.combinatorics;

import cc.redberry.core.combinatorics.IntCombinatorialPort;
import cc.redberry.core.utils.BitArray;
import java.util.Arrays;

public class IntDistinctTuplesPort
implements IntCombinatorialPort {
    private final BitArray previousMask;
    private final BitArray[] setMasks;
    private final int[] combination;
    private final BitArray temp;
    private byte state = (byte)-1;

    public IntDistinctTuplesPort(int[] ... sets) {
        int maxIndex = 0;
        for (int[] set : sets) {
            if (set.length == 0) continue;
            Arrays.sort(set);
            if (maxIndex >= set[set.length - 1]) continue;
            maxIndex = set[set.length - 1];
        }
        this.previousMask = new BitArray(++maxIndex);
        this.temp = new BitArray(maxIndex);
        this.setMasks = new BitArray[sets.length];
        for (int i = 0; i < sets.length; ++i) {
            this.setMasks[i] = new BitArray(maxIndex);
            for (int j : sets[i]) {
                this.setMasks[i].set(j);
            }
        }
        this.combination = new int[sets.length];
        this.previousMask.setAll();
        this.init();
    }

    private void init() {
        int i = 0;
        while (i < this.setMasks.length) {
            this.temp.loadValueFrom(this.setMasks[i]);
            this.temp.and(this.previousMask);
            int nextBit = this.temp.nextBit(this.combination[i]);
            if (nextBit == -1) {
                if (i == 0) {
                    this.state = 1;
                    return;
                }
                this.combination[i] = 0;
                this.previousMask.set(this.combination[--i]);
                int n = i;
                this.combination[n] = this.combination[n] + 1;
                continue;
            }
            this.combination[i] = nextBit;
            this.previousMask.clear(nextBit);
            ++i;
        }
    }

    @Override
    public int[] take() {
        if (this.state == 1) {
            return null;
        }
        if (this.state == -1) {
            this.state = 0;
            return this.combination;
        }
        int n = this.setMasks.length - 1;
        int n2 = this.combination[n];
        this.combination[n] = n2 + 1;
        this.previousMask.set(n2);
        int i = this.setMasks.length - 1;
        while (i < this.setMasks.length) {
            this.temp.loadValueFrom(this.setMasks[i]);
            this.temp.and(this.previousMask);
            int nextBit = this.temp.nextBit(this.combination[i]);
            if (nextBit == -1) {
                if (i == 0) {
                    this.state = 1;
                    return null;
                }
                this.combination[i] = 0;
                this.previousMask.set(this.combination[--i]);
                int n3 = i;
                this.combination[n3] = this.combination[n3] + 1;
                continue;
            }
            this.combination[i] = nextBit;
            this.previousMask.clear(nextBit);
            ++i;
        }
        return this.combination;
    }

    @Override
    public void reset() {
        this.state = (byte)-1;
        Arrays.fill(this.combination, 0);
        this.previousMask.setAll();
        this.init();
    }

    @Override
    public int[] getReference() {
        return this.combination;
    }
}

