/*
 * Decompiled with CFR 0.152.
 */
package jvx.volume;

import jv.geom.PgEdgeStar;
import jv.geom.PgTetraSet;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;
import jvx.util.PuPriorityQueue;
import jvx.volume.PgTetraVertexStar;
import jvx.volume.PwTetraSet;

public class PwSimplifyTet
extends PjWorkshop {
    protected PgTetraSet m_tetraSet;
    PgEdgeStar[] m_edgeStar;
    int m_numEdges;
    PgEdgeStar[][] m_tetEdge;
    PuPriorityQueue m_queue;
    static /* synthetic */ Class class$jvx$volume$PwSimplifyTet;

    public PwSimplifyTet() {
        super("TetraSet Simplification");
        if (((Object)((Object)this)).getClass() == (class$jvx$volume$PwSimplifyTet == null ? (class$jvx$volume$PwSimplifyTet = PwSimplifyTet.class$("jvx.volume.PwSimplifyTet")) : class$jvx$volume$PwSimplifyTet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public boolean update(Object object) {
        return super.update(object);
    }

    public void setGeometry(PgGeometry pgGeometry) {
        super.setGeometry(pgGeometry);
        this.m_tetraSet = (PgTetraSet)pgGeometry;
        this.initializeQueue();
    }

    public void initializeQueue() {
        int n;
        int n2 = this.m_tetraSet.getNumTetras();
        this.m_edgeStar = this.m_tetraSet.makeEdgeStars();
        this.m_numEdges = this.m_edgeStar.length;
        this.m_tetEdge = new PgEdgeStar[n2][6];
        for (n = 0; n < this.m_numEdges; ++n) {
            int n3 = this.m_edgeStar[n].getValence();
            int[] nArray = this.m_edgeStar[n].getElementInd();
            int[] nArray2 = this.m_edgeStar[n].getNeighbourLocInd();
            for (int i = 0; i < n3; ++i) {
                this.m_tetEdge[nArray[i]][nArray2[i]] = this.m_edgeStar[n];
            }
        }
        this.m_queue = new PuPriorityQueue(this.m_numEdges);
        for (n = 0; n < this.m_numEdges; ++n) {
            double d = PdVector.dist((PdVector)this.m_tetraSet.getVertex(this.m_edgeStar[n].m_data[0]), (PdVector)this.m_tetraSet.getVertex(this.m_edgeStar[n].m_data[1]));
            this.m_queue.enqueue(n, d);
        }
    }

    public static void collapseHighestValenceEdge(PgTetraSet pgTetraSet) {
        int n;
        pgTetraSet.markBoundary();
        int n2 = pgTetraSet.getNumTetras();
        int[] nArray = new int[2];
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        PgEdgeStar pgEdgeStar = new PgEdgeStar();
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < 6; ++i) {
                PwTetraSet.computeEdgeStar(pgTetraSet, n, i, pgEdgeStar);
                int n6 = pgEdgeStar.getValence();
                if (!PwTetraSet.edgeStarIsClosed(pgTetraSet, pgEdgeStar)) {
                    n6 *= 2;
                }
                if (n6 <= n5) continue;
                n5 = n6;
                n3 = n;
                n4 = i;
            }
        }
        PiVector piVector = pgTetraSet.getTetra(n3);
        nArray = new int[]{piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n4][0]], piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n4][1]]};
        if (nArray[0] > nArray[1]) {
            n = nArray[0];
            nArray[0] = nArray[1];
            nArray[1] = n;
        }
        PwSimplifyTet.moveVertex(pgTetraSet, nArray[0], nArray[1]);
        PwSimplifyTet.collapseEdge(pgTetraSet, n3, n4);
        pgTetraSet.removeMarkedTetras();
        pgTetraSet.removeUnusedVertices();
    }

    public static void collapseShortestEdge(PgTetraSet pgTetraSet) {
        PiVector piVector;
        int n;
        pgTetraSet.markBoundary();
        int n2 = pgTetraSet.getNumTetras();
        int[] nArray = new int[2];
        int n3 = -1;
        int n4 = -1;
        double d = Double.MAX_VALUE;
        for (n = 0; n < n2; ++n) {
            piVector = pgTetraSet.getTetra(n);
            for (int i = 0; i < 6; ++i) {
                nArray[0] = piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[i][0]];
                nArray[1] = piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[i][1]];
                double d2 = PdVector.dist((PdVector)pgTetraSet.getVertex(nArray[0]), (PdVector)pgTetraSet.getVertex(nArray[1]));
                if (!(d2 < d)) continue;
                n3 = n;
                n4 = i;
                d = d2;
            }
        }
        piVector = pgTetraSet.getTetra(n3);
        nArray = new int[]{piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n4][0]], piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n4][1]]};
        if (nArray[0] > nArray[1]) {
            n = nArray[0];
            nArray[0] = nArray[1];
            nArray[1] = n;
        }
        PwSimplifyTet.moveVertex(pgTetraSet, nArray[0], nArray[1]);
        PwSimplifyTet.collapseEdge(pgTetraSet, n3, n4);
        pgTetraSet.removeMarkedTetras();
        pgTetraSet.removeUnusedVertices();
    }

    public static void collapseFirstEdge(PgTetraSet pgTetraSet) {
        pgTetraSet.markBoundary();
        PiVector piVector = pgTetraSet.getTetra(0);
        int[] nArray = new int[]{piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[0][0]], piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[0][1]]};
        if (nArray[0] > nArray[1]) {
            int n = nArray[0];
            nArray[0] = nArray[1];
            nArray[1] = n;
        }
        PwSimplifyTet.moveVertex(pgTetraSet, nArray[0], nArray[1]);
        PwSimplifyTet.collapseEdge(pgTetraSet, 0, 0);
        pgTetraSet.removeMarkedTetras();
        pgTetraSet.removeUnusedVertices();
    }

    public static void moveVertex(PgTetraSet pgTetraSet, int n, int n2) {
        if (pgTetraSet.hasTagVertex(n, 14) == pgTetraSet.hasTagVertex(n2, 14)) {
            pgTetraSet.getVertex(n).add(pgTetraSet.getVertex(n2));
            pgTetraSet.getVertex(n).multScalar(0.5);
            return;
        }
        if (pgTetraSet.hasTagVertex(n, 14)) {
            pgTetraSet.getVertex(n2).copy(pgTetraSet.getVertex(n));
            pgTetraSet.setTagVertex(n2, 14);
            return;
        }
        pgTetraSet.getVertex(n).copy(pgTetraSet.getVertex(n2));
        pgTetraSet.setTagVertex(n, 14);
    }

    public static void collapseEdge(PgTetraSet pgTetraSet, int n, int n2) {
        Object object;
        int n3;
        PiVector piVector = pgTetraSet.getTetra(n);
        int[] nArray = new int[]{piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n2][0]], piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n2][1]]};
        if (nArray[0] > nArray[1]) {
            int n4 = nArray[0];
            nArray[0] = nArray[1];
            nArray[1] = n4;
        }
        PgTetraVertexStar pgTetraVertexStar = new PgTetraVertexStar();
        pgTetraVertexStar.makeVertexStar(pgTetraSet, nArray[1], n);
        PgEdgeStar pgEdgeStar = new PgEdgeStar();
        PwTetraSet.computeEdgeStar(pgTetraSet, n, n2, pgEdgeStar);
        int n5 = pgEdgeStar.getValence();
        for (int i = 0; i < n5; ++i) {
            int n6;
            n3 = pgEdgeStar.getElementInd(i);
            object = new int[2];
            int[] nArray2 = new int[2];
            int[] nArray3 = new int[2];
            for (n6 = 0; n6 < 2; ++n6) {
                PiVector piVector2 = pgTetraSet.getTetra(n3);
                object[n6] = piVector2.getIndexOf(nArray[n6]);
                nArray3[n6] = pgTetraSet.getNeighbour((int)n3).m_data[object[n6]];
                if (nArray3[n6] <= -1) continue;
                nArray2[n6] = pgTetraSet.getOppVertexLocInd(n3, object[n6]);
            }
            pgTetraSet.setTagTetra(n3, 2);
            for (n6 = 0; n6 < 2; ++n6) {
                if (nArray3[n6] < 0) continue;
                pgTetraSet.getNeighbour((int)nArray3[n6]).m_data[nArray2[n6]] = nArray3[(n6 + 1) % 2];
            }
        }
        n5 = pgTetraVertexStar.getSize();
        PiVector piVector3 = pgTetraVertexStar.getTetIndex();
        for (n3 = 0; n3 < n5; ++n3) {
            object = pgTetraSet.getTetra(piVector3.m_data[n3]);
            int n7 = object.getIndexOf(nArray[1]);
            if (n7 < 0) {
                PsDebug.warning((String)"Could not find local index of vertex in tetrahedron");
                continue;
            }
            object.m_data[n7] = nArray[0];
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

