/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;

public class PnVertexRKIgnoreDirection
extends PnGeodesicRK {
    protected PdBaryDir[][] m_vec;

    public PnVertexRKIgnoreDirection(PgElementSet pgElementSet) {
        super(pgElementSet);
        if (pgElementSet.getDimOfElements() != 3) {
            throw new IllegalArgumentException("geometry is no triangulation");
        }
        this.m_vec = null;
    }

    public void setVectorField(PdBaryDir[][] pdBaryDirArray) {
        this.m_vec = pdBaryDirArray;
    }

    public void setVectorField(PgVectorField pgVectorField) {
        int n = pgVectorField.getNumVectors();
        int n2 = this.m_geom.getNumElements();
        this.m_vec = new PdBaryDir[n2][3];
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector pdVector = new PdVector(this.m_geom.getDimOfVertices());
        for (int i = 0; i < n2; ++i) {
            int n3 = piVectorArray[i].getSize();
            for (int j = 0; j < n3; ++j) {
                int n4 = piVectorArray[i].m_data[j];
                this.m_vec[i][j] = new PdBaryDir(3);
                if (n4 >= n) continue;
                pdVector.copy(pdVectorArray[n4]);
                if (j > 0 && PdVector.dot((PdVector)pdVectorArray[piVectorArray[i].m_data[0]], (PdVector)pdVector) < 0.0) {
                    pdVector.multScalar(-1.0);
                }
                PwBary.projectOntoElement(this.m_geom, i, pdVector, this.m_vec[i][j]);
            }
        }
    }

    public void eval(int n, PdBary pdBary, PdBaryDir pdBaryDir) {
        int n2;
        int n3;
        pdBaryDir.setSize(3);
        PdBaryDir pdBaryDir2 = PdBaryDir.copyNew((PdBaryDir)pdBaryDir);
        for (n3 = 0; n3 < 3; ++n3) {
            pdBaryDir.m_data[n3] = 0.0;
            for (n2 = 0; n2 < 3; ++n2) {
                int n4 = n3;
                pdBaryDir.m_data[n4] = pdBaryDir.m_data[n4] + pdBary.m_data[n2] * this.m_vec[n][n2].m_data[n3];
            }
        }
        if (this.m_bInvert) {
            for (n2 = 0; n2 < 3; ++n2) {
                pdBaryDir.m_data[n2] = -pdBaryDir.m_data[n2];
            }
        }
        int n5 = n3 = PwBary.scalar(this.m_geom, n, pdBaryDir2, pdBaryDir, false) < 0.0 ? 1 : 0;
        if (n3 != 0) {
            for (n2 = 0; n2 < 3; ++n2) {
                pdBaryDir.m_data[n2] = -pdBaryDir.m_data[n2];
            }
        }
    }
}

