/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgTetraSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnJacobi;

public class PnPCA {
    static /* synthetic */ Class class$jv$geom$PgElementSet;
    static /* synthetic */ Class class$jv$geom$PgVectorField;

    public static PdMatrix getCovarianceMatrix(PgElementSet pgElementSet) {
        return PnPCA.getCovarianceMatrix(pgElementSet, PnPCA.getBarycenter(pgElementSet));
    }

    public static PdMatrix getCovarianceMatrix(PgElementSet pgElementSet, PdVector pdVector) {
        return PnPCA.getCovarianceMatrix(pgElementSet, pdVector, null);
    }

    public static PdMatrix getCovarianceMatrix(PgElementSet pgElementSet, PdVector pdVector, int[] nArray) {
        double[] dArray = pdVector.getEntries();
        double[] dArray2 = new double[6];
        dArray2[5] = 0.0;
        dArray2[4] = 0.0;
        dArray2[3] = 0.0;
        dArray2[2] = 0.0;
        dArray2[1] = 0.0;
        dArray2[0] = 0.0;
        double d = 0.0;
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        int n = nArray == null ? pgElementSet.getNumElements() : nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray == null ? i : nArray[i];
            PiVector piVector = pgElementSet.getElement(n2);
            for (int j = 2; j < piVector.getSize(); ++j) {
                PdVector pdVector5 = pgElementSet.getVertex(piVector.getEntry(0));
                PdVector pdVector6 = pgElementSet.getVertex(piVector.getEntry(j - 1));
                PdVector pdVector7 = pgElementSet.getVertex(piVector.getEntry(j));
                double d2 = PdVector.area((PdVector)pdVector5, (PdVector)pdVector6, (PdVector)pdVector7);
                d += d2;
                PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])pgElementSet.getVertices(), (int[])piVector.getEntries());
                double[] dArray3 = pdVector2.getEntries();
                pdVector3.sub(pdVector6, pdVector5);
                pdVector4.sub(pdVector7, pdVector5);
                double[] dArray4 = pdVector3.getEntries();
                double[] dArray5 = pdVector4.getEntries();
                double d3 = 2.0 * d2 / 36.0;
                double d4 = 2.0 * d2 / -72.0;
                dArray2[0] = dArray2[0] + (d3 * (dArray4[0] * dArray4[0] + dArray5[0] * dArray5[0]) + 2.0 * d4 * dArray4[0] * dArray5[0]);
                dArray2[1] = dArray2[1] + (d3 * (dArray4[1] * dArray4[0] + dArray5[1] * dArray5[0]) + d4 * (dArray4[1] * dArray5[0] + dArray4[0] * dArray5[1]));
                dArray2[2] = dArray2[2] + (d3 * (dArray4[1] * dArray4[1] + dArray5[1] * dArray5[1]) + 2.0 * d4 * dArray4[1] * dArray5[1]);
                dArray2[3] = dArray2[3] + (d3 * (dArray4[2] * dArray4[0] + dArray5[2] * dArray5[0]) + d4 * (dArray4[2] * dArray5[0] + dArray4[0] * dArray5[2]));
                dArray2[4] = dArray2[4] + (d3 * (dArray4[2] * dArray4[1] + dArray5[2] * dArray5[1]) + d4 * (dArray4[2] * dArray5[1] + dArray4[1] * dArray5[2]));
                dArray2[5] = dArray2[5] + (d3 * (dArray4[2] * dArray4[2] + dArray5[2] * dArray5[2]) + 2.0 * d4 * dArray4[2] * dArray5[2]);
                dArray2[0] = dArray2[0] + d2 * dArray3[0] * dArray3[0];
                dArray2[1] = dArray2[1] + d2 * dArray3[1] * dArray3[0];
                dArray2[2] = dArray2[2] + d2 * dArray3[1] * dArray3[1];
                dArray2[3] = dArray2[3] + d2 * dArray3[2] * dArray3[0];
                dArray2[4] = dArray2[4] + d2 * dArray3[2] * dArray3[1];
                dArray2[5] = dArray2[5] + d2 * dArray3[2] * dArray3[2];
            }
        }
        dArray2[0] = dArray2[0] / d;
        dArray2[1] = dArray2[1] / d;
        dArray2[2] = dArray2[2] / d;
        dArray2[3] = dArray2[3] / d;
        dArray2[4] = dArray2[4] / d;
        dArray2[5] = dArray2[5] / d;
        dArray2[0] = dArray2[0] - dArray[0] * dArray[0];
        dArray2[1] = dArray2[1] - dArray[1] * dArray[0];
        dArray2[2] = dArray2[2] - dArray[1] * dArray[1];
        dArray2[3] = dArray2[3] - dArray[2] * dArray[0];
        dArray2[4] = dArray2[4] - dArray[2] * dArray[1];
        dArray2[5] = dArray2[5] - dArray[2] * dArray[2];
        PdMatrix pdMatrix = new PdMatrix(3);
        pdMatrix.setEntry(0, 0, dArray2[0]);
        pdMatrix.setEntry(0, 1, dArray2[1]);
        pdMatrix.setEntry(1, 1, dArray2[2]);
        pdMatrix.setEntry(0, 2, dArray2[3]);
        pdMatrix.setEntry(1, 2, dArray2[4]);
        pdMatrix.setEntry(2, 2, dArray2[5]);
        pdMatrix.setEntry(1, 0, dArray2[1]);
        pdMatrix.setEntry(2, 0, dArray2[3]);
        pdMatrix.setEntry(2, 1, dArray2[4]);
        return pdMatrix;
    }

    public static PdMatrix getCovarianceMatrix(PgTetraSet pgTetraSet) {
        return PnPCA.getCovarianceMatrix(pgTetraSet, PnPCA.getBarycenter(pgTetraSet));
    }

    public static PdMatrix getCovarianceMatrix(PgTetraSet pgTetraSet, PdVector pdVector) {
        return PnPCA.getCovarianceMatrix(pgTetraSet, pdVector, null);
    }

    public static PdMatrix getCovarianceMatrix(PgTetraSet pgTetraSet, PdVector pdVector, int[] nArray) {
        double[] dArray = pdVector.getEntries();
        double[] dArray2 = new double[6];
        dArray2[5] = 0.0;
        dArray2[4] = 0.0;
        dArray2[3] = 0.0;
        dArray2[2] = 0.0;
        dArray2[1] = 0.0;
        dArray2[0] = 0.0;
        double d = 0.0;
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        int n = nArray == null ? pgTetraSet.getNumTetras() : nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray == null ? i : nArray[i];
            PiVector piVector = pgTetraSet.getElement(n2);
            PdVector pdVector6 = pgTetraSet.getVertex(piVector.getEntry(0));
            for (int j = 2; j < piVector.getSize(); ++j) {
                PdVector pdVector7 = pgTetraSet.getVertex(piVector.getEntry(j - 2));
                PdVector pdVector8 = pgTetraSet.getVertex(piVector.getEntry(j - 1));
                PdVector pdVector9 = pgTetraSet.getVertex(piVector.getEntry(j));
                double d2 = pgTetraSet.getVolumeOfTetra(n2);
                d += d2;
                PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])pgTetraSet.getVertices(), (int[])piVector.getEntries());
                double[] dArray3 = pdVector2.getEntries();
                pdVector3.sub(pdVector7, pdVector6);
                pdVector4.sub(pdVector8, pdVector6);
                pdVector5.sub(pdVector9, pdVector6);
                double[] dArray4 = pdVector3.getEntries();
                double[] dArray5 = pdVector4.getEntries();
                double[] dArray6 = pdVector5.getEntries();
                double d3 = 2.0 * d2 * 17.0 / 1920.0;
                double d4 = 2.0 * d2 / 1920.0;
                dArray2[0] = dArray2[0] + (d3 * (dArray4[0] * dArray4[0] + dArray5[0] * dArray5[0] + dArray6[0] * dArray6[0]) + 2.0 * d4 * (dArray4[0] * dArray5[0] + dArray5[0] * dArray6[0] + dArray6[0] * dArray4[0]));
                dArray2[1] = dArray2[1] + (d3 * (dArray4[1] * dArray4[0] + dArray5[1] * dArray5[0] + dArray6[1] * dArray6[0]) + d4 * (dArray4[1] * dArray5[0] + dArray4[0] * dArray5[1] + dArray5[1] * dArray6[0] + dArray5[0] * dArray6[1] + dArray6[1] * dArray4[0] + dArray6[0] * dArray4[1]));
                dArray2[2] = dArray2[2] + (d3 * (dArray4[1] * dArray4[1] + dArray5[1] * dArray5[1] + dArray6[1] * dArray6[1]) + 2.0 * d4 * (dArray4[1] * dArray5[1] + dArray5[1] * dArray6[1] + dArray6[1] * dArray4[1]));
                dArray2[3] = dArray2[3] + (d3 * (dArray4[2] * dArray4[0] + dArray5[2] * dArray5[0] + dArray6[2] * dArray6[0]) + d4 * (dArray4[2] * dArray5[0] + dArray4[0] * dArray5[2] + dArray5[2] * dArray6[0] + dArray5[0] * dArray6[2] + dArray6[2] * dArray4[0] + dArray6[0] * dArray4[2]));
                dArray2[4] = dArray2[4] + (d3 * (dArray4[2] * dArray4[1] + dArray5[2] * dArray5[1] + dArray6[2] * dArray6[1]) + d4 * (dArray4[2] * dArray5[1] + dArray4[1] * dArray5[2] + dArray5[2] * dArray6[1] + dArray5[1] * dArray6[2] + dArray6[2] * dArray4[1] + dArray6[1] * dArray4[2]));
                dArray2[5] = dArray2[5] + (d3 * (dArray4[2] * dArray4[2] + dArray5[2] * dArray5[2] + dArray6[2] * dArray6[2]) + 2.0 * d4 * (dArray4[2] * dArray5[2] + dArray5[2] * dArray6[2] + dArray6[2] * dArray4[2]));
                dArray2[0] = dArray2[0] + d2 * dArray3[0] * dArray3[0];
                dArray2[1] = dArray2[1] + d2 * dArray3[1] * dArray3[0];
                dArray2[2] = dArray2[2] + d2 * dArray3[1] * dArray3[1];
                dArray2[3] = dArray2[3] + d2 * dArray3[2] * dArray3[0];
                dArray2[4] = dArray2[4] + d2 * dArray3[2] * dArray3[1];
                dArray2[5] = dArray2[5] + d2 * dArray3[2] * dArray3[2];
            }
        }
        dArray2[0] = dArray2[0] / d;
        dArray2[1] = dArray2[1] / d;
        dArray2[2] = dArray2[2] / d;
        dArray2[3] = dArray2[3] / d;
        dArray2[4] = dArray2[4] / d;
        dArray2[5] = dArray2[5] / d;
        dArray2[0] = dArray2[0] - dArray[0] * dArray[0];
        dArray2[1] = dArray2[1] - dArray[1] * dArray[0];
        dArray2[2] = dArray2[2] - dArray[1] * dArray[1];
        dArray2[3] = dArray2[3] - dArray[2] * dArray[0];
        dArray2[4] = dArray2[4] - dArray[2] * dArray[1];
        dArray2[5] = dArray2[5] - dArray[2] * dArray[2];
        PdMatrix pdMatrix = new PdMatrix(3);
        pdMatrix.setEntry(0, 0, dArray2[0]);
        pdMatrix.setEntry(0, 1, dArray2[1]);
        pdMatrix.setEntry(1, 1, dArray2[2]);
        pdMatrix.setEntry(0, 2, dArray2[3]);
        pdMatrix.setEntry(1, 2, dArray2[4]);
        pdMatrix.setEntry(2, 2, dArray2[5]);
        pdMatrix.setEntry(1, 0, dArray2[1]);
        pdMatrix.setEntry(2, 0, dArray2[3]);
        pdMatrix.setEntry(2, 1, dArray2[4]);
        return pdMatrix;
    }

    public static PdMatrix getWeightedCovarianceMatrix(PgTetraSet pgTetraSet, PgVectorField pgVectorField, PdVector pdVector, int[] nArray) {
        double[] dArray = pdVector.getEntries();
        double[] dArray2 = new double[6];
        dArray2[5] = 0.0;
        dArray2[4] = 0.0;
        dArray2[3] = 0.0;
        dArray2[2] = 0.0;
        dArray2[1] = 0.0;
        dArray2[0] = 0.0;
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            PiVector piVector = pgTetraSet.getTetra(n2);
            PdVector pdVector6 = pgTetraSet.getVertex(piVector.getEntry(0));
            PdVector pdVector7 = pgTetraSet.getVertex(piVector.getEntry(1));
            PdVector pdVector8 = pgTetraSet.getVertex(piVector.getEntry(2));
            PdVector pdVector9 = pgTetraSet.getVertex(piVector.getEntry(3));
            double d = pgVectorField.getVector(n2).getFirstEntry();
            double d2 = pgTetraSet.getVolumeOfTetra(n2) * d;
            PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])pgTetraSet.getVertices(), (int[])piVector.getEntries());
            double[] dArray3 = pdVector2.getEntries();
            pdVector3.sub(pdVector7, pdVector6);
            pdVector4.sub(pdVector8, pdVector6);
            pdVector5.sub(pdVector9, pdVector6);
            double[] dArray4 = pdVector3.getEntries();
            double[] dArray5 = pdVector4.getEntries();
            double[] dArray6 = pdVector5.getEntries();
            double d3 = 2.0 * d2 * 17.0 / 1920.0;
            double d4 = 2.0 * d2 / 1920.0;
            dArray2[0] = dArray2[0] + (d3 * (dArray4[0] * dArray4[0] + dArray5[0] * dArray5[0] + dArray6[0] * dArray6[0]) + 2.0 * d4 * (dArray4[0] * dArray5[0] + dArray5[0] * dArray6[0] + dArray6[0] * dArray4[0]));
            dArray2[1] = dArray2[1] + (d3 * (dArray4[1] * dArray4[0] + dArray5[1] * dArray5[0] + dArray6[1] * dArray6[0]) + d4 * (dArray4[1] * dArray5[0] + dArray4[0] * dArray5[1] + dArray5[1] * dArray6[0] + dArray5[0] * dArray6[1] + dArray6[1] * dArray4[0] + dArray6[0] * dArray4[1]));
            dArray2[2] = dArray2[2] + (d3 * (dArray4[1] * dArray4[1] + dArray5[1] * dArray5[1] + dArray6[1] * dArray6[1]) + 2.0 * d4 * (dArray4[1] * dArray5[1] + dArray5[1] * dArray6[1] + dArray6[1] * dArray4[1]));
            dArray2[3] = dArray2[3] + (d3 * (dArray4[2] * dArray4[0] + dArray5[2] * dArray5[0] + dArray6[2] * dArray6[0]) + d4 * (dArray4[2] * dArray5[0] + dArray4[0] * dArray5[2] + dArray5[2] * dArray6[0] + dArray5[0] * dArray6[2] + dArray6[2] * dArray4[0] + dArray6[0] * dArray4[2]));
            dArray2[4] = dArray2[4] + (d3 * (dArray4[2] * dArray4[1] + dArray5[2] * dArray5[1] + dArray6[2] * dArray6[1]) + d4 * (dArray4[2] * dArray5[1] + dArray4[1] * dArray5[2] + dArray5[2] * dArray6[1] + dArray5[1] * dArray6[2] + dArray6[2] * dArray4[1] + dArray6[1] * dArray4[2]));
            dArray2[5] = dArray2[5] + (d3 * (dArray4[2] * dArray4[2] + dArray5[2] * dArray5[2] + dArray6[2] * dArray6[2]) + 2.0 * d4 * (dArray4[2] * dArray5[2] + dArray5[2] * dArray6[2] + dArray6[2] * dArray4[2]));
            dArray2[0] = dArray2[0] + d2 * (dArray3[0] - dArray[0]) * (dArray3[0] - dArray[0]);
            dArray2[1] = dArray2[1] + d2 * (dArray3[1] - dArray[1]) * (dArray3[0] - dArray[0]);
            dArray2[2] = dArray2[2] + d2 * (dArray3[1] - dArray[1]) * (dArray3[1] - dArray[1]);
            dArray2[3] = dArray2[3] + d2 * (dArray3[2] - dArray[2]) * (dArray3[0] - dArray[0]);
            dArray2[4] = dArray2[4] + d2 * (dArray3[2] - dArray[2]) * (dArray3[1] - dArray[1]);
            dArray2[5] = dArray2[5] + d2 * (dArray3[2] - dArray[2]) * (dArray3[2] - dArray[2]);
        }
        PdMatrix pdMatrix = new PdMatrix(3);
        pdMatrix.setEntry(0, 0, dArray2[0]);
        pdMatrix.setEntry(0, 1, dArray2[1]);
        pdMatrix.setEntry(1, 1, dArray2[2]);
        pdMatrix.setEntry(0, 2, dArray2[3]);
        pdMatrix.setEntry(1, 2, dArray2[4]);
        pdMatrix.setEntry(2, 2, dArray2[5]);
        pdMatrix.setEntry(1, 0, dArray2[1]);
        pdMatrix.setEntry(2, 0, dArray2[3]);
        pdMatrix.setEntry(2, 1, dArray2[4]);
        return pdMatrix;
    }

    public static PdMatrix getWeightedCovarianceMatrix(PgTetraSet pgTetraSet, PdMatrix[] pdMatrixArray, PdVector pdVector, int[] nArray) {
        double[] dArray = pdVector.getEntries();
        double[] dArray2 = new double[6];
        dArray2[5] = 0.0;
        dArray2[4] = 0.0;
        dArray2[3] = 0.0;
        dArray2[2] = 0.0;
        dArray2[1] = 0.0;
        dArray2[0] = 0.0;
        double d = 0.0;
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            PiVector piVector = pgTetraSet.getTetra(n2);
            PdVector pdVector6 = pgTetraSet.getVertex(piVector.getEntry(0));
            PdVector pdVector7 = pgTetraSet.getVertex(piVector.getEntry(1));
            PdVector pdVector8 = pgTetraSet.getVertex(piVector.getEntry(2));
            PdVector pdVector9 = pgTetraSet.getVertex(piVector.getEntry(3));
            double d2 = pgTetraSet.getVolumeOfTetra(n2);
            PdMatrix pdMatrix = pdMatrixArray[n2];
            d += d2;
            PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])pgTetraSet.getVertices(), (int[])piVector.getEntries());
            pdVector2.leftMultMatrix(pdMatrix);
            double[] dArray3 = pdVector2.getEntries();
            pdVector3.sub(pdVector7, pdVector6);
            pdVector4.sub(pdVector8, pdVector6);
            pdVector5.sub(pdVector9, pdVector6);
            double[] dArray4 = pdVector3.getEntries();
            double[] dArray5 = pdVector4.getEntries();
            double[] dArray6 = pdVector5.getEntries();
            double d3 = 2.0 * d2 * 17.0 / 1920.0;
            double d4 = 2.0 * d2 / 1920.0;
            dArray2[0] = dArray2[0] + (d3 * (dArray4[0] * dArray4[0] + dArray5[0] * dArray5[0] + dArray6[0] * dArray6[0]) + 2.0 * d4 * (dArray4[0] * dArray5[0] + dArray5[0] * dArray6[0] + dArray6[0] * dArray4[0]));
            dArray2[1] = dArray2[1] + (d3 * (dArray4[1] * dArray4[0] + dArray5[1] * dArray5[0] + dArray6[1] * dArray6[0]) + d4 * (dArray4[1] * dArray5[0] + dArray4[0] * dArray5[1] + dArray5[1] * dArray6[0] + dArray5[0] * dArray6[1] + dArray6[1] * dArray4[0] + dArray6[0] * dArray4[1]));
            dArray2[2] = dArray2[2] + (d3 * (dArray4[1] * dArray4[1] + dArray5[1] * dArray5[1] + dArray6[1] * dArray6[1]) + 2.0 * d4 * (dArray4[1] * dArray5[1] + dArray5[1] * dArray6[1] + dArray6[1] * dArray4[1]));
            dArray2[3] = dArray2[3] + (d3 * (dArray4[2] * dArray4[0] + dArray5[2] * dArray5[0] + dArray6[2] * dArray6[0]) + d4 * (dArray4[2] * dArray5[0] + dArray4[0] * dArray5[2] + dArray5[2] * dArray6[0] + dArray5[0] * dArray6[2] + dArray6[2] * dArray4[0] + dArray6[0] * dArray4[2]));
            dArray2[4] = dArray2[4] + (d3 * (dArray4[2] * dArray4[1] + dArray5[2] * dArray5[1] + dArray6[2] * dArray6[1]) + d4 * (dArray4[2] * dArray5[1] + dArray4[1] * dArray5[2] + dArray5[2] * dArray6[1] + dArray5[1] * dArray6[2] + dArray6[2] * dArray4[1] + dArray6[1] * dArray4[2]));
            dArray2[5] = dArray2[5] + (d3 * (dArray4[2] * dArray4[2] + dArray5[2] * dArray5[2] + dArray6[2] * dArray6[2]) + 2.0 * d4 * (dArray4[2] * dArray5[2] + dArray5[2] * dArray6[2] + dArray6[2] * dArray4[2]));
            dArray2[0] = dArray2[0] + d2 * dArray3[0] * dArray3[0];
            dArray2[1] = dArray2[1] + d2 * dArray3[1] * dArray3[0];
            dArray2[2] = dArray2[2] + d2 * dArray3[1] * dArray3[1];
            dArray2[3] = dArray2[3] + d2 * dArray3[2] * dArray3[0];
            dArray2[4] = dArray2[4] + d2 * dArray3[2] * dArray3[1];
            dArray2[5] = dArray2[5] + d2 * dArray3[2] * dArray3[2];
        }
        dArray2[0] = dArray2[0] / d;
        dArray2[1] = dArray2[1] / d;
        dArray2[2] = dArray2[2] / d;
        dArray2[3] = dArray2[3] / d;
        dArray2[4] = dArray2[4] / d;
        dArray2[5] = dArray2[5] / d;
        dArray2[0] = dArray2[0] - dArray[0] * dArray[0];
        dArray2[1] = dArray2[1] - dArray[1] * dArray[0];
        dArray2[2] = dArray2[2] - dArray[1] * dArray[1];
        dArray2[3] = dArray2[3] - dArray[2] * dArray[0];
        dArray2[4] = dArray2[4] - dArray[2] * dArray[1];
        dArray2[5] = dArray2[5] - dArray[2] * dArray[2];
        PdMatrix pdMatrix = new PdMatrix(3);
        pdMatrix.setEntry(0, 0, dArray2[0]);
        pdMatrix.setEntry(0, 1, dArray2[1]);
        pdMatrix.setEntry(1, 1, dArray2[2]);
        pdMatrix.setEntry(0, 2, dArray2[3]);
        pdMatrix.setEntry(1, 2, dArray2[4]);
        pdMatrix.setEntry(2, 2, dArray2[5]);
        pdMatrix.setEntry(1, 0, dArray2[1]);
        pdMatrix.setEntry(2, 0, dArray2[3]);
        pdMatrix.setEntry(2, 1, dArray2[4]);
        return pdMatrix;
    }

    public static PdVector getBarycenter(PgElementSet pgElementSet) {
        PdVector pdVector = new PdVector(0.0, 0.0, 0.0);
        double d = 0.0;
        PdVector pdVector2 = new PdVector(3);
        int n = pgElementSet.getNumElements();
        for (int i = 0; i < n; ++i) {
            PiVector piVector = pgElementSet.getElement(i);
            double d2 = pgElementSet.getAreaOfElement(i);
            d += d2;
            PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])pgElementSet.getVertices(), (int[])piVector.getEntries());
            pdVector2.multScalar(d2);
            pdVector.add(pdVector2);
        }
        pdVector.multScalar(1.0 / d);
        return pdVector;
    }

    public static PdVector getBarycenter(PgTetraSet pgTetraSet) {
        PdVector pdVector = new PdVector(0.0, 0.0, 0.0);
        double d = 0.0;
        PdVector pdVector2 = new PdVector(3);
        int n = pgTetraSet.getNumTetras();
        for (int i = 0; i < n; ++i) {
            PiVector piVector = pgTetraSet.getTetra(i);
            double d2 = pgTetraSet.getVolumeOfTetra(i);
            d += d2;
            PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])pgTetraSet.getVertices(), (int[])piVector.getEntries());
            pdVector2.multScalar(d2);
            pdVector.add(pdVector2);
        }
        pdVector.multScalar(1.0 / d);
        return pdVector;
    }

    public static PdVector getBarycenter(PgElementSet pgElementSet, int[] nArray) {
        PdVector pdVector = new PdVector(0.0, 0.0, 0.0);
        double d = 0.0;
        PdVector pdVector2 = new PdVector(3);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            PiVector piVector = pgElementSet.getElement(n2);
            double d2 = pgElementSet.getAreaOfElement(n2);
            d += d2;
            PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])pgElementSet.getVertices(), (int[])piVector.getEntries());
            pdVector2.multScalar(d2);
            pdVector.add(pdVector2);
        }
        pdVector.multScalar(1.0 / d);
        return pdVector;
    }

    public static PdVector getBarycenter(PgTetraSet pgTetraSet, int[] nArray) {
        PdVector pdVector = new PdVector(0.0, 0.0, 0.0);
        double d = 0.0;
        PdVector pdVector2 = new PdVector(3);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            PiVector piVector = pgTetraSet.getElement(n2);
            double d2 = pgTetraSet.getVolumeOfTetra(n2);
            d += d2;
            PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])pgTetraSet.getVertices(), (int[])piVector.getEntries());
            pdVector2.multScalar(d2);
            pdVector.add(pdVector2);
        }
        pdVector.multScalar(1.0 / d);
        return pdVector;
    }

    public static PdVector getWeightedBarycenter(PgTetraSet pgTetraSet, PgVectorField pgVectorField, int[] nArray) {
        PdVector pdVector = new PdVector(0.0, 0.0, 0.0);
        double d = 0.0;
        PdVector pdVector2 = new PdVector(3);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            PiVector piVector = pgTetraSet.getTetra(n2);
            double d2 = pgVectorField.getVector(n2).getFirstEntry();
            double d3 = pgTetraSet.getVolumeOfTetra(n2) * d2;
            d += d3;
            PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])pgTetraSet.getVertices(), (int[])piVector.getEntries());
            pdVector2.multScalar(d3);
            pdVector.add(pdVector2);
        }
        pdVector.multScalar(1.0 / d);
        return pdVector;
    }

    public static PdVector getNormal(PgElementSet pgElementSet, PdVector pdVector) {
        PdVector pdVector2 = new PdVector(3);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)3, (int)3);
        PnJacobi.computeEigenvectors(PnPCA.getCovarianceMatrix(pgElementSet, pdVector), 3, pdVector2, pdVectorArray);
        int n = pdVector2.getEntry(0) < pdVector2.getEntry(1) && pdVector2.getEntry(0) < pdVector2.getEntry(2) ? 0 : (pdVector2.getEntry(1) < pdVector2.getEntry(2) ? 1 : 2);
        PdVector pdVector3 = PdVector.copyNew((PdVector)pdVectorArray[n]);
        pdVector3.normalize();
        return pdVector3;
    }

    public static PdVector getNormal(PgTetraSet pgTetraSet, PdVector pdVector) {
        PdVector pdVector2 = new PdVector(3);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)3, (int)3);
        PnJacobi.computeEigenvectors(PnPCA.getCovarianceMatrix(pgTetraSet, pdVector), 3, pdVector2, pdVectorArray);
        int n = pdVector2.getEntry(0) < pdVector2.getEntry(1) && pdVector2.getEntry(0) < pdVector2.getEntry(2) ? 0 : (pdVector2.getEntry(1) < pdVector2.getEntry(2) ? 1 : 2);
        PdVector pdVector3 = PdVector.copyNew((PdVector)pdVectorArray[n]);
        pdVector3.normalize();
        return pdVector3;
    }

    public static PdVector getNormal(PgElementSet pgElementSet, PdVector pdVector, int[] nArray) {
        PdVector pdVector2 = new PdVector(3);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)3, (int)3);
        PnJacobi.computeEigenvectors(PnPCA.getCovarianceMatrix(pgElementSet, pdVector, nArray), 3, pdVector2, pdVectorArray);
        int n = pdVector2.getEntry(0) < pdVector2.getEntry(1) && pdVector2.getEntry(0) < pdVector2.getEntry(2) ? 0 : (pdVector2.getEntry(1) < pdVector2.getEntry(2) ? 1 : 2);
        PdVector pdVector3 = PdVector.copyNew((PdVector)pdVectorArray[n]);
        pdVector3.normalize();
        return pdVector3;
    }

    public static PdVector getNormal(PgTetraSet pgTetraSet, PdVector pdVector, int[] nArray) {
        PdVector pdVector2 = new PdVector(3);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)3, (int)3);
        PnJacobi.computeEigenvectors(PnPCA.getCovarianceMatrix(pgTetraSet, pdVector, nArray), 3, pdVector2, pdVectorArray);
        int n = pdVector2.getEntry(0) < pdVector2.getEntry(1) && pdVector2.getEntry(0) < pdVector2.getEntry(2) ? 0 : (pdVector2.getEntry(1) < pdVector2.getEntry(2) ? 1 : 2);
        PdVector pdVector3 = PdVector.copyNew((PdVector)pdVectorArray[n]);
        pdVector3.normalize();
        return pdVector3;
    }

    public static PdVector getWeightedNormal(PgTetraSet pgTetraSet, PgVectorField pgVectorField, PdVector pdVector, int[] nArray) {
        PdVector pdVector2 = new PdVector(3);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)3, (int)3);
        PnJacobi.computeEigenvectors(PnPCA.getWeightedCovarianceMatrix(pgTetraSet, pgVectorField, pdVector, nArray), 3, pdVector2, pdVectorArray);
        int n = pdVector2.getEntry(0) < pdVector2.getEntry(1) && pdVector2.getEntry(0) < pdVector2.getEntry(2) ? 0 : (pdVector2.getEntry(1) < pdVector2.getEntry(2) ? 1 : 2);
        PdVector pdVector3 = PdVector.copyNew((PdVector)pdVectorArray[n]);
        pdVector3.normalize();
        return pdVector3;
    }

    public static PdVector getWeightedBarycenter(PgTetraSet pgTetraSet, PdMatrix[] pdMatrixArray, int[] nArray) {
        PdVector pdVector = new PdVector(0.0, 0.0, 0.0);
        double d = 0.0;
        PdVector pdVector2 = new PdVector(3);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            PiVector piVector = pgTetraSet.getTetra(n2);
            PdMatrix pdMatrix = pdMatrixArray[n2];
            double d2 = pgTetraSet.getVolumeOfTetra(n2);
            d += d2;
            PgGeometry.getCenterOfElement((PdVector)pdVector2, (PdVector[])pgTetraSet.getVertices(), (int[])piVector.getEntries());
            pdVector2.leftMultMatrix(pdMatrix);
            pdVector2.leftMultMatrix(pdMatrix);
            pdVector2.multScalar(d2);
            pdVector.add(pdVector2);
        }
        pdVector.multScalar(1.0 / d);
        return pdVector;
    }

    public static void transformToNormalPosition(PgElementSet pgElementSet) {
        int n;
        int n2;
        int n3 = pgElementSet.getDimOfVertices();
        PdMatrix pdMatrix = PnPCA.getCovarianceMatrix(pgElementSet);
        PdVector pdVector = new PdVector(n3);
        PdVector[] pdVectorArray = new PdVector[n3];
        for (int i = 0; i < n3; ++i) {
            pdVectorArray[i] = new PdVector(n3);
        }
        PnJacobi.computeEigenvectors(pdMatrix, n3, pdVector, pdVectorArray);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3 - 1; ++n) {
                if (!(pdVector.getEntry(n) < pdVector.getEntry(n + 1))) continue;
                PdVector pdVector2 = pdVectorArray[n];
                pdVectorArray[n] = pdVectorArray[n + 1];
                pdVectorArray[n + 1] = pdVector2;
                double d = pdVector.m_data[n];
                pdVector.m_data[n] = pdVector.m_data[n + 1];
                pdVector.m_data[n + 1] = d;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            pdVectorArray[n2].normalize();
        }
        PnPCA.transformCoordinateSystem((PgGeometry)pgElementSet, PnPCA.getBarycenter(pgElementSet), pdVectorArray, pgElementSet.getNumVertices(), pgElementSet.getNumElements());
        pgElementSet.makeElementNormals();
        n2 = pgElementSet.getNumVectorFields();
        for (n = 0; n < n2; ++n) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(n);
            PnPCA.transformCoordinateSystem((PgGeometry)pgVectorField, PnPCA.getBarycenter(pgElementSet), pdVectorArray, pgElementSet.getNumVertices(), pgElementSet.getNumElements());
        }
    }

    public static void transformCoordinateSystem(PgGeometry pgGeometry, PdVector pdVector, PdVector[] pdVectorArray, int n, int n2) {
        int n3;
        int n4 = pgGeometry.getDimOfVertices();
        for (int i = 0; i < n; ++i) {
            pgGeometry.getVertex(i).sub(pdVector);
        }
        PdMatrix pdMatrix = new PdMatrix(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            System.arraycopy(pdVectorArray[n3].m_data, 0, pdMatrix.m_data[n3], 0, n4);
        }
        pdMatrix.transpose();
        pdMatrix.invert();
        if (pgGeometry.getClass() == (class$jv$geom$PgElementSet == null ? (class$jv$geom$PgElementSet = PnPCA.class$("jv.geom.PgElementSet")) : class$jv$geom$PgElementSet)) {
            for (n3 = 0; n3 < n; ++n3) {
                pgGeometry.getVertex(n3).leftMultMatrix(pdMatrix);
            }
        } else if (pgGeometry.getClass() == (class$jv$geom$PgVectorField == null ? (class$jv$geom$PgVectorField = PnPCA.class$("jv.geom.PgVectorField")) : class$jv$geom$PgVectorField)) {
            PgVectorField pgVectorField = (PgVectorField)pgGeometry;
            if (pgVectorField.getBasedOn() == 1) {
                for (int i = 0; i < n2; ++i) {
                    pgVectorField.getVector(i).leftMultMatrix(pdMatrix);
                }
            } else if (pgVectorField.getBasedOn() == 0) {
                for (int i = 0; i < n; ++i) {
                    pgVectorField.getVector(i).leftMultMatrix(pdMatrix);
                }
            }
        } else {
            PsDebug.error((String)("Was asked to transform a coordinate system of geometry " + pgGeometry.getClass() + " which is neither a PgPointSet nor a PgElementSet nor a PgVectorField."));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

