/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnDiriEnergy;

public class PnHodgeU
extends PnDiriEnergy {
    protected PgVectorField m_vf;
    protected PdVector[][] m_gradFi;
    protected PiVector m_bndInd;
    protected PdVector m_areas = new PdVector(0);
    static /* synthetic */ Class class$jvx$numeric$PnHodgeU;

    public PnHodgeU() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnHodgeU == null ? (class$jvx$numeric$PnHodgeU = PnHodgeU.class$("jvx.numeric.PnHodgeU")) : class$jvx$numeric$PnHodgeU)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"Missing m_stiffMatrix, call setSurface before.");
            return;
        }
        super.initSurface(pgElementSet, pgElementSet2);
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        int n;
        super.setSurface(pgElementSet, pgElementSet2);
        int n2 = pgElementSet.getNumElements();
        int n3 = pgElementSet.getDimOfVertices();
        if (this.m_gradFi == null || this.m_gradFi.length != n2) {
            this.m_gradFi = new PdVector[n2][];
            for (n = 0; n < n2; ++n) {
                this.m_gradFi[n] = PdVector.realloc(null, (int)3, (int)n3);
            }
        }
        this.computeGradients();
        this.m_bndInd = new PiVector(this.m_nop - this.m_noiv);
        n = 0;
        for (int i = 0; i < this.m_nop; ++i) {
            if (this.m_invIndex[i] != -1) continue;
            this.m_bndInd.setEntry(n, i);
            ++n;
        }
        return true;
    }

    public void setVectorField(PgVectorField pgVectorField) {
        this.m_vf = pgVectorField;
    }

    protected void computeGradients() {
        if (this.m_domain == null) {
            PsDebug.warning((String)"Missing domain.");
            return;
        }
        int n = this.m_domain.getNumElements();
        PiVector[] piVectorArray = this.m_domain.getElements();
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        double[] dArray = new double[3];
        PdVector[] pdVectorArray2 = PdVector.realloc(null, (int)3, (int)this.m_domain.getDimOfVertices());
        this.m_areas.setSize(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            int[] nArray = piVectorArray[i].m_data;
            double d = this.m_domain.getAreaOfElement(i);
            this.m_areas.setEntry(i, d);
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray[nArray[0]], (PdVector)pdVectorArray[nArray[1]], (PdVector)pdVectorArray[nArray[2]]);
            for (n2 = 0; n2 < 3; ++n2) {
                pdVectorArray2[n2].sub(pdVectorArray[nArray[(n2 + 2) % 3]], pdVectorArray[nArray[(n2 + 1) % 3]]);
            }
            for (n2 = 0; n2 < 3; ++n2) {
                this.m_gradFi[i][n2].blend(dArray[(n2 + 1) % 3], pdVectorArray2[(n2 + 1) % 3], -dArray[(n2 + 2) % 3], pdVectorArray2[(n2 + 2) % 3]);
                this.m_gradFi[i][n2].multScalar(1.0 / (2.0 * d));
            }
        }
    }

    public double eval(PdVector pdVector) {
        if (this.m_vf == null) {
            return 0.0;
        }
        double d = super.eval(pdVector);
        int n = this.m_domain.getNumElements();
        PiVector[] piVectorArray = this.m_domain.getElements();
        PdVector[] pdVectorArray = this.m_vf.getVectors();
        int n2 = this.m_domain.getDimOfVertices();
        PdVector pdVector2 = new PdVector(n2);
        if (pdVectorArray != null && pdVectorArray.length == n) {
            for (int i = 0; i < n; ++i) {
                pdVector2.setConstant(0.0);
                for (int j = 0; j < 3; ++j) {
                    int n3 = piVectorArray[i].m_data[j];
                    for (int k = 0; k < n2; ++k) {
                        int n4 = k;
                        pdVector2.m_data[n4] = pdVector2.m_data[n4] + pdVector.m_data[this.m_dim * n3] * this.m_gradFi[i][j].m_data[k];
                    }
                }
                double d2 = this.m_areas.getEntry(i);
                d -= PdVector.dot((PdVector)pdVector2, (PdVector)pdVectorArray[i]) * d2;
            }
        }
        return d;
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        int n;
        int n2;
        pdVector2 = super.evalGradient(pdVector, pdVector2);
        if (this.m_vf == null) {
            return pdVector2;
        }
        PdVector[] pdVectorArray = this.m_vf.getVectors();
        int n3 = this.m_domain.getNumElements();
        if (pdVectorArray != null && pdVectorArray.length == n3) {
            PiVector[] piVectorArray = this.m_domain.getElements();
            for (n2 = 0; n2 < n3; ++n2) {
                int[] nArray = piVectorArray[n2].m_data;
                double d = this.m_areas.getEntry(n2);
                for (n = 0; n < 3; ++n) {
                    int n4 = nArray[n];
                    pdVector2.m_data[n4] = pdVector2.m_data[n4] - PdVector.dot((PdVector)this.m_gradFi[n2][n], (PdVector)pdVectorArray[n2]) * d;
                }
            }
        }
        if (this.m_bZeroGradient) {
            int n5 = this.m_bndInd.getSize();
            for (n2 = 0; n2 < n5; ++n2) {
                n = this.m_dim * this.m_bndInd.getEntry(n2);
                for (int i = 0; i < this.m_dim; ++i) {
                    pdVector2.m_data[n + i] = 0.0;
                }
            }
        }
        return pdVector2;
    }

    public PdVector[][] getGradFi() {
        return this.m_gradFi;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

