/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.DataOutputStream;
import jvx.loader.PsU3dBlock;

class PsU3dModelNodeBlock
extends PsU3dBlock {
    public String m_name;
    public int m_parentNodeCount;
    public String[] m_parentNodeName;
    public float[][][] m_parentNodeTransform;
    public String m_resourceName;
    public int m_modelVisibility = 3;

    public PsU3dModelNodeBlock() {
        this.m_blockType = -222;
    }

    public void setNumParents(int n) {
        this.m_parentNodeCount = n;
        this.m_parentNodeTransform = new float[n][4][4];
        this.m_parentNodeName = new String[n];
    }

    public void computeSize() {
        this.m_dataSize = this.m_name.length() + 2 + this.m_resourceName.length() + 2 + 8;
        for (int i = 0; i < this.m_parentNodeCount; ++i) {
            this.m_dataSize += this.m_parentNodeName[i].length() + 2 + 64;
        }
        this.m_metaDataSize = 0;
    }

    public void write(DataOutputStream dataOutputStream) {
        super.write(dataOutputStream);
        int n = this.writeString(dataOutputStream, this.m_name);
        this.writeUInt32(dataOutputStream, this.m_parentNodeCount);
        for (int i = 0; i < this.m_parentNodeCount; ++i) {
            n += this.writeString(dataOutputStream, this.m_parentNodeName[i]);
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.writeFloat32(dataOutputStream, this.m_parentNodeTransform[i][j][k]);
                }
            }
        }
        n += this.writeString(dataOutputStream, this.m_resourceName);
        this.writeUInt32(dataOutputStream, this.m_modelVisibility);
        this.writePaddingBytes(dataOutputStream, n %= 4);
    }
}

