/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

class PsPreviewCanvas
extends Canvas {
    protected Image m_image;
    protected int[] m_imageSize;
    protected Color m_displayBackgroundColor;
    protected int[] m_displayPosition;
    protected int[] m_paperPosition;
    protected String m_headLine = "";
    protected int m_headerFontSize = 24;
    protected int[] m_headLinePosition;

    PsPreviewCanvas() {
    }

    public void setImage(Image image) {
        this.m_image = image;
    }

    public void setImageSize(int[] nArray) {
        this.m_imageSize = nArray;
    }

    public void setDispBgColor(Color color) {
        this.m_displayBackgroundColor = color;
    }

    public void setHeadLine(String string) {
        this.m_headLine = string;
    }

    public void setHeaderFontSize(int n) {
        this.m_headerFontSize = n;
    }

    public void setHeadLinePosition(int[] nArray) {
        this.m_headLinePosition = nArray;
    }

    public void setDisplayPosition(int[] nArray) {
        this.m_displayPosition = nArray;
    }

    public void setPaperPosition(int[] nArray) {
        this.m_paperPosition = nArray;
    }

    public void paint(Graphics graphics) {
        Object object;
        super.paint(graphics);
        if (this.m_paperPosition != null) {
            graphics.setColor(new Color(255, 255, 255));
            graphics.fillRect(this.m_paperPosition[0], this.m_paperPosition[1], this.m_paperPosition[2], this.m_paperPosition[3]);
        }
        if (this.m_image != null && this.m_displayPosition != null) {
            if (this.m_displayPosition[2] * this.m_imageSize[1] == this.m_displayPosition[3] * this.m_imageSize[0]) {
                graphics.drawImage(this.m_image, this.m_displayPosition[0], this.m_displayPosition[1], this.m_displayPosition[2], this.m_displayPosition[3], null);
            } else {
                graphics.setColor(this.m_displayBackgroundColor);
                graphics.fillRect(this.m_displayPosition[0], this.m_displayPosition[1], this.m_displayPosition[2], this.m_displayPosition[3]);
                object = new int[4];
                if (this.m_displayPosition[2] * this.m_imageSize[1] > this.m_displayPosition[3] * this.m_imageSize[0]) {
                    object[1] = this.m_displayPosition[1];
                    object[3] = this.m_displayPosition[3];
                    object[2] = this.m_imageSize[0] * this.m_displayPosition[3] / this.m_imageSize[1];
                    object[0] = this.m_displayPosition[0] + (this.m_displayPosition[2] - object[2]) / 2;
                } else {
                    object[0] = this.m_displayPosition[0];
                    object[2] = this.m_displayPosition[2];
                    object[3] = this.m_imageSize[1] * this.m_displayPosition[2] / this.m_imageSize[0];
                    object[1] = this.m_displayPosition[1] + (this.m_displayPosition[3] - object[3]) / 2;
                }
                graphics.drawImage(this.m_image, (int)object[0], (int)object[1], (int)object[2], (int)object[3], null);
            }
        }
        graphics.setColor(new Color(0, 0, 0));
        object = new Font("Helvetica", 0, this.m_headerFontSize);
        graphics.setFont((Font)object);
        graphics.drawString(this.m_headLine, this.m_headLinePosition[0], this.m_headLinePosition[1]);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

