/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jv.loader.PgAbstractLoader;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgXyzLoader
extends PgAbstractLoader {
    private static final String[] elementSymbols = new String[]{"Xx", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt"};
    private static Hashtable htElementMap;
    private static final int elementNumberMax;
    private static final short[] covalentMars;
    private static final int[] argbsCpk;

    public static PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open((String)string);
        if (bufferedReader == null) {
            PsDebug.warning((String)("could not open = " + string));
            return null;
        }
        PgXyzLoader pgXyzLoader = new PgXyzLoader();
        PgJvxSrc[] pgJvxSrcArray = pgXyzLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pgJvxSrcArray != null && pgJvxSrcArray.length > 0 && pgJvxSrcArray[0] != null) {
            pgJvxSrcArray[0].setName(PsUtil.getFileBaseName((String)string));
        }
        return pgJvxSrcArray;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        this.m_geomArr = null;
        try {
            this.m_geomArr = this.parse(bufferedReader);
            if (this.m_geomArr == null) {
                PsDebug.warning((String)"error during parsing of reader");
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)"error when during parsing of reader");
            iOException.printStackTrace();
            return null;
        }
        if (this.m_bIsAnimation) {
            this.m_animArr = new PgJvxSrc[this.m_geomArr.length][1];
            for (int i = 0; i < this.m_geomArr.length; ++i) {
                this.m_animArr[i][0] = this.m_geomArr[i];
            }
        }
        return this.m_geomArr;
    }

    protected PgJvxSrc[] parse(BufferedReader bufferedReader) throws IOException {
        PgJvxSrc[] pgJvxSrcArray;
        int n;
        Vector<PgJvxSrc[]> vector = new Vector<PgJvxSrc[]>();
        int n2 = 0;
        while ((n = this.readAtomCount(bufferedReader)) > 0) {
            pgJvxSrcArray = new PgJvxSrc();
            pgJvxSrcArray.setType(32);
            pgJvxSrcArray.setName(bufferedReader.readLine());
            pgJvxSrcArray.setNumVertices(n);
            pgJvxSrcArray.showVertices(true);
            pgJvxSrcArray.showPolygons(true);
            pgJvxSrcArray.setGlobalVertexSize(7.0);
            pgJvxSrcArray.setGlobalPolygonSize(5.0);
            this.readAtoms(bufferedReader, (PgJvxSrc)pgJvxSrcArray, n, n2);
            if (n == 0) {
                PsDebug.warning((String)("missing atoms in model = " + String.valueOf(n2)));
                return null;
            }
            if (n2 > 0) {
                PgJvxSrc pgJvxSrc = (PgJvxSrc)vector.elementAt(0);
                pgJvxSrcArray.setNumPolygons(pgJvxSrc.getNumPolygons());
                pgJvxSrcArray.setPolygons(pgJvxSrc.getPolygons());
            }
            vector.addElement(pgJvxSrcArray);
            ++n2;
        }
        if (n2 == 0) {
            PsDebug.warning((String)"missing model");
            return null;
        }
        if (n2 > 1) {
            this.m_bIsAnimation = true;
        }
        pgJvxSrcArray = new PgJvxSrc[n2];
        for (int i = 0; i < n2; ++i) {
            pgJvxSrcArray[i] = (PgJvxSrc)vector.elementAt(i);
        }
        return pgJvxSrcArray;
    }

    private int readAtomCount(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            return 0;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ");
        if (!stringTokenizer.hasMoreTokens()) {
            return 0;
        }
        return Integer.parseInt(stringTokenizer.nextToken());
    }

    private void readAtoms(BufferedReader bufferedReader, PgJvxSrc pgJvxSrc, int n, int n2) throws IOException {
        int n3;
        boolean bl = false;
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)pgJvxSrc.getNumVertices(), (int)3);
        double[] dArray = new double[4];
        int[] nArray = new int[n];
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine(), "\t ");
            String string = stringTokenizer.nextToken().intern();
            nArray[i] = PgXyzLoader.elementNumberFromSymbol(string);
            colorArray[i] = new Color(argbsCpk[nArray[i]]);
            double d = PuDouble.parseDouble((String)stringTokenizer.nextToken());
            double d2 = PuDouble.parseDouble((String)stringTokenizer.nextToken());
            double d3 = PuDouble.parseDouble((String)stringTokenizer.nextToken());
            PdVector pdVector = new PdVector(d, d2, d3);
            pdVector.setName(string);
            pgJvxSrc.setVertex(i, pdVector);
            for (n3 = 0; n3 < 4 && stringTokenizer.hasMoreTokens(); ++n3) {
                dArray[n3] = PuDouble.parseDouble((String)stringTokenizer.nextToken());
            }
            if (n3 < 3) continue;
            bl = true;
            double d4 = dArray[n3 - 3];
            double d5 = dArray[n3 - 2];
            double d6 = dArray[n3 - 1];
            pdVectorArray[i].set(d4, d5, d6);
        }
        pgJvxSrc.setVertexColors(colorArray);
        pgJvxSrc.showVertexColors(true);
        pgJvxSrc.showPolygonColors(true);
        pgJvxSrc.showSmoothEdgeColors(true);
        pgJvxSrc.showEdgeColorFromVertices(true);
        if (bl) {
            pgJvxSrc.setNumVectorFields(1);
            pgJvxSrc.setVectors(0, pdVectorArray);
        }
        if (n2 == 0) {
            pgJvxSrc.setNumPolygons(n);
            pgJvxSrc.setNumPolygons(0);
            float f = 0.4f;
            for (int i = 0; i < n; ++i) {
                short s = covalentMars[nArray[i]];
                for (int j = i + 1; j < n; ++j) {
                    n3 = covalentMars[nArray[j]];
                    float f2 = (float)(s + n3 + 450) / 1000.0f;
                    float f3 = (float)PdVector.dist((PdVector)pgJvxSrc.getVertex(i), (PdVector)pgJvxSrc.getVertex(j));
                    if (!(f < f3) || !(f3 < f2)) continue;
                    pgJvxSrc.addPolygon(new PiVector(i, j));
                }
            }
        }
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PsDebug.error((String)"export of XYZ geometries not available");
        return true;
    }

    private static byte elementNumberFromSymbol(String string) {
        Serializable serializable;
        if (htElementMap == null) {
            serializable = new Hashtable();
            int n = elementNumberMax;
            while (--n >= 0) {
                String string2 = elementSymbols[n];
                Integer n2 = new Integer(n);
                ((Hashtable)serializable).put(string2, n2);
                if (string2.length() != 2) continue;
                string2 = "" + string2.charAt(0) + Character.toUpperCase(string2.charAt(1));
                ((Hashtable)serializable).put(string2, n2);
            }
            htElementMap = serializable;
        }
        if (string == null) {
            System.out.println("elementNumberFromSymbol(null) ?");
            return 0;
        }
        serializable = (Integer)htElementMap.get(string);
        if (serializable != null) {
            return (byte)((Integer)serializable).intValue();
        }
        System.out.println("" + string + "' is not a recognized symbol");
        return 0;
    }

    static {
        elementNumberMax = elementSymbols.length;
        covalentMars = new short[]{2000, 230, 930, 680, 350, 830, 680, 680, 680, 640, 1120, 970, 1100, 1350, 1200, 750, 1020, 990, 1570, 1330, 990, 1440, 1470, 1330, 1350, 1350, 1340, 1330, 1500, 1520, 1450, 1220, 1170, 1210, 1220, 1210, 1910, 1470, 1120, 1780, 1560, 1480, 1470, 1350, 1400, 1450, 1500, 1590, 1690, 1630, 1460, 1460, 1470, 1400, 1980, 1670, 1340, 1870, 1830, 1820, 1810, 1800, 1800, 1990, 1790, 1760, 1750, 1740, 1730, 1720, 1940, 1720, 1570, 1430, 1370, 1350, 1370, 1320, 1500, 1500, 1700, 1550, 1540, 1540, 1680, 1700, 2400, 2000, 1900, 1880, 1790, 1610, 1580, 1550, 1530, 1510, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1600, 1600, 1600, 1600, 1600, 1600};
        argbsCpk = new int[]{-60269, -1, -2490369, -3374849, -3997952, -19019, -7303024, -13610760, -62195, -7282608, -4987915, -5546766, -7667968, -4217178, -997216, Short.MIN_VALUE, -208, -14684129, -8334877, -7388972, -12714240, -1644826, -4209977, -5855573, -7693881, -6522169, -2070989, -1011552, -11481008, -3637197, -8552272, -4026481, -10055793, -4357917, -24320, -5887703, -10700591, -9425232, -16711936, -7012353, -7020320, -9190711, -11225675, -12869986, -14381169, -16089716, -16750203, -4144960, -9841, -5868173, -10059648, -6397003, -2852352, -7077740, -12411216, -11069553, -16725760, -9382657, -57, -2490425, -3670073, -6029369, -7340089, -10354745, -12189753, -13566009, -14680121, -16711780, -16718219, -16722862, -16728264, -16733404, -11681025, -11688193, -14576426, -14254677, -14260586, -15248249, -3092256, -11997, -4671280, -5876659, -11052703, -6402123, -5547008, -9089211, -12418410, -12451738, -16745216, -9393158, -16729345, -16735745, -16740353, -16744193, -16749569, -11248398, -8889117, -7712797, -6211884, -5038124, -5038150, -5042778, -4387449, -3735450, -3407783, -3080113, -2555835, -2097096, -1703890, -1376218};
    }
}

