/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import jv.object.PsObject;
import jvx.loader.PsU3dBlock;
import jvx.loader.PsU3dHeaderBlock;
import jvx.loader.PsU3dPriorityUpdateBlock;

public class PgU3dSrc
extends PsObject {
    public Hashtable[] m_palette = new Hashtable[8];
    public static final int MODEL_PALETTE = 0;
    public static final int LIGHT_PALETTE = 1;
    public static final int VIEW_PALETTE = 2;
    public static final int TEXTURE_PALETTE = 3;
    public static final int SHADER_PALETTE = 4;
    public static final int MATERIAL_PALETTE = 5;
    public static final int MOTION_PALETTEE = 6;
    public static final int NODE_PALETTE = 7;
    public PsU3dHeaderBlock m_header;
    public static final boolean m_bIncludePriorityUpdates = false;

    public PgU3dSrc() {
        for (int i = 0; i < 8; ++i) {
            this.m_palette[i] = new Hashtable();
        }
        this.m_header = new PsU3dHeaderBlock();
    }

    public void write(DataOutputStream dataOutputStream) {
        PsU3dBlock psU3dBlock;
        this.m_header.m_fileSize += 32L;
        this.m_header.m_declarationSize += 32;
        this.computeFileSize();
        this.m_header.write(dataOutputStream);
        PsU3dPriorityUpdateBlock psU3dPriorityUpdateBlock = new PsU3dPriorityUpdateBlock();
        Enumeration enumeration = this.m_palette[7].elements();
        while (enumeration.hasMoreElements()) {
            psU3dBlock = (PsU3dBlock)((Object)enumeration.nextElement());
            psU3dBlock.write(dataOutputStream);
        }
        for (int i = 1; i < 7; ++i) {
            enumeration = this.m_palette[i].elements();
            while (enumeration.hasMoreElements()) {
                psU3dBlock = (PsU3dBlock)((Object)enumeration.nextElement());
                psU3dBlock.write(dataOutputStream);
            }
        }
        enumeration = this.m_palette[0].elements();
        while (enumeration.hasMoreElements()) {
            psU3dBlock = (PsU3dBlock)((Object)enumeration.nextElement());
            psU3dBlock.write(dataOutputStream);
        }
    }

    public void computeFileSize() {
        PsU3dBlock psU3dBlock;
        int n;
        this.m_header.m_declarationSize = n = this.m_header.getSize();
        this.m_header.m_fileSize = n;
        Enumeration enumeration = this.m_palette[7].elements();
        while (enumeration.hasMoreElements()) {
            psU3dBlock = (PsU3dBlock)((Object)enumeration.nextElement());
            n = psU3dBlock.getSize();
            this.m_header.m_fileSize += (long)n;
        }
        for (int i = 0; i < 7; ++i) {
            enumeration = this.m_palette[i].elements();
            while (enumeration.hasMoreElements()) {
                psU3dBlock = (PsU3dBlock)((Object)enumeration.nextElement());
                n = psU3dBlock.getSize();
                this.m_header.m_fileSize += (long)n;
            }
        }
    }
}

