/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import jv.geom.PgElementSet;
import jv.loader.PgAbstractLoader;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.rsrc.PsJavaView;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.loader.PgMacroPatch;

public final class PgBdLoader
extends PgAbstractLoader {
    protected String m_task;
    protected int m_startFrame;
    protected int m_endFrame;
    protected int m_numIntegerParms;
    protected int m_numDoubleParms;
    protected int m_numPatches;
    protected int m_numVertices;
    protected PdVector[] m_vertex;
    protected PiVector[] m_vertexType;
    protected PgElementSet[] m_elemArr;
    protected PgMacroPatch[] m_patch;

    public PgGeometryIf[] getSpecializedGeometries() {
        return this.m_elemArr;
    }

    public int getNumPatches() {
        return this.m_numPatches;
    }

    public PgMacroPatch getPatch(int n) {
        if (this.m_patch == null) {
            PsDebug.warning((String)"m_Patch==null");
            return null;
        }
        if (n < 0 || this.m_patch.length <= n) {
            PsDebug.warning((String)"index out of range");
            return null;
        }
        return this.m_patch[n];
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        this.m_elemArr = this.readElementSet(bufferedReader);
        if (this.m_elemArr == null) {
            PsDebug.warning((String)"error during parsing.");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[this.m_elemArr.length];
        for (int i = 0; i < this.m_elemArr.length; ++i) {
            pgJvxSrcArray[i] = this.m_elemArr[i].getJvx();
        }
        return pgJvxSrcArray;
    }

    public PgElementSet[] readElementSet(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        boolean bl = this.parse(bufferedReader);
        if (!bl) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        int n = this.getNumPatches();
        PgElementSet pgElementSet = null;
        for (int i = 0; i < n; ++i) {
            PgMacroPatch pgMacroPatch = this.getPatch(i);
            PgElementSet pgElementSet2 = pgMacroPatch.buildElementSet(null);
            if (n == 1 || i == 0) {
                pgElementSet = pgElementSet2;
                continue;
            }
            pgElementSet.merge((PgGeometryIf)pgElementSet2);
        }
        pgElementSet.close();
        if (PsJavaView.m_bAutoNormals) {
            pgElementSet.makeVertexNormals();
        }
        if (PsJavaView.m_bAutoElementNormals) {
            pgElementSet.makeElementNormals();
        }
        this.m_elemArr = new PgElementSet[]{pgElementSet};
        return this.m_elemArr;
    }

    private int nextToken(StreamTokenizer streamTokenizer) throws IOException {
        block6: while (true) {
            switch (streamTokenizer.nextToken()) {
                case -1: {
                    return -1;
                }
                case 10: {
                    continue block6;
                }
                case -3: {
                    return -3;
                }
                case -2: {
                    return -2;
                }
            }
            PsDebug.warning((String)"token not identified");
        }
    }

    protected boolean parse(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing argumnt");
            return false;
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.whitespaceChars(59, 59);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        try {
            int n;
            int n2;
            if (this.nextToken(streamTokenizer) != -3) {
                PsDebug.warning((String)"failed reading m_task");
                return false;
            }
            this.m_task = new String(streamTokenizer.sval);
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.warning((String)"failed reading m_startFrame");
                return false;
            }
            this.m_startFrame = (int)streamTokenizer.nval;
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.warning((String)"failed reading m_endFrame");
                return false;
            }
            this.m_endFrame = (int)streamTokenizer.nval;
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.warning((String)"failed reading m_numIntegerParms");
                return false;
            }
            this.m_numIntegerParms = (int)streamTokenizer.nval;
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.warning((String)"failed reading m_numDoubleParms");
                return false;
            }
            this.m_numDoubleParms = (int)streamTokenizer.nval;
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.warning((String)"failed reading numPatches");
                return false;
            }
            this.m_numPatches = (int)streamTokenizer.nval;
            this.m_patch = new PgMacroPatch[this.m_numPatches];
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.warning((String)"Number expected");
                return false;
            }
            this.m_numVertices = (int)streamTokenizer.nval;
            this.m_vertexType = new PiVector[this.m_numVertices];
            this.m_vertex = new PdVector[this.m_numVertices];
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                this.m_vertexType[n2] = new PiVector(3);
                this.m_vertex[n2] = new PdVector(3);
                for (n = 0; n < 3; ++n) {
                    if (this.nextToken(streamTokenizer) != -2) {
                        PsDebug.warning((String)("failed reading m_vertexType[" + n2 + "].m_data[" + n + "]"));
                        return false;
                    }
                    this.m_vertexType[n2].m_data[n] = (int)streamTokenizer.nval;
                }
                for (n = 0; n < 3; ++n) {
                    if (this.nextToken(streamTokenizer) != -2) {
                        PsDebug.warning((String)("failed reading m_vertex[" + n2 + "].m_data[" + n + "]"));
                        return false;
                    }
                    this.m_vertex[n2].m_data[n] = streamTokenizer.nval;
                }
            }
            for (n2 = 0; n2 < this.m_numPatches; ++n2) {
                int n3;
                int n4;
                String string;
                int n5;
                this.m_patch[n2] = new PgMacroPatch(3);
                this.m_patch[n2].setVertexType(this.m_vertexType);
                this.m_patch[n2].setVertex(this.m_vertex);
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading orientation in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].setOrientation((int)streamTokenizer.nval);
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading bndType in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].setBndType((int)streamTokenizer.nval);
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading patchLength in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].setNumVertices((int)streamTokenizer.nval);
                int n6 = this.m_patch[n2].getNumVertices();
                for (n5 = 0; n5 < n6; ++n5) {
                    if (this.nextToken(streamTokenizer) != -2) {
                        PsDebug.warning((String)("error reading element[" + n5 + "] in patch[" + n2 + "]"));
                        return false;
                    }
                    this.m_patch[n2].m_element.m_data[n5] = (int)streamTokenizer.nval;
                }
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading numULines in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].m_numULines = (int)streamTokenizer.nval;
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading numVLines in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].m_numVLines = (int)streamTokenizer.nval;
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading numUSubs in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].m_numUSubs = (int)streamTokenizer.nval;
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading numVSubs in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].m_numVSubs = (int)streamTokenizer.nval;
                if (this.m_patch[n2].getBndType() == 1) {
                    for (n5 = 0; n5 < n6; ++n5) {
                        if (this.nextToken(streamTokenizer) != -2) {
                            PsDebug.warning((String)("error reading bndShape[" + n5 + "][0] in patch[" + n2 + "]"));
                            return false;
                        }
                        string = Integer.toString((int)streamTokenizer.nval);
                        n4 = Integer.parseInt(string, 8);
                        string = Integer.toBinaryString(n4);
                        n3 = string.length();
                        for (n = 0; n < n3; ++n) {
                            if (string.charAt(n3 - 1 - n) == '1') {
                                this.m_patch[n2].m_bndShapeBits[n5].set(n);
                                continue;
                            }
                            this.m_patch[n2].m_bndShapeBits[n5].clear(n);
                        }
                        if (this.nextToken(streamTokenizer) != -2) {
                            PsDebug.warning((String)("error reading bndShape[" + n5 + "][" + 0 + "] in patch[" + n2 + "]"));
                            return false;
                        }
                        this.m_patch[n2].m_bndShape[n5].m_data[0] = (int)streamTokenizer.nval;
                        if (this.m_patch[n2].m_bndShapeBits[n5].get(7) && !(this.m_patch[n2].m_bndShapeBits[n5].get(7) && this.m_patch[n2].m_bndShapeBits[n5].get(5))) continue;
                        for (n = 1; n < 3; ++n) {
                            if (this.nextToken(streamTokenizer) != -2) {
                                PsDebug.warning((String)("error reading bndShape[" + n5 + "][" + n + "] in patch[" + n2 + "]"));
                                return false;
                            }
                            this.m_patch[n2].m_bndShape[n5].m_data[n] = (int)streamTokenizer.nval;
                        }
                    }
                    continue;
                }
                for (n5 = 0; n5 < n6; ++n5) {
                    string = Integer.toString(220);
                    n4 = Integer.parseInt(string, 8);
                    string = Integer.toBinaryString(n4);
                    n3 = string.length();
                    for (n = 0; n < n3; ++n) {
                        if (string.charAt(n3 - 1 - n) == '1') {
                            this.m_patch[n2].m_bndShapeBits[n5].set(n);
                            continue;
                        }
                        this.m_patch[n2].m_bndShapeBits[n5].clear(n);
                    }
                }
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown = " + iOException.toString() + "\n\tparsing broke abnormally in line=" + streamTokenizer.lineno() + ",\n\treading st.sval=" + streamTokenizer.sval + ",\n\tst.ttype=" + streamTokenizer.ttype));
            return false;
        }
        PsDebug.notify((String)"... finished");
        return true;
    }
}

