/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PdVector_IP;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuReflect;
import jvx.project.PjWorkshop;

public class PwTransform
extends PjWorkshop {
    protected PuDouble[] m_scale;
    protected PuDouble[] m_trans;
    protected PuDouble[] m_rotate;
    protected PuDouble m_scaleAll;
    private double[] m_scaleOld;
    private double[] m_transOld;
    private double[] m_rotateOld;
    private double m_scaleAllOld;
    protected PuDouble[] m_scaleTex;
    protected PuDouble[] m_transTex;
    protected PuDouble[] m_rotateTex;
    protected PuDouble m_scaleAllTex;
    private double[] m_scaleTexOld;
    private double[] m_transTexOld;
    private double[] m_rotateTexOld;
    private double m_scaleAllTexOld;
    protected PuDouble m_scaleVectorFields;
    protected PuDouble m_rotateVectorFields;
    private double m_scaleVectorFieldsOld;
    private double m_rotateVectorFieldsOld;
    protected PgPointSet m_geom;
    protected int m_dim = 0;
    protected int m_numRotateAxis;
    protected boolean m_bWholeScene;
    protected boolean m_bSelectedGeometriesOnly;
    protected PgPointSet m_pCenter = new PgPointSet(this.m_dim);
    protected boolean m_bUseBaryCenterOfGeom;
    protected boolean m_bSelectedVerticesOnly;
    protected PdVector_IP m_center_IP;
    protected PdVector_IP m_centerTex_IP;
    protected PuFunction m_function;
    protected static String[] m_defExpr = new String[]{"u", "v", "sin(u)*cos(v)"};
    static /* synthetic */ Class class$jvx$geom$PwTransform;

    public PwTransform() {
        super(PsConfig.getMessage((int)48024));
        this.m_pCenter.setNumVertices(1);
        PdVector pdVector = this.m_pCenter.getVertex(0);
        pdVector.setName(PsConfig.getMessage((int)54471));
        this.m_pCenter.setName(pdVector.getName());
        this.m_pCenter.showVertexLabels(true);
        this.m_pCenter.addUpdateListener((PsUpdateIf)this);
        this.m_center_IP = new PdVector_IP();
        this.m_center_IP.setTitle("Origin");
        this.m_center_IP.setParent((PsUpdateIf)this);
        this.m_center_IP.setVector(this.m_pCenter.getVertex(0));
        this.m_scaleAll = new PuDouble(PsConfig.getMessage((int)54470), (PsUpdateIf)this);
        this.m_scaleTex = new PuDouble[2];
        this.m_transTex = new PuDouble[2];
        this.m_rotateTex = new PuDouble[1];
        this.m_scaleTexOld = new double[2];
        this.m_transTexOld = new double[2];
        this.m_rotateTexOld = new double[2];
        for (int i = 0; i < 2; ++i) {
            this.m_scaleTex[i] = new PuDouble(PsConfig.getMessage((int)54384) + " " + i, (PsUpdateIf)this);
            this.m_transTex[i] = new PuDouble(PsConfig.getMessage((int)54386) + " " + i, (PsUpdateIf)this);
        }
        this.m_rotateTex[0] = new PuDouble(PsConfig.getMessage((int)54385) + " " + 0, (PsUpdateIf)this);
        this.m_scaleAllTex = new PuDouble(PsConfig.getMessage((int)54470), (PsUpdateIf)this);
        this.m_centerTex_IP = new PdVector_IP();
        this.m_centerTex_IP.setTitle("Origin");
        this.m_centerTex_IP.setParent((PsUpdateIf)this);
        this.m_centerTex_IP.setVector(new PdVector(0.5, 0.5));
        this.m_scaleVectorFields = new PuDouble("Scale", (PsUpdateIf)this);
        this.m_rotateVectorFields = new PuDouble("Rotate in tangent plane", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwTransform == null ? (class$jvx$geom$PwTransform = PwTransform.class$("jvx.geom.PwTransform")) : class$jvx$geom$PwTransform)) {
            this.init();
        }
    }

    public void init() {
        int n;
        int n2;
        super.init();
        this.m_scaleAll.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_scaleAll.setDefValue(1.0);
        this.m_scaleAll.init();
        this.m_scaleAllOld = 1.0;
        this.m_bUseBaryCenterOfGeom = true;
        this.m_bWholeScene = false;
        this.m_bSelectedGeometriesOnly = false;
        this.m_bSelectedVerticesOnly = false;
        for (n2 = 0; n2 < 2; ++n2) {
            this.m_scaleTexOld[n2] = 1.0;
            this.m_transTexOld[n2] = 0.0;
            this.m_scaleTex[n2].setDefBounds(0.0, 10.0, 0.1, 1.0);
            this.m_scaleTex[n2].setDefValue(1.0);
            this.m_scaleTex[n2].init();
            this.m_transTex[n2].setDefBounds(-1.0, 1.0, 0.05, 0.1);
            this.m_transTex[n2].setDefValue(0.0);
            this.m_transTex[n2].init();
        }
        this.m_rotateTexOld[0] = 0.0;
        this.m_rotateTex[0].setDefBounds(-360.0, 360.0, 1.0, 10.0);
        this.m_rotateTex[0].setDefValue(0.0);
        this.m_rotateTex[0].init();
        this.m_scaleAllTex.setDefBounds(0.1, 10.0, 0.1, 1.0);
        this.m_scaleAllTex.setDefValue(1.0);
        this.m_scaleAllTex.init();
        this.m_scaleAllTexOld = 1.0;
        this.m_scaleVectorFields.setDefBounds(0.0, 10.0, 1.0, 1.0);
        this.m_scaleVectorFields.setDefValue(1.0);
        this.m_scaleVectorFields.init();
        this.m_scaleVectorFieldsOld = 1.0;
        this.m_rotateVectorFields.setDefBounds(-360.0, 360.0, 1.0, 1.0);
        this.m_rotateVectorFields.setDefValue(1.0);
        this.m_rotateVectorFields.init();
        this.m_rotateVectorFieldsOld = 0.0;
        n2 = this.m_dim;
        for (n = 0; n < n2; ++n) {
            this.m_scaleOld[n] = 1.0;
            this.m_transOld[n] = 0.0;
            this.m_scale[n].setDefBounds(0.1, 10.0, 0.1, 1.0);
            this.m_scale[n].setDefValue(1.0);
            this.m_scale[n].init();
            this.m_trans[n].setDefBounds(-10.0, 10.0, 0.1, 1.0);
            this.m_trans[n].setDefValue(0.0);
            this.m_trans[n].init();
        }
        for (n = 0; n < this.m_numRotateAxis; ++n) {
            this.m_rotateOld[n] = 0.0;
            this.m_rotate[n].setDefBounds(-360.0, 360.0, 1.0, 10.0);
            this.m_rotate[n].setDefValue(0.0);
            this.m_rotate[n].init();
        }
        if (this.m_function != null) {
            this.m_function.init();
        }
    }

    public void reset() {
        super.reset();
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.m_pCenter.getVertex(0).set(0.0, 0.0, 0.0);
        this.m_centerTex_IP.getVector().set(0.5, 0.5);
        this.update(this.m_center_IP);
    }

    public void close() {
        if (this.m_display != null && this.m_pCenter.hasDisplay(this.m_display)) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_pCenter);
            this.m_display.update((Object)this.m_display);
        }
        super.close();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgPointSet)) {
            PsDebug.warning((String)"workshop requires instance of PgPointSet.");
            return;
        }
        super.setGeometry(pgGeometry);
        this.m_geom = (PgPointSet)pgGeometry;
        this.setDimension(this.m_geom.getDimOfVertices());
        double d = this.m_geom.getDiameter();
        for (int i = 0; i < this.m_dim; ++i) {
            this.m_trans[i].setBounds(-3.0 * d, 3.0 * d, 0.01 * d, 0.1 * d);
            this.m_trans[i].update((Object)this.m_trans[i]);
        }
        this.init();
    }

    public void setDimension(int n) {
        int n2;
        if (n == this.m_dim) {
            return;
        }
        this.m_dim = n;
        this.m_numRotateAxis = n == 3 ? 3 : (n == 2 ? 1 : 0);
        this.m_scale = new PuDouble[n];
        this.m_trans = new PuDouble[n];
        this.m_rotate = new PuDouble[this.m_numRotateAxis];
        this.m_scaleOld = new double[n];
        this.m_transOld = new double[n];
        this.m_rotateOld = new double[this.m_numRotateAxis];
        for (n2 = 0; n2 < n; ++n2) {
            this.m_scale[n2] = new PuDouble(PsConfig.getMessage((int)54384) + " " + n2, (PsUpdateIf)this);
            this.m_trans[n2] = new PuDouble(PsConfig.getMessage((int)54386) + " " + n2, (PsUpdateIf)this);
        }
        for (n2 = 0; n2 < this.m_numRotateAxis; ++n2) {
            this.m_rotate[n2] = new PuDouble(PsConfig.getMessage((int)54385) + " " + n2, (PsUpdateIf)this);
        }
        this.m_pCenter.setDimOfVertices(n);
        this.m_function = new PuFunction(n, n);
        this.m_function.setParent((PsUpdateIf)this);
        this.m_function.setName(PsConfig.getMessage((int)15044));
        n2 = Math.min(n, m_defExpr.length);
        for (int i = 0; i < n2; ++i) {
            this.m_function.setExpression(i, m_defExpr[i]);
        }
    }

    public boolean update(Object object) {
        if (object == this.m_pCenter) {
            this.m_center_IP.update((Object)this.m_pCenter.getVertex(0));
            return true;
        }
        if (object == this.m_center_IP) {
            this.m_pCenter.update((Object)this.m_pCenter);
            return true;
        }
        if (object == this.m_centerTex_IP) {
            return true;
        }
        if (this.transformGeometries(object)) {
            return true;
        }
        return super.update(object);
    }

    private boolean transformGeometries(Object object) {
        int n;
        int n2;
        PgGeometryIf[] pgGeometryIfArray;
        if (this.m_bWholeScene) {
            pgGeometryIfArray = this.m_display.getGeometries();
            for (n2 = 0; n2 < pgGeometryIfArray.length; ++n2) {
                if (!(pgGeometryIfArray[n2] instanceof PgPointSet) || pgGeometryIfArray[n2] == this.m_pCenter) continue;
                if (!this.transformGeometry((PgPointSet)pgGeometryIfArray[n2], object)) {
                    return false;
                }
                pgGeometryIfArray[n2].update((Object)pgGeometryIfArray[n2]);
            }
        } else if (this.m_bSelectedGeometriesOnly) {
            pgGeometryIfArray = this.m_display.getVisibleGeometries();
            for (n2 = 0; n2 < pgGeometryIfArray.length; ++n2) {
                if (!(pgGeometryIfArray[n2] instanceof PgPointSet) || pgGeometryIfArray[n2] == this.m_pCenter) continue;
                if (!this.transformGeometry((PgPointSet)pgGeometryIfArray[n2], object)) {
                    return false;
                }
                pgGeometryIfArray[n2].update((Object)pgGeometryIfArray[n2]);
            }
        } else {
            if (!this.transformGeometry(this.m_geom, object)) {
                return false;
            }
            this.m_geom.update((Object)this.m_geom);
        }
        this.m_scaleAllOld = this.m_scaleAll.getValue();
        for (n = 0; n < this.m_dim; ++n) {
            this.m_transOld[n] = this.m_trans[n].getValue();
            this.m_scaleOld[n] = this.m_scale[n].getValue();
        }
        for (n = 0; n < this.m_rotate.length; ++n) {
            this.m_rotateOld[n] = this.m_rotate[n].getValue();
        }
        this.m_scaleAllTexOld = this.m_scaleAllTex.getValue();
        for (n = 0; n < 2; ++n) {
            this.m_transTexOld[n] = this.m_transTex[n].getValue();
            this.m_scaleTexOld[n] = this.m_scaleTex[n].getValue();
        }
        this.m_rotateTexOld[0] = this.m_rotateTex[0].getValue();
        this.m_scaleVectorFieldsOld = this.m_scaleVectorFields.getValue();
        this.m_rotateVectorFieldsOld = this.m_rotateVectorFields.getValue();
        return true;
    }

    private boolean transformGeometry(PgPointSet pgPointSet, Object object) {
        int n;
        int n2 = Math.min(this.m_dim, pgPointSet.getDimOfVertices());
        PdVector pdVector = this.m_bUseBaryCenterOfGeom ? pgPointSet.getCenterOfGravity() : this.m_pCenter.getVertex(0);
        PdVector pdVector2 = this.m_centerTex_IP.getVector();
        PdVector[] pdVectorArray = pgPointSet.getVertexTextures();
        PdVector[][] pdVectorArray2 = null;
        if (pgPointSet instanceof PgElementSet && ((PgElementSet)pgPointSet).hasElementTextures()) {
            pdVectorArray2 = ((PgElementSet)pgPointSet).getElementTextures();
        }
        if (object == this.m_function) {
            this.compute(pgPointSet, this.m_bSelectedVerticesOnly);
            return true;
        }
        if (object == this.m_scaleAll) {
            PwTransform.scale(pgPointSet, this.m_scaleAll.getValue() / this.m_scaleAllOld, pdVector, this.m_bSelectedVerticesOnly);
            return true;
        }
        if (object == this.m_scaleAllTex) {
            if (pdVectorArray != null) {
                PwTransform.scale(pdVectorArray, this.m_scaleAllTex.getValue() / this.m_scaleAllTexOld, pdVector2, this.m_bSelectedVerticesOnly);
            } else if (pdVectorArray2 != null) {
                PwTransform.scale(pdVectorArray2, this.m_scaleAllTex.getValue() / this.m_scaleAllTexOld, pdVector2, this.m_bSelectedVerticesOnly);
            }
            return true;
        }
        if (object == this.m_scaleVectorFields) {
            PgVectorField pgVectorField = this.m_geom.getSelectedVectorField();
            if (pgVectorField == null) {
                PsDebug.warning((String)"No vector field selected.");
                return true;
            }
            PwTransform.scale(pgVectorField.getVectors(), this.m_scaleVectorFields.getValue() / this.m_scaleVectorFieldsOld, new PdVector(3), this.m_bSelectedVerticesOnly);
            return true;
        }
        if (object == this.m_rotateVectorFields) {
            PgVectorField pgVectorField = this.m_geom.getSelectedVectorField();
            if (pgVectorField == null) {
                PsDebug.warning((String)"No vector field selected.");
                return true;
            }
            if (pgVectorField.getBasedOn() == 0) {
                this.rotate(pgVectorField.getVectors(), (this.m_rotateVectorFields.getValue() - this.m_rotateVectorFieldsOld) * 2.0 * Math.PI / 360.0, this.m_geom.getVertexNormals(), new PdVector(3), this.m_bSelectedVerticesOnly, this.m_geom.getNumVertices());
            } else if (this.m_geom instanceof PgElementSet) {
                this.rotate(pgVectorField.getVectors(), (this.m_rotateVectorFields.getValue() - this.m_rotateVectorFieldsOld) * 2.0 * Math.PI / 360.0, ((PgElementSet)this.m_geom).getElementNormals(), new PdVector(3), this.m_bSelectedVerticesOnly, ((PgElementSet)this.m_geom).getNumElements());
            }
            return true;
        }
        for (n = 0; n < n2; ++n) {
            if (object == this.m_trans[n]) {
                PwTransform.translate(pgPointSet, this.m_trans[n].getValue() - this.m_transOld[n], n, this.m_bSelectedVerticesOnly);
                return true;
            }
            if (object != this.m_scale[n]) continue;
            PwTransform.scale(pgPointSet, this.m_scale[n].getValue() / this.m_scaleOld[n], n, pdVector, this.m_bSelectedVerticesOnly);
            this.updateNormals(pgPointSet);
            return true;
        }
        for (n = 0; n < this.m_rotate.length; ++n) {
            if (object != this.m_rotate[n]) continue;
            PwTransform.rotate(pgPointSet, (this.m_rotate[n].getValue() - this.m_rotateOld[n]) * Math.PI / 180.0, n, pdVector, this.m_bSelectedVerticesOnly);
            this.updateNormals(pgPointSet);
            return true;
        }
        for (n = 0; n < 2; ++n) {
            if (object == this.m_transTex[n]) {
                if (pdVectorArray != null) {
                    PwTransform.translate(pdVectorArray, this.m_transTex[n].getValue() - this.m_transTexOld[n], n, false);
                } else if (pdVectorArray2 != null) {
                    PwTransform.translate(pdVectorArray2, this.m_transTex[n].getValue() - this.m_transTexOld[n], n, false);
                }
                return true;
            }
            if (object != this.m_scaleTex[n]) continue;
            if (pdVectorArray != null) {
                PwTransform.scale(pdVectorArray, this.m_scaleTex[n].getValue() / this.m_scaleTexOld[n], n, pdVector2, false);
            } else if (pdVectorArray2 != null) {
                PwTransform.scale(pdVectorArray2, this.m_scaleTex[n].getValue() / this.m_scaleTexOld[n], n, pdVector2, false);
            }
            return true;
        }
        if (object == this.m_rotateTex[0]) {
            if (pdVectorArray != null) {
                PwTransform.rotate(pdVectorArray, (this.m_rotateTex[0].getValue() - this.m_rotateTexOld[0]) * Math.PI / 180.0, 0, pdVector2, false);
            } else if (pdVectorArray2 != null) {
                PwTransform.rotate(pdVectorArray2, (this.m_rotateTex[0].getValue() - this.m_rotateTexOld[0]) * Math.PI / 180.0, 0, pdVector2, false);
            }
            return true;
        }
        return false;
    }

    private void updateNormals(PgPointSet pgPointSet) {
        pgPointSet.makeVertexNormals();
        if (pgPointSet instanceof PgElementSet) {
            PgElementSet pgElementSet = (PgElementSet)pgPointSet;
            pgElementSet.makeElementNormals();
        }
        this.m_geom.update((Object)this.m_geom);
    }

    public void compute(PgPointSet pgPointSet, boolean bl) {
        int n = pgPointSet.getNumVertices();
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        PdVector pdVector = new PdVector(this.m_dim);
        for (int i = 0; i < n; ++i) {
            pdVector.copy(this.m_geomSave.getVertex(i));
            if (bl && !pdVectorArray[i].hasTag(1)) continue;
            this.m_function.eval(pdVectorArray[i].m_data, pdVector.m_data);
        }
        pgPointSet.makeVertexNormals();
    }

    public static void translate(PgPointSet pgPointSet, double d, int n) {
        PwTransform.translate(pgPointSet, d, n, false);
    }

    public static void translate(PgPointSet pgPointSet, double d, int n, boolean bl) {
        if (pgPointSet == null) {
            PsDebug.warning((String)"Cannot translate geometry. Geometry s null.");
            return;
        }
        PwTransform.translate(pgPointSet.getVertices(), d, n, bl);
    }

    private static void translate(PdVector[][] pdVectorArray, double d, int n, boolean bl) {
        if (pdVectorArray == null) {
            PsDebug.warning((String)"Cannot translate. Vertices are null.");
            return;
        }
        for (int i = 0; i < pdVectorArray.length; ++i) {
            PwTransform.translate(pdVectorArray[i], d, n, bl);
        }
    }

    private static void translate(PdVector[] pdVectorArray, double d, int n, boolean bl) {
        if (pdVectorArray == null) {
            PsDebug.warning((String)"Cannot translate. Vertices are null.");
            return;
        }
        if (pdVectorArray.length == 0) {
            return;
        }
        if (n < 0 || n >= pdVectorArray[0].getSize()) {
            PsDebug.warning((String)("Cannot translate geometry. Given coordinate " + n + " is out of range."));
            return;
        }
        int n2 = pdVectorArray.length;
        if (!bl) {
            for (int i = 0; i < n2; ++i) {
                int n3 = n;
                pdVectorArray[i].m_data[n3] = pdVectorArray[i].m_data[n3] + d;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (!pdVectorArray[i].hasTag(1)) continue;
                int n4 = n;
                pdVectorArray[i].m_data[n4] = pdVectorArray[i].m_data[n4] + d;
            }
        }
    }

    public static void scale(PgPointSet pgPointSet, double d) {
        PwTransform.scale(pgPointSet, d, pgPointSet.getCenterOfGravity(), false);
    }

    public static void scale(PgPointSet pgPointSet, double d, PdVector pdVector, boolean bl) {
        PwTransform.scale(pgPointSet.getVertices(), d, pdVector, bl);
    }

    private static void scale(PdVector[][] pdVectorArray, double d, PdVector pdVector, boolean bl) {
        if (pdVectorArray == null) {
            PsDebug.warning((String)"Cannot scale. Vertices are null.");
            return;
        }
        for (int i = 0; i < pdVectorArray.length; ++i) {
            PwTransform.scale(pdVectorArray[i], d, pdVector, bl);
        }
    }

    private static void scale(PdVector[] pdVectorArray, double d, PdVector pdVector, boolean bl) {
        if (pdVectorArray == null) {
            PsDebug.warning((String)"Cannot scale. Vertices are null.");
            return;
        }
        if (pdVectorArray.length == 0) {
            return;
        }
        int n = pdVectorArray.length;
        int n2 = pdVectorArray[0].getSize();
        if (!bl) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    pdVectorArray[i].m_data[j] = (pdVectorArray[i].m_data[j] - pdVector.m_data[j]) * d + pdVector.m_data[j];
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (!pdVectorArray[i].hasTag(1)) continue;
                    pdVectorArray[i].m_data[j] = (pdVectorArray[i].m_data[j] - pdVector.m_data[j]) * d + pdVector.m_data[j];
                }
            }
        }
    }

    public static void scale(PgPointSet pgPointSet, double d, int n) {
        PwTransform.scale(pgPointSet, d, n, pgPointSet.getCenterOfGravity(), false);
    }

    public static void scale(PgPointSet pgPointSet, double d, int n, PdVector pdVector, boolean bl) {
        PwTransform.scale(pgPointSet.getVertices(), d, n, pdVector, bl);
    }

    private static void scale(PdVector[][] pdVectorArray, double d, int n, PdVector pdVector, boolean bl) {
        if (pdVectorArray == null) {
            PsDebug.warning((String)"Cannot scale. Vertices are null.");
            return;
        }
        for (int i = 0; i < pdVectorArray.length; ++i) {
            PwTransform.scale(pdVectorArray[i], d, n, pdVector, bl);
        }
    }

    private static void scale(PdVector[] pdVectorArray, double d, int n, PdVector pdVector, boolean bl) {
        if (pdVectorArray == null) {
            PsDebug.warning((String)"Cannot scale. Vertices are null.");
            return;
        }
        if (pdVectorArray.length == 0) {
            return;
        }
        if (n < 0 || n >= pdVectorArray[0].getSize()) {
            PsDebug.warning((String)("Cannot scale geometry. Given coordinate " + n + " is out of range."));
            return;
        }
        int n2 = pdVectorArray.length;
        double d2 = pdVector.m_data[n];
        if (!bl) {
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].m_data[n] = (pdVectorArray[i].m_data[n] - d2) * d + d2;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (!pdVectorArray[i].hasTag(1)) continue;
                pdVectorArray[i].m_data[n] = (pdVectorArray[i].m_data[n] - d2) * d + d2;
            }
        }
    }

    public static void rotate(PgPointSet pgPointSet, double d, int n) {
        PdVector pdVector = pgPointSet.getCenterOfGravity();
        PwTransform.rotate(pgPointSet, d, n, pdVector, false);
    }

    public static void rotate(PgPointSet pgPointSet, double d, int n, boolean bl) {
        PdVector pdVector = pgPointSet.getCenterOfGravity();
        PwTransform.rotate(pgPointSet, d, n, pdVector, bl);
    }

    public static void rotate(PgPointSet pgPointSet, double d, int n, PdVector pdVector, boolean bl) {
        PwTransform.rotate(pgPointSet.getVertices(), d, n, pdVector, bl);
    }

    public static void rotate(PgPointSet pgPointSet, double d, int n, PdVector pdVector) {
        PwTransform.rotate(pgPointSet, d, n, pdVector, false);
    }

    private static void rotate(PdVector[][] pdVectorArray, double d, int n, PdVector pdVector, boolean bl) {
        if (pdVectorArray == null) {
            PsDebug.warning((String)"Cannot rotate. Vertices are null.");
            return;
        }
        for (int i = 0; i < pdVectorArray.length; ++i) {
            PwTransform.rotate(pdVectorArray[i], d, n, pdVector, bl);
        }
    }

    private static void rotate(PdVector[] pdVectorArray, double d, int n, PdVector pdVector, boolean bl) {
        if (pdVectorArray == null) {
            PsDebug.warning((String)"Cannot rotate. Vertices are null.");
            return;
        }
        if (pdVectorArray.length == 0) {
            return;
        }
        if (n < 0 || n >= pdVectorArray[0].getSize()) {
            PsDebug.warning((String)("Cannot rotate geometry. Given coordinate " + n + " is out of range."));
            return;
        }
        int n2 = pdVectorArray[0].getSize();
        if (n2 != 2 && n2 != 3) {
            PsDebug.warning((String)"Space dimension must be 2 or 3.");
            return;
        }
        if (pdVector == null || pdVector.getSize() != n2) {
            PsDebug.warning((String)"Cannot rotate geometry. Space dimension is not equal dimension of center.");
            return;
        }
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = pdVector;
        if (n2 == 2) {
            pdVector2.set(0.0, 0.0, 1.0);
            pdVector3 = new PdVector(3);
            pdVector3.copy(pdVector);
        } else {
            pdVector2.m_data[n] = 1.0;
        }
        PdMatrix pdMatrix = PuReflect.rotateLine((PdVector)pdVector3, (PdVector)pdVector2, (double)d);
        int n3 = pdVectorArray.length;
        PdVector pdVector4 = new PdVector(3);
        if (!bl) {
            for (int i = 0; i < n3; ++i) {
                pdVector4.copyArray(pdVectorArray[i]);
                pdVectorArray[i].leftMultAffin(pdMatrix, pdVector4, true);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (!pdVectorArray[i].hasTag(1)) continue;
                pdVector4.copyArray(pdVectorArray[i]);
                pdVectorArray[i].leftMultAffin(pdMatrix, pdVector4, true);
            }
        }
    }

    private void rotate(PdVector[] pdVectorArray, double d, PdVector[] pdVectorArray2, PdVector pdVector, boolean bl, int n) {
        if (pdVectorArray == null) {
            PsDebug.warning((String)"Cannot rotate. Vertices are null.");
            return;
        }
        if (pdVectorArray.length == 0) {
            return;
        }
        if (pdVectorArray2 == null || pdVectorArray2.length < n || pdVectorArray.length < n) {
            PsDebug.warning((String)"Cannot rotate geometry. Given coordinate axes has wrong dimension.");
            return;
        }
        int n2 = pdVectorArray[0].getSize();
        if (n2 != 3) {
            PsDebug.warning((String)"Space dimension must be 3.");
            return;
        }
        if (pdVector == null || pdVector.getSize() != n2) {
            PsDebug.warning((String)"Cannot rotate geometry. Space dimension is not equal dimension of center.");
            return;
        }
        PdVector pdVector2 = new PdVector(3);
        if (!bl) {
            for (int i = 0; i < n; ++i) {
                PdMatrix pdMatrix = PuReflect.rotateLine((PdVector)pdVector, (PdVector)pdVectorArray2[i], (double)d);
                pdVector2.copyArray(pdVectorArray[i]);
                pdVectorArray[i].leftMultAffin(pdMatrix, pdVector2, true);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!pdVectorArray[i].hasTag(1)) continue;
                PdMatrix pdMatrix = PuReflect.rotateLine((PdVector)pdVector, (PdVector)pdVectorArray2[i], (double)d);
                pdVector2.copyArray(pdVectorArray[i]);
                pdVectorArray[i].leftMultAffin(pdMatrix, pdVector2, true);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

