/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import jv.geom.PgElementSet;
import jv.geom.PgTexture;
import jv.number.PuInteger;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.viewer.PvDisplay;
import jvx.geom.PwBary;
import jvx.geom.PwGeodesic;
import jvx.project.PjWorkshop;

public class PwTexture
extends PjWorkshop {
    public static String m_defQuadTexture = "images/jvTextureSquareOpaque_sgl.gif";
    public static String m_defTriTexture = "images/jvTextureTriangleOpaque_med.jpg";
    public static String m_defDijkstraTexture = "images/jvTextureDijkstra.gif";
    protected PgElementSet m_geom;
    protected PuInteger m_LICSize;
    protected Dimension m_textureSize = new Dimension(0, 0);
    private static int VGAP = 8;
    static /* synthetic */ Class class$jvx$geom$PwTexture;

    public PwTexture() {
        super(PsConfig.getMessage((int)51050));
        this.m_LICSize = new PuInteger(PsConfig.getMessage((int)54110), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwTexture == null ? (class$jvx$geom$PwTexture = PwTexture.class$("jvx.geom.PwTexture")) : class$jvx$geom$PwTexture)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_LICSize.setDefBounds(10, 500, 5, 50);
        this.m_LICSize.setDefValue(40);
        this.m_LICSize.init();
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"geometry must be a triangulation");
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        this.m_geom = pgElementSet;
    }

    public boolean update(Object object) {
        if (object == null) {
            super.update(null);
        } else if (object == this.m_LICSize) {
            return true;
        }
        return super.update(object);
    }

    public static void makePatchTexture(PgElementSet pgElementSet) {
        Object object;
        PgTexture pgTexture = pgElementSet.getTexture();
        if (pgTexture == null) {
            pgTexture = new PgTexture();
            object = PsConfig.getInstBase();
            if (PuString.isEmpty((String)object)) {
                object = PsConfig.getCodeBase();
            }
            object = pgElementSet.getDimOfElements() == 3 ? (String)object + m_defTriTexture : (String)object + m_defQuadTexture;
            pgTexture.setImageName((String)object);
            PsImage psImage = new PsImage((String)object);
            psImage.loadImage();
            Image image = psImage.getImage();
            if (image != null) {
                pgTexture.setImage(image);
            }
            pgElementSet.setTexture(pgTexture);
        }
        pgElementSet.assureElementTextures();
        object = pgElementSet.getElementTextures();
        int n = pgElementSet.getNumElements();
        switch (pgElementSet.getDimOfElements()) {
            case 3: {
                for (int i = 0; i < n; ++i) {
                    object[i][0].set(0.0, 0.0);
                    object[i][1].set(1.0, 0.0);
                    object[i][2].set(0.5, 1.0);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n; ++i) {
                    object[i][0].set(1.0, 0.0);
                    object[i][1].set(0.0, 0.0);
                    object[i][2].set(0.0, 1.0);
                    object[i][3].set(1.0, 1.0);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < n; ++i) {
                    object[i][0].set(0.3, 0.0);
                    object[i][1].set(0.6, 0.0);
                    object[i][2].set(1.0, 0.6);
                    object[i][3].set(0.5, 1.0);
                    object[i][4].set(0.0, 0.6);
                }
                break;
            }
            case 6: {
                for (int i = 0; i < n; ++i) {
                    object[i][0].set(0.25, 0.0);
                    object[i][1].set(0.75, 0.0);
                    object[i][2].set(1.0, 0.5);
                    object[i][3].set(0.75, 1.0);
                    object[i][4].set(0.25, 1.0);
                    object[i][5].set(0.0, 0.5);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < n; ++i) {
                    object[i][0].set(0.3, 0.0);
                    object[i][1].set(0.6, 0.0);
                    object[i][2].set(1.0, 0.3);
                    object[i][3].set(1.0, 0.6);
                    object[i][4].set(0.6, 1.0);
                    object[i][5].set(0.3, 1.0);
                    object[i][6].set(0.0, 0.6);
                    object[i][7].set(0.0, 0.3);
                }
                break;
            }
            default: {
                for (int i = 0; i < n; ++i) {
                    int n2 = pgElementSet.getDimOfElement(i);
                    if (n2 < 3) continue;
                    if (n2 == 3) {
                        object[i][0].set(1.0, 0.0);
                        object[i][1].set(0.0, 0.0);
                        object[i][2].set(0.0, 1.0);
                        continue;
                    }
                    object[i][0].set(1.0, 0.0);
                    object[i][1].set(0.0, 0.0);
                    object[i][2].set(0.0, 1.0);
                    object[i][3].set(1.0, 1.0);
                }
            }
        }
        pgElementSet.showElementTexture(true);
    }

    public static void makeDijkstraTexture(PgElementSet pgElementSet) {
        String string;
        PgTexture pgTexture;
        if (pgElementSet.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if ((pgTexture = pgElementSet.getTexture()) == null) {
            pgTexture = new PgTexture();
        }
        if (PuString.isEmpty((String)(string = PsConfig.getInstBase()))) {
            string = PsConfig.getCodeBase();
        }
        string = string + m_defDijkstraTexture;
        pgTexture.setImageName(string);
        PsImage psImage = new PsImage(string);
        psImage.loadImage();
        Image image = psImage.getImage();
        if (image != null) {
            pgTexture.setImage(image);
        }
        pgElementSet.setTexture(pgTexture);
        pgElementSet.assureElementTextures();
        int n = pgElementSet.getNumElements();
        int n2 = pgElementSet.getNumVertices();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!pgElementSet.hasTagVertex(i, 1)) continue;
            ++n3;
        }
        PiVector piVector = new PiVector();
        if (n3 == 0) {
            piVector.setSize(1);
            piVector.m_data[0] = 0;
        } else {
            piVector.setSize(n3);
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                if (!pgElementSet.hasTagVertex(i, 1)) continue;
                piVector.m_data[n4] = i;
                ++n4;
            }
        }
        PdVector[][] pdVectorArray = pgElementSet.getElementTextures();
        PiVector piVector2 = PwGeodesic.getDijkstraDistance(pgElementSet, piVector);
        for (int i = 0; i < n; ++i) {
            PiVector piVector3 = pgElementSet.getElement(i);
            int n5 = 0;
            if (piVector2.m_data[piVector3.m_data[1]] < piVector2.m_data[piVector3.m_data[n5]]) {
                n5 = 1;
            }
            if (piVector2.m_data[piVector3.m_data[2]] < piVector2.m_data[piVector3.m_data[n5]]) {
                n5 = 2;
            }
            int n6 = (n5 + 1) % 3;
            int n7 = (n5 + 2) % 3;
            if (piVector2.m_data[piVector3.m_data[n6]] == piVector2.m_data[piVector3.m_data[n5]] && piVector2.m_data[piVector3.m_data[n7]] == piVector2.m_data[piVector3.m_data[n5]]) {
                pdVectorArray[i][n5].set(0.0, 0.0);
                pdVectorArray[i][n6].set(0.5, 0.01);
                pdVectorArray[i][n7].set(1.0, 0.0);
                continue;
            }
            if (piVector2.m_data[piVector3.m_data[n6]] == piVector2.m_data[piVector3.m_data[n5]]) {
                pdVectorArray[i][n5].set(0.0, 0.0);
                pdVectorArray[i][n6].set(1.0, 0.0);
                pdVectorArray[i][n7].set(0.5, 1.0);
                continue;
            }
            if (piVector2.m_data[piVector3.m_data[n7]] == piVector2.m_data[piVector3.m_data[n5]]) {
                pdVectorArray[i][n5].set(0.0, 0.0);
                pdVectorArray[i][n6].set(0.5, 1.0);
                pdVectorArray[i][n7].set(1.0, 0.0);
                continue;
            }
            pdVectorArray[i][n5].set(0.5, 0.0);
            pdVectorArray[i][n6].set(1.0, 1.0);
            pdVectorArray[i][n7].set(0.0, 1.0);
        }
        pgElementSet.showElementTexture(true);
    }

    public static void makeThresholdTexture(PgElementSet pgElementSet, PdVector pdVector, double d) {
        String string;
        int n = pgElementSet.getNumVertices();
        if (pdVector.getSize() != n) {
            PsDebug.warning((String)"Size of data does not fit to the geometry.");
            return;
        }
        PgTexture pgTexture = pgElementSet.getTexture();
        if (pgTexture == null) {
            pgTexture = new PgTexture();
        }
        if (PuString.isEmpty((String)(string = PsConfig.getInstBase()))) {
            string = PsConfig.getCodeBase();
        }
        string = string + m_defDijkstraTexture;
        pgTexture.setImageName(string);
        PsImage psImage = new PsImage(string);
        psImage.loadImage();
        Image image = psImage.getImage();
        if (image != null) {
            pgTexture.setImage(image);
        }
        pgElementSet.setTexture(pgTexture);
        pgElementSet.assureElementTextures();
        int n2 = pgElementSet.getNumElements();
        PdVector[][] pdVectorArray = pgElementSet.getElementTextures();
        for (int i = 0; i < n2; ++i) {
            int n3;
            PiVector piVector = pgElementSet.getElement(i);
            int n4 = piVector.getSize();
            double d2 = 1.0;
            double d3 = 0.0;
            for (n3 = 0; n3 < n4; ++n3) {
                if (!(Math.abs(pdVector.m_data[piVector.m_data[n3]] - d) > d3)) continue;
                d3 = Math.abs(pdVector.m_data[piVector.m_data[n3]] - d);
            }
            if (d3 != 0.0) {
                while (d3 * d2 < 0.25) {
                    d2 *= 2.0;
                }
                while (d3 * d2 > 0.5) {
                    d2 *= 0.5;
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                pdVectorArray[i][n3].set(1.0 * (double)n3 / ((double)n4 - 1.0), 0.5 + d2 * (pdVector.m_data[piVector.m_data[n3]] - d));
            }
        }
        pgElementSet.showElementTexture(true);
    }

    public static void makeThresholdTexture(PgElementSet pgElementSet, PdVector[] pdVectorArray, double[] dArray) {
        if (pdVectorArray.length == 1 && dArray.length == 1) {
            PwTexture.makeThresholdTexture(pgElementSet, pdVectorArray[0], dArray[0]);
            return;
        }
        if (pdVectorArray.length != 2 || dArray.length != 2) {
            PsDebug.warning((String)"Wrong size of data array.");
            return;
        }
        int n = pgElementSet.getNumVertices();
        if (pdVectorArray[0].getSize() != n || pdVectorArray[1].getSize() != n) {
            PsDebug.warning((String)"Size of data does not fit to the geometry.");
            return;
        }
        PgTexture pgTexture = pgElementSet.getTexture();
        if (pgTexture == null) {
            pgTexture = new PgTexture();
        }
        pgElementSet.setTexture(pgTexture);
        pgElementSet.assureElementTextures();
        int n2 = pgElementSet.getNumElements();
        PdVector[][] pdVectorArray2 = pgElementSet.getElementTextures();
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            PiVector piVector = pgElementSet.getElement(i);
            int n4 = piVector.getSize();
            for (n3 = 0; n3 < 2; ++n3) {
                dArray2[n3] = 1.0;
                dArray3[n3] = 0.0;
                for (int j = 0; j < n4; ++j) {
                    if (!(Math.abs(pdVectorArray[n3].m_data[piVector.m_data[j]] - dArray[n3]) > dArray3[n3])) continue;
                    dArray3[n3] = Math.abs(pdVectorArray[n3].m_data[piVector.m_data[j]] - dArray[n3]);
                }
                if (dArray3[n3] == 0.0) continue;
                while (dArray3[n3] * dArray2[n3] < 0.25) {
                    int n5 = n3;
                    dArray2[n5] = dArray2[n5] * 2.0;
                }
                while (dArray3[n3] * dArray2[n3] > 0.5) {
                    int n6 = n3;
                    dArray2[n6] = dArray2[n6] * 0.5;
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                pdVectorArray2[i][n3].set(0.5 + dArray2[0] * (pdVectorArray[0].m_data[piVector.m_data[n3]] - dArray[0]), 0.5 + dArray2[1] * (pdVectorArray[1].m_data[piVector.m_data[n3]] - dArray[1]));
            }
        }
        pgElementSet.showElementTexture(true);
    }

    public int getLicSize() {
        return this.m_LICSize.getValue();
    }

    public void setLicSize(int n) {
        this.m_LICSize.setValue(n);
    }

    public void burn() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"missing geometry");
            return;
        }
        PvDisplay pvDisplay = (PvDisplay)this.getDisplay();
        if (pvDisplay == null) {
            PsDebug.warning((String)"missing display");
            return;
        }
        int n = this.m_LICSize.getValue();
        double[] dArray = PwTexture.makeElementTextureCoords(this.m_geom, n);
        if (dArray[0] < 1.0E-10) {
            return;
        }
        int n2 = (int)dArray[1];
        int n3 = (int)dArray[2];
        int[] nArray = new int[n2 * n3];
        PgTexture pgTexture = new PgTexture();
        pgTexture.setImage(PsConfig.getFrame().createImage(new MemoryImageSource(n2, n3, nArray, 0, n2)));
        this.m_geom.setTexture(pgTexture);
        this.m_geom.showElementTexture(true);
        this.m_geom.update((Object)this.m_geom);
        pvDisplay.burn();
        pvDisplay.repaint();
    }

    public static void compactPeriodicTextures(PdVector[][] pdVectorArray) {
        if (pdVectorArray == null) {
            PsDebug.warning((String)"no texture");
            return;
        }
        PdVector pdVector = new PdVector(2);
        PdVector pdVector2 = new PdVector(2);
        for (int i = 0; i < pdVectorArray.length; ++i) {
            int n;
            PdVector[] pdVectorArray2 = pdVectorArray[i];
            pdVector2.setConstant(Double.NEGATIVE_INFINITY);
            pdVector.setConstant(Double.POSITIVE_INFINITY);
            for (n = 0; n < pdVectorArray2.length; ++n) {
                pdVector2.m_data[0] = Math.max(pdVector2.m_data[0], pdVectorArray2[n].m_data[0]);
                pdVector2.m_data[1] = Math.max(pdVector2.m_data[1], pdVectorArray2[n].m_data[1]);
                pdVector.m_data[0] = Math.min(pdVector.m_data[0], pdVectorArray2[n].m_data[0]);
                pdVector.m_data[1] = Math.min(pdVector.m_data[1], pdVectorArray2[n].m_data[1]);
            }
            pdVector2.add(pdVector);
            pdVector2.multScalar(0.5);
            pdVector2.m_data[0] = Math.floor(pdVector2.m_data[0]);
            pdVector2.m_data[1] = Math.floor(pdVector2.m_data[1]);
            for (n = 0; n < pdVectorArray2.length; ++n) {
                pdVectorArray2[n].sub(pdVector2);
            }
        }
    }

    public static double[] makeElementTextureCoords(PgElementSet pgElementSet, int n) {
        int n2;
        int n3;
        int n4;
        pgElementSet.setDimOfTextures(2);
        pgElementSet.assureElementTextures();
        int n5 = pgElementSet.getNumElements();
        if (n5 == 0) {
            return new double[]{0.0, 0.0, 0.0};
        }
        double d = 0.0;
        double d2 = 0.0;
        PiVector piVector = new PiVector(n5);
        PdVector pdVector = new PdVector(n5);
        PdVector pdVector2 = new PdVector(n5);
        PdVector pdVector3 = new PdVector(n5);
        PdVector pdVector4 = new PdVector(n5);
        PdVector pdVector5 = new PdVector(n5);
        PdVector pdVector6 = new PdVector(n5);
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        for (int i = 0; i < n5; ++i) {
            double d3;
            int n6;
            piVector.m_data[i] = 0;
            pdVector.m_data[i] = 0.0;
            for (n6 = 0; n6 < 3; ++n6) {
                pdBaryDir.m_data[n6] = 0.0;
                pdBaryDir.m_data[(n6 + 1) % 3] = 1.0;
                pdBaryDir.m_data[(n6 + 2) % 3] = -1.0;
                d3 = PwBary.norm(pgElementSet, i, pdBaryDir, n6 == 0);
                if (d3 > pdVector.m_data[i]) {
                    piVector.m_data[i] = n6;
                    pdVector.m_data[i] = d3;
                }
                if (!(d3 > d)) continue;
                d = d3;
            }
            n6 = piVector.m_data[i];
            pdBaryDir.m_data[n6] = 0.0;
            pdBaryDir.m_data[(n6 + 1) % 3] = 1.0;
            pdBaryDir.m_data[(n6 + 2) % 3] = -1.0;
            pdBaryDir2.m_data[n6] = 1.0;
            pdBaryDir2.m_data[(n6 + 1) % 3] = 0.0;
            pdBaryDir2.m_data[(n6 + 2) % 3] = -1.0;
            pdVector2.m_data[i] = PwBary.scalar(pgElementSet, i, pdBaryDir, pdBaryDir2, false) / pdVector.m_data[i];
            d3 = PwBary.norm(pgElementSet, i, pdBaryDir2, false);
            d3 *= d3;
            if ((d3 -= pdVector2.m_data[i] * pdVector2.m_data[i]) < 0.0) {
                d3 = 0.0;
            }
            pdVector3.m_data[i] = Math.sqrt(d3);
            if (pdVector3.m_data[i] > d2) {
                d2 = pdVector3.m_data[i];
            }
            if (pdVector2.m_data[i] < 1.0E-10) {
                pdVector4.setEntry(i, 1.5707963267948966);
            } else {
                pdVector4.setEntry(i, Math.atan(pdVector3.m_data[i] / pdVector2.m_data[i]));
            }
            double d4 = pdVector.m_data[i] - pdVector2.m_data[i];
            if (d4 < 1.0E-10) {
                pdVector5.setEntry(i, 1.5707963267948966);
                continue;
            }
            pdVector5.setEntry(i, Math.atan(pdVector3.m_data[i] / d4));
        }
        double d5 = (double)n / d;
        for (int i = 0; i < n5; ++i) {
            pdVector.m_data[i] = Math.ceil(pdVector.m_data[i] * d5);
            pdVector2.m_data[i] = Math.ceil(pdVector2.m_data[i] * d5);
            pdVector3.m_data[i] = Math.ceil(pdVector3.m_data[i] * d5);
            pdVector6.m_data[i] = pdVector.m_data[i] * pdVector3.m_data[i] / 2.0;
        }
        int[] nArray = new int[n5];
        PuMath.heapsort((int)n5, (double[])pdVector3.m_data, (int[])nArray);
        int n7 = n5 / 2;
        for (n4 = 0; n4 < n7; ++n4) {
            int n8 = nArray[n4];
            nArray[n4] = nArray[n5 - 1 - n4];
            nArray[n5 - 1 - n4] = n8;
        }
        n4 = 0;
        int n9 = 0;
        PiVector[][] piVectorArray = new PiVector[n5][3];
        int n10 = 12;
        boolean[] blArray = new boolean[n5];
        int n11 = n5;
        for (int i = 0; i < n5; ++i) {
            if (pdVector3.m_data[nArray[i]] < 1.0E-10 || pdVector.m_data[nArray[i]] < 1.0E-10) {
                --n11;
                blArray[nArray[i]] = false;
                piVectorArray[nArray[i]][0] = new PiVector(0, 0);
                piVectorArray[nArray[i]][1] = new PiVector(0, 0);
                piVectorArray[nArray[i]][2] = new PiVector(0, 0);
                continue;
            }
            blArray[nArray[i]] = true;
        }
        double d6 = 0.0;
        for (int i = 0; i < n5; ++i) {
            d6 += pdVector.m_data[i] * 2.0 / 3.0;
        }
        double d7 = d6 / 2.0;
        double d8 = pdVector3.m_data[nArray[0]];
        if (d8 > 1.0E-10) {
            while (d6 > 1.5 * d8 || d6 < d8 * 2.0 / 3.0) {
                d6 = d6 > 1.5 * d8 ? (d6 -= d7) : (d6 += d7);
                d7 /= 2.0;
                d8 = 0.0;
                double d9 = 0.0;
                for (int i = 0; i < n5; ++i) {
                    if (!((d9 += pdVector.m_data[nArray[i]] * 2.0 / 3.0) > d6)) continue;
                    d8 += pdVector3.m_data[nArray[i]];
                    d9 = 0.0;
                }
            }
        }
        int n12 = 0 + VGAP / 2;
        int n13 = 0;
        int n14 = 0;
        int n15 = PwTexture.newRow(blArray, pdVector3, nArray, VGAP);
        n4 += n15;
        int n16 = 100;
        while (n11 > 0) {
            double d10;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            double d11;
            double d12;
            if ((double)n13 > d6 || (double)n14 > d6) {
                if (n13 > n9) {
                    n9 = n13;
                }
                if (n14 > n9) {
                    n9 = n14;
                }
                n12 = n4 + VGAP / 2;
                n13 = 0;
                n14 = 0;
                n15 = PwTexture.newRow(blArray, pdVector3, nArray, VGAP);
                n4 += n15;
                continue;
            }
            int n22 = n15 - VGAP;
            if (n13 > n14) {
                d12 = Math.atan((double)n22 / (double)(n13 - n14));
                d11 = Double.MAX_VALUE;
                n3 = -1;
                n2 = 0;
                n21 = 0;
                for (n20 = 0; n20 < n5 && n21 <= n16; ++n20) {
                    n19 = nArray[n20];
                    if (!blArray[n19]) continue;
                    ++n21;
                    double d13 = pdVector5.m_data[n19] < d12 ? ((n18 = (int)((double)(n14 + n10) + pdVector.m_data[n19] - pdVector2.m_data[n19] * (double)n22 / pdVector3.m_data[n19])) <= n13 ? (double)n22 * ((double)n10 + pdVector.m_data[n19]) / 2.0 - pdVector6.m_data[n19] : (double)n22 * (((double)n10 + pdVector.m_data[n19] - (double)n18 + (double)n13 - 1.0) / 2.0 + (double)n18 - (double)n13 + 1.0) - pdVector6.m_data[n19]) : (double)n22 * ((double)n10 + (double)(n13 - n14) * pdVector3.m_data[n19] / (double)n22 + pdVector2.m_data[n19]) / 2.0 - pdVector6.m_data[n19];
                    if (d13 < d11) {
                        d11 = d13;
                        n3 = n19;
                        n2 = 0;
                    }
                    d13 = pdVector4.m_data[n19] < d12 ? ((n18 = (int)((double)(n14 + n10) + pdVector2.m_data[n19] * (double)n22 / pdVector3.m_data[n19])) <= n13 ? (double)n22 * ((double)n10 + pdVector.m_data[n19]) / 2.0 - pdVector6.m_data[n19] : (double)n22 * (((double)n10 + pdVector.m_data[n19] - (double)n18 + (double)n13 - 1.0) / 2.0 + (double)n18 - (double)n13 + 1.0) - pdVector6.m_data[n19]) : (double)n22 * ((double)n10 + (double)(n13 - n14) * pdVector3.m_data[n19] / (double)n22 + pdVector.m_data[n19] - pdVector2.m_data[n19]) / 2.0 - pdVector6.m_data[n19];
                    if (!(d13 < d11)) continue;
                    d11 = d13;
                    n3 = n19;
                    n2 = 1;
                }
                if (n3 == -1) {
                    throw new IllegalStateException("OUCH!!!");
                }
                n20 = piVector.m_data[n3];
                if (n2 != 0) {
                    n19 = 2;
                    n17 = 1;
                } else {
                    n19 = 1;
                    n17 = 2;
                }
                d10 = n2 != 0 ? pdVector.m_data[n3] - pdVector2.m_data[n3] : pdVector2.m_data[n3];
                if (pdVector5.m_data[n3] < d12 && n2 == 0 || pdVector4.m_data[n3] < d12 && n2 != 0) {
                    piVectorArray[n3][(n20 + n19) % 3] = new PiVector(n14 + n10 / 2, n22 + n12);
                    piVectorArray[n3][(n20 + n17) % 3] = new PiVector(n14 + n10 / 2 + (int)pdVector.m_data[n3], n22 + n12);
                    piVectorArray[n3][n20] = new PiVector(n14 + n10 / 2 + (int)(pdVector.m_data[n3] - d10), n22 + n12 - (int)pdVector3.m_data[n3]);
                } else {
                    piVectorArray[n3][(n20 + n19) % 3] = new PiVector((int)((double)(n14 + n10 / 2) + (double)(n13 - n14) * pdVector3.m_data[n3] / (double)n22 + d10 - pdVector.m_data[n3]), n22 + n12);
                    piVectorArray[n3][(n20 + n17) % 3] = new PiVector((int)((double)(n14 + n10 / 2) + (double)(n13 - n14) * pdVector3.m_data[n3] / (double)n22 + d10), n22 + n12);
                    piVectorArray[n3][n20] = new PiVector((int)((double)(n14 + n10 / 2) + (double)(n13 - n14) * pdVector3.m_data[n3] / (double)n22), n22 + n12 - (int)pdVector3.m_data[n3]);
                }
                n13 = (int)Math.max((double)(n13 + n10 / 2), (double)piVectorArray[n3][(n20 + n17) % 3].m_data[0] - d10 * (double)n22 / pdVector3.m_data[n3] + (double)(n10 / 2));
                n14 = piVectorArray[n3][(n20 + n17) % 3].m_data[0] + n10 / 2;
                blArray[n3] = false;
                --n11;
                continue;
            }
            d12 = n14 != n13 ? Math.atan((double)n22 / (double)(n14 - n13)) : 1.5707963267948966;
            d11 = Double.MAX_VALUE;
            n3 = -1;
            n2 = 0;
            n21 = 0;
            for (n20 = 0; n20 < n5 && n21 <= n16; ++n20) {
                n19 = nArray[n20];
                if (!blArray[n19]) continue;
                ++n21;
                double d14 = pdVector4.m_data[n19] < d12 ? ((n18 = (int)((double)(n13 + n10) + pdVector.m_data[n19] - (pdVector.m_data[n19] - pdVector2.m_data[n19]) * (double)n22 / pdVector3.m_data[n19])) <= n14 ? (double)n22 * ((double)n10 + pdVector.m_data[n19]) / 2.0 - pdVector6.m_data[n19] : (double)n22 * (((double)n10 + pdVector.m_data[n19] - (double)n18 + (double)n14 - 1.0) / 2.0 + (double)n18 - (double)n14 + 1.0) - pdVector6.m_data[n19]) : (double)n22 * ((double)n10 + (double)(n14 - n13) * pdVector3.m_data[n19] / (double)n22 + pdVector.m_data[n19] - pdVector2.m_data[n19]) / 2.0 - pdVector6.m_data[n19];
                if (d14 < d11) {
                    d11 = d14;
                    n3 = n19;
                    n2 = 0;
                }
                d14 = pdVector5.m_data[n19] < d12 ? ((n18 = (int)((double)(n14 + n10) + pdVector.m_data[n19] - pdVector2.m_data[n19] * (double)n22 / pdVector3.m_data[n19])) <= n13 ? (double)n22 * ((double)n10 + pdVector.m_data[n19]) / 2.0 - pdVector6.m_data[n19] : (double)n22 * (((double)n10 + pdVector.m_data[n19] - (double)n18 + (double)n13 - 1.0) / 2.0 + (double)n18 - (double)n13 + 1.0) - pdVector6.m_data[n19]) : (double)n22 * ((double)n10 + (double)(n13 - n14) * pdVector3.m_data[n19] / (double)n22 + pdVector2.m_data[n19]) / 2.0 - pdVector6.m_data[n19];
                if (!(d14 < d11)) continue;
                d11 = d14;
                n3 = n19;
                n2 = 1;
            }
            if (n3 == -1) {
                throw new IllegalStateException("OUCH (2)!!!");
            }
            n20 = piVector.m_data[n3];
            if (n2 != 0) {
                n19 = 2;
                n17 = 1;
            } else {
                n19 = 1;
                n17 = 2;
            }
            d10 = n2 != 0 ? pdVector.m_data[n3] - pdVector2.m_data[n3] : pdVector2.m_data[n3];
            if (pdVector4.m_data[n3] < d12 && n2 == 0 || pdVector5.m_data[n3] < d12 && n2 != 0) {
                piVectorArray[n3][(n20 + n17) % 3] = new PiVector(n13 + n10 / 2, n12);
                piVectorArray[n3][(n20 + n19) % 3] = new PiVector(n13 + n10 / 2 + (int)pdVector.m_data[n3], n12);
                piVectorArray[n3][n20] = new PiVector(n13 + n10 / 2 + (int)d10, n12 + (int)pdVector3.m_data[n3]);
            } else {
                piVectorArray[n3][(n20 + n17) % 3] = new PiVector((int)((double)(n13 + n10 / 2) + (double)(n14 - n13) * pdVector3.m_data[n3] / (double)n22 - d10), n12);
                piVectorArray[n3][(n20 + n19) % 3] = new PiVector((int)((double)(n13 + n10 / 2) + (double)(n14 - n13) * pdVector3.m_data[n3] / (double)n22 - d10 + pdVector.m_data[n3]), n12);
                piVectorArray[n3][n20] = new PiVector((int)((double)(n13 + n10 / 2) + (double)(n14 - n13) * pdVector3.m_data[n3] / (double)n22), n12 + (int)pdVector3.m_data[n3]);
            }
            n13 = piVectorArray[n3][(n20 + n19) % 3].m_data[0] + n10 / 2;
            n14 = (int)Math.max((double)(n14 + n10 / 2), (double)piVectorArray[n3][(n20 + n19) % 3].m_data[0] - (pdVector.m_data[n3] - d10) * (double)n22 / pdVector3.m_data[n3] + (double)(n10 / 2));
            blArray[n3] = false;
            --n11;
        }
        double d15 = 1.0 / (double)n4;
        double d16 = 1.0 / (double)n9;
        PdVector[][] pdVectorArray = new PdVector[n5][3];
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < 3; ++n2) {
                pdVectorArray[n3][n2] = new PdVector((double)piVectorArray[n3][n2].m_data[0] * d16, 1.0 - (double)piVectorArray[n3][n2].m_data[1] * d15);
            }
        }
        pgElementSet.setElementTextures(pdVectorArray);
        double[] dArray = new double[]{d5, n9, n4};
        return dArray;
    }

    private static int newRow(boolean[] blArray, PdVector pdVector, int[] nArray, int n) {
        double d = 0.0;
        int n2 = 0;
        while (!blArray[nArray[n2]]) {
            ++n2;
        }
        d = pdVector.m_data[nArray[n2]];
        int n3 = (int)d + n;
        return n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

