/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgUtil;
import jvx.geom.PgVertexStar;
import jvx.geom.PwCurvature;
import jvx.numeric.PnJacobi;
import jvx.numeric.PnMassMatrix;
import jvx.project.PjWorkshop;
import jvx.util.PuQueue;
import jvx.vector.PwVectorField;

public class PwShapeOperator
extends PjWorkshop {
    private static final long serialVersionUID = 2911299465845415039L;
    public static boolean m_useConvolutionMask = false;
    private static double[][] m_edgeAngle = null;
    private static boolean m_bUseAbsoluteValue;
    private static PdVector m_edge;
    private static PdVector m_e1;
    private static PdVector m_e2;
    private static PdVector m_img_e1;
    private static PdVector m_img_e2;
    private static PdVector m_tmp2;
    static /* synthetic */ Class class$jvx$geom$PwShapeOperator;

    public PwShapeOperator() {
        super("Shape Operator");
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwShapeOperator == null ? (class$jvx$geom$PwShapeOperator = PwShapeOperator.class$("jvx.geom.PwShapeOperator")) : class$jvx$geom$PwShapeOperator)) {
            this.init();
        }
    }

    public static boolean isEnabledConvolution() {
        return m_useConvolutionMask;
    }

    public static void enableConvolution(boolean bl) {
        m_useConvolutionMask = bl;
    }

    public static boolean isEnabledAbsoluteValue() {
        return m_bUseAbsoluteValue;
    }

    public static void enableAbsoluteValue(boolean bl) {
        m_bUseAbsoluteValue = bl;
    }

    public static PdMatrix[] getShapeOperator(PgElementSet pgElementSet, double d, boolean bl, PdMatrix[] pdMatrixArray) {
        int n;
        if (!pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        long l = System.currentTimeMillis();
        pgElementSet.allocateEdgeStars();
        m_edgeAngle = new double[pgElementSet.getNumEdgeStars()][3];
        for (int i = 0; i < m_edgeAngle.length; ++i) {
            for (n = 0; n < m_edgeAngle[i].length; ++n) {
                PwShapeOperator.m_edgeAngle[i][n] = Double.NaN;
            }
        }
        PiVector piVector = PgVertexStar.getElementPerVertex(pgElementSet);
        if (pdMatrixArray == null) {
            n = bl ? pgElementSet.getNumVertices() : pgElementSet.getNumElements();
            pdMatrixArray = new PdMatrix[n];
        }
        if (bl) {
            for (n = 0; n < pgElementSet.getNumVertices(); ++n) {
                pdMatrixArray[n] = PwShapeOperator.getShapeOperator(pgElementSet, n, piVector.m_data[n], d, null);
                if (n % 100 != 0 || System.currentTimeMillis() - l <= 3000L) continue;
                PsDebug.showStatus((String)("Calculating shape operators ... " + 100 * n / pgElementSet.getNumVertices() + "%"));
            }
        } else {
            for (n = 0; n < pgElementSet.getNumElements(); ++n) {
                pdMatrixArray[n] = PwShapeOperator.getShapeOperator(pgElementSet, n, d, null);
                if (n % 100 != 0 || System.currentTimeMillis() - l <= 3000L) continue;
                PsDebug.showStatus((String)("Calculating shape operators ... " + 100 * n / pgElementSet.getNumElements() + "%"));
            }
        }
        if (System.currentTimeMillis() - l > 1000L) {
            PsDebug.showStatus((String)"Calculating shape operators ... done.");
        }
        m_edgeAngle = null;
        return pdMatrixArray;
    }

    public static PdMatrix getShapeOperator(PgElementSet pgElementSet, int n, int n2, double d, PdMatrix pdMatrix) {
        if (pgElementSet == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = pgElementSet.getElementWithVertex(n);
        }
        return PwShapeOperator.makeShapeOperator(pgElementSet, n2, pgElementSet.getVertex(n), d, pdMatrix);
    }

    public static PdMatrix getShapeOperator(PgElementSet pgElementSet, PdBary pdBary, double d, PdMatrix pdMatrix) {
        if (pgElementSet == null) {
            return null;
        }
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix(3);
        }
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n = pdBary.getElementInd();
        PiVector piVector = pgElementSet.getElement(n);
        PdVector pdVector = pdBary.getVertex(null, pdVectorArray[piVector.m_data[0]], pdVectorArray[piVector.m_data[1]], pdVectorArray[piVector.m_data[2]]);
        return PwShapeOperator.makeShapeOperator(pgElementSet, n, pdVector, d, pdMatrix);
    }

    private static PdMatrix makeShapeOperator(PgElementSet pgElementSet, int n, PdVector pdVector, double d, PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix(3, 3);
        }
        byte[] byArray = new byte[pgElementSet.getNumElements()];
        PuQueue puQueue = new PuQueue(100);
        puQueue.enqueue(n);
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        double d2 = 0.0;
        boolean[] blArray = new boolean[3];
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        while (!puQueue.isEmpty()) {
            int n2;
            int n3;
            int n4;
            int n5 = puQueue.extractFirst();
            byArray[n5] = 2;
            PiVector piVector = pgElementSet.getElement(n5);
            int n6 = piVector.getSize();
            for (n4 = 0; n4 < n6; ++n4) {
                blArray[n4] = pdVector.sqrDist(pdVectorArray[piVector.m_data[n4]]) < d * d;
            }
            for (n4 = 0; n4 < n6; ++n4) {
                n3 = pgElementSet.getNeighbour((int)n5).m_data[n4];
                if (n3 < 0) continue;
                n2 = (n4 + 1) % n6;
                int n7 = (n4 + 2) % n6;
                int n8 = piVector.m_data[n2];
                int n9 = piVector.m_data[n7];
                if ((blArray[n2] || blArray[n7]) && byArray[n3] == 0) {
                    puQueue.enqueue(n3);
                    byArray[n3] = 1;
                }
                if (byArray[n3] >= 2) continue;
                PdVector pdVector4 = pdVectorArray[n8];
                PdVector pdVector5 = pdVectorArray[n9];
                pdVector2.sub(pdVector5, pdVector4);
                double d3 = 0.0;
                if (blArray[n2] && blArray[n7]) {
                    d3 = PwShapeOperator.getEdgeCurvature(pgElementSet, n5, n3, n8, n9);
                    d3 /= pdVector2.length();
                } else if (!blArray[n2] && blArray[n7]) {
                    d3 = PwShapeOperator.getEdgeCurvature(pgElementSet, n5, n3, n9, n8);
                    d3 *= PwShapeOperator.edgeLengthInBall(pdVector, d, pdVector5, pdVector4) / pdVector2.sqrLength();
                } else if (blArray[n2] && !blArray[n7]) {
                    d3 = PwShapeOperator.getEdgeCurvature(pgElementSet, n5, n3, n8, n9);
                    d3 *= PwShapeOperator.edgeLengthInBall(pdVector, d, pdVector4, pdVector5) / pdVector2.sqrLength();
                }
                if (m_useConvolutionMask) {
                    pdVector3.blend(0.5, pdVector4, 0.5, pdVector5);
                    d3 *= PwShapeOperator.convolutionMask(PdVector.sqrDist((PdVector)pdVector, (PdVector)pdVector3) / d);
                }
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        double[] dArray = pdMatrix.m_data[i];
                        int n10 = j;
                        dArray[n10] = dArray[n10] + d3 * pdVector2.m_data[i] * pdVector2.m_data[j];
                    }
                }
            }
            n4 = piVector.m_data[0];
            n3 = piVector.m_data[1];
            n2 = piVector.m_data[2];
            if (blArray[0] && blArray[1] && blArray[2]) {
                d2 += PdVector.area((PdVector)pdVectorArray[n4], (PdVector)pdVectorArray[n3], (PdVector)pdVectorArray[n2]);
                continue;
            }
            if (!blArray[0] && blArray[1] && blArray[2]) {
                d2 += PwShapeOperator.getQuadElementArea(pdVector, d, pdVectorArray[n3], pdVectorArray[n2], pdVectorArray[n4]);
                continue;
            }
            if (blArray[0] && !blArray[1] && blArray[2]) {
                d2 += PwShapeOperator.getQuadElementArea(pdVector, d, pdVectorArray[n4], pdVectorArray[n2], pdVectorArray[n3]);
                continue;
            }
            if (blArray[0] && blArray[1] && !blArray[2]) {
                d2 += PwShapeOperator.getQuadElementArea(pdVector, d, pdVectorArray[n4], pdVectorArray[n3], pdVectorArray[n2]);
                continue;
            }
            if (!blArray[0] && !blArray[1] && blArray[2]) {
                d2 += PwShapeOperator.getTriangElementArea(pdVector, d, pdVectorArray[n2], pdVectorArray[n4], pdVectorArray[n3]);
                continue;
            }
            if (!blArray[0] && blArray[1] && !blArray[2]) {
                d2 += PwShapeOperator.getTriangElementArea(pdVector, d, pdVectorArray[n3], pdVectorArray[n4], pdVectorArray[n2]);
                continue;
            }
            if (!blArray[0] || blArray[1] || blArray[2]) continue;
            d2 += PwShapeOperator.getTriangElementArea(pdVector, d, pdVectorArray[n4], pdVectorArray[n3], pdVectorArray[n2]);
        }
        if (d2 != 0.0) {
            pdMatrix.multScalar(1.0 / d2);
        }
        return pdMatrix;
    }

    public static PdMatrix getShapeOperator(PgElementSet pgElementSet, int n, double d, PdMatrix pdMatrix) {
        PdBary pdBary = new PdBary(pgElementSet.getElement(n).getSize());
        pdBary.setElementInd(n);
        for (int i = 0; i < pdBary.getSize(); ++i) {
            pdBary.m_data[i] = 1.0 / (double)pdBary.getSize();
        }
        return PwShapeOperator.getShapeOperator(pgElementSet, pdBary, d, pdMatrix);
    }

    private static double getEdgeCurvature(PgElementSet pgElementSet, int n, int n2, int n3, int n4) {
        PiVector piVector = pgElementSet.getElement(n);
        PiVector piVector2 = pgElementSet.getElement(n2);
        int n5 = piVector.getIndexOf(n3);
        int n6 = piVector2.getIndexOf(n3);
        int n7 = pgElementSet.getNeighbour(n).getIndexOf(n2);
        boolean bl = piVector.m_data[(n5 + 1) % piVector.getSize()] == n4;
        boolean bl2 = piVector2.m_data[(n6 + 1) % piVector2.getSize()] != n4;
        boolean bl3 = bl == bl2;
        PdVector pdVector = pgElementSet.getElementNormal(n);
        PdVector pdVector2 = pgElementSet.getElementNormal(n2);
        m_edge.sub(pgElementSet.getVertex(n4), pgElementSet.getVertex(n3));
        boolean bl4 = PdVector.det((PdVector)pdVector, (PdVector)m_edge, (PdVector)pdVector2) > 0.0;
        double d = m_edgeAngle != null && !Double.isNaN(m_edgeAngle[n][n7]) ? m_edgeAngle[n][n7] : PdVector.angle((PdVector)pdVector, (PdVector)pdVector2);
        if (m_edgeAngle != null) {
            PwShapeOperator.m_edgeAngle[n][n7] = d;
        }
        if (d < 1.0E-10 || d > 179.9999999999) {
            return 0.0;
        }
        if (!bl3) {
            d = 180.0 - d;
        }
        if (bl4) {
            d = -d;
        }
        if (!bl && bl3) {
            d = -d;
        }
        d = d / 180.0 * Math.PI;
        if (m_bUseAbsoluteValue) {
            return Math.abs(d);
        }
        return d;
    }

    private static double edgeLengthInBall(PdVector pdVector, double d, PdVector pdVector2, PdVector pdVector3) {
        double d2 = pdVector2.dist(pdVector3);
        if (d2 < 1.0E-10) {
            return 0.0;
        }
        if (pdVector2.sqrDist(pdVector) < 1.0E-10) {
            return d;
        }
        double d3 = PdVector.dot((PdVector)pdVector3, (PdVector)pdVector, (PdVector)pdVector2) / d2;
        double d4 = Math.sqrt(d3 * d3 - pdVector.sqrDist(pdVector3) + d * d);
        return d3 - d4;
    }

    private static double getQuadElementArea(PdVector pdVector, double d, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        double d2 = pdVector2.dist(pdVector4);
        double d3 = pdVector3.dist(pdVector4);
        double d4 = PwShapeOperator.edgeLengthInBall(pdVector, d, pdVector2, pdVector4);
        double d5 = PwShapeOperator.edgeLengthInBall(pdVector, d, pdVector3, pdVector4);
        return (d5 / d3 + d4 / d2 - d5 * d4 / (d3 * d2)) * PdVector.area((PdVector)pdVector2, (PdVector)pdVector3, (PdVector)pdVector4);
    }

    private static double getTriangElementArea(PdVector pdVector, double d, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        double d2 = pdVector2.sqrDist(pdVector4);
        double d3 = pdVector2.sqrDist(pdVector3);
        double d4 = PwShapeOperator.edgeLengthInBall(pdVector, d, pdVector2, pdVector4);
        double d5 = PwShapeOperator.edgeLengthInBall(pdVector, d, pdVector2, pdVector3);
        return d4 * d5 / Math.sqrt(d2 * d3) * PdVector.area((PdVector)pdVector2, (PdVector)pdVector3, (PdVector)pdVector4);
    }

    public static void getPrincipalCurvatures(PgElementSet pgElementSet, PdMatrix[] pdMatrixArray, PdVector[] pdVectorArray, PdVector[][] pdVectorArray2, boolean bl, boolean bl2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Cannot compute principal curvatures. Given geometry is null.");
            return;
        }
        int n = pgElementSet.getDimOfVertices();
        int n2 = bl2 ? pgElementSet.getNumVertices() : pgElementSet.getNumElements();
        PdVector pdVector = new PdVector(n);
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)n, (int)n);
        PdVector pdVector2 = new PdVector(n);
        int[] nArray = new int[n];
        for (int i = 0; i < n2; ++i) {
            int n3;
            PnJacobi.computeEigenvectors(pdMatrixArray[i], n, pdVector, pdVectorArray3);
            for (n3 = 0; n3 < n; ++n3) {
                pdVector2.m_data[n3] = Math.abs(pdVector.m_data[n3]);
            }
            PuMath.heapsort((int)n, (double[])pdVector2.m_data, (int[])nArray);
            if (pdVector.m_data[nArray[n - 1]] < pdVector.m_data[nArray[n - 2]]) {
                if (pdVectorArray2 != null) {
                    pdVectorArray2[0][i].copyArray(pdVectorArray3[nArray[n - 2]]);
                }
                if (pdVectorArray != null) {
                    pdVectorArray[0].m_data[i] = pdVector.m_data[nArray[n - 2]];
                }
                if (pdVectorArray2 != null) {
                    pdVectorArray2[1][i].copyArray(pdVectorArray3[nArray[n - 1]]);
                }
                if (pdVectorArray == null) continue;
                pdVectorArray[1].m_data[i] = pdVector.m_data[nArray[n - 1]];
                continue;
            }
            for (n3 = 0; n3 < 2; ++n3) {
                if (pdVectorArray2 != null) {
                    pdVectorArray2[n3][i].copyArray(pdVectorArray3[nArray[n - 1 - n3]]);
                }
                if (pdVectorArray == null) continue;
                pdVectorArray[n3].m_data[i] = pdVector.m_data[nArray[n - 1 - n3]];
            }
        }
    }

    private static double convolutionMask(double d) {
        if (d > 1.0) {
            return 0.0;
        }
        if (d < 0.0) {
            return 3.0;
        }
        return 3.0 * (1.0 - d);
    }

    public static PgVectorField[] makeElementBasedPrincipalCurvatures(PgElementSet pgElementSet, PdVector[] pdVectorArray, boolean bl) {
        int n;
        pgElementSet.allocateEdgeStars();
        PdMatrix[] pdMatrixArray = PwCurvature.getShapeOperator(pgElementSet, null, false);
        PnMassMatrix.multInvMassMatrix(pgElementSet, pdMatrixArray, true);
        int n2 = pgElementSet.getNumElements();
        PdMatrix pdMatrix = new PdMatrix(3);
        PgVectorField[] pgVectorFieldArray = new PgVectorField[2];
        for (n = 0; n < 2; ++n) {
            pgVectorFieldArray[n] = new PgVectorField(3, 1);
            pgVectorFieldArray[n].setName("Principal curvatures" + n);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgElementSet);
        }
        for (n = 0; n < n2; ++n) {
            PdVector[] pdVectorArray2;
            int n3;
            PiVector piVector = pgElementSet.getElement(n);
            int n4 = piVector.getSize();
            pdMatrix.setConstant(0.0);
            for (int i = 0; i < n4; ++i) {
                n3 = piVector.m_data[i];
                pdMatrix.add(pdMatrixArray[n3]);
            }
            pdMatrix.multScalar(1.0 / (double)n4);
            if (pdVectorArray == null) {
                pdVectorArray2 = PwShapeOperator.calcEigensystem(pdMatrix, pgElementSet.getElementNormal(n), null, null);
            } else {
                PdVector pdVector = new PdVector(2);
                pdVectorArray2 = PwShapeOperator.calcEigensystem(pdMatrix, pgElementSet.getElementNormal(n), null, pdVector);
                pdVectorArray[n] = new PdVector(pdVector.m_data[0], pdVector.m_data[1]);
            }
            for (n3 = 0; n3 < 2; ++n3) {
                pgVectorFieldArray[n3].setVector(n, pdVectorArray2[n3]);
            }
        }
        return pgVectorFieldArray;
    }

    public static PgVectorField[] makeVertexBasedPrincipalCurvatures(PgElementSet pgElementSet, PdVector[] pdVectorArray, boolean bl) {
        int n;
        PdMatrix[] pdMatrixArray = PwCurvature.getShapeOperator(pgElementSet, null, false);
        PnMassMatrix.multInvMassMatrix(pgElementSet, pdMatrixArray, true);
        int n2 = pgElementSet.getNumVertices();
        PgVectorField[] pgVectorFieldArray = new PgVectorField[2];
        for (n = 0; n < 2; ++n) {
            pgVectorFieldArray[n] = new PgVectorField(3, 0);
            pgVectorFieldArray[n].setName("Principal curvatures" + n);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgElementSet);
        }
        for (n = 0; n < n2; ++n) {
            PdVector[] pdVectorArray2 = PwShapeOperator.calcEigensystem(pdMatrixArray[n], pgElementSet.getVertexNormal(n), null, pdVectorArray != null ? pdVectorArray[n] : null);
            for (int i = 0; i < 2; ++i) {
                pgVectorFieldArray[i].setVector(n, pdVectorArray2[i]);
            }
        }
        return pgVectorFieldArray;
    }

    public static PgVectorField[] makeElementBasedPrincipalCurvatures(PgElementSet pgElementSet, PdVector[] pdVectorArray) {
        double d = 5.0 * PgUtil.getEdgeLengths(pgElementSet, null, true).average();
        return PwShapeOperator.makeElementBasedPrincipalCurvatures(pgElementSet, pdVectorArray, d);
    }

    public static PgVectorField[] makeElementBasedPrincipalCurvatures(PgElementSet pgElementSet, PdVector[] pdVectorArray, double d) {
        int n = pgElementSet.getNumElements();
        PdMatrix[] pdMatrixArray = PwShapeOperator.getShapeOperator(pgElementSet, d, false, null);
        PgVectorField[] pgVectorFieldArray = new PgVectorField[2];
        for (int i = 0; i < 2; ++i) {
            pgVectorFieldArray[i] = new PgVectorField(3, 1);
            pgVectorFieldArray[i].setName("Principal curvatures" + i);
            pgVectorFieldArray[i].setGeometry((PgPointSet)pgElementSet);
        }
        for (int i = 0; i < n; ++i) {
            PdVector[] pdVectorArray2;
            if (pdVectorArray == null) {
                pdVectorArray2 = PwShapeOperator.calcEigensystem(pdMatrixArray[i], pgElementSet.getElementNormal(i), null, null);
            } else {
                PdVector pdVector = new PdVector(2);
                pdVectorArray2 = PwShapeOperator.calcEigensystem(pdMatrixArray[i], pgElementSet.getElementNormal(i), null, pdVector);
                pdVectorArray[i].m_data[0] = pdVector.m_data[0];
                pdVectorArray[i].m_data[1] = pdVector.m_data[1];
            }
            for (int j = 0; j < 2; ++j) {
                pgVectorFieldArray[j].setVector(i, pdVectorArray2[j]);
            }
        }
        return pgVectorFieldArray;
    }

    public static PgVectorField[] makeVertexBasedPrincipalCurvatures(PgElementSet pgElementSet, PdVector[] pdVectorArray, double d) {
        int n;
        int n2 = pgElementSet.getNumVertices();
        PdMatrix[] pdMatrixArray = PwShapeOperator.getShapeOperator(pgElementSet, d, true, null);
        PgVectorField[] pgVectorFieldArray = new PgVectorField[2];
        for (n = 0; n < 2; ++n) {
            pgVectorFieldArray[n] = new PgVectorField(3, 0);
            pgVectorFieldArray[n].setName("Principal curvatures" + n);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgElementSet);
        }
        for (n = 0; n < n2; ++n) {
            PdVector[] pdVectorArray2 = PwShapeOperator.calcEigensystem(pdMatrixArray[n], pgElementSet.getVertexNormal(n), null, pdVectorArray != null ? pdVectorArray[n] : null);
            for (int i = 0; i < 2; ++i) {
                pgVectorFieldArray[i].setVector(n, pdVectorArray2[i]);
            }
        }
        return pgVectorFieldArray;
    }

    public static PdVector[] calcEigensystem(PdMatrix pdMatrix, PdVector pdVector, PdVector[] pdVectorArray, PdVector pdVector2) {
        pdVectorArray = PdVector.realloc((PdVector[])pdVectorArray, (int)4, (int)3);
        if (pdVector2 != null) {
            pdVector2.setSize(2);
        }
        PdVector pdVector3 = PdVector.copyNew((PdVector)pdVector);
        pdVector3.normalize();
        m_e1.setConstant(1.0);
        PwShapeOperator.m_e1.m_data[pdVector3.indexOfAbsMax()] = 0.0;
        PuVectorGeom.projectOntoPlane((PdVector)m_e1, (PdVector)pdVector3);
        m_e1.normalize();
        m_e2.cross(pdVector3, m_e1);
        m_img_e1.leftMultMatrix(pdMatrix, m_e1);
        m_img_e2.leftMultMatrix(pdMatrix, m_e2);
        PuVectorGeom.projectOntoPlane((PdVector)m_img_e1, (PdVector)pdVector3);
        PuVectorGeom.projectOntoPlane((PdVector)m_img_e2, (PdVector)pdVector3);
        double d = m_e1.dot(m_img_e1);
        double d2 = m_e2.dot(m_img_e1);
        double d3 = m_e1.dot(m_img_e2);
        double d4 = m_e2.dot(m_img_e2);
        double d5 = d * d + 4.0 * d2 * d3 - 2.0 * d * d4 + d4 * d4;
        d5 = d5 < 0.0 ? 0.0 : Math.sqrt(d5);
        pdVectorArray[0].blend(d - d4 - d5, m_e1, 2.0 * d3, m_e2);
        pdVectorArray[1].blend(d - d4 + d5, m_e1, 2.0 * d3, m_e2);
        PwShapeOperator.normalizeFrame(pdVectorArray[0], pdVectorArray[1], m_e1, m_e2, pdVector3);
        if (Math.abs(d + d4 - d5) < Math.abs(d + d4 + d5)) {
            PdVector pdVector4 = pdVectorArray[0];
            pdVectorArray[0] = pdVectorArray[1];
            pdVectorArray[1] = pdVector4;
            if (pdVector2 != null) {
                pdVector2.m_data[0] = (d + d4 + d5) / 2.0;
                pdVector2.m_data[1] = (d + d4 - d5) / 2.0;
            }
        } else if (pdVector2 != null) {
            pdVector2.m_data[0] = (d + d4 - d5) / 2.0;
            pdVector2.m_data[1] = (d + d4 + d5) / 2.0;
        }
        m_tmp2.cross(pdVectorArray[0], pdVectorArray[1]);
        if (m_tmp2.dot(pdVector3) < 0.0) {
            pdVectorArray[1].multScalar(-1.0);
        }
        pdVectorArray[2].multScalar(pdVectorArray[0], -1.0);
        pdVectorArray[3].multScalar(pdVectorArray[1], -1.0);
        return pdVectorArray;
    }

    public static PdVector makeTrustFunction(PgVectorField pgVectorField, PdVector[] pdVectorArray, boolean bl) {
        if (pgVectorField == null) {
            PsDebug.warning((String)"Missing vector field.");
            return null;
        }
        if (!(pgVectorField.getGeometry() instanceof PgElementSet)) {
            PsDebug.warning((String)"Vector field must live on an element set.");
            return null;
        }
        PgElementSet pgElementSet = (PgElementSet)pgVectorField.getGeometry();
        PdVector pdVector = PwShapeOperator.calcCurvatureWeights(pdVectorArray);
        int n = pgVectorField.getNumVectors();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < pgElementSet.getDimOfElement(i); ++j) {
                    int n2 = pgElementSet.getNeighbour(i).getEntry(j);
                    if (n2 < 0) continue;
                    double d = PwVectorField.calcAngle(pgVectorField, i, n2);
                    if (d > Math.PI) {
                        d -= Math.PI;
                    }
                    if (d > 1.5707963267948966) {
                        d = Math.PI - d;
                    }
                    int n3 = i;
                    pdVector.m_data[n3] = pdVector.m_data[n3] * Math.exp(-d / 2.0);
                }
            }
        }
        return pdVector;
    }

    private static PdVector calcCurvatureWeights(PdVector[] pdVectorArray) {
        int n = pdVectorArray.length;
        PdVector pdVector = new PdVector(n);
        for (int i = 0; i < n; ++i) {
            double d = pdVectorArray[i].m_data[0];
            double d2 = pdVectorArray[i].m_data[1];
            pdVector.m_data[i] = Math.abs(d - d2);
        }
        return pdVector;
    }

    public static void normalizeFrame(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5) {
        double d = pdVector.sqrLength();
        double d2 = pdVector2.sqrLength();
        if (d <= 1.0E-10 && d2 <= 1.0E-10) {
            pdVector.copy(pdVector3);
            pdVector2.copy(pdVector4);
            return;
        }
        if (d <= 1.0E-10) {
            pdVector2.normalize();
            pdVector.cross(pdVector2, pdVector5);
            return;
        }
        if (d2 <= 1.0E-10) {
            pdVector.normalize();
            pdVector2.cross(pdVector5, pdVector);
            return;
        }
        pdVector.normalize();
        pdVector2.normalize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_edge = new PdVector(3);
        m_e1 = new PdVector(3);
        m_e2 = new PdVector(3);
        m_img_e1 = new PdVector(3);
        m_img_e2 = new PdVector(3);
        m_tmp2 = new PdVector(3);
    }
}

