/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Random;
import java.util.Vector;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.vecmath.PiVector;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwGeodesic;
import jvx.project.PjWorkshop;

public class PwMatching
extends PjWorkshop {
    protected PgElementSet m_elementSet;
    private int[] m_matching;
    private int m_noe;
    private int m_numUnmatched;
    private Vector m_outer;
    private Vector m_refusedOuter;
    private int[] m_iPreviousOuter;
    private int[] m_oDeviation;
    private int[] m_currentWay;
    private int[] m_root;
    private int[] m_triangleType;
    private static final int UNUSED = -1;
    private static final int ROOT = 0;
    private static final int INNER = 1;
    private static final int OUTER = 2;
    private int m_preMatching = 0;
    public static final int CONSERVATIVE = 0;
    public static final int DIJKSTRA = 1;
    public static final int GREEDY = 2;
    public static final int NONE = 3;
    static /* synthetic */ Class class$jvx$geom$PwMatching;

    public PwMatching() {
        super(PsConfig.getMessage((int)54441));
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwMatching == null ? (class$jvx$geom$PwMatching = PwMatching.class$("jvx.geom.PwMatching")) : class$jvx$geom$PwMatching)) {
            this.init();
        }
    }

    public void setGeometry(PgElementSet pgElementSet) {
        this.m_elementSet = pgElementSet;
        super.setGeometry((PgGeometry)pgElementSet);
        this.init();
    }

    public void setPreMatching(int n) {
        this.m_preMatching = n;
    }

    public void init() {
        super.init();
        if (this.m_elementSet != null) {
            if (this.m_elementSet.getDimOfElements() != 3) {
                PsDebug.warning((String)"Geometry is not triangulated.");
            }
            if (!this.m_elementSet.checkNeighbour(false)) {
                this.m_elementSet.makeNeighbour();
            }
            this.m_noe = this.m_elementSet.getNumElements();
            this.m_matching = new int[this.m_noe];
            this.m_iPreviousOuter = new int[this.m_noe];
            this.m_oDeviation = new int[this.m_noe];
            this.m_currentWay = new int[this.m_noe];
            this.m_root = new int[this.m_noe];
            this.m_triangleType = new int[this.m_noe];
            for (int i = 0; i < this.m_noe; ++i) {
                this.m_matching[i] = -1;
                this.m_iPreviousOuter[i] = -1;
                this.m_oDeviation[i] = -1;
                this.m_currentWay[i] = -1;
                this.m_root[i] = -1;
                this.m_triangleType[i] = -1;
            }
            this.m_outer = new Vector();
            this.m_refusedOuter = new Vector();
        }
    }

    public void reset() {
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.m_elementSet.copy((PsObject)this.m_geom);
        this.m_elementSet.update((Object)this.m_elementSet);
        this.init();
    }

    public void dijkstraMatching() {
        int n;
        int n2 = this.m_elementSet.getNumVertices();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!this.m_elementSet.hasTagVertex(n, 1)) continue;
            ++n3;
        }
        PiVector piVector = new PiVector();
        if (n3 == 0) {
            piVector.setSize(1);
            piVector.m_data[0] = 0;
        } else {
            piVector.setSize(n3);
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                if (!this.m_elementSet.hasTagVertex(n, 1)) continue;
                piVector.m_data[n4] = n;
                ++n4;
            }
        }
        PiVector piVector2 = PwGeodesic.getDijkstraDistance(this.m_elementSet, piVector);
        for (n = 0; n < this.m_noe; ++n) {
            this.m_matching[n] = -1;
        }
        for (n = 0; n < this.m_noe; ++n) {
            PiVector piVector3 = this.m_elementSet.getElement(n);
            PiVector piVector4 = this.m_elementSet.getNeighbour(n);
            for (int i = 0; i < 3; ++i) {
                if ((piVector2.m_data[piVector3.m_data[i]] >= piVector2.m_data[piVector3.m_data[(i + 1) % 3]] || piVector2.m_data[piVector3.m_data[i]] >= piVector2.m_data[piVector3.m_data[(i + 2) % 3]]) && (piVector2.m_data[piVector3.m_data[i]] <= piVector2.m_data[piVector3.m_data[(i + 1) % 3]] || piVector2.m_data[piVector3.m_data[i]] <= piVector2.m_data[piVector3.m_data[(i + 2) % 3]])) continue;
                this.m_matching[n] = piVector4.m_data[i];
            }
        }
        for (n = 0; n < this.m_noe; ++n) {
            if (this.m_matching[n] == -1 || this.m_matching[this.m_matching[n]] == n) continue;
            this.m_matching[n] = -1;
        }
        this.greedyMatching();
    }

    public void conservativeMatching() {
        int n;
        for (n = 0; n < this.m_noe; ++n) {
            this.m_matching[n] = -1;
        }
        for (n = 0; n < this.m_noe; ++n) {
            if (this.m_matching[n] != -1) continue;
            PiVector piVector = this.m_elementSet.getNeighbour(n);
            int n2 = piVector.m_data[0];
            if (n2 == -1) continue;
            piVector = this.m_elementSet.getNeighbour(n2);
            if (piVector.m_data[0] != n) continue;
            this.m_matching[n] = n2;
            this.m_matching[n2] = n;
        }
        this.greedyMatching();
    }

    public void greedyMatching() {
        block0: for (int i = 0; i < this.m_noe; ++i) {
            PiVector piVector = this.m_elementSet.getNeighbour(i);
            if (this.m_matching[i] != -1) continue;
            for (int j = 0; j < 3; ++j) {
                if (piVector.m_data[j] == -1 || this.m_matching[piVector.m_data[j]] != -1) continue;
                this.m_matching[piVector.m_data[j]] = i;
                this.m_matching[i] = piVector.m_data[j];
                continue block0;
            }
        }
    }

    protected void setRoots() {
        this.m_numUnmatched = 0;
        for (int i = 0; i < this.m_noe; ++i) {
            if (this.m_matching[i] == -1) {
                ++this.m_numUnmatched;
                this.m_triangleType[i] = 0;
                this.m_root[i] = i;
                this.makeOuter(i);
            } else {
                this.m_root[i] = -1;
                this.m_triangleType[i] = -1;
            }
            this.m_iPreviousOuter[i] = -1;
            this.m_oDeviation[i] = -1;
            this.m_currentWay[i] = -1;
        }
    }

    private void makeOuter(int n) {
        PiVector piVector = this.m_elementSet.getNeighbour(n);
        for (int i = 0; i < 3; ++i) {
            if (piVector.m_data[i] == -1 || this.m_matching[piVector.m_data[i]] == n || piVector.m_data[i] == -1 || piVector.m_data[i] == this.m_iPreviousOuter[n]) continue;
            int[] nArray = new int[]{n, piVector.m_data[i], this.m_root[n]};
            this.m_outer.addElement(nArray);
        }
    }

    protected boolean findMatching() {
        while (!this.m_outer.isEmpty()) {
            int[] nArray = (int[])this.m_outer.elementAt(0);
            this.m_outer.removeElementAt(0);
            int n = nArray[0];
            if (nArray[2] != this.m_root[n] || this.m_matching[this.m_root[n]] != -1) continue;
            int n2 = nArray[1];
            if (this.m_triangleType[n2] != -1 && this.m_matching[this.m_root[n2]] != -1 || this.m_triangleType[n2] == -1) {
                int n3 = this.m_matching[n2];
                this.m_iPreviousOuter[n3] = -1;
                this.m_oDeviation[n2] = -1;
                this.m_oDeviation[n3] = -1;
                this.m_currentWay[n2] = -1;
                this.m_currentWay[n3] = -1;
                this.m_triangleType[n2] = 1;
                this.m_triangleType[n3] = 2;
                this.m_iPreviousOuter[n2] = n;
                this.m_root[n2] = this.m_root[n];
                this.m_root[n3] = this.m_root[n];
                this.makeOuter(n3);
                continue;
            }
            if (this.m_triangleType[n2] == 2 || this.m_triangleType[n2] == 0) {
                if (this.m_root[n] == this.m_root[n2]) {
                    this.createBlossom(n, n2);
                    continue;
                }
                this.rematch(n, n2);
                return true;
            }
            if (this.m_root[n] == this.m_root[n2]) continue;
            this.m_refusedOuter.addElement(nArray);
        }
        return false;
    }

    private void createBlossom(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.m_root[n];
        int[] nArray = new int[]{n, n2};
        int n8 = -1;
        int[][] nArrayArray = new int[2][];
        for (n6 = 0; n6 < 2; ++n6) {
            this.markPath(nArray[n6], n7);
            n5 = nArray[n6];
            n4 = 1;
            while (n5 != n7) {
                n4 += 2;
                if (n8 == -1 && this.m_root[n5] == -1) {
                    n8 = n5;
                }
                this.m_root[n5] = -1;
                n5 = this.m_currentWay[this.m_matching[n5]];
            }
            nArrayArray[n6] = new int[n4];
            n5 = nArray[n6];
            n3 = 0;
            while (n5 != n7) {
                nArrayArray[n6][n3] = n5;
                nArrayArray[n6][++n3] = this.m_matching[n5];
                ++n3;
                n5 = this.m_currentWay[this.m_matching[n5]];
            }
            nArrayArray[n6][n3] = n5;
            for (n3 = 0; n3 < n4; n3 += 2) {
                this.m_currentWay[nArrayArray[n6][n3]] = -1;
            }
        }
        for (n6 = 0; n6 < 2; ++n6) {
            n4 = nArrayArray[n6].length;
            for (n3 = 0; n3 < n4; n3 += 2) {
                this.m_root[nArrayArray[n6][n3]] = n7;
            }
        }
        if (n8 == -1) {
            n8 = n7;
        }
        for (n6 = 0; n6 < 2; ++n6) {
            n5 = nArray[n6];
            n4 = 0;
            n3 = this.m_iPreviousOuter[nArray[n6]] != -1 ? nArray[n6] : -1;
            boolean bl = true;
            while (n5 != n8) {
                int n9 = nArrayArray[n6][n4 += 2];
                if (n9 != n8 && this.m_iPreviousOuter[n9] == -1) {
                    this.m_iPreviousOuter[n9] = this.m_matching[n5];
                }
                if (this.m_triangleType[this.m_matching[n5]] == 1) {
                    this.m_triangleType[this.m_matching[n5]] = 2;
                    this.makeOuter(this.m_matching[n5]);
                    this.m_oDeviation[this.m_matching[n5]] = n3;
                    if (bl) {
                        bl = false;
                        n3 = -1;
                    }
                } else if (!bl) {
                    bl = true;
                    n3 = n5;
                }
                n5 = n9;
            }
        }
        for (n6 = 0; n6 < 2; ++n6) {
            if (nArray[n6] == n8 || this.m_iPreviousOuter[nArray[n6]] != -1) continue;
            this.m_iPreviousOuter[nArray[n6]] = nArray[(n6 + 1) % 2];
        }
    }

    private void rematch(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        for (int i = 0; i < 2; ++i) {
            int n3 = nArray[i];
            int n4 = this.m_root[n3];
            this.markPath(nArray[i], n4);
            int n5 = this.m_matching[n3];
            while (n3 != n4) {
                int n6 = n5;
                n3 = this.m_currentWay[n6];
                n5 = this.m_matching[n3];
                this.m_matching[n3] = n6;
                this.m_matching[n6] = n3;
                this.m_triangleType[n3] = -1;
                this.m_triangleType[n6] = -1;
                this.m_oDeviation[n3] = -1;
                this.m_oDeviation[n6] = -1;
                this.m_iPreviousOuter[n3] = -1;
                this.m_iPreviousOuter[n6] = -1;
                this.m_root[n3] = -1;
                this.m_root[n6] = -1;
                this.m_currentWay[n3] = -1;
                this.m_currentWay[n6] = -1;
            }
            this.m_matching[nArray[i]] = nArray[(i + 1) % 2];
            this.m_triangleType[nArray[i]] = -1;
            this.m_oDeviation[nArray[i]] = -1;
            this.m_iPreviousOuter[nArray[i]] = -1;
            this.m_currentWay[nArray[i]] = -1;
        }
        for (int i = this.m_refusedOuter.size() - 1; i >= 0; --i) {
            int[] nArray2 = (int[])this.m_refusedOuter.elementAt(i);
            if ((this.m_root[nArray2[1]] == this.m_root[nArray[0]] || this.m_root[nArray2[1]] == this.m_root[nArray[1]] || this.m_root[nArray2[1]] == -1) && this.m_root[nArray2[0]] != this.m_root[nArray[0]] && this.m_root[nArray2[0]] != this.m_root[nArray[1]] && this.m_matching[nArray2[2]] == -1) {
                this.m_outer.addElement(nArray2);
                this.m_refusedOuter.removeElementAt(i);
                continue;
            }
            if (nArray2[2] != this.m_root[nArray[0]] && nArray2[2] != this.m_root[nArray[1]] && this.m_matching[nArray2[2]] == -1) continue;
            this.m_refusedOuter.removeElementAt(i);
        }
        this.m_root[nArray[0]] = -1;
        this.m_root[nArray[1]] = -1;
        this.m_numUnmatched -= 2;
    }

    private void markPath(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (this.m_matching[n] == n2) {
            return;
        }
        int n3 = n;
        while (this.m_oDeviation[n3] == -1) {
            this.m_currentWay[this.m_matching[n3]] = this.m_iPreviousOuter[this.m_matching[n3]];
            this.m_currentWay[this.m_currentWay[this.m_matching[n3]]] = this.m_matching[n3];
            if ((n3 = this.m_currentWay[this.m_matching[n3]]) != n2) continue;
            return;
        }
        this.markPath(this.m_oDeviation[n3], this.m_matching[n3]);
        PiVector piVector = this.m_elementSet.getNeighbour(this.m_oDeviation[n3]);
        for (int i = 0; i < 3; ++i) {
            if (piVector.m_data[i] == this.m_matching[this.m_oDeviation[n3]] || piVector.m_data[i] == this.m_iPreviousOuter[this.m_oDeviation[n3]]) continue;
            this.m_currentWay[piVector.m_data[i]] = this.m_oDeviation[n3];
            this.m_currentWay[this.m_oDeviation[n3]] = piVector.m_data[i];
            this.markPath(piVector.m_data[i], n2);
            break;
        }
    }

    public void turnTriangles() {
        int n = -1;
        for (int i = 0; i < this.m_noe; ++i) {
            PiVector piVector;
            int n2;
            PiVector piVector2 = this.m_elementSet.getNeighbour(i);
            if (this.m_matching[i] == -1) {
                n = 0;
            }
            for (n2 = 0; n2 < 3; ++n2) {
                if (piVector2.m_data[n2] != this.m_matching[i]) continue;
                n = n2;
                break;
            }
            if (n == 1) {
                piVector = this.m_elementSet.getElement(i);
                n2 = piVector.m_data[0];
                piVector.m_data[0] = piVector.m_data[1];
                piVector.m_data[1] = piVector.m_data[2];
                piVector.m_data[2] = n2;
                n2 = piVector2.m_data[0];
                piVector2.m_data[0] = piVector2.m_data[1];
                piVector2.m_data[1] = piVector2.m_data[2];
                piVector2.m_data[2] = n2;
                continue;
            }
            if (n != 2) continue;
            piVector = this.m_elementSet.getElement(i);
            n2 = piVector.m_data[0];
            piVector.m_data[0] = piVector.m_data[2];
            piVector.m_data[2] = piVector.m_data[1];
            piVector.m_data[1] = n2;
            n2 = piVector2.m_data[0];
            piVector2.m_data[0] = piVector2.m_data[2];
            piVector2.m_data[2] = piVector2.m_data[1];
            piVector2.m_data[1] = n2;
        }
    }

    public void match() {
        if (this.m_preMatching == 0) {
            this.conservativeMatching();
        } else if (this.m_preMatching == 1) {
            this.dijkstraMatching();
        } else if (this.m_preMatching == 2) {
            this.greedyMatching();
        }
        this.setRoots();
        while (this.m_numUnmatched >= 2 && this.findMatching()) {
        }
        this.turnTriangles();
        this.m_elementSet.update((Object)this.m_elementSet);
    }

    public void matchAllInner() {
        int n = this.m_noe;
        PgBndPolygon[] pgBndPolygonArray = null;
        boolean bl = false;
        if (this.m_elementSet.hasBoundary()) {
            bl = true;
            pgBndPolygonArray = (PgBndPolygon[])PsObject.clone((PsObject[])this.m_elementSet.getBoundaries());
        }
        PwCleanMesh.closeHoles(this.m_elementSet);
        this.init();
        if (this.m_preMatching == 0) {
            this.conservativeMatching();
        } else if (this.m_preMatching == 1) {
            this.dijkstraMatching();
        } else if (this.m_preMatching == 2) {
            this.greedyMatching();
        }
        this.setRoots();
        while (this.m_numUnmatched >= 2 && this.findMatching()) {
        }
        for (int i = 0; i < n; ++i) {
            if (this.m_matching[i] >= n) {
                this.m_matching[i] = -1;
            }
            PiVector piVector = this.m_elementSet.getNeighbour(i);
            for (int j = 0; j < 3; ++j) {
                if (piVector.m_data[j] < n) continue;
                piVector.m_data[j] = -1;
            }
        }
        this.m_elementSet.setNumElements(n);
        this.m_noe = n;
        this.turnTriangles();
        if (bl) {
            this.m_elementSet.setBoundary(pgBndPolygonArray);
        }
        this.m_elementSet.update((Object)this.m_elementSet);
        this.init();
    }

    public void makeQuadrangulation() {
        int n;
        int n2;
        int n3 = 0;
        PiVector[] piVectorArray = new PiVector[this.m_noe];
        int[] nArray = new int[this.m_noe];
        for (n2 = 0; n2 < this.m_noe; ++n2) {
            PiVector piVector;
            piVectorArray[n2] = piVector = this.m_elementSet.getNeighbour(n2);
            if (this.m_elementSet.hasTagElement(n2, 2)) continue;
            nArray[n2] = n2;
            if (piVector.getSize() == 3 && piVector.m_data[0] != -1) {
                int n4 = piVector.m_data[0];
                PiVector piVector2 = this.m_elementSet.getNeighbour(n4);
                if (piVector2.getSize() == 3 && piVector2.m_data[0] == n2) {
                    int n5;
                    PiVector piVector3 = this.m_elementSet.getElement(n2);
                    PiVector piVector4 = this.m_elementSet.getElement(n4);
                    boolean bl = true;
                    if (piVector3.m_data[1] == piVector4.m_data[1]) {
                        bl = false;
                    }
                    if (this.m_elementSet.getDimOfElements() == 3) {
                        this.m_elementSet.setDimOfElements(-1);
                    }
                    piVectorArray[n2] = bl ? new PiVector(piVector2.m_data[1], piVector2.m_data[2], piVector.m_data[1], piVector.m_data[2]) : new PiVector(piVector2.m_data[2], piVector2.m_data[1], piVector.m_data[1], piVector.m_data[2]);
                    this.m_elementSet.setElement(n2, new PiVector(piVector3.m_data[0], piVector3.m_data[1], piVector4.m_data[0], piVector3.m_data[2]));
                    this.m_elementSet.setTagElement(n4, 2);
                    nArray[n4] = n2;
                    if (this.m_elementSet.hasElementNormals()) {
                        this.m_elementSet.getElementNormal(n2).blend(0.5, this.m_elementSet.getElementNormal(n2), 0.5, this.m_elementSet.getElementNormal(n4));
                    }
                    if ((n5 = this.m_elementSet.getNumVectorFields()) > 0) {
                        for (n = 0; n < n5; ++n) {
                            PgVectorField pgVectorField = this.m_elementSet.getVectorField(n);
                            if (pgVectorField.getBasedOn() != 1) continue;
                            pgVectorField.getVector(n2).blend(0.5, pgVectorField.getVector(n2), 0.5, pgVectorField.getVector(n4));
                        }
                    }
                    if (this.m_elementSet.hasElementColors()) {
                        this.m_elementSet.setElementColor(n2, PdColor.blend((double)0.5, (Color)this.m_elementSet.getElementColor(n2), (double)0.5, (Color)this.m_elementSet.getElementColor(n4)));
                    }
                    if (!this.m_elementSet.hasElementBackColors()) continue;
                    this.m_elementSet.setElementBackColor(n2, PdColor.blend((double)0.5, (Color)this.m_elementSet.getElementBackColor(n2), (double)0.5, (Color)this.m_elementSet.getElementBackColor(n4)));
                    continue;
                }
                ++n3;
                continue;
            }
            ++n3;
        }
        if (this.m_elementSet.hasElementTextures()) {
            this.m_elementSet.assureElementTextures();
        }
        for (n2 = 0; n2 < this.m_noe; ++n2) {
            int n6 = piVectorArray[n2].getSize();
            for (n = 0; n < n6; ++n) {
                if (piVectorArray[n2].m_data[n] == -1) continue;
                piVectorArray[n2].m_data[n] = nArray[piVectorArray[n2].m_data[n]];
            }
        }
        this.m_elementSet.setNeighbours(piVectorArray);
        this.m_elementSet.removeMarkedElements();
        if (n3 == 0) {
            this.m_elementSet.setDimOfElements(4);
        } else {
            this.m_elementSet.setDimOfElements(-1);
        }
        this.m_elementSet.update((Object)this.m_elementSet);
    }

    public void scrambleTriangles() {
        int n = -1;
        Random random = new Random();
        for (int i = 0; i < this.m_noe; ++i) {
            int n2;
            PiVector piVector;
            PiVector piVector2;
            n = Math.abs(random.nextInt()) % 3;
            if (n == 1) {
                piVector2 = this.m_elementSet.getElement(i);
                piVector = this.m_elementSet.getNeighbour(i);
                n2 = piVector2.m_data[0];
                piVector2.m_data[0] = piVector2.m_data[1];
                piVector2.m_data[1] = piVector2.m_data[2];
                piVector2.m_data[2] = n2;
                n2 = piVector.m_data[0];
                piVector.m_data[0] = piVector.m_data[1];
                piVector.m_data[1] = piVector.m_data[2];
                piVector.m_data[2] = n2;
                continue;
            }
            if (n != 2) continue;
            piVector2 = this.m_elementSet.getElement(i);
            piVector = this.m_elementSet.getNeighbour(i);
            n2 = piVector2.m_data[0];
            piVector2.m_data[0] = piVector2.m_data[2];
            piVector2.m_data[2] = piVector2.m_data[1];
            piVector2.m_data[1] = n2;
            n2 = piVector.m_data[0];
            piVector.m_data[0] = piVector.m_data[2];
            piVector.m_data[2] = piVector.m_data[1];
            piVector.m_data[1] = n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

