/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgVectorField;
import jv.geom.PuCleanMesh;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;
import jvx.geom.PwCleanMesh;
import jvx.numeric.PnStraightestGeodesic;
import jvx.project.PjWorkshop;
import jvx.util.PuPriorityQueue;

public class PwGeodesic
extends PjWorkshop
implements PvPickListenerIf {
    protected PgElementSet m_geom = null;
    protected boolean m_isShowingElements = false;
    protected boolean m_isShowingEdges = false;
    protected PuInteger m_startElem;
    protected PuInteger m_endElem;
    protected PuDouble m_maxLen;
    protected PuDouble m_angle;
    protected double m_len = -1.0;
    protected PdBary m_startbary = new PdBary(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
    protected PdBary m_endbary = new PdBary(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
    protected PgPolygonOnElementSet m_polyOnEs = null;
    protected PnStraightestGeodesic m_exp = null;
    protected PgPolygon m_poly = null;
    protected boolean m_bPickStartingPoint = false;
    protected boolean m_bPickEnabled = false;
    private PdVector m_edge = new PdVector(3);
    private PdVector m_dir = new PdVector(3);
    public static final int SHORTEST = 0;
    public static final int STRAIGHTEST = 1;
    protected int m_method = 0;
    public static final int SHORTEST_DIJKSTRA = 0;
    public static final int SHORTEST_DIJKSTRA_REUSE = 1;
    public static final int SHORTEST_EUCL_DIJKSTRA = 2;
    public static final int SHORTEST_ELEMENT_TREE = 3;
    public static final int SHORTEST_DIJKSTRA_HOMOTOPIC = 4;
    protected static final int SHORTEST_MAX_MODE = 4;
    protected int m_shortestMode = 0;
    protected PiVector m_triangleRun;
    protected PiVector[] m_runs = null;
    protected boolean m_runsOutdated = true;
    protected boolean m_moveStart;
    private int[] tempints = null;
    private PgElementSet unfolded = new PgElementSet(2);
    private PdVector temp2d1 = new PdVector(2);
    private PdVector temp2d2 = new PdVector(2);
    private PdVector temp2d3 = new PdVector(2);
    private PdBary tempbary = new PdBary(3);
    static /* synthetic */ Class class$jvx$geom$PwGeodesic;

    public PwGeodesic() {
        super(PsConfig.getMessage((int)51020));
        this.m_startElem = new PuInteger(PsConfig.getMessage((int)54067), (PsUpdateIf)this);
        this.m_endElem = new PuInteger(PsConfig.getMessage((int)54068), (PsUpdateIf)this);
        this.m_maxLen = new PuDouble(PsConfig.getMessage((int)54069), (PsUpdateIf)this);
        this.m_angle = new PuDouble(PsConfig.getMessage((int)54070), (PsUpdateIf)this);
        this.m_poly = new PgPolygon(3);
        this.m_poly.setName(PsConfig.getMessage((int)45007) + "[" + PsObject.getNumObjects() + "]");
        this.m_poly.setGlobalEdgeSize(2.0);
        this.m_startElem.setDefBounds(0, 0, 1, 2);
        this.m_startElem.setDefValue(0);
        this.m_startElem.init();
        this.m_endElem.setDefBounds(0, 0, 1, 2);
        this.m_endElem.setDefValue(0);
        this.m_endElem.init();
        this.m_triangleRun = new PiVector(0);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwGeodesic == null ? (class$jvx$geom$PwGeodesic = PwGeodesic.class$("jvx.geom.PwGeodesic")) : class$jvx$geom$PwGeodesic)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_maxLen.setDefBounds(0.0, 200.0, 0.5, 5.0);
        this.m_maxLen.setDefValue(0.1);
        this.m_maxLen.init();
        this.m_angle.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_angle.setDefValue(0.0);
        this.m_angle.init();
        this.m_len = -1.0;
        this.setMethod(0);
        this.update((Object)this);
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this) {
            if (this.m_geom != null) {
                this.m_poly.update(null);
            }
        } else {
            if (object == this.m_geom) {
                if (this.isUpdateSender()) {
                    return true;
                }
                this.setElemBounds();
                this.m_exp.setGeometry(this.m_geom);
                this.setUpdateSender(true);
                this.computeWay();
                this.setUpdateSender(false);
                this.update((Object)this);
                return super.update(null);
            }
            if (object == this.m_startElem) {
                if (this.isUpdateSender()) {
                    return true;
                }
                this.setUpdateSender(true);
                this.computeWay();
                this.setUpdateSender(false);
                this.update((Object)this);
                return super.update(null);
            }
            if (object == this.m_endElem) {
                if (this.isUpdateSender()) {
                    return true;
                }
                this.setUpdateSender(true);
                this.computeWay();
                this.setUpdateSender(false);
                this.update((Object)this);
                return super.update(null);
            }
            if (object == this.m_maxLen) {
                if (this.isUpdateSender()) {
                    return true;
                }
                this.setUpdateSender(true);
                this.computeWay();
                this.setUpdateSender(false);
                this.update((Object)this);
                return super.update(null);
            }
            if (object == this.m_angle) {
                if (this.isUpdateSender()) {
                    return true;
                }
                this.setUpdateSender(true);
                this.computeWay();
                this.setUpdateSender(false);
                this.update((Object)this);
                return super.update(null);
            }
        }
        return super.update(object);
    }

    public void showWay() {
        this.computeWay(this.m_startElem.getValue(), this.m_startbary, this.m_endElem.getValue(), this.m_endbary);
        this.update((Object)this);
    }

    public void computeWay() {
        this.computeWay(this.m_startElem.getValue(), this.m_startbary, this.m_endElem.getValue(), this.m_endbary);
    }

    private void setElemBounds() {
        int n = this.m_geom.getNumElements();
        if (this.tempints == null || n != this.tempints.length) {
            this.tempints = new int[n];
            this.m_startElem.setBounds(0, n - 1, 1, 2);
            this.m_endElem.setBounds(0, n - 1, 1, 2);
        }
        if (this.m_runs == null || n != this.m_runs.length) {
            this.m_runs = PiVector.realloc((PiVector[])this.m_runs, (int)n);
        }
    }

    public void setGeometry(PgElementSet pgElementSet) {
        if (this.m_geom != null) {
            this.removeGeometry();
        }
        super.setGeometry((PgGeometry)pgElementSet);
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry not triangulated. Triangulating.");
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if (PwCleanMesh.isDegenerated(pgElementSet)) {
            PsDebug.warning((String)"Removing degenerated faces.");
            PuCleanMesh.identifyVertices((PgPointSet)pgElementSet, (double)1.0E-10);
        }
        this.m_bPickEnabled = true;
        this.m_geom = pgElementSet;
        this.m_isShowingElements = this.m_geom.isShowingElements();
        this.m_isShowingEdges = this.m_geom.isShowingEdges();
        this.m_geom.showElements(false);
        this.m_geom.showEdges(true);
        this.m_geom.addUpdateListener((PsUpdateIf)this);
        double d = this.m_geom.getDiameter() * 5.0;
        this.m_maxLen.setBounds(0.0, d, d / 100.0, d / 50.0);
        this.m_maxLen.setValue(d / 50.0);
        this.setElemBounds();
        int n = this.m_geom.getNumElements();
        this.m_startElem.setValue(n / 3);
        this.m_endElem.setValue(2 * n / 3);
        this.m_startbary.setElementInd(n / 3);
        this.m_endbary.setElementInd(2 * n / 3);
        this.m_exp = new PnStraightestGeodesic(pgElementSet, false);
        this.m_exp.setSavingMatrices(false);
        this.m_polyOnEs = new PgPolygonOnElementSet(3);
        this.m_polyOnEs.setGeometry(this.m_geom);
        this.m_runsOutdated = true;
    }

    public void removeGeometry() {
        super.removeGeometry();
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
            if (!this.m_geom.isShowingElements()) {
                this.m_geom.showElements(this.m_isShowingElements);
            }
            if (this.m_geom.isShowingEdges()) {
                this.m_geom.showEdges(this.m_isShowingEdges);
            }
            this.m_geom.update((Object)this.m_geom);
        }
        this.m_polyOnEs = null;
        this.m_exp = null;
        this.m_geom = null;
        this.m_bPickEnabled = false;
    }

    public double getActualLength() {
        return this.m_len;
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_display != null) {
            this.m_display.removePickListener((PvPickListenerIf)this);
            this.m_display.removeGeometry((PgGeometryIf)this.m_poly);
        }
        super.setDisplay(pvDisplayIf);
        if (pvDisplayIf == null) {
            return;
        }
        this.m_display.addPickListener((PvPickListenerIf)this);
        this.m_display.addGeometry((PgGeometryIf)this.m_poly);
    }

    public void close() {
        super.close();
        if (this.m_display != null) {
            if (this.m_poly != null) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_poly);
            }
            this.m_display.removePickListener((PvPickListenerIf)this);
            this.m_display.update(null);
        }
    }

    public void cancel() {
        this.m_geom.removeUpdateListener((PsUpdateIf)this);
        super.cancel();
    }

    public void ok() {
        this.fixpolygon();
        super.ok();
    }

    protected void fixpolygon() {
        this.m_poly = new PgPolygon(3);
        if (this.m_display != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_poly);
        }
        this.init();
    }

    public PgPolygon getPolygon() {
        return this.m_poly;
    }

    public PgPolygonOnElementSet getPolygonOnElementSet() {
        return this.m_polyOnEs;
    }

    protected boolean computeWay(int n, PdBary pdBary, int n2, PdBary pdBary2) {
        int n3;
        int n4;
        PgPolygonOnElementSet pgPolygonOnElementSet;
        if (this.m_geom == null) {
            return false;
        }
        this.m_polyOnEs = null;
        if (this.m_method == 0) {
            if (this.m_shortestMode == 1) {
                if (!PwGeodesic.continueTriangleRun(this.m_geom, n, n2, this.m_triangleRun, this.tempints)) {
                    this.m_triangleRun.setSize(0);
                }
                this.m_polyOnEs = PwGeodesic.getShortest(this.m_geom, pdBary, n, pdBary2, n2, this.m_triangleRun, this.m_polyOnEs, this.unfolded, null, null, null, this.temp2d1, this.temp2d2, this.temp2d3, this.tempbary);
            } else if (this.m_shortestMode == 2) {
                this.m_triangleRun = PwGeodesic.computeTriangleRunEuclideanDijkstra(this.m_geom, n, pdBary, n2, pdBary2, this.m_triangleRun, null);
                this.m_polyOnEs = PwGeodesic.getShortest(this.m_geom, pdBary, n, pdBary2, n2, this.m_triangleRun, this.m_polyOnEs, this.unfolded, null, null, null, this.temp2d1, this.temp2d2, this.temp2d3, this.tempbary);
            } else if (this.m_shortestMode == 3) {
                if (this.m_runsOutdated) {
                    this.m_runs = PwGeodesic.computeTriangleRunGeodesicDistance(this.m_geom, n, pdBary, this.m_runs, this.tempints);
                    this.m_runsOutdated = false;
                }
                PiVector piVector = this.m_geom.getNeighbour(n2);
                PiVector piVector2 = new PiVector();
                pgPolygonOnElementSet = null;
                double d = Double.MAX_VALUE;
                for (n4 = piVector.getSize() - 1; n4 >= -1; --n4) {
                    int n5;
                    int n6;
                    if (n4 >= 0) {
                        n6 = piVector.m_data[n4];
                        if (n6 < 0) continue;
                        n5 = this.m_runs[n6].getSize() + 1;
                    } else {
                        n6 = n2;
                        n5 = this.m_runs[n6].getSize();
                    }
                    piVector2.setSize(n5);
                    piVector2.copy(this.m_runs[n6]);
                    piVector2.m_data[n5 - 1] = n2;
                    pgPolygonOnElementSet = PwGeodesic.getShortest(this.m_geom, pdBary, n, pdBary2, n2, piVector2, pgPolygonOnElementSet);
                    if (pgPolygonOnElementSet == null) {
                        PsDebug.warning((String)"could not find geodesic");
                        continue;
                    }
                    pgPolygonOnElementSet.getPolygon(this.m_poly);
                    double d2 = this.m_poly.getLength();
                    if (d2 < d) {
                        if (this.m_polyOnEs == null) {
                            this.m_polyOnEs = new PgPolygonOnElementSet(this.m_geom);
                        }
                        this.m_polyOnEs.copy((PsObject)pgPolygonOnElementSet);
                        d = d2;
                    }
                    this.m_triangleRun.setSize(piVector2.getSize());
                    this.m_triangleRun.copy(piVector2);
                }
            } else if (this.m_shortestMode == 4) {
                int n7;
                int n8;
                if (this.m_triangleRun.getSize() == 0) {
                    int[] nArray = PwGeodesic.getConnectingStrip(this.m_geom, n, n2);
                    if (nArray == null || nArray.length == 0) {
                        PsDebug.error((String)"Could not find a way at all.");
                        return false;
                    }
                    this.m_triangleRun.set(nArray);
                } else {
                    int[] nArray;
                    int n9 = this.m_triangleRun.getLastEntry();
                    n8 = n2;
                    if (this.m_moveStart) {
                        n9 = this.m_triangleRun.getFirstEntry();
                        n8 = n;
                    }
                    if ((nArray = PwGeodesic.getConnectingStrip(this.m_geom, n9, n8)) == null || nArray.length == 0) {
                        PsDebug.error((String)"Could not find a way at all.");
                        return false;
                    }
                    n7 = this.m_triangleRun.getSize();
                    n3 = nArray.length;
                    n4 = n7 + n3 - 1;
                    if (this.m_moveStart) {
                        this.m_triangleRun.invert();
                    }
                    this.m_triangleRun.setSize(n4);
                    for (int i = 0; i < n3 - 1; ++i) {
                        this.m_triangleRun.m_data[n7 + i] = nArray[i + 1];
                    }
                    if (this.m_moveStart) {
                        this.m_triangleRun.invert();
                    }
                }
                this.m_polyOnEs = PwGeodesic.getShortest(this.m_geom, this.m_startbary, this.m_triangleRun.getFirstEntry(), this.m_endbary, this.m_triangleRun.getLastEntry(), this.m_triangleRun, null);
                int n10 = this.m_polyOnEs.getNumVertices();
                this.m_triangleRun.setSize(0);
                for (n8 = 0; n8 < n10 - 1; ++n8) {
                    int n11 = this.m_polyOnEs.getVertexElemInd(n8);
                    if (n11 == (n7 = this.m_polyOnEs.getVertexElemInd(n8 + 1))) {
                        this.m_triangleRun.addEntry(n11);
                        continue;
                    }
                    if (!this.m_geom.getNeighbour(n11).contains(n7)) {
                        PdBary pdBary3 = this.m_polyOnEs.getVertexBary(n8 + 1);
                        n4 = pdBary3.isOnVertex();
                        if (n4 == -1) continue;
                        PgVertexStar pgVertexStar = new PgVertexStar();
                        pgVertexStar.makeVertexStar(this.m_geom, this.m_geom.getElement((int)n7).m_data[n4], n7);
                        PiVector piVector = pgVertexStar.getElement();
                        int n12 = piVector.getIndexOf(n11);
                        int n13 = piVector.getIndexOf(n7);
                        if (n12 == -1 || n13 == -1) {
                            PsDebug.error((String)"The star does not contain the next element in computeShortestInStrip()");
                            return false;
                        }
                        piVector.shift(-n12);
                        n13 = piVector.getIndexOf(n7);
                        for (int i = 0; i < n13; ++i) {
                            this.m_triangleRun.addEntry(piVector.m_data[i]);
                        }
                        continue;
                    }
                    this.m_triangleRun.addEntry(n11);
                }
                this.m_triangleRun.addEntry(n2);
                this.m_triangleRun.removeSuccessiveDuplicates();
            } else {
                this.m_triangleRun.setSize(0);
                this.m_polyOnEs = PwGeodesic.getShortest(this.m_geom, pdBary, n, pdBary2, n2, this.m_triangleRun, this.m_polyOnEs, this.unfolded, null, null, null, this.temp2d1, this.temp2d2, this.temp2d3, this.tempbary);
            }
        } else {
            if (this.m_polyOnEs == null) {
                this.m_polyOnEs = new PgPolygonOnElementSet(this.m_geom);
            }
            PdBaryDir pdBaryDir = PdBaryDir.copyNew((PdBaryDir)PdBaryDir.TRIANGLE_EDGE[2]);
            PwBary.rotateInElement(this.m_geom, n, pdBaryDir, this.m_angle.getValue() / 180.0 * Math.PI, pdBaryDir, false);
            pdBaryDir.multScalar(this.m_maxLen.getValue() / PwBary.norm(this.m_geom, n, pdBaryDir, false));
            pdBary.m_elementInd = n;
            this.m_exp.eval(pdBary, pdBaryDir, this.m_polyOnEs);
        }
        if (this.m_polyOnEs != null) {
            this.m_polyOnEs.getPolygon(this.m_poly);
            this.m_poly.setVisible(true);
            double d = this.m_poly.getLength();
            if (this.m_method == 0) {
                this.m_maxLen.setValue(d);
            }
            this.m_len = d;
            if (this.m_method == 0 && this.m_polyOnEs.getNumVertices() >= 2) {
                pgPolygonOnElementSet = this.m_poly.getVertex(0);
                int n14 = pgPolygonOnElementSet.getSize() - 1;
                if (n14 > this.m_dir.m_data.length) {
                    n14 = this.m_dir.m_data.length - 1;
                }
                this.m_dir.copy(this.m_poly.getVertex(1));
                for (n3 = n14; n3 >= 0; --n3) {
                    int n15 = n3;
                    this.m_dir.m_data[n15] = this.m_dir.m_data[n15] - ((PdVector)pgPolygonOnElementSet).m_data[n3];
                }
                PiVector piVector = this.m_geom.getElement(n);
                pgPolygonOnElementSet = this.m_geom.getVertex(piVector.getEntry(0));
                n14 = pgPolygonOnElementSet.getSize() - 1;
                if (n14 > this.m_edge.m_data.length) {
                    n14 = this.m_edge.m_data.length - 1;
                }
                this.m_edge.copy(this.m_geom.getVertex(piVector.getEntry(1)));
                for (n4 = n14; n4 >= 0; --n4) {
                    int n16 = n4;
                    this.m_edge.m_data[n16] = this.m_edge.m_data[n16] - ((PdVector)pgPolygonOnElementSet).m_data[n4];
                }
                double d3 = PdVector.angle((PdVector)this.m_dir, (PdVector)this.m_edge);
                if (PdVector.dot((PdVector)PdVector.crossNew((PdVector)this.m_edge, (PdVector)PdVector.subNew((PdVector)this.m_geom.getVertex(piVector.getEntry(2)), (PdVector)this.m_geom.getVertex(piVector.getEntry(0)))), (PdVector)PdVector.crossNew((PdVector)this.m_edge, (PdVector)this.m_dir)) < 0.0) {
                    d3 *= -1.0;
                }
                this.m_angle.setValue(d3);
                if (this.m_polyOnEs.getNumVertices() >= 1 && this.m_startElem.getValue() != this.m_polyOnEs.getVertexElemInd(0)) {
                    this.m_startElem.setValue(this.m_polyOnEs.getVertexElemInd(0));
                    this.m_startbary.copy(this.m_polyOnEs.getVertexBary(0));
                }
            }
            if (this.m_polyOnEs.getNumVertices() >= 1) {
                this.m_endElem.setValue(this.m_polyOnEs.getVertexElemInd(this.m_polyOnEs.getNumVertices() - 1));
                this.m_endbary.copy(this.m_polyOnEs.getVertexBary(this.m_polyOnEs.getNumVertices() - 1));
            }
        } else {
            this.m_poly.setVisible(false);
            this.m_len = -1.0;
            return false;
        }
        return true;
    }

    public void selectGeometry(PgGeometryIf pgGeometryIf) {
        this.m_bPickEnabled = pgGeometryIf == this.m_geom;
    }

    public void pickDisplay(PvPickEvent pvPickEvent) {
    }

    public void dragDisplay(PvPickEvent pvPickEvent) {
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (!this.m_bPickEnabled || pvPickEvent.getElementInd() < 0 || pvPickEvent.getElementSubInd() < 0) {
            return;
        }
        if (this.m_bPickStartingPoint) {
            this.m_startbary = pvPickEvent.getBary();
            this.m_startElem.setValue(pvPickEvent.getElementInd());
            this.m_runsOutdated = true;
            this.m_moveStart = true;
        } else {
            this.m_endbary = pvPickEvent.getBary();
            this.m_endElem.setValue(pvPickEvent.getElementInd());
            this.m_moveStart = false;
        }
        this.computeWay();
        this.update((Object)this);
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        this.pickInitial(pvPickEvent);
    }

    public void pickVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }

    public void dragVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }

    public void markVertices(PvPickEvent pvPickEvent) {
    }

    public void unmarkVertices(PvPickEvent pvPickEvent) {
    }

    public void setPickFirst() {
        this.m_bPickStartingPoint = true;
    }

    public void setPickLast() {
        this.m_bPickStartingPoint = false;
    }

    protected boolean getPickFirst() {
        return this.m_bPickStartingPoint;
    }

    public void setMethod(int n) {
        switch (n) {
            case 0: {
                this.m_method = 0;
                this.m_maxLen.setEnabled(false);
                this.m_angle.setEnabled(false);
                this.m_endElem.setEnabled(true);
                this.setPickLast();
                if (this.m_poly == null) break;
                this.m_poly.setName(PsConfig.getMessage((int)45008) + "[" + PsObject.getNumObjects() + "]");
                break;
            }
            case 1: {
                this.m_method = 1;
                this.m_endElem.setEnabled(false);
                this.m_maxLen.setEnabled(true);
                this.m_angle.setEnabled(true);
                if (this.m_poly != null) {
                    this.m_poly.setName(PsConfig.getMessage((int)45009) + "[" + PsObject.getNumObjects() + "]");
                }
                this.setPickFirst();
            }
        }
    }

    public int getMethod() {
        return this.m_method;
    }

    public void setShortestMode(int n) {
        if (n < 0 || n > 4) {
            PsDebug.warning((String)("flag out of bounds = " + n));
        }
        this.m_shortestMode = n;
    }

    public int getShortestMode() {
        return this.m_shortestMode;
    }

    public void setAngle(double d) {
        this.m_angle.setValue(d);
    }

    public double getAngle() {
        return this.m_angle.getValue();
    }

    public void setStartBary(PdBary pdBary) {
        if (pdBary == null) {
            return;
        }
        this.m_startbary.copy(pdBary);
        this.m_runsOutdated = true;
    }

    public void setStartElement(int n) {
        if (n == this.m_startElem.getValue()) {
            return;
        }
        this.m_startElem.setValue(n);
        this.m_runsOutdated = true;
    }

    public void setEndBary(PdBary pdBary) {
        if (pdBary == null) {
            return;
        }
        this.m_endbary.copy(pdBary);
    }

    public void setEndElement(int n) {
        this.m_endElem.setValue(n);
    }

    private static boolean continueTriangleRun(PgElementSet pgElementSet, int n, int n2, PiVector piVector, int[] nArray) {
        int n3;
        int n4;
        PiVector piVector2;
        int n5 = piVector.getSize();
        if (n5 < 1) {
            return false;
        }
        if (n2 != piVector.m_data[n5 - 1]) {
            piVector2 = new PiVector(PwGeodesic.getConnectingStrip(pgElementSet, piVector.m_data[n5 - 1], n2));
            n4 = piVector2.getSize();
            piVector.setSize(n5 + n4 - 1);
            for (n3 = 1; n3 < n4; ++n3) {
                piVector.m_data[n5 + n3 - 1] = piVector2.m_data[n3];
            }
            n5 = n5 + n4 - 1;
        }
        if (n != piVector.m_data[0]) {
            piVector2 = new PiVector(PwGeodesic.getConnectingStrip(pgElementSet, n, piVector.m_data[0]));
            n4 = piVector2.getSize();
            piVector2.setSize(n5 + n4 - 1);
            for (n3 = 0; n3 < n5; ++n3) {
                piVector2.m_data[n4 - 1 + n3] = piVector.m_data[n3];
            }
            piVector.setSize(piVector2.getSize());
            piVector.copy(piVector2);
        }
        return true;
    }

    private static PiVector computeTriangleRunEuclideanDijkstra(PgElementSet pgElementSet, int n, PdBary pdBary, int n2, PdBary pdBary2, PiVector piVector, PiVector[] piVectorArray) {
        int n3;
        int n4;
        PiVector[] piVectorArray2;
        int n5 = pgElementSet.getDimOfVertices();
        int n6 = pgElementSet.getNumVertices();
        int n7 = pgElementSet.getNumElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray3 = pgElementSet.getElements();
        if (piVectorArray == null || piVectorArray.length != n6) {
            piVectorArray2 = PiVector.realloc(null, (int)n6);
        } else {
            piVectorArray2 = piVectorArray;
            for (int i = 0; i < n6; ++i) {
                if (piVectorArray2[i] == null) {
                    piVectorArray2[i] = new PiVector(0);
                    continue;
                }
                piVectorArray2[i].setSize(0);
            }
        }
        PuPriorityQueue puPriorityQueue = new PuPriorityQueue(n6, Double.MAX_VALUE);
        double[] dArray = new double[n6];
        System.arraycopy(puPriorityQueue.getKeys(), 0, dArray, 0, n6);
        PdVector pdVector = new PdVector(n5);
        pdBary.getVertex(pdVector, pdVectorArray[piVectorArray3[n].m_data[0]], pdVectorArray[piVectorArray3[n].m_data[1]], pdVectorArray[piVectorArray3[n].m_data[2]]);
        PdVector pdVector2 = new PdVector(n5);
        pdBary2.getVertex(pdVector2, pdVectorArray[piVectorArray3[n2].m_data[0]], pdVectorArray[piVectorArray3[n2].m_data[1]], pdVectorArray[piVectorArray3[n2].m_data[2]]);
        for (n4 = 0; n4 < 3; ++n4) {
            int n8 = piVectorArray3[n].m_data[n4];
            dArray[n8] = PdVector.dist((PdVector)pdVector, (PdVector)pdVectorArray[n8]);
            puPriorityQueue.decreaseKey(n8, PdVector.dist((PdVector)pdVector, (PdVector)pdVectorArray[n8]) + PdVector.dist((PdVector)pdVector2, (PdVector)pdVectorArray[n8]));
            piVectorArray2[n8].addEntry(n8);
        }
        int[] nArray = new int[n6];
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < piVectorArray3[i].m_data.length; ++j) {
                nArray[piVectorArray3[i].m_data[j]] = i;
            }
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        int n9 = 0;
        block4: while ((n4 = puPriorityQueue.extractMin()) >= 0 && n9 < 7) {
            pgVertexStar.makeVertexStar(pgElementSet, n4, nArray[n4]);
            PiVector piVector2 = pgVertexStar.getLink();
            for (n3 = 0; n3 < piVector2.m_data.length; ++n3) {
                int n10 = piVector2.m_data[n3];
                double d = PdVector.dist((PdVector)pdVectorArray[n4], (PdVector)pdVectorArray[n10]);
                if (!(dArray[n10] > dArray[n4] + d)) continue;
                dArray[n10] = dArray[n4] + d;
                if (puPriorityQueue.isElement(n10)) {
                    puPriorityQueue.decreaseKey(n10, dArray[n4] + d + PdVector.dist((PdVector)pdVectorArray[n10], (PdVector)pdVector2));
                } else {
                    puPriorityQueue.enqueue(n10, dArray[n4] + d + PdVector.dist((PdVector)pdVectorArray[n10], (PdVector)pdVector2));
                }
                int n11 = piVectorArray2[n4].getSize() + 1;
                piVectorArray2[n10].setSize(n11);
                piVectorArray2[n10].copyArray(piVectorArray2[n4]);
                piVectorArray2[n10].m_data[n11 - 1] = n10;
            }
            for (n3 = 0; n3 < 3; ++n3) {
                if (n4 != piVectorArray3[n2].m_data[n3]) continue;
                n9 |= 1 << n3;
                continue block4;
            }
        }
        n3 = -1;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            int n12 = piVectorArray3[n2].m_data[i];
            double d2 = PdVector.dist((PdVector)pdVector2, (PdVector)pdVectorArray[n12]) + dArray[n12];
            if (!(d2 < d)) continue;
            n3 = n12;
            d = d2;
        }
        PiVector piVector3 = piVectorArray2[n3];
        int n13 = piVector3.getSize();
        int n14 = n13 * 4;
        if (piVector == null) {
            piVector = new PiVector(0);
        }
        piVector.setSize(n14);
        int n15 = 0;
        int n16 = n;
        for (int i = 0; i < n13; ++i) {
            int n17;
            int n18;
            int n19 = piVector3.m_data[i];
            int n20 = i < n13 - 1 ? piVector3.m_data[i + 1] : -1;
            pgVertexStar.makeVertexStar(pgElementSet, n19, n16);
            PiVector piVector4 = pgVertexStar.getElement();
            PiVector piVector5 = pgVertexStar.getLink();
            int n21 = pgVertexStar.getSize();
            if (pgVertexStar.isClosed()) {
                if (n20 != -1 && piVector5.m_data[0] == n20) continue;
                for (n18 = 0; n18 < n21 - 1 && piVector4.m_data[n18] != n2 && (n20 == -1 || piVector5.m_data[n18 + 1] != n20); ++n18) {
                    if (++n15 > n14) {
                        piVector.setSize(n14 += n13 * 2);
                    }
                    piVector.m_data[n15 - 1] = piVector4.m_data[n18];
                }
                if (n20 != -1) {
                    n16 = piVector4.m_data[n18];
                }
                if (piVector4.m_data[n18] != n2) continue;
                break;
            }
            n18 = piVector4.getIndexOf(n16);
            if (n18 < 0) {
                PsDebug.error((String)"geometry has non-manifold vertices");
                return null;
            }
            int n22 = n18;
            if (n20 != -1) {
                n17 = piVector5.getIndexOf(n20);
                if (n17 < 0) {
                    PsDebug.error((String)"geometry has non-manifold vertices");
                    return null;
                }
                if (n17 > n18 + 1) {
                    for (n22 = n18; n22 < n17 - 1 && piVector4.m_data[n22] != n2; ++n22) {
                        if (++n15 > n14) {
                            piVector.setSize(n14 += n13 * 2);
                        }
                        piVector.m_data[n15 - 1] = piVector4.m_data[n22];
                    }
                } else if (n17 < n18) {
                    for (n22 = n18; n22 > n17 && piVector4.m_data[n22] != n2; --n22) {
                        if (++n15 > n14) {
                            piVector.setSize(n14 += n13 * 2);
                        }
                        piVector.m_data[n15 - 1] = piVector4.m_data[n22];
                    }
                }
                n16 = piVector4.m_data[n22];
            } else {
                n17 = piVector4.getIndexOf(n2);
                if (n17 > n18) {
                    for (n22 = n18; n22 < n17; ++n22) {
                        if (++n15 > n14) {
                            piVector.setSize(n14 += n13 * 2);
                        }
                        piVector.m_data[n15 - 1] = piVector4.m_data[n22];
                    }
                } else if (n17 < n18) {
                    for (n22 = n18; n22 > n17; --n22) {
                        if (++n15 > n14) {
                            piVector.setSize(n14 += n13 * 2);
                        }
                        piVector.m_data[n15 - 1] = piVector4.m_data[n22];
                    }
                }
            }
            if (piVector4.m_data[n22] == n2) break;
        }
        piVector.setSize(++n15);
        piVector.m_data[n15 - 1] = n2;
        return piVector;
    }

    private static PiVector[] computeTriangleRunGeodesicDistance(PgElementSet pgElementSet, int n, PdBary pdBary, PiVector[] piVectorArray, int[] nArray) {
        int n2;
        int n3 = pgElementSet.getDimOfVertices();
        int n4 = pgElementSet.getNumElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        if (nArray == null || nArray.length < n4) {
            nArray = new int[n4];
        }
        if (piVectorArray == null || piVectorArray.length != n4) {
            piVectorArray = PiVector.realloc(null, (int)n4);
        } else {
            for (int i = 0; i < n4; ++i) {
                if (piVectorArray[i] == null) {
                    piVectorArray[i] = new PiVector(0);
                    continue;
                }
                piVectorArray[i].setSize(0);
            }
        }
        PuPriorityQueue puPriorityQueue = new PuPriorityQueue(n4, Double.MAX_VALUE);
        double[] dArray = puPriorityQueue.getKeys();
        PiVector piVector = new PiVector(0);
        PgPolygonOnElementSet pgPolygonOnElementSet = null;
        PgPolygon pgPolygon = new PgPolygon(n3);
        puPriorityQueue.decreaseKey(n, 0.0);
        piVectorArray[n].addEntry(n);
        while ((n2 = puPriorityQueue.extractMin()) >= 0) {
            int n5 = piVectorArray[n2].getSize();
            int n6 = piVectorArray2[n2].getSize();
            for (int i = 0; i < n6; ++i) {
                int n7 = piVectorArray2[n2].m_data[i];
                if (n7 < 0) continue;
                piVector.setSize(n5 + 1);
                piVector.copy(piVectorArray[n2]);
                piVector.m_data[n5] = n7;
                pgPolygonOnElementSet = PwGeodesic.getShortest(pgElementSet, pdBary, n, PdBary.TRIANGLE_CENTER, n7, piVector, pgPolygonOnElementSet);
                if (pgPolygonOnElementSet == null) {
                    PsDebug.warning((String)"could not find geodesic");
                    continue;
                }
                pgPolygonOnElementSet.getPolygon(pgPolygon);
                double d = pgPolygon.getLength();
                if (!(d < dArray[n7])) continue;
                if (puPriorityQueue.isElement(n7)) {
                    puPriorityQueue.decreaseKey(n7, d);
                } else {
                    puPriorityQueue.enqueue(n7, d);
                }
                piVectorArray[n7].setSize(piVector.getSize());
                piVectorArray[n7].copy(piVector);
            }
        }
        return piVectorArray;
    }

    public static boolean isConnected(PiVector[] piVectorArray, PiVector piVector) {
        int n = piVector.getSize();
        for (int i = 0; i < n - 1; ++i) {
            int n2;
            int n3 = piVectorArray[piVector.m_data[i]].getSize();
            for (n2 = 0; n2 < n3 && piVectorArray[piVector.m_data[i]].m_data[n2] != piVector.m_data[i + 1]; ++n2) {
            }
            if (n2 < n3) continue;
            return false;
        }
        return true;
    }

    protected static double unfoldOntoElement(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5, PdVector pdVector6, PdVector pdVector7, PdVector pdVector8, PdVector pdVector9, PdVector pdVector10, PdVector pdVector11, PdVector pdVector12, PdVector pdVector13) {
        int n = pdVector2.getSize();
        int n2 = pdVector5.getSize();
        if (pdVector10 == null) {
            pdVector10 = new PdVector(n);
        }
        if (pdVector11 == null) {
            pdVector11 = new PdVector(n);
        }
        if (pdVector12 == null) {
            pdVector12 = new PdVector(n2);
        }
        if (pdVector13 == null) {
            pdVector13 = new PdVector(n2);
        }
        pdVector.setSize(n);
        pdVector12.sub(pdVector6, pdVector5);
        pdVector12.normalize();
        pdVector13.sub(pdVector9, pdVector5);
        double d = PdVector.dot((PdVector)pdVector12, (PdVector)pdVector13);
        pdVector12.multScalar(d);
        pdVector12.add(pdVector5);
        double d2 = PdVector.dist((PdVector)pdVector9, (PdVector)pdVector12);
        pdVector10.sub(pdVector2, pdVector3);
        pdVector10.normalize();
        pdVector11.copy(pdVector10);
        pdVector.sub(pdVector3, pdVector4);
        pdVector10.multScalar(PdVector.dot((PdVector)pdVector10, (PdVector)pdVector));
        pdVector.sub(pdVector10);
        pdVector.normalize();
        pdVector.multScalar(d2);
        pdVector11.multScalar(d);
        pdVector11.add(pdVector3);
        pdVector.add(pdVector11);
        if (pdVector8 != null) {
            return PdVector.dist((PdVector)pdVector, (PdVector)pdVector8);
        }
        return d2;
    }

    public static int[] getConnectingStrip(PgElementSet pgElementSet, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = pgElementSet.getNumElements();
        if (n < 0 || n >= n6 || n2 < 0 || n2 >= n6) {
            PsDebug.warning((String)("Wrong start=" + n + " or end=" + n2 + " element."));
            return null;
        }
        int[] nArray = new int[n6];
        int n7 = 0;
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n6];
        nArray[0] = n;
        nArray2[n] = 1;
        ++n7;
        boolean bl = n == n2;
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        block0: for (int i = 0; !bl && i < n7; ++i) {
            n5 = nArray[i];
            int n8 = nArray2[n5];
            PiVector piVector = piVectorArray[n5];
            n4 = piVector.getSize();
            for (n3 = 0; n3 < n4; ++n3) {
                int n9 = piVector.getEntry(n3);
                if (n9 < 0 || nArray2[n9] != 0) continue;
                nArray2[n9] = n8 + 1;
                nArray[n7] = n9;
                nArray3[n9] = n5;
                ++n7;
                if (n9 != n2) continue;
                bl = true;
                continue block0;
            }
        }
        if (!bl) {
            return null;
        }
        n5 = nArray2[n2];
        int[] nArray4 = new int[n5];
        n4 = n2;
        for (n3 = n5 - 1; n3 >= 0; --n3) {
            nArray4[n3] = n4;
            if (n4 == n) continue;
            n4 = nArray3[n4];
        }
        if (nArray4[0] != n) {
            PsDebug.warning((String)"Broken neighbourhood information!");
            return null;
        }
        return nArray4;
    }

    public static PgPolygon[] getShortestInStrip(PgElementSet pgElementSet, PdBary pdBary, PdBary pdBary2, int[] nArray, PiVector piVector, PiVector piVector2, PdBaryDir pdBaryDir) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (pgElementSet == null || pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry not triangulated.");
            return null;
        }
        if (nArray == null || nArray.length == 0) {
            PsDebug.warning((String)"Not a valid strip.");
            return null;
        }
        if (piVector != null) {
            piVector.setSize(0);
        }
        if (piVector2 != null) {
            piVector2.setSize(0);
        }
        if ((n8 = nArray.length) == 1) {
            double d;
            if (pdBaryDir != null) {
                pdBaryDir.sub(pdBary2, pdBary);
            }
            if ((d = PwBary.norm(pgElementSet, nArray[0], pdBaryDir, true)) > 1.0E-10) {
                pdBaryDir.multScalar(1.0 / d);
            }
            PgPolygon[] pgPolygonArray = new PgPolygon[]{null, null, new PgPolygon(2)};
            pgPolygonArray[2].setNumVertices(2);
            pgPolygonArray[2].setVertex(0, 0.0, 0.0);
            pgPolygonArray[2].setVertex(1, d, 0.0);
            return null;
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector piVector3 = pgElementSet.getNeighbour(nArray[0]);
        int n9 = -1;
        for (int i = 0; i < 3; ++i) {
            if (piVector3.getEntry(i) != nArray[1]) continue;
            n9 = i;
        }
        if (n9 == -1) {
            PsDebug.warning((String)"Not a valid strip (not connected).");
            return null;
        }
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        PdBaryDir pdBaryDir3 = new PdBaryDir(3);
        PdBary pdBary3 = new PdBary(3);
        PdBary pdBary4 = new PdBary(3);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)2, (int)(3 * n8));
        PdVector[] pdVectorArray2 = PdVector.realloc(null, (int)2, (int)(3 * n8));
        PiVector[] piVectorArray2 = PiVector.realloc(null, (int)2, (int)(3 * n8));
        int n10 = 0;
        for (int i = 0; i < 2; ++i) {
            PdVector pdVector;
            n7 = 2;
            n6 = 1;
            if (i == 1) {
                n7 = 1;
                n6 = 2;
            }
            pdBary3.m_data[(n9 + n7) % 3] = 1.0;
            pdBary3.m_data[n9] = 0.0;
            pdBary3.m_data[(n9 + n6) % 3] = 0.0;
            pdBaryDir2.sub(pdBary, pdBary3);
            pdBary4.m_data[(n9 + n7) % 3] = 0.0;
            pdBary4.m_data[n9] = 0.0;
            pdBary4.m_data[(n9 + n6) % 3] = 1.0;
            pdBaryDir3.sub(pdBary4, pdBary3);
            double d = Math.abs(PwBary.getOrientedAngle(pgElementSet, nArray[0], pdBaryDir2, pdBaryDir3, false));
            double d2 = PwBary.norm(pgElementSet, nArray[0], pdBaryDir2, false);
            double d3 = 0.0;
            if (i == 1) {
                pdBaryDir2.multScalar(-1.0);
                pdBaryDir3.sub(pdBary4, pdBary);
                d3 = -Math.abs(PwBary.getOrientedAngle(pgElementSet, nArray[0], pdBaryDir3, pdBaryDir2, false));
                pdVector = new PdVector(d2 * Math.cos(d3), d2 * Math.sin(d3));
            } else {
                pdVector = new PdVector(d2, 0.0);
            }
            PdVector pdVector2 = new PdVector(2);
            pdVector2.copy(pdVector);
            pdVector2.multScalar(-1.0);
            n5 = (n9 + n7) % 3;
            n4 = piVectorArray[nArray[0]].getEntry(n5);
            pdVectorArray[i].setEntry(0, 0.0);
            pdVectorArray2[i].setEntry(0, 0.0);
            piVectorArray2[i].setEntry(0, -1);
            pdVectorArray[i].setEntry(1, pdVector.getEntry(0));
            pdVectorArray2[i].setEntry(1, pdVector.getEntry(1));
            piVectorArray2[i].setEntry(1, n4);
            n10 = 2;
            n3 = 0;
            while (n3 + 1 < n8) {
                n2 = 1;
                n = n3;
                while (n2 != 0) {
                    if (++n3 >= n8) {
                        n2 = 0;
                        break;
                    }
                    n2 = 0;
                    for (int j = 0; j < 3 && n2 == 0; ++j) {
                        if (piVectorArray[nArray[n3]].getEntry(j) != n4) continue;
                        n2 = 1;
                        n5 = j;
                    }
                    if (n2 == 0) continue;
                    pdBaryDir2.m_data[n5] = -1.0;
                    pdBaryDir2.m_data[(n5 + n7) % 3] = 0.0;
                    pdBaryDir2.m_data[(n5 + n6) % 3] = 1.0;
                    if (n3 != n8 - 1) {
                        pdBaryDir3.m_data[n5] = -1.0;
                        pdBaryDir3.m_data[(n5 + n7) % 3] = 1.0;
                        pdBaryDir3.m_data[(n5 + n6) % 3] = 0.0;
                    } else {
                        pdBary3.m_data[n5] = 1.0;
                        pdBary3.m_data[(n5 + n7) % 3] = 0.0;
                        pdBary3.m_data[(n5 + n6) % 3] = 0.0;
                        pdBaryDir3.sub(pdBary2, pdBary3);
                    }
                    d += Math.abs(PwBary.getOrientedAngle(pgElementSet, nArray[n3], pdBaryDir2, pdBaryDir3, false));
                    d2 = PwBary.norm(pgElementSet, nArray[n3], pdBaryDir3, false);
                }
                if (--n3 == n) {
                    PsDebug.error((String)"Not a valid strip (not connected).");
                    return null;
                }
                if (i == 1) {
                    d *= -1.0;
                }
                pdVector2.normalize();
                double d4 = pdVector2.getEntry(0);
                double d5 = pdVector2.getEntry(1);
                pdVector2.setEntry(0, Math.cos(d) * d4 - Math.sin(d) * d5);
                pdVector2.setEntry(1, Math.sin(d) * d4 + Math.cos(d) * d5);
                pdVector2.multScalar(d2);
                pdVector.add(pdVector2);
                pdVector2.multScalar(-1.0);
                pdVectorArray[i].setEntry(n10, pdVector.getEntry(0));
                pdVectorArray2[i].setEntry(n10, pdVector.getEntry(1));
                n5 = (n5 + n7) % 3;
                n4 = piVectorArray[nArray[n3]].getEntry(n5);
                piVectorArray2[i].setEntry(n10, n4);
                ++n10;
                pdBaryDir2.m_data[n5] = -1.0;
                pdBaryDir2.m_data[(n5 + n7) % 3] = 0.0;
                pdBaryDir2.m_data[(n5 + n6) % 3] = 1.0;
                pdBaryDir3.m_data[n5] = -1.0;
                pdBaryDir3.m_data[(n5 + n7) % 3] = 1.0;
                pdBaryDir3.m_data[(n5 + n6) % 3] = 0.0;
                d = Math.abs(PwBary.getOrientedAngle(pgElementSet, nArray[n3], pdBaryDir2, pdBaryDir3, false));
            }
            pdVectorArray[i].setSize(n10);
            pdVectorArray2[i].setSize(n10);
            piVectorArray2[i].setEntry(n10 - 1, -1);
            piVectorArray2[i].setSize(n10);
        }
        PgPolygon[] pgPolygonArray = new PgPolygon[3];
        for (n7 = 0; n7 < 2; ++n7) {
            pgPolygonArray[n7] = new PgPolygon(2);
            n6 = piVectorArray2[n7].getSize();
            pgPolygonArray[n7].setNumVertices(n6);
            for (int i = 0; i < n6; ++i) {
                PdVector pdVector = new PdVector(pdVectorArray[n7].getEntry(i), pdVectorArray2[n7].getEntry(i));
                pgPolygonArray[n7].setVertex(i, pdVector);
            }
        }
        n7 = 1;
        n6 = 0;
        boolean bl = false;
        pgPolygonArray[2] = new PgPolygon(2);
        pgPolygonArray[2].setDimOfVectors(2);
        pgPolygonArray[2].setNumVertices(1);
        pgPolygonArray[2].setVertex(0, new PdVector(pdVectorArray[0].getEntry(0), pdVectorArray2[0].getEntry(0)));
        do {
            int n11;
            int n12;
            int n13;
            ++n7;
            int n14 = PwGeodesic.nextVertexOfShortestInStrip(pdVectorArray[0], pdVectorArray2[0], pdVectorArray[1], pdVectorArray2[1]);
            int n15 = 0;
            boolean bl2 = false;
            if (n14 < 0) {
                n15 = 1;
                if ((n14 *= -1) == pdVectorArray[1].getSize() - 1) {
                    bl = true;
                } else if (n14 == pdVectorArray[1].getSize() - 2) {
                    bl = true;
                    bl2 = true;
                }
            } else if (n14 == pdVectorArray[0].getSize() - 1) {
                bl = true;
            } else if (n14 == pdVectorArray[0].getSize() - 2) {
                bl = true;
                bl2 = true;
            }
            pgPolygonArray[2].setNumVertices(n7);
            pgPolygonArray[2].setVertex(n7 - 1, new PdVector(pdVectorArray[n15].getEntry(n14), pdVectorArray2[n15].getEntry(n14)));
            if (bl2) {
                pgPolygonArray[2].setNumVertices(++n7);
                pgPolygonArray[2].setVertex(n7 - 1, new PdVector(pdVectorArray[0].getEntry(pdVectorArray[0].getSize() - 1), pdVectorArray2[0].getEntry(pdVectorArray2[0].getSize() - 1)));
            }
            int n16 = piVectorArray2[n15].getEntry(n14);
            if (bl2 || !bl) {
                ++n6;
                if (piVector2 != null) {
                    piVector2.setSize(n6);
                    piVector2.setEntry(n6 - 1, n16);
                }
                if (piVector != null) {
                    piVector.setSize(n6);
                    piVector.setEntry(n6 - 1, n15);
                }
            }
            if (bl) continue;
            int n17 = 0;
            int n18 = (n15 + 1) % 2;
            if (n15 == 0) {
                n13 = 2;
                n5 = 1;
            } else {
                n13 = 1;
                n5 = 2;
            }
            n4 = piVectorArray2[n15].getEntry(n14 + 1);
            n3 = -1;
            n2 = 0;
            for (n = 0; n < n8; ++n) {
                for (n2 = 0; n2 < 3 && piVectorArray[nArray[n]].getEntry(n2) != n16; ++n2) {
                }
                if (n2 >= 3 || piVectorArray[nArray[n]].getEntry((n2 + n13) % 3) != n4) continue;
                n3 = n;
                break;
            }
            n = piVectorArray[nArray[n3]].getEntry((n2 + n5) % 3);
            int n19 = 0;
            do {
                ++n19;
                for (n12 = 0; n12 < 3 && piVectorArray[nArray[n3 + n19]].getEntry(n12) != n; ++n12) {
                }
                if (n12 >= 3) continue;
                n2 = n12;
            } while (n12 < 3 && n3 + n19 < n8 - 1);
            if (n12 >= 3) {
                --n19;
            }
            int n20 = piVectorArray[nArray[n3 + n19]].getEntry((n2 + n5) % 3);
            if (n3 + n19 == n8 - 1) {
                n17 = pdVectorArray[n18].getSize() - 2;
            } else {
                while (n17 < pdVectorArray[n18].getSize() - 1 && (piVectorArray2[n18].getEntry(n17) != n || piVectorArray2[n18].getEntry(n17 + 1) != n20)) {
                    ++n17;
                }
            }
            for (n11 = n14; n11 < pdVectorArray[n15].getSize(); ++n11) {
                pdVectorArray[n15].setEntry(n11 - n14, pdVectorArray[n15].getEntry(n11));
                pdVectorArray2[n15].setEntry(n11 - n14, pdVectorArray2[n15].getEntry(n11));
                piVectorArray2[n15].setEntry(n11 - n14, piVectorArray2[n15].getEntry(n11));
            }
            pdVectorArray[n15].setSize(pdVectorArray[n15].getSize() - n14);
            pdVectorArray2[n15].setSize(pdVectorArray2[n15].getSize() - n14);
            piVectorArray2[n15].setSize(piVectorArray2[n15].getSize() - n14);
            pdVectorArray[n18].setEntry(0, pdVectorArray[n15].getEntry(0));
            pdVectorArray2[n18].setEntry(0, pdVectorArray2[n15].getEntry(0));
            piVectorArray2[n18].setEntry(0, piVectorArray2[n15].getEntry(0));
            for (n11 = n17; n11 < pdVectorArray[n18].getSize(); ++n11) {
                pdVectorArray[n18].setEntry(n11 - n17 + 1, pdVectorArray[n18].getEntry(n11));
                pdVectorArray2[n18].setEntry(n11 - n17 + 1, pdVectorArray2[n18].getEntry(n11));
                piVectorArray2[n18].setEntry(n11 - n17 + 1, piVectorArray2[n18].getEntry(n11));
            }
            pdVectorArray[n18].setSize(pdVectorArray[n18].getSize() - n17 + 1);
            pdVectorArray2[n18].setSize(pdVectorArray2[n18].getSize() - n17 + 1);
            piVectorArray2[n18].setSize(piVectorArray2[n18].getSize() - n17 + 1);
        } while (!bl);
        if (pdBaryDir != null) {
            double d = -PdVector.angle((PdVector)new PdVector(1.0, 0.0), (PdVector)pgPolygonArray[2].getVertex(1)) / 180.0 * Math.PI;
            pdBary3.m_data[(n9 + 2) % 3] = 1.0;
            pdBary3.m_data[n9] = 0.0;
            pdBary3.m_data[(n9 + 1) % 3] = 0.0;
            pdBaryDir2.sub(pdBary3, pdBary);
            PwBary.rotateInElement(pgElementSet, nArray[0], pdBaryDir2, d, pdBaryDir, false);
            double d6 = PwBary.norm(pgElementSet, nArray[0], pdBaryDir, false);
            if (d6 > 1.0E-10) {
                pdBaryDir.multScalar(1.0 / d6);
            }
        }
        return pgPolygonArray;
    }

    private static int nextVertexOfShortestInStrip(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        int n;
        int n2;
        PdVector pdVector5 = new PdVector(2);
        pdVector5.set(pdVector.getEntry(1) - pdVector.getEntry(0), pdVector2.getEntry(1) - pdVector2.getEntry(0));
        pdVector5.normalize();
        PdVector[] pdVectorArray = new PdVector[2];
        PdVector[] pdVectorArray2 = new PdVector[2];
        pdVectorArray[0] = pdVector;
        pdVectorArray[1] = pdVector3;
        pdVectorArray2[0] = pdVector2;
        pdVectorArray2[1] = pdVector4;
        int[] nArray = new int[]{pdVector.getSize(), pdVector3.getSize()};
        PdVector[] pdVectorArray3 = new PdVector[2];
        PdVector[] pdVectorArray4 = new PdVector[2];
        PdVector pdVector6 = new PdVector(2);
        PdVector pdVector7 = new PdVector(2);
        for (n2 = 0; n2 < 2; ++n2) {
            pdVectorArray3[n2] = new PdVector(nArray[n2]);
            pdVectorArray4[n2] = new PdVector(nArray[n2]);
            for (n = 1; n < nArray[n2]; ++n) {
                pdVector6.set(pdVectorArray[n2].getEntry(n) - pdVectorArray[n2].getEntry(0), pdVectorArray2[n2].getEntry(n) - pdVectorArray2[n2].getEntry(0));
                double d = pdVector6.length();
                pdVectorArray4[n2].setEntry(n, d);
                if (d == 0.0) {
                    pdVectorArray3[n2].setEntry(n, 0.0);
                    continue;
                }
                double d2 = PdVector.dot((PdVector)pdVector6, (PdVector)pdVector5);
                if ((d2 /= d) < -1.0) {
                    d2 = -1.0;
                } else if (d2 > 1.0) {
                    d2 = 1.0;
                }
                d2 = Math.acos(d2);
                if (pdVector5.getEntry(0) * pdVector6.getEntry(1) - pdVector5.getEntry(1) * pdVector6.getEntry(0) < 0.0) {
                    d2 *= -1.0;
                }
                if (n > 1) {
                    boolean bl = false;
                    boolean bl2 = false;
                    pdVector6.set(pdVectorArray[n2].getEntry(n - 1) - pdVectorArray[n2].getEntry(0), pdVectorArray2[n2].getEntry(n - 1) - pdVectorArray2[n2].getEntry(0));
                    double d3 = -pdVector6.getEntry(1);
                    double d4 = pdVector6.getEntry(0);
                    pdVector7.set(pdVectorArray[n2].getEntry(n) - pdVectorArray[n2].getEntry(n - 1), pdVectorArray2[n2].getEntry(n) - pdVectorArray2[n2].getEntry(n - 1));
                    double d5 = pdVector7.getEntry(0) * d3 + pdVector7.getEntry(1) * d4;
                    if (d5 < -1.0E-10) {
                        bl = true;
                    } else if (d5 > 1.0E-10) {
                        bl2 = true;
                    }
                    double d6 = pdVectorArray3[n2].getEntry(n - 1);
                    if (bl) {
                        while (d2 > d6 + 1.0E-10) {
                            d2 -= Math.PI * 2;
                        }
                        while (d2 + Math.PI * 2 < d6 + 1.0E-10) {
                            d2 += Math.PI * 2;
                        }
                    } else if (bl2) {
                        while (d2 < d6 - 1.0E-10) {
                            d2 += Math.PI * 2;
                        }
                        while (d2 - Math.PI * 2 > d6 - 1.0E-10) {
                            d2 -= Math.PI * 2;
                        }
                    } else {
                        while (Math.abs(d2 - Math.PI * 2 - d6) < Math.abs(d2 - d6)) {
                            d2 -= Math.PI * 2;
                        }
                        while (Math.abs(d2 + Math.PI * 2 - d6) < Math.abs(d2 - d6)) {
                            d2 += Math.PI * 2;
                        }
                    }
                }
                pdVectorArray3[n2].setEntry(n, d2);
            }
        }
        n2 = 1;
        n = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = 1;
        int n6 = 0;
        while (n == 0) {
            if (n6 > 5) {
                PsDebug.error((String)"Caught in loop.");
                break;
            }
            do {
                if (n2 == nArray[n3] - 1) {
                    n = 1;
                    continue;
                }
                if ((double)n5 * pdVectorArray3[n3].getEntry(n2) > (double)n5 * pdVectorArray3[n3].getEntry(n2 + 1)) {
                    ++n2;
                    continue;
                }
                n = 1;
            } while (n == 0);
            double d = pdVectorArray3[n3].getEntry(n2);
            int n7 = -1;
            int n8 = n2 + 1;
            n = 0;
            while (n8 < nArray[n3] && n == 0) {
                if ((double)n5 * pdVectorArray3[n3].getEntry(n8) < (double)n5 * d) {
                    n = 1;
                    continue;
                }
                ++n8;
            }
            if (n != 0) {
                n7 = n8;
            }
            int n9 = -1;
            n8 = 1;
            n = 0;
            do {
                if ((double)n5 * pdVectorArray3[n4].getEntry(n8) > (double)n5 * d) {
                    n = 1;
                    continue;
                }
                ++n8;
            } while (n8 < nArray[n4] && n == 0);
            if (n != 0) {
                n9 = n8;
            }
            n = 0;
            double d7 = pdVectorArray4[n3].getEntry(n2);
            double d8 = pdVectorArray3[n3].getEntry(n2);
            double d9 = 0.0;
            if (n7 > 0) {
                d9 = (pdVectorArray3[n3].getEntry(n2) - pdVectorArray3[n3].getEntry(n7 - 1)) / (pdVectorArray3[n3].getEntry(n7) - pdVectorArray3[n3].getEntry(n7 - 1)) * (pdVectorArray4[n3].getEntry(n7) - pdVectorArray4[n3].getEntry(n7 - 1)) + pdVectorArray4[n3].getEntry(n7 - 1);
            }
            double d10 = 0.0;
            if (n9 > 0) {
                d10 = (pdVectorArray3[n3].getEntry(n2) - pdVectorArray3[n4].getEntry(n9 - 1)) / (pdVectorArray3[n4].getEntry(n9) - pdVectorArray3[n4].getEntry(n9 - 1)) * (pdVectorArray4[n4].getEntry(n9) - pdVectorArray4[n4].getEntry(n9 - 1)) + pdVectorArray4[n4].getEntry(n9 - 1);
            }
            if (n7 < 0 && n9 < 0 || n9 == nArray[n4] - 1 && n2 == nArray[n3] - 1) {
                n2 *= n5;
                n = 1;
                continue;
            }
            if (n7 >= 0 && (n9 < 0 || d9 < d10)) {
                n2 = n7;
                continue;
            }
            if (n9 >= 0 && (d7 > d10 || (double)n5 * d8 < (double)n5 * pdVectorArray3[n4].getEntry(1))) {
                n3 = (n3 + 1) % 2;
                n4 = (n4 + 1) % 2;
                n5 *= -1;
                n2 = 1;
                ++n6;
                continue;
            }
            n2 *= n5;
            n = 1;
        }
        return n2;
    }

    public static PgPolygonOnElementSet getShortest(PgElementSet pgElementSet, PdBary pdBary, int n, PdBary pdBary2, int n2) {
        return PwGeodesic.getShortest(pgElementSet, pdBary, n, pdBary2, n2, null, null);
    }

    public static PgPolygonOnElementSet getShortest(PgElementSet pgElementSet, PdBary pdBary, int n, PdBary pdBary2, int n2, PiVector piVector, PgPolygonOnElementSet pgPolygonOnElementSet) {
        return PwGeodesic.getShortest(pgElementSet, pdBary, n, pdBary2, n2, piVector, pgPolygonOnElementSet, null, null, null, null, null, null, null, null);
    }

    public static PgPolygonOnElementSet getShortest(PgElementSet pgElementSet, PdBary pdBary, int n, PdBary pdBary2, int n2, PiVector piVector, PgPolygonOnElementSet pgPolygonOnElementSet, PgElementSet pgElementSet2, PiVector piVector2, PiVector piVector3, PiVector piVector4, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdBary pdBary3) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl;
        int n9;
        int n10;
        int n11;
        int n12;
        Object[] objectArray;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"No valid geometry.");
            return null;
        }
        if (pdBary == null || pdBary2 == null) {
            PsDebug.warning((String)"missing PdBary argument.");
            return null;
        }
        int n13 = pgElementSet.getNumElements();
        int n14 = pgElementSet.getNumVertices();
        if (n2 >= n13 || n >= n13 || n < 0 || n2 < 0) {
            PsDebug.warning((String)("No valid start and/or end element,start=" + n + ",end=" + n2 + "."));
            return null;
        }
        if (piVector == null || piVector.getSize() == 0 || piVector.m_data[0] != n || piVector.m_data[piVector.getSize() - 1] != n2) {
            objectArray = PwGeodesic.getConnectingStrip(pgElementSet, n, n2);
            if (objectArray == null || objectArray.length == 0) {
                PsDebug.error((String)"Could not find a way at all.");
                return null;
            }
            piVector = new PiVector(objectArray);
        }
        objectArray = pgElementSet.getElements();
        int n15 = piVector.getSize();
        if (n15 == 1) {
            if (pgPolygonOnElementSet == null) {
                pgPolygonOnElementSet = new PgPolygonOnElementSet(pgElementSet);
            }
            pgPolygonOnElementSet.setNumVertices(2);
            pgPolygonOnElementSet.setVertexBary(0, n, pdBary);
            pgPolygonOnElementSet.setVertexBary(1, n2, pdBary2);
            return pgPolygonOnElementSet;
        }
        boolean bl2 = false;
        int n16 = 0;
        int n17 = 5 * n14;
        if (pgElementSet2 == null) {
            pgElementSet2 = new PgElementSet(2);
        }
        pgElementSet2.setDimOfVertices(2);
        if (piVector3 == null) {
            piVector3 = new PiVector();
        }
        if (piVector4 == null) {
            piVector4 = new PiVector();
        }
        if (pdVector == null) {
            pdVector = new PdVector(2);
        }
        pdVector.setSize(2);
        if (pdVector2 == null) {
            pdVector2 = new PdVector(2);
        }
        pdVector2.setSize(2);
        if (pdVector3 == null) {
            pdVector3 = new PdVector(2);
        }
        pdVector3.setSize(2);
        if (pdBary3 == null) {
            pdBary3 = new PdBary(3);
        }
        pdBary3.setSize(3);
        int n18 = -1;
        PdVector[] pdVectorArray = null;
        PiVector[] piVectorArray = null;
        PdVector pdVector4 = new PdVector();
        PgVertexStar pgVertexStar = new PgVertexStar();
        PiVector piVector5 = new PiVector();
        while (!bl2) {
            n2 = PwGeodesic.findLastElementInStrip(pdBary2, n2, piVector, (PiVector[])objectArray);
            n = PwGeodesic.findFirstElementInStrip(pdBary, n, piVector, (PiVector[])objectArray);
            if (piVector.getSize() == 1) {
                if (pgPolygonOnElementSet == null) {
                    pgPolygonOnElementSet = new PgPolygonOnElementSet(pgElementSet);
                }
                pgPolygonOnElementSet.setNumVertices(2);
                pgPolygonOnElementSet.setVertexBary(0, n, pdBary);
                pgPolygonOnElementSet.setVertexBary(1, n2, pdBary2);
                return pgPolygonOnElementSet;
            }
            if (++n16 > n17) {
                PsDebug.error((String)"Caught in loop.");
            }
            if (n16 > n17 + 1) {
                return null;
            }
            if ((piVector = PwGeodesic.unfoldTriangleRun(pgElementSet, piVector, pgElementSet2, piVector3, piVector4)) == null) {
                return null;
            }
            pdVectorArray = pgElementSet2.getVertices();
            n18 = pgElementSet2.getNumElements();
            piVectorArray = pgElementSet2.getElements();
            pdBary.getVertex(pdVectorArray[piVector3.m_data[0]], pdVectorArray[piVectorArray[0].m_data[0]], pdVectorArray[piVectorArray[0].m_data[1]], pdVectorArray[piVectorArray[0].m_data[2]]);
            pdBary2.getVertex(pdVectorArray[piVector3.m_data[piVector3.getSize() - 1]], pdVectorArray[piVectorArray[n18 - 1].m_data[0]], pdVectorArray[piVectorArray[n18 - 1].m_data[1]], pdVectorArray[piVectorArray[n18 - 1].m_data[2]]);
            piVector2 = PwGeodesic.getShortestInUnfoldedTriangleRun(pgElementSet2, piVector3, piVector4, piVector2);
            n12 = piVector2.getSize() - 2;
            bl2 = true;
            n11 = 1;
            for (n10 = 0; n10 < n12 && bl2; ++n10) {
                int n19 = piVector2.m_data[n10] >= 0 ? piVector3.m_data[piVector2.m_data[n10]] : piVector4.m_data[-piVector2.m_data[n10]];
                n9 = piVector2.m_data[n11];
                if (n9 >= 0) {
                    bl = true;
                } else {
                    bl = false;
                    n9 = -n9;
                }
                int n20 = bl ? piVector3.m_data[n9] : piVector4.m_data[n9];
                int n21 = piVector2.m_data[n10 + 2] >= 0 ? piVector3.m_data[piVector2.m_data[n10 + 2]] : piVector4.m_data[-piVector2.m_data[n10 + 2]];
                n8 = n9;
                n7 = piVector.m_data[--n8];
                n6 = -1;
                for (n5 = 0; n5 < 3; ++n5) {
                    if (piVectorArray[n8].m_data[n5] != n20) continue;
                    n6 = n5;
                    break;
                }
                pgVertexStar.makeVertexStar(pgElementSet, objectArray[n7].m_data[n6], n7);
                if (pgVertexStar.isClosed()) {
                    int n22;
                    pdVector.sub(pdVectorArray[n19], pdVectorArray[n20]);
                    pdVector2.sub(pdVectorArray[n21], pdVectorArray[n20]);
                    double d = PdVector.angle((PdVector)pdVector, (PdVector)pdVector2) / 180.0 * Math.PI;
                    if (bl) {
                        if (pdVector.m_data[0] * pdVector2.m_data[1] - pdVector.m_data[1] * pdVector2.m_data[0] < 0.0) {
                            d = Math.PI * 2 - d;
                        }
                    } else if (pdVector2.m_data[0] * pdVector.m_data[1] - pdVector2.m_data[1] * pdVector.m_data[0] < 0.0) {
                        d = Math.PI * 2 - d;
                    }
                    double d2 = PwBary.getVertexAngles(pgVertexStar, pgElementSet, pdVector4);
                    d = d / d2 * 2.0 * Math.PI;
                    double d3 = d2 - Math.PI * 2;
                    if (bl) {
                        for (n22 = n8; n22 < n18 && piVector3.m_data[n22 + 1] == piVector3.m_data[n8 + 1]; ++n22) {
                        }
                    } else {
                        while (n22 < n18 && piVector4.m_data[n22 + 1] == piVector4.m_data[n8 + 1]) {
                            ++n22;
                        }
                    }
                    n4 = piVector.m_data[n22];
                    n3 = pgVertexStar.getSize();
                    double d4 = 1.0000000000000001E-7;
                    if (d3 < -d4 || d < (d2 - d3) / 2.0 - d4 || d > (d2 + d3) / 2.0 + d4 || n22 - n8 + 1 > n3) {
                        int n23;
                        bl2 = false;
                        int n24 = 0;
                        int[] nArray = null;
                        if (n22 - n8 + 1 <= n3) {
                            PiVector piVector6 = pgVertexStar.getElement();
                            nArray = new int[n3];
                            int n25 = 0;
                            do {
                                n25 = bl ? --n25 : ++n25;
                                if (n25 < 0) {
                                    n25 += n3;
                                } else if (n25 >= n3) {
                                    n25 -= n3;
                                }
                                nArray[n24] = piVector6.m_data[n25];
                                ++n24;
                            } while (piVector6.m_data[n25] != n4);
                            n23 = n18 - (n3 - --n24) + n24 + 2;
                        } else {
                            n23 = n18 - n3;
                        }
                        piVector5.setSize(n23);
                        System.arraycopy(piVector.m_data, 0, piVector5.m_data, 0, n8 + 1);
                        if (n22 - n8 + 1 <= n3) {
                            System.arraycopy(nArray, 0, piVector5.m_data, n8 + 1, n24);
                            System.arraycopy(piVector.m_data, n22, piVector5.m_data, n8 + n24 + 1, n18 - n22);
                        } else {
                            System.arraycopy(piVector.m_data, n8 + n3 + 1, piVector5.m_data, n8 + 1, n18 - n8 - 1 - n3);
                        }
                        piVector.setSize(n23);
                        piVector.copy(piVector5);
                    }
                }
                ++n11;
            }
        }
        if (pgPolygonOnElementSet == null) {
            pgPolygonOnElementSet = new PgPolygonOnElementSet(pgElementSet);
        } else {
            pgPolygonOnElementSet.setGeometry(pgElementSet);
        }
        pgPolygonOnElementSet.setNumVertices(n18 + 1);
        pgPolygonOnElementSet.setVertexBary(0, n, pdBary);
        n12 = 1;
        n11 = 1;
        n10 = piVector2.getSize();
        n8 = piVector3.m_data[0];
        n7 = -1;
        for (n4 = 1; n4 < n10; ++n4) {
            n9 = piVector2.m_data[n4];
            if (n9 < 0) {
                n9 = -n9;
                bl = false;
            } else {
                bl = true;
            }
            n7 = bl ? piVector3.m_data[n9] : piVector4.m_data[n9];
            pdVector2.sub(pdVectorArray[n7], pdVectorArray[n8]);
            pdVector2.normalize();
            while (n11 < n9) {
                pdVector.sub(pdVectorArray[piVector3.m_data[n11]], pdVectorArray[piVector4.m_data[n11]]);
                double d = pdVector.length();
                if (d < 1.0E-10) {
                    PsDebug.error((String)"Geometry degenerated");
                    return null;
                }
                pdVector.multScalar(1.0 / d);
                double d5 = PuVectorGeom.intersectionOfLineAndLine((PdVector)pdVector3, (PdVector)pdVectorArray[piVector4.m_data[n11]], (PdVector)pdVector, (PdVector)pdVectorArray[n8], (PdVector)pdVector2);
                d5 /= d;
                n6 = -1;
                n5 = piVector3.m_data[n11] != piVector3.m_data[n11 + 1] ? piVector3.m_data[n11 + 1] : piVector4.m_data[n11 + 1];
                for (n3 = 0; n3 < 3; ++n3) {
                    if (piVectorArray[n11].m_data[n3] != n5) continue;
                    n6 = n3;
                    break;
                }
                pdBary3.m_data[n6] = 0.0;
                pdBary3.m_data[(n6 + 1) % 3] = d5;
                pdBary3.m_data[(n6 + 2) % 3] = 1.0 - d5;
                pgPolygonOnElementSet.setVertexBary(n12, piVector.m_data[n11], pdBary3);
                ++n12;
                ++n11;
            }
            if (bl) {
                while (n9 < n18 && piVector3.m_data[n9] == piVector3.m_data[n9 + 1]) {
                    ++n9;
                }
            } else {
                while (n9 < n18 && piVector4.m_data[n9] == piVector4.m_data[n9 + 1]) {
                    ++n9;
                }
            }
            if (n9 >= n18) {
                n9 = n18 - 1;
            }
            n11 = n9 + 1;
            n6 = -1;
            for (n3 = 0; n3 < 3; ++n3) {
                if (piVectorArray[n9].m_data[n3] != n7) continue;
                n6 = n3;
                break;
            }
            pdBary3.copy(PdBary.TRIANGLE_VERTEX[n6]);
            pgPolygonOnElementSet.setVertexBary(n12, piVector.m_data[n9], pdBary3);
            ++n12;
            n8 = n7;
        }
        pgPolygonOnElementSet.setVertexBary(n12 - 1, n2, pdBary2);
        pgPolygonOnElementSet.setNumVertices(n12);
        return pgPolygonOnElementSet;
    }

    private static int findFirstElementInStrip(PdBary pdBary, int n, PiVector piVector, PiVector[] piVectorArray) {
        int n2;
        if (pdBary == null || piVector == null) {
            PsDebug.warning((String)"missing argument.");
            return -1;
        }
        int n3 = piVector.getSize();
        if (n3 > 1 && (n2 = PwBary.liesOnVertex(pdBary)) != -1) {
            int n4;
            int n5 = n2;
            n2 = piVectorArray[n].m_data[n2];
            int n6 = -1;
            int n7 = 0;
            block0: while (n5 != -1 && n7 < n3 - 1) {
                ++n7;
                n6 = n5;
                n5 = -1;
                for (n4 = 0; n4 < 3; ++n4) {
                    if (piVectorArray[piVector.m_data[n7]].m_data[n4] != n2) continue;
                    n5 = n4;
                    continue block0;
                }
            }
            if (n5 == -1) {
                --n7;
                pdBary.copy(PdBary.TRIANGLE_VERTEX[n6]);
            } else {
                pdBary.copy(PdBary.TRIANGLE_VERTEX[n5]);
            }
            n = piVector.m_data[n7];
            for (n4 = n7; n4 < n3; ++n4) {
                piVector.m_data[n4 - n7] = piVector.m_data[n4];
            }
            piVector.setSize(n3 - n7);
        }
        return n;
    }

    private static int findLastElementInStrip(PdBary pdBary, int n, PiVector piVector, PiVector[] piVectorArray) {
        int n2;
        int n3 = piVector.getSize();
        if (n3 > 1 && (n2 = PwBary.liesOnVertex(pdBary)) != -1) {
            int n4 = n2;
            n2 = piVectorArray[n].m_data[n2];
            int n5 = -1;
            block0: while (n4 != -1 && n3 > 1) {
                --n3;
                n5 = n4;
                n4 = -1;
                for (int i = 0; i < 3; ++i) {
                    if (piVectorArray[piVector.m_data[n3 - 1]].m_data[i] != n2) continue;
                    n4 = i;
                    continue block0;
                }
            }
            if (n4 == -1) {
                ++n3;
                pdBary.copy(PdBary.TRIANGLE_VERTEX[n5]);
            } else {
                pdBary.copy(PdBary.TRIANGLE_VERTEX[n4]);
            }
            n = piVector.m_data[n3 - 1];
            piVector.setSize(n3);
        }
        return n;
    }

    public static PiVector unfoldTriangleRun(PgElementSet pgElementSet, PiVector piVector, PgElementSet pgElementSet2, PiVector piVector2, PiVector piVector3) {
        double d;
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int n = piVector.getSize();
        int n2 = n + 2;
        int n3 = pgElementSet.getDimOfVertices();
        if (piVector2 == null) {
            piVector2 = new PiVector();
        }
        if (piVector3 == null) {
            piVector3 = new PiVector();
        }
        piVector2.setSize(n + 1);
        piVector3.setSize(n + 1);
        int n4 = 0;
        if (pgElementSet2 == null) {
            pgElementSet2 = new PgElementSet(2);
        }
        pgElementSet2.setDimOfVertices(2);
        if (n < 2) {
            PsDebug.warning((String)"run has length < 2 doing nothing");
            return null;
        }
        pgElementSet2.setNumElements(n);
        pgElementSet2.setNumVertices(n2);
        pgElementSet2.setDimOfElements(3);
        PdVector[] pdVectorArray2 = pgElementSet2.getVertices();
        PiVector[] piVectorArray3 = pgElementSet2.getElements();
        PdVector pdVector = new PdVector(2);
        PdVector pdVector2 = new PdVector(n3);
        PdVector pdVector3 = new PdVector(n3);
        int n5 = piVector.m_data[0];
        pdVector.setConstant(0.0);
        pgElementSet2.setVertex(0, pdVector);
        pdVector2.sub(pdVectorArray[piVectorArray[n5].m_data[1]], pdVectorArray[piVectorArray[n5].m_data[0]]);
        pdVector.m_data[0] = d = pdVector2.length();
        pgElementSet2.setVertex(1, pdVector);
        pdVector3.sub(pdVectorArray[piVectorArray[n5].m_data[2]], pdVectorArray[piVectorArray[n5].m_data[0]]);
        pdVector2.normalize();
        pdVector.m_data[0] = PdVector.dot((PdVector)pdVector2, (PdVector)pdVector3);
        pdVector2.multScalar(-pdVector.m_data[0]);
        pdVector2.add(pdVector3);
        pdVector.m_data[1] = pdVector2.length();
        pgElementSet2.setVertex(2, pdVector);
        pgElementSet2.setElement(0, 0, 1, 2);
        int n6 = 1;
        int n7 = 3;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        for (int i = 1; i < n; ++i) {
            int n12;
            int n13 = n8;
            n8 = n5;
            n5 = piVector.m_data[i];
            if (n5 == n13) {
                --n7;
                n5 = n13;
                n8 = --n6 - 2 >= 0 ? piVector.m_data[n6 - 2] : -1;
                --n4;
                if (n6 < 2) {
                    n11 = -1;
                    continue;
                }
                n12 = piVector2.m_data[n4] == piVector2.m_data[n4 - 1] ? piVector3.m_data[n4] : piVector2.m_data[n4];
                for (int j = 0; j < 3; ++j) {
                    if (piVectorArray3[n6 - 1].m_data[j] != n12) continue;
                    n12 = j;
                    break;
                }
                n11 = piVectorArray[n5].m_data[n12];
                continue;
            }
            piVector.m_data[n6] = piVector.m_data[i];
            n9 = -1;
            int n14 = piVectorArray2[n8].getSize();
            for (n12 = 0; n12 < n14; ++n12) {
                if (piVectorArray2[n8].m_data[n12] != n5) continue;
                n9 = n12;
                n10 = pgElementSet.getOppVertexLocInd(n8, n9);
            }
            if (n9 < 0) {
                PsDebug.error((String)"triangle run not connected");
                return null;
            }
            PwGeodesic.unfoldOntoElement(pdVectorArray2[n7], pdVectorArray2[piVectorArray3[n6 - 1].m_data[(n9 + 1) % 3]], pdVectorArray2[piVectorArray3[n6 - 1].m_data[(n9 + 2) % 3]], pdVectorArray2[piVectorArray3[n6 - 1].m_data[n9]], pdVectorArray[piVectorArray[n5].m_data[(n10 + 1) % 3]], pdVectorArray[piVectorArray[n5].m_data[(n10 + 2) % 3]], pdVectorArray[piVectorArray[n5].m_data[n10]], null, pdVectorArray[piVectorArray[n5].m_data[n10]], pdVector, null, pdVector2, pdVector3);
            piVectorArray3[n6].m_data[n10] = n7;
            piVectorArray3[n6].m_data[(n10 + 1) % 3] = piVectorArray3[n6 - 1].m_data[(n9 + 2) % 3];
            piVectorArray3[n6].m_data[(n10 + 2) % 3] = piVectorArray3[n6 - 1].m_data[(n9 + 1) % 3];
            if (n11 != -1) {
                if (n11 == piVectorArray[n5].m_data[(n10 + 1) % 3]) {
                    piVector2.m_data[n4] = n7 - 1;
                    piVector3.m_data[n4] = piVector3.m_data[n4 - 1];
                    ++n4;
                } else {
                    piVector2.m_data[n4] = piVector2.m_data[n4 - 1];
                    piVector3.m_data[n4] = n7 - 1;
                    ++n4;
                }
            } else {
                piVector2.m_data[0] = piVectorArray3[n6 - 1].m_data[n9];
                piVector3.m_data[0] = piVector2.m_data[0];
                piVector2.m_data[1] = piVectorArray3[n6 - 1].m_data[(n9 + 2) % 3];
                piVector3.m_data[1] = piVectorArray3[n6 - 1].m_data[(n9 + 1) % 3];
                n4 = 2;
            }
            n11 = piVectorArray[n5].m_data[n10];
            ++n6;
            ++n7;
        }
        piVector2.m_data[n4] = n7 - 1;
        piVector3.m_data[n4] = n7 - 1;
        piVector2.setSize(n4 + 1);
        piVector3.setSize(n4 + 1);
        piVector.setSize(n6);
        pgElementSet2.setNumElements(n6);
        pgElementSet2.setNumVertices(n7);
        return piVector;
    }

    public static PiVector getShortestInUnfoldedTriangleRun(PgElementSet pgElementSet, PiVector piVector, PiVector piVector2, PiVector piVector3) {
        int n;
        int n2;
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        if (piVector3 == null) {
            piVector3 = new PiVector();
        }
        int n3 = piVector.getSize();
        piVector3.setSize(n3);
        int n4 = 1;
        PiVector piVector4 = piVector3;
        piVector4.m_data[0] = 0;
        PiVector[] piVectorArray = new PiVector[]{piVector, piVector2};
        PiVector[] piVectorArray2 = new PiVector[2];
        int[] nArray = new int[2];
        for (n2 = 0; n2 < 2; ++n2) {
            piVectorArray2[n2] = new PiVector(n3);
            nArray[n2] = 1;
            piVectorArray2[n2].m_data[0] = 1;
        }
        PdVector pdVector = new PdVector(2);
        PdVector pdVector2 = new PdVector(2);
        piVector2.m_data[n3 - 1] = piVector2.m_data[n3 - 2];
        for (n = 2; n < n3; ++n) {
            n2 = piVector.m_data[n] != piVector.m_data[n - 1] ? 0 : 1;
            int n5 = n2;
            int n6 = -1;
            for (int i = 0; i < 2 && n6 < 0; ++i) {
                int n7;
                int n8;
                int n9 = nArray[n5] - 1;
                while (n9 >= 0 && n6 < 0) {
                    pdVector.sub(pdVectorArray[piVectorArray[n5].m_data[piVectorArray2[n5].m_data[n9]]], pdVectorArray[piVectorArray[n2].m_data[n]]);
                    double d = pdVector.m_data[0];
                    if (n5 == 0) {
                        pdVector.m_data[0] = -pdVector.m_data[1];
                        pdVector.m_data[1] = d;
                    } else {
                        pdVector.m_data[0] = pdVector.m_data[1];
                        pdVector.m_data[1] = -d;
                    }
                    n6 = n9;
                    for (n8 = n9 - 1; n8 >= 0; --n8) {
                        pdVector2.sub(pdVectorArray[piVectorArray[n5].m_data[piVectorArray2[n5].m_data[n8]]], pdVectorArray[piVectorArray[n2].m_data[n]]);
                        if (!(PdVector.dot((PdVector)pdVector, (PdVector)pdVector2) > 0.0)) continue;
                        n6 = -1;
                        break;
                    }
                    if (n6 >= 0) {
                        int n10;
                        if (piVector4.m_data[n4 - 1] < 0) {
                            n7 = -1;
                            n10 = 1;
                        } else {
                            n7 = 1;
                            n10 = 0;
                        }
                        pdVector2.sub(pdVectorArray[piVectorArray[n10].m_data[n7 * piVector4.m_data[n4 - 1]]], pdVectorArray[piVectorArray[n2].m_data[n]]);
                        if (PdVector.dot((PdVector)pdVector, (PdVector)pdVector2) > 0.0) {
                            n6 = -1;
                        }
                    }
                    if (n6 >= 0) continue;
                    --n9;
                }
                if (n6 >= 0) {
                    if (n5 != n2) {
                        n7 = n5 == 0 ? 1 : -1;
                        nArray[n2] = 1;
                        piVectorArray2[n2].m_data[0] = n;
                        for (n8 = 0; n8 <= n9; ++n8) {
                            piVector4.m_data[n4] = n7 * piVectorArray2[n5].m_data[n8];
                            ++n4;
                        }
                        for (n8 = n9 + 1; n8 < nArray[n5]; ++n8) {
                            piVectorArray2[n5].m_data[n8 - n9 - 1] = piVectorArray2[n5].m_data[n8];
                        }
                        nArray[n5] = nArray[n5] - n9 - 1;
                    } else {
                        piVectorArray2[n2].m_data[n9 + 1] = n;
                        nArray[n2] = n9 + 2;
                    }
                }
                n5 = (n5 + 1) % 2;
            }
            if (n6 >= 0) continue;
            nArray[n2] = 1;
            piVectorArray2[n2].m_data[0] = n;
        }
        for (n = 0; n < nArray[0]; ++n) {
            piVector4.m_data[n4] = piVectorArray2[0].m_data[n];
            ++n4;
        }
        piVector4.setSize(n4);
        piVector2.m_data[n3 - 1] = piVector.m_data[n3 - 1];
        return piVector4;
    }

    public static PiVector getDijkstraDistance(PgElementSet pgElementSet, PiVector piVector) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = pgElementSet.getNumVertices();
        int n6 = pgElementSet.getNumElements();
        PiVector piVector2 = new PiVector(n5);
        piVector2.setConstant(-1);
        for (n4 = 0; n4 < piVector.getSize(); ++n4) {
            piVector2.setEntry(piVector.m_data[n4], 0);
        }
        int[] nArray = new int[n5];
        PiVector[] piVectorArray = PiVector.realloc(null, (int)n5, (int)6);
        PiVector[] piVectorArray2 = pgElementSet.getElements();
        for (n4 = 0; n4 < n6; ++n4) {
            int n7 = piVectorArray2[n4].getSize();
            for (n3 = 0; n3 < n7; ++n3) {
                int n8 = piVectorArray2[n4].getEntry(n3);
                if (piVectorArray[n8].getSize() <= nArray[n8]) {
                    piVectorArray[n8].setSize(2 * nArray[n8] + 1);
                }
                piVectorArray[n8].setEntry(nArray[n8], n4);
                int n9 = n8;
                nArray[n9] = nArray[n9] + 1;
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            piVectorArray[n4].setSize(nArray[n4]);
        }
        int[] nArray2 = new int[n5];
        PiVector[] piVectorArray3 = PiVector.realloc(null, (int)n5, (int)6);
        for (n4 = 0; n4 < n6; ++n4) {
            int n10 = piVectorArray2[n4].getSize();
            for (n3 = 0; n3 < n10; ++n3) {
                int n11;
                n2 = piVectorArray2[n4].getEntry((n3 + 1) % n10);
                n = piVectorArray3[n2].getIndexOf(n11 = piVectorArray2[n4].getEntry((n3 + 2) % n10));
                if (n != -1 && n < nArray2[n2]) continue;
                if (piVectorArray3[n2].getSize() <= nArray2[n2]) {
                    piVectorArray3[n2].setSize(2 * nArray2[n2] + 1);
                }
                piVectorArray3[n2].setEntry(nArray2[n2], n11);
                int n12 = n2;
                nArray2[n12] = nArray2[n12] + 1;
                if (piVectorArray3[n11].getSize() <= nArray2[n11]) {
                    piVectorArray3[n11].setSize(2 * nArray2[n11] + 1);
                }
                piVectorArray3[n11].setEntry(nArray2[n11], n2);
                int n13 = n11;
                nArray2[n13] = nArray2[n13] + 1;
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            piVectorArray3[n4].setSize(nArray2[n4]);
        }
        PiVector piVector3 = new PiVector(n5);
        n2 = 0;
        PiVector piVector4 = new PiVector(n5);
        piVector4.copy(0, piVector, 0, piVector.getSize());
        n = piVector.getSize();
        while (n > 0) {
            for (n4 = 0; n4 < n; ++n4) {
                int n14 = piVector4.getEntry(n4);
                for (n3 = 0; n3 < piVectorArray3[n14].getSize(); ++n3) {
                    int n15 = piVectorArray3[n14].getEntry(n3);
                    if (piVector2.getEntry(n15) != -1) continue;
                    piVector2.setEntry(n15, piVector2.getEntry(n14) + 1);
                    piVector3.setEntry(n2, n15);
                    ++n2;
                }
            }
            piVector4.copy(0, piVector3, 0, n2);
            n = n2;
            n2 = 0;
        }
        return piVector2;
    }

    public static int removeLoops(int[] nArray, int n, int[] nArray2) {
        int n2;
        int n3 = n;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray2[n2] = -1;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray2[nArray[n2]] == -1) {
                nArray2[nArray[n2]] = n2;
                continue;
            }
            int n4 = nArray2[nArray[n2]];
            for (int i = n4 + 1; i < n2; ++i) {
                nArray2[nArray[i]] = -1;
            }
            System.arraycopy(nArray, n2, nArray, n4, n3 - n2);
            n3 -= n2 - n4;
            n2 = n4;
        }
        return n3;
    }

    public static PgVectorField getEuclideanDijkstraDistance(PgElementSet pgElementSet, PiVector piVector, PgVectorField pgVectorField) {
        int n;
        int n2 = pgElementSet.getNumVertices();
        PuPriorityQueue puPriorityQueue = new PuPriorityQueue(n2, Double.MAX_VALUE);
        for (n = 0; n < piVector.m_data.length; ++n) {
            puPriorityQueue.decreaseKey(piVector.m_data[n], 0.0);
        }
        int[] nArray = PgVertexStar.getElementPerVertex((PgElementSet)pgElementSet).m_data;
        PgVertexStar pgVertexStar = new PgVertexStar();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        double[] dArray = puPriorityQueue.getKeys();
        PdVector pdVector = new PdVector(pgElementSet.getDimOfVertices());
        while ((n = puPriorityQueue.extractMin()) >= 0) {
            pgVertexStar.makeVertexStar(pgElementSet, n, nArray[n]);
            PiVector piVector2 = pgVertexStar.getLink();
            for (int i = 0; i < piVector2.m_data.length; ++i) {
                pdVector.sub(pdVectorArray[n], pdVectorArray[piVector2.m_data[i]]);
                double d = pdVector.length();
                if (!(dArray[piVector2.m_data[i]] > dArray[n] + d)) continue;
                puPriorityQueue.enqueueOrDecrease(piVector2.m_data[i], dArray[n] + d);
            }
        }
        if (pgVectorField == null) {
            pgVectorField = new PgVectorField(1, 0);
            pgVectorField.setName("Distance Field");
            pgVectorField.setGeometry((PgPointSet)pgElementSet);
            pgElementSet.addVectorField(pgVectorField);
        } else if (pgVectorField.getType() != 0) {
            pgVectorField.setType(0);
        }
        if (pgVectorField.getDimOfVectors() != 1) {
            pgVectorField.setDimOfVectors(1);
        }
        if (pgVectorField.getNumVectors() != n2) {
            pgVectorField.setNumVectors(n2);
        }
        PdVector[] pdVectorArray2 = pgVectorField.getVectors();
        for (int i = 0; i < n2; ++i) {
            pdVectorArray2[i].m_data[0] = dArray[i];
        }
        return pgVectorField;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

