/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgBndConstraint;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwIdentify;
import jvx.project.PjWorkshop;

public class PwBoundary
extends PjWorkshop {
    protected PgElementSet m_elemSet;
    protected PuDouble m_cornerAngle;
    protected double m_defCornerAngle = 120.0;
    protected boolean m_bMakeBoundaryConstraints;
    protected PuDouble m_lineTol = new PuDouble(PsConfig.getMessage((int)54045), (PsUpdateIf)this);
    protected double m_defLineTol = 0.001;
    protected PuDouble m_planeTol = new PuDouble(PsConfig.getMessage((int)54046), (PsUpdateIf)this);
    protected double m_defPlaneTol = 0.001;
    static /* synthetic */ Class class$jvx$geom$PwBoundary;

    public PwBoundary() {
        super(PsConfig.getMessage((int)51065));
        this.m_cornerAngle = new PuDouble(PsConfig.getMessage((int)54047), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwBoundary == null ? (class$jvx$geom$PwBoundary = PwBoundary.class$("jvx.geom.PwBoundary")) : class$jvx$geom$PwBoundary)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setEnabledMakeConstraints(true);
        this.m_lineTol.setDefBounds(0.0, 100.0 * this.m_defLineTol, 1.0 * this.m_defLineTol, 10.0 * this.m_defLineTol);
        this.m_lineTol.setDefValue(this.m_defLineTol);
        this.m_lineTol.init();
        this.m_planeTol.setDefBounds(0.0, 100.0 * this.m_defPlaneTol, 1.0 * this.m_defPlaneTol, 10.0 * this.m_defPlaneTol);
        this.m_planeTol.setDefValue(this.m_defPlaneTol);
        this.m_planeTol.init();
        this.m_cornerAngle.setDefBounds(0.0, 200.0, 1.0, 10.0);
        this.m_cornerAngle.setDefValue(this.m_defCornerAngle);
        this.m_cornerAngle.init();
    }

    public void reset() {
        super.reset();
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.update((Object)this);
    }

    public void close() {
        PwIdentify.removeMarks(this.m_geom);
        this.update((Object)this);
        super.close();
    }

    public void ok() {
        this.makeBoundary();
        if (this.m_bMakeBoundaryConstraints) {
            this.makeBoundaryConstraints();
        }
        this.close();
    }

    public boolean update(Object object) {
        if (object == this) {
            this.setUpdateSender(true);
            PwIdentify.removeMarks((PgGeometry)this.m_elemSet);
            PwCleanMesh.markCornerVertices(this.m_elemSet, this.m_cornerAngle.getValue());
            this.m_elemSet.update((Object)this.m_elemSet);
            this.setUpdateSender(false);
            return super.update(null);
        }
        if (object == this.m_elemSet) {
            if (this.isUpdateSender()) {
                return true;
            }
            if (this.isModal()) {
                return true;
            }
            this.setGeometry((PgGeometry)this.m_elemSet);
            return true;
        }
        if (object == this.m_lineTol) {
            return true;
        }
        if (object == this.m_planeTol) {
            return true;
        }
        if (object == this.m_cornerAngle) {
            return this.update((Object)this);
        }
        return super.update(object);
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgElementSet)) {
            PsDebug.warning((String)"workshop requires instance of PgElementSet.");
            return;
        }
        super.setGeometry(pgGeometry);
        this.m_elemSet = (PgElementSet)pgGeometry;
        this.update((Object)this);
    }

    public void removeBoundary() {
        if (this.m_elemSet == null) {
            return;
        }
        if (this.m_elemSet.hasBoundary()) {
            this.m_elemSet.removeBoundaries();
        }
    }

    public void makeBoundary() {
        if (this.m_elemSet == null) {
            return;
        }
        PwBoundary.makeBoundary(this.m_elemSet);
    }

    public double getCornerAngle() {
        return this.m_cornerAngle.getValue();
    }

    public void setCornerAngle(double d) {
        this.m_cornerAngle.setValue(d);
    }

    public double getLineTol() {
        return this.m_lineTol.getValue();
    }

    public void setLineTol(double d) {
        this.m_lineTol.setValue(d);
    }

    public double getPlaneTol() {
        return this.m_planeTol.getValue();
    }

    public void setPlaneTol(double d) {
        this.m_planeTol.setValue(d);
    }

    public static void makeBoundary(PgElementSet pgElementSet) {
        Object object;
        int n;
        int n2;
        int n3;
        if (pgElementSet.hasBoundary()) {
            pgElementSet.removeBoundaries();
        }
        if ((n3 = pgElementSet.getNumVertices()) < 1) {
            return;
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int n4 = pgElementSet.getNumElements();
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            int n6 = piVectorArray[n2].getSize();
            int[] nArray = piVectorArray2[n2].m_data;
            for (n = 0; n < n6; ++n) {
                if (nArray[n] != -1) continue;
                ++n5;
            }
        }
        if (n5 == 0) {
            return;
        }
        n2 = pgElementSet.getDimOfVertices();
        PgPolygonSet pgPolygonSet = new PgPolygonSet(n2);
        pgPolygonSet.setNumVertices(n3);
        pgPolygonSet.setVertices(pgElementSet.getVertices());
        pgPolygonSet.setNumPolygons(n5);
        int n7 = 0;
        for (n = 0; n < n4; ++n) {
            int n8 = piVectorArray[n].getSize();
            int[] nArray = piVectorArray2[n].m_data;
            object = piVectorArray[n].m_data;
            for (int i = 0; i < n8; ++i) {
                if (nArray[i] != -1) continue;
                pgPolygonSet.setPolygon(n7++, object[(i + 1) % n8], object[(i + 2) % n8]);
            }
        }
        PwCleanMesh.joinPolygons(pgPolygonSet);
        n = pgPolygonSet.getNumPolygons();
        PgBndPolygon[] pgBndPolygonArray = new PgBndPolygon[n];
        for (int i = 0; i < n; ++i) {
            pgBndPolygonArray[i] = new PgBndPolygon(n2);
            pgBndPolygonArray[i].setName(PsConfig.getMessage((boolean)true, (int)45000, (String)"Boundary") + " " + String.valueOf(i));
            object = pgPolygonSet.getPolygon(i);
            pgBndPolygonArray[i].setNumVertices(object.getSize());
            pgBndPolygonArray[i].setGeometry(pgElementSet);
            pgBndPolygonArray[i].getVertexInd().copy((PiVector)object);
            pgBndPolygonArray[i].makeElementInd();
            pgBndPolygonArray[i].setClosed(pgPolygonSet.isClosed(i));
        }
        pgElementSet.setBoundary(pgBndPolygonArray);
    }

    public boolean isEnabledMakeConstraints() {
        return this.m_bMakeBoundaryConstraints;
    }

    public void setEnabledMakeConstraints(boolean bl) {
        this.m_bMakeBoundaryConstraints = bl;
    }

    public void makeBoundaryConstraints() {
        int n;
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        if (!pgElementSet.hasBoundary()) {
            PsDebug.warning((String)"Missing Boundary");
        }
        PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
        for (n = 0; n < pgBndPolygonArray.length; ++n) {
            PwBoundary.makeBoundaryConstraint(pgElementSet, n, this.m_lineTol.getValue(), this.m_planeTol.getValue());
        }
        for (n = 0; n < pgBndPolygonArray.length; ++n) {
            int n2;
            PgBndConstraint pgBndConstraint = pgBndPolygonArray[n].getBndConstraint();
            if (pgBndConstraint == null || !pgBndConstraint.hasShape(5)) continue;
            int n3 = pgBndPolygonArray[n].getNumVertices();
            PiVector piVector = pgBndPolygonArray[n].getVertexInd();
            int n4 = piVector.getEntry(0);
            if (n4 == (n2 = piVector.getEntry(n3 - 1))) {
                pgBndConstraint.m_startDir = null;
                pgBndConstraint.m_endDir = null;
                continue;
            }
            for (int i = 0; i < pgBndPolygonArray.length; ++i) {
                PgBndConstraint pgBndConstraint2;
                if (n == i || (pgBndConstraint2 = pgBndPolygonArray[i].getBndConstraint()) == null || !pgBndConstraint2.hasShape(5)) continue;
                n3 = pgBndPolygonArray[i].getNumVertices();
                piVector = pgBndPolygonArray[i].getVertexInd();
                PdVector pdVector = PdVector.crossNew((PdVector)pgBndConstraint.m_dir, (PdVector)pgBndConstraint2.m_dir);
                pdVector.normalize();
                if (n4 == piVector.getEntry(0)) {
                    pgBndConstraint.m_startDir = (PdVector)pdVector.clone();
                    pgBndConstraint2.m_startDir = (PdVector)pdVector.clone();
                    continue;
                }
                if (n4 == piVector.getEntry(n3 - 1)) {
                    pgBndConstraint.m_startDir = (PdVector)pdVector.clone();
                    pgBndConstraint2.m_endDir = (PdVector)pdVector.clone();
                    continue;
                }
                if (n2 == piVector.getEntry(0)) {
                    pgBndConstraint.m_endDir = (PdVector)pdVector.clone();
                    pgBndConstraint2.m_startDir = (PdVector)pdVector.clone();
                    continue;
                }
                if (n2 != piVector.getEntry(n3 - 1)) continue;
                pgBndConstraint.m_endDir = (PdVector)pdVector.clone();
                pgBndConstraint2.m_endDir = (PdVector)pdVector.clone();
            }
        }
    }

    public static void makeBoundaryConstraint(PgElementSet pgElementSet, int n, double d, double d2) {
        int n2;
        int n3;
        PgBndPolygon[] pgBndPolygonArray;
        if (!pgElementSet.hasBoundary()) {
            PsDebug.warning((String)"Missing Boundary");
        }
        if ((pgBndPolygonArray = pgElementSet.getBoundaries()).length - 1 < n) {
            PsDebug.warning((String)"bndIndex to high");
        }
        PiVector piVector = pgBndPolygonArray[n].getVertexInd();
        int n4 = pgBndPolygonArray[n].getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        if (n4 < 2) {
            return;
        }
        double d3 = PdVector.dist((PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[n4 - 1]]);
        boolean bl = true;
        if (d3 > 1.0E-10) {
            for (int i = 1; i < n4 - 1; ++i) {
                double d4 = PdVector.dist((PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[i]]);
                double d5 = PdVector.dist((PdVector)pdVectorArray[piVector.m_data[n4 - 1]], (PdVector)pdVectorArray[piVector.m_data[i]]);
                if (d4 > d3) {
                    if (!((d3 + d5) / d4 > 1.0 + d)) continue;
                    bl = false;
                    continue;
                }
                if (d5 > d3) {
                    if (!((d3 + d4) / d5 > 1.0 + d)) continue;
                    bl = false;
                    continue;
                }
                if (!((d4 + d5) / d3 > 1.0 + d)) continue;
                bl = false;
            }
        } else {
            bl = false;
        }
        if (bl) {
            PgBndConstraint pgBndConstraint = new PgBndConstraint(pgElementSet.getDimOfVertices());
            pgBndConstraint.setShape(4);
            pgBndConstraint.m_start.copy(pdVectorArray[piVector.m_data[0]]);
            pgBndConstraint.m_end.copy(pdVectorArray[piVector.m_data[n4 - 1]]);
            pgBndConstraint.m_dir.sub(pdVectorArray[piVector.m_data[n4 - 1]], pdVectorArray[piVector.m_data[0]]);
            pgBndConstraint.m_dir.normalize();
            pgBndPolygonArray[n].setBndConstraint(pgBndConstraint);
            return;
        }
        if (n4 < 3) {
            return;
        }
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        boolean bl2 = false;
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = new PdVector(3);
        PdVector pdVector7 = new PdVector(3);
        PdVector pdVector8 = new PdVector(3);
        for (n3 = 0; n3 < n4 - 2; ++n3) {
            for (n2 = n3 + 1; n2 < n4 - 1; ++n2) {
                for (int i = n4 - 1; i > n2; --i) {
                    pdVector3.sub(pdVectorArray[piVector.m_data[n2]], pdVectorArray[piVector.m_data[n3]]);
                    pdVector4.sub(pdVectorArray[piVector.m_data[i]], pdVectorArray[piVector.m_data[n3]]);
                    pdVector.cross(pdVector3, pdVector4);
                    if (!pdVector.normalize()) continue;
                    pdVector5.cross(pdVector, pdVector3);
                    pdVector5.normalize();
                    pdVector6.copy(pdVector4);
                    pdVector6.normalize();
                    pdVector7.blend(0.5, pdVectorArray[piVector.m_data[n2]], 0.5, pdVectorArray[piVector.m_data[n3]]);
                    pdVector8.blend(0.5, pdVectorArray[piVector.m_data[i]], 0.5, pdVectorArray[piVector.m_data[n3]]);
                    double d6 = PdVector.dotDir((PdVector)pdVector6, (PdVector)pdVector8, (PdVector)pdVector7);
                    pdVector5.multScalar(d6 / PdVector.dot((PdVector)pdVector5, (PdVector)pdVector6));
                    pdVector2.add(pdVector7, pdVector5);
                    bl2 = true;
                    break;
                }
                if (bl2) break;
            }
            if (bl2) break;
        }
        n3 = 0;
        if (bl2) {
            n3 = 1;
            for (n2 = 1; n2 < n4; ++n2) {
                double d7 = Math.abs(PdVector.dot((PdVector)PdVector.subNew((PdVector)pdVectorArray[piVector.m_data[n2]], (PdVector)pdVectorArray[piVector.m_data[0]]), (PdVector)pdVector));
                if (!(d7 > d2)) continue;
                n3 = 0;
                break;
            }
        }
        if (n3 != 0) {
            PgBndConstraint pgBndConstraint = new PgBndConstraint(pgElementSet.getDimOfVertices());
            pgBndConstraint.setShape(5);
            pgBndConstraint.m_start.copy(pdVectorArray[piVector.m_data[0]]);
            pgBndConstraint.m_end.copy(pdVectorArray[piVector.m_data[n4 - 1]]);
            pgBndConstraint.m_dir.copy(pdVector);
            pgBndPolygonArray[n].setBndConstraint(pgBndConstraint);
            return;
        }
        PgBndConstraint pgBndConstraint = new PgBndConstraint(pgElementSet.getDimOfVertices());
        pgBndConstraint.setShape(3);
        pgBndPolygonArray[n].setBndConstraint(pgBndConstraint);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

