/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.util.Random;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgTexture;
import jv.geom.PuCleanMesh;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwBlocks
extends PjWorkshop {
    public static final Color[] COLOR_TABLE = new Color[]{new Color(29, 36, 47), new Color(56, 107, 184), new Color(195, 61, 62), new Color(250, 249, 245), new Color(250, 215, 75)};
    private static final double[][] Y_COORDS = new double[][]{{0.7, 0.3}, {0.7, 0.3}, {0.7, 0.3}, {0.7, 0.3}, {0.3, 0.0}, {1.0, 0.7}};
    public static String m_defBlocks = "images/jvTextureBlocks.jpg";
    private PdVector m_cubeSize;
    private PdVector m_min;
    private int m_dim;
    private int[] m_discr;
    private Random m_random;
    static /* synthetic */ Class class$jvx$geom$PwBlocks;

    public PwBlocks() {
        super(PsConfig.getMessage((int)51064));
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwBlocks == null ? (class$jvx$geom$PwBlocks = PwBlocks.class$("jvx.geom.PwBlocks")) : class$jvx$geom$PwBlocks)) {
            this.init();
        }
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_random = new Random();
        this.m_dim = this.m_geom.getDimOfVertices();
        this.m_discr = new int[this.m_dim];
        for (int i = 0; i < this.m_dim; ++i) {
            this.m_discr[i] = 10;
        }
    }

    public void setDiscr(int n) {
        if (n < 1) {
            PsDebug.warning((String)("discretization out of range = " + n));
            return;
        }
        for (int i = 0; i < this.m_dim; ++i) {
            this.m_discr[i] = n;
        }
    }

    public void setDiscr(int n, int n2) {
        if (n >= this.m_dim || n2 < 1) {
            PsDebug.warning((String)"parameter out of range");
            return;
        }
        this.m_discr[n] = n2;
    }

    public void reset() {
        PdVector[] pdVectorArray = this.m_geom.getBounds();
        this.m_min = pdVectorArray[0];
        this.m_cubeSize = new PdVector(this.m_dim);
        for (int i = 0; i < this.m_dim; ++i) {
            this.m_cubeSize.m_data[i] = (pdVectorArray[1].m_data[i] - this.m_min.m_data[i]) / (double)this.m_discr[i];
        }
    }

    public int[][] blocks() {
        int n;
        int n2;
        PiVector[] piVectorArray;
        int n3;
        int n4;
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        if (pgElementSet.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        int n5 = pgElementSet.getNumVertices();
        int n6 = pgElementSet.getNumElements();
        Vector<PdVector> vector = new Vector<PdVector>();
        Vector<int[]> vector2 = new Vector<int[]>();
        for (int i = 0; i < n5; ++i) {
            vector.addElement(this.m_geom.getVertex(i));
            vector2.addElement(this.getIntCoordinates(pgElementSet.getVertex(i)));
        }
        Vector<PiVector> vector3 = new Vector<PiVector>();
        Vector<PiVector> vector4 = new Vector<PiVector>();
        for (n4 = 0; n4 < n6; ++n4) {
            vector3.addElement(pgElementSet.getElement(n4));
            vector4.addElement(pgElementSet.getNeighbour(n4));
        }
        n4 = 0;
        int n7 = vector.size();
        int n8 = n6;
        int n9 = -1;
        boolean bl = false;
        while (n4 < vector3.size()) {
            n3 = 0;
            piVectorArray = (PiVector[])vector3.elementAt(n4);
            for (n2 = 0; n2 < 3; ++n2) {
                int n10;
                n = 0;
                for (int i = 0; i < this.m_dim; ++i) {
                    if (1 >= Math.abs(((int[])vector2.elementAt(piVectorArray.m_data[(n2 + 1) % 3]))[i] - ((int[])vector2.elementAt(piVectorArray.m_data[(n2 + 2) % 3]))[i])) continue;
                    n = 1;
                    break;
                }
                if (n == 0) continue;
                PiVector piVector = (PiVector)vector4.elementAt(n4);
                vector.addElement(PdVector.blendNew((double)0.5, (PdVector)((PdVector)vector.elementAt(piVectorArray.m_data[(n2 + 1) % 3])), (double)0.5, (PdVector)((PdVector)vector.elementAt(piVectorArray.m_data[(n2 + 2) % 3]))));
                vector2.addElement(this.getIntCoordinates((PdVector)vector.elementAt(n7)));
                int n11 = piVector.m_data[n2];
                PiVector piVector2 = (PiVector)piVectorArray.clone();
                PiVector piVector3 = (PiVector)piVector.clone();
                for (n10 = 0; n10 < 3; ++n10) {
                    piVector2.m_data[n10] = piVectorArray.m_data[(n2 + 1 + n10) % 3];
                    piVector3.m_data[n10] = piVector.m_data[(n2 + 1 + n10) % 3];
                }
                for (n10 = 0; n10 < 2; ++n10) {
                    piVector.m_data[n10] = piVector3.m_data[n10 + 1];
                    piVectorArray.m_data[n10 + 1] = piVector2.m_data[(n10 + 2) % 3];
                }
                piVector.m_data[2] = n8;
                piVector2.m_data[0] = n7;
                piVectorArray.m_data[0] = n7;
                piVector3.m_data[1] = n4;
                if (piVector3.m_data[0] != -1) {
                    PiVector piVector4 = (PiVector)vector4.elementAt(piVector3.m_data[0]);
                    for (int i = 0; i < 3; ++i) {
                        if (piVector4.m_data[i] != n4) continue;
                        piVector4.m_data[i] = n8;
                    }
                }
                vector3.addElement(piVector2);
                vector4.addElement(piVector3);
                if (n11 != -1) {
                    int n12;
                    PiVector piVector5 = (PiVector)vector4.elementAt(n11);
                    PiVector piVector6 = (PiVector)vector3.elementAt(n11);
                    for (int i = 0; i < 3; ++i) {
                        if (piVector5.m_data[i] != n4 || (piVector6.m_data[(i + 1) % 3] != piVectorArray.m_data[2] || piVector6.m_data[(i + 2) % 3] != piVector2.m_data[1]) && (piVector6.m_data[(i + 1) % 3] != piVector2.m_data[1] || piVector6.m_data[(i + 2) % 3] != piVectorArray.m_data[2])) continue;
                        n9 = i;
                        if (piVector6.m_data[(i + 1) % 3] == piVectorArray.m_data[2] && piVector6.m_data[(i + 2) % 3] == piVector2.m_data[1]) {
                            bl = false;
                            break;
                        }
                        bl = true;
                        break;
                    }
                    PiVector piVector7 = (PiVector)piVector6.clone();
                    PiVector piVector8 = (PiVector)piVector5.clone();
                    if (bl) {
                        for (n12 = 0; n12 < 3; ++n12) {
                            piVector7.m_data[n12] = piVector6.m_data[(n9 + 2 + n12) % 3];
                            piVector8.m_data[n12] = piVector5.m_data[(n9 + 2 + n12) % 3];
                        }
                        for (n12 = 0; n12 < 2; ++n12) {
                            piVector5.m_data[(n12 + 2) % 3] = piVector8.m_data[n12 + 1];
                            piVector6.m_data[n12 + 1] = piVector7.m_data[n12];
                        }
                        piVector5.m_data[1] = n8 + 1;
                        piVector8.m_data[2] = n11;
                        piVector8.m_data[1] = n8;
                    } else {
                        for (n12 = 0; n12 < 3; ++n12) {
                            piVector7.m_data[n12] = piVector6.m_data[(n9 + 1 + n12) % 3];
                            piVector8.m_data[n12] = piVector5.m_data[(n9 + 1 + n12) % 3];
                        }
                        for (n12 = 0; n12 < 2; ++n12) {
                            piVector5.m_data[n12] = piVector8.m_data[n12 + 1];
                            piVector6.m_data[n12 + 1] = piVector7.m_data[(n12 + 2) % 3];
                        }
                        piVector5.m_data[2] = n8 + 1;
                        piVector8.m_data[1] = n11;
                        piVector8.m_data[2] = n8;
                    }
                    if (piVector8.m_data[0] != -1) {
                        PiVector piVector9 = (PiVector)vector4.elementAt(piVector8.m_data[0]);
                        for (int i = 0; i < 3; ++i) {
                            if (piVector9.m_data[i] != n11) continue;
                            piVector9.m_data[i] = n8 + 1;
                        }
                    }
                    piVector6.m_data[0] = n7;
                    piVector7.m_data[0] = n7;
                    vector3.addElement(piVector7);
                    vector4.addElement(piVector8);
                    piVector3.m_data[2] = ++n8;
                }
                ++n8;
                n3 = 1;
                ++n7;
            }
            if (n3 != 0) continue;
            ++n4;
        }
        n5 = vector2.size();
        pgElementSet.setNumVertices(n5);
        for (n3 = 0; n3 < n5; ++n3) {
            this.m_geom.setVertex(n3, this.getVertexFromInt((int[])vector2.elementAt(n3)));
        }
        n6 = vector3.size();
        pgElementSet.setNumElements(n6);
        PiVector[] piVectorArray2 = new PiVector[n6];
        piVectorArray = new PiVector[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            piVectorArray2[n2] = (PiVector)vector3.elementAt(n2);
            piVectorArray[n2] = (PiVector)vector4.elementAt(n2);
        }
        pgElementSet.setElements(piVectorArray2);
        pgElementSet.setNeighbours(piVectorArray);
        int[][] nArrayArray = new int[n5][];
        for (n = 0; n < n5; ++n) {
            nArrayArray[n] = (int[])vector2.elementAt(n);
        }
        this.makeCubes(nArrayArray);
        return nArrayArray;
    }

    private void makeCubes(int[][] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.m_dim != 3) {
            PsDebug.warning((String)("dimension of vertices must be 3, m_dim = " + this.m_dim));
            return;
        }
        boolean[][][] blArray = this.getUsedBlocks(nArray);
        Vector<PdVector> vector = new Vector<PdVector>();
        Vector<PiVector> vector2 = new Vector<PiVector>();
        Vector<PiVector> vector3 = new Vector<PiVector>();
        int[][][] nArray2 = new int[this.m_discr[0] + 1][this.m_discr[1] + 1][this.m_discr[2] + 1];
        for (n4 = 0; n4 < this.m_discr[0] + 1; ++n4) {
            for (n3 = 0; n3 < this.m_discr[1] + 1; ++n3) {
                for (n2 = 0; n2 < this.m_discr[2] + 1; ++n2) {
                    nArray2[n4][n3][n2] = -1;
                }
            }
        }
        for (n4 = 0; n4 <= this.m_discr[0]; ++n4) {
            for (n3 = 0; n3 <= this.m_discr[1]; ++n3) {
                for (n2 = 0; n2 <= this.m_discr[2]; ++n2) {
                    if (!blArray[n4][n3][n2]) continue;
                    n = vector.size();
                    for (int i = 0; i < 2; ++i) {
                        for (int j = 0; j < 2; ++j) {
                            for (int k = 0; k < 2; ++k) {
                                vector.addElement(new PdVector(this.m_min.m_data[0] + this.m_cubeSize.m_data[0] * ((double)n4 - 0.5 + (double)i), this.m_min.m_data[1] + this.m_cubeSize.m_data[1] * ((double)n3 - 0.5 + (double)j), this.m_min.m_data[2] + this.m_cubeSize.m_data[2] * ((double)n2 - 0.5 + (double)k)));
                            }
                        }
                    }
                    if (n4 == 0 || !blArray[n4 - 1][n3][n2]) {
                        vector2.addElement(new PiVector(n + 0, n + 1, n + 3, n + 2));
                        vector3.addElement(new PiVector(n4, n3, n2, 0));
                    }
                    if (n4 == this.m_discr[0] || !blArray[n4 + 1][n3][n2]) {
                        vector2.addElement(new PiVector(n + 4, n + 6, n + 7, n + 5));
                        vector3.addElement(new PiVector(n4, n3, n2, 1));
                    }
                    if (n3 == 0 || !blArray[n4][n3 - 1][n2]) {
                        vector2.addElement(new PiVector(n + 0, n + 4, n + 5, n + 1));
                        vector3.addElement(new PiVector(n4, n3, n2, 2));
                    }
                    if (n3 == this.m_discr[1] || !blArray[n4][n3 + 1][n2]) {
                        vector2.addElement(new PiVector(n + 2, n + 3, n + 7, n + 6));
                        vector3.addElement(new PiVector(n4, n3, n2, 3));
                    }
                    if (n2 == 0 || !blArray[n4][n3][n2 - 1]) {
                        vector2.addElement(new PiVector(n + 0, n + 2, n + 6, n + 4));
                        vector3.addElement(new PiVector(n4, n3, n2, 4));
                    }
                    if (n2 == this.m_discr[2] || !blArray[n4][n3][n2 + 1]) {
                        vector2.addElement(new PiVector(n + 1, n + 5, n + 7, n + 3));
                        vector3.addElement(new PiVector(n4, n3, n2, 5));
                    }
                    if (n4 == 0) {
                        if (n3 == 0) {
                            nArray2[n4][n3][n2] = this.randomColor(-1, -1);
                            continue;
                        }
                        nArray2[n4][n3][n2] = this.randomColor(nArray2[n4][n3 - 1][n2], -1);
                        continue;
                    }
                    nArray2[n4][n3][n2] = n3 == 0 ? this.randomColor(nArray2[n4 - 1][n3][n2], -1) : (nArray2[n4 - 1][n3][n2] == -1 ? this.randomColor(nArray2[n4][n3 - 1][n2], -1) : (nArray2[n4][n3 - 1][n2] == -1 ? this.randomColor(nArray2[n4 - 1][n3][n2], -1) : (n2 % 2 == 0 ? this.randomColor(nArray2[n4 - 1][n3][n2], nArray2[n4][n3 - 1][n2]) : this.randomColor(nArray2[n4][n3 - 1][n2], nArray2[n4 - 1][n3][n2]))));
                }
            }
        }
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        n3 = vector.size();
        n2 = vector2.size();
        pgElementSet.setNumVertices(n3);
        for (n = 0; n < n3; ++n) {
            pgElementSet.setVertex(n, (PdVector)vector.elementAt(n));
        }
        pgElementSet.setNumElements(n2);
        pgElementSet.setDimOfElements(4);
        pgElementSet.assureElementColors();
        pgElementSet.assureElementTextures();
        PgTexture pgTexture = new PgTexture();
        String string = PsConfig.getInstBase();
        if (PuString.isEmpty((String)string)) {
            string = PsConfig.getCodeBase();
        }
        pgTexture.setImageName(string + m_defBlocks);
        Image image = PsImage.getImage((String)pgTexture.getImageName());
        Frame frame = PsConfig.getFrame();
        if (!PsImage.loadImage((Component)frame, (Image)image)) {
            PsDebug.warning((String)("failed loading image = " + pgTexture.getImageName()));
        }
        pgTexture.setImage(image);
        if (image == null) {
            PsDebug.warning((String)"loading default texture failed, use texture panel.");
        }
        pgElementSet.setTexture(pgTexture);
        for (int i = 0; i < n2; ++i) {
            pgElementSet.setElement(i, (PiVector)vector2.elementAt(i));
            int[] nArray3 = ((PiVector)vector3.elementAt((int)i)).m_data;
            int n5 = nArray2[nArray3[0]][nArray3[1]][nArray3[2]];
            pgElementSet.setElementColor(i, COLOR_TABLE[n5]);
            double[] dArray = Y_COORDS[nArray3[3]];
            double d = 0.2 * (double)n5;
            PdVector[] pdVectorArray = new PdVector[]{new PdVector(d, dArray[0]), new PdVector(d, dArray[1]), new PdVector(d + 0.2, dArray[1]), new PdVector(d + 0.2, dArray[0])};
            pgElementSet.setElementTexture(i, pdVectorArray);
        }
        pgElementSet.showElementTexture(true);
        pgElementSet.showElementColors(true);
        pgElementSet.makeNeighbour();
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        PuCleanMesh.identifyVertices((PgPointSet)pgElementSet, (double)1.0E-10);
    }

    public boolean[][][] getUsedBlocks(int[][] nArray) {
        boolean[][][] blArray = new boolean[this.m_discr[0] + 1][this.m_discr[1] + 1][this.m_discr[2] + 1];
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        int n = pgElementSet.getNumElements();
        int[][] nArrayArray = new int[3][];
        int[] nArray2 = new int[3];
        int[][] nArrayArray2 = new int[3][];
        boolean[][][] blArray2 = new boolean[2][2][2];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4;
            PiVector piVector = pgElementSet.getElement(i);
            for (n4 = 0; n4 < 3; ++n4) {
                nArray2[n4] = 0;
            }
            for (n4 = 0; n4 < 3; ++n4) {
                nArrayArray[n4] = nArray[piVector.m_data[n4]];
                nArrayArray2[n4] = new int[3];
                for (n3 = 0; n3 < 3; ++n3) {
                    int n5 = n3;
                    nArray2[n5] = nArray2[n5] + nArrayArray[n4][n3];
                }
            }
            for (n4 = 0; n4 < 3; ++n4) {
                int n6 = n4;
                nArray2[n6] = nArray2[n6] / 3;
                for (n3 = 0; n3 < 3; ++n3) {
                    nArrayArray2[n3][n4] = nArrayArray[n3][n4] - nArray2[n4];
                }
            }
            for (n4 = 0; n4 < 2; ++n4) {
                for (n3 = 0; n3 < 2; ++n3) {
                    for (n2 = 0; n2 < 2; ++n2) {
                        blArray2[n4][n3][n2] = false;
                    }
                }
            }
            for (n4 = 0; n4 < 3; ++n4) {
                blArray2[nArrayArray2[n4][0]][nArrayArray2[n4][1]][nArrayArray2[n4][2]] = true;
            }
            for (n4 = 0; n4 < 2; ++n4) {
                for (n3 = 0; n3 < 2; ++n3) {
                    for (n2 = 0; n2 < 2; ++n2) {
                        if (!blArray2[n4][n3][n2]) continue;
                        blArray[nArray2[0] + n4][nArray2[1] + n3][nArray2[2] + n2] = true;
                    }
                }
            }
        }
        return blArray;
    }

    private int[] getIntCoordinates(PdVector pdVector) {
        PdVector pdVector2 = PdVector.subNew((PdVector)pdVector, (PdVector)this.m_min);
        int[] nArray = new int[this.m_dim];
        for (int i = 0; i < this.m_dim; ++i) {
            while (this.m_cubeSize.m_data[i] * ((double)nArray[i] + 0.5) < pdVector2.m_data[i]) {
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
        }
        return nArray;
    }

    private PdVector getVertexFromInt(int[] nArray) {
        PdVector pdVector = new PdVector(this.m_dim);
        for (int i = 0; i < this.m_dim; ++i) {
            pdVector.m_data[i] = this.m_min.m_data[i] + (double)nArray[i] * this.m_cubeSize.m_data[i];
        }
        return pdVector;
    }

    private int randomColor(int n, int n2) {
        int n3 = COLOR_TABLE.length;
        int n4 = Math.abs(this.m_random.nextInt()) % n3;
        if (n2 != -1 && Math.abs(this.m_random.nextInt()) % 20 < 1) {
            n4 = n2;
        }
        if (n != -1 && Math.abs(this.m_random.nextInt()) % 2 < 1) {
            n4 = n;
        }
        return n4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

