/*
 * Decompiled with CFR 0.152.
 */
package jvx.curve;

import jv.function.PuFunction;
import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;

public class PgParmCurve
extends PgPolygon {
    protected static final String[] m_defFunction2D = new String[]{"cos(u)", "sin(2*u)"};
    protected static final String[] m_defFunction3D = new String[]{"cos(u)", "sin(2*u)", "u/5"};
    protected PuFunction m_function;
    protected PuDouble m_uMin;
    protected PuDouble m_uMax;
    protected PuInteger m_numPoints;
    protected PuInteger m_dimension;
    static /* synthetic */ Class class$jvx$curve$PgParmCurve;

    public PgParmCurve() {
        this(3);
    }

    public PgParmCurve(int n) {
        super(n);
        this.setTag(10);
        this.m_dimension = new PuInteger(PsConfig.getMessage((boolean)true, (int)54000, (String)"Dimension"), (PsUpdateIf)this);
        this.m_uMin = new PuDouble("u-" + PsConfig.getMessage((int)54000), (PsUpdateIf)this);
        this.m_uMax = new PuDouble("u-" + PsConfig.getMessage((int)54001), (PsUpdateIf)this);
        this.m_numPoints = new PuInteger(PsConfig.getMessage((int)54002), (PsUpdateIf)this);
        this.m_function = new PuFunction(1, n);
        this.m_function.setName(PsConfig.getMessage((int)15044));
        this.m_function.setParent((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$curve$PgParmCurve == null ? (class$jvx$curve$PgParmCurve = PgParmCurve.class$("jvx.curve.PgParmCurve")) : class$jvx$curve$PgParmCurve)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.showVertices(false);
        this.setGlobalEdgeSize(2.0);
        int n = this.getDimOfVertices();
        this.m_dimension.setDefBounds(2, 3, 1, 1);
        this.m_dimension.setDefValue(n);
        this.m_dimension.setValue(n);
        this.m_dimension.init();
        if (n == 2) {
            this.m_uMin.setDefBounds(0.0, Math.PI * 2, 0.1, 1.0);
            this.m_uMin.setDefValue(0.0);
            this.m_uMin.init();
            this.m_uMax.setDefBounds(0.0, Math.PI * 2, 0.1, 1.0);
            this.m_uMax.setDefValue(Math.PI * 2);
            this.m_uMax.init();
            this.m_numPoints.setDefBounds(2, 300, 1, 5);
            this.m_numPoints.setDefValue(100);
            this.m_numPoints.init();
            this.setFunctionExpressions(m_defFunction2D);
        } else {
            this.m_uMin.setDefBounds(-10.0, 0.0, 0.1, 5.0);
            this.m_uMin.setDefValue(Math.PI * -2);
            this.m_uMin.init();
            this.m_uMax.setDefBounds(0.0, 10.0, 0.1, 5.0);
            this.m_uMax.setDefValue(Math.PI * 2);
            this.m_uMax.init();
            this.m_numPoints.setDefBounds(2, 300, 1, 5);
            this.m_numPoints.setDefValue(200);
            this.m_numPoints.init();
            this.setFunctionExpressions(m_defFunction3D);
        }
        this.computeCurve();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (object == this.m_function) {
            this.computeCurve();
            return super.update((Object)this);
        }
        if (object == this.m_dimension) {
            this.setDimOfVertices(this.m_dimension.getValue());
            return true;
        }
        if (object == this.m_numPoints) {
            if (this.m_numPoints.getValue() <= 1) {
                this.m_numPoints.setValue(2);
            }
            this.computeCurve();
            return super.update((Object)this);
        }
        if (object == this.m_uMin) {
            if (this.m_uMin.getValue() > this.m_uMax.getValue()) {
                this.m_uMax.setValue(this.m_uMin.getValue());
            } else {
                this.computeCurve();
            }
            return super.update((Object)this);
        }
        if (object == this.m_uMax) {
            if (this.m_uMax.getValue() < this.m_uMin.getValue()) {
                this.m_uMin.setValue(this.m_uMax.getValue());
            } else {
                this.computeCurve();
            }
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public boolean computeCurve() {
        int n = this.m_numPoints.getValue();
        double d = this.m_uMin.getValue();
        double d2 = (this.m_uMax.getValue() - d) / (double)(n - 1);
        this.setNumVertices(n);
        double[] dArray = new double[1];
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        int n2 = 0;
        dArray[0] = d;
        for (int i = 0; i < n; ++i) {
            this.m_function.eval(pdVector.m_data, dArray);
            this.setVertex(n2, pdVector);
            ++n2;
            dArray[0] = dArray[0] + d2;
        }
        return true;
    }

    public void setDimOfVertices(int n) {
        if (this.m_dimension != null) {
            this.m_dimension.setValue(n);
        }
        super.setDimOfVertices(n);
        if (this.m_function != null) {
            this.m_function.setNumFunctions(n);
            String[] stringArray = n == 2 ? m_defFunction2D : m_defFunction3D;
            this.setFunctionExpressions(stringArray);
            this.init();
            this.m_function.update((Object)this.m_function);
        }
    }

    public boolean setFunction(PuFunction puFunction) {
        if (puFunction == null) {
            PsDebug.warning((String)"missing function");
            return false;
        }
        if (puFunction.getNumFunctions() != this.m_dimension.getValue()) {
            PsDebug.warning((String)"number of functions different than dimension.");
            return false;
        }
        this.m_function = puFunction;
        this.m_function.setParent((PsUpdateIf)this);
        return true;
    }

    public boolean setFunctionExpressions(String[] stringArray) {
        if (stringArray == null) {
            PsDebug.warning((String)"missing function expressions");
            return false;
        }
        if (stringArray.length != this.m_dimension.getValue()) {
            PsDebug.warning((String)"number of function expressions different than dimension.");
            return false;
        }
        int n = this.m_dimension.getValue();
        for (int i = 0; i < n; ++i) {
            this.m_function.setExpression(i, stringArray[i]);
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

