/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.SliderEvent;
import debuxter.SliderEventMulticaster;
import debuxter.SliderListener;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Slider
extends Canvas
implements MouseListener,
MouseMotionListener {
    private static final int THUMB_SIZE = 14;
    private static final int BUFFER = 2;
    private static final int DEFAULT_WIDTH = 100;
    private static final int DEFAULT_HEIGHT = 15;
    private static final int MIN_WIDTH = 34;
    private static final int MIN_HEIGHT = 6;
    private static final int DEFAULT_MIN = 0;
    private static final int DEFAULT_MAX = 100;
    public static final int PERCENTAGE = 1;
    public static final int SLIDERVALUE = 2;
    static final long serialVersionUID = 20060308L;
    int base = 1;
    int maxValue = 100;
    int minValue = 0;
    Color bgColor;
    Color thumbColor;
    Color barColor;
    Color slashColor;
    int value;
    double percent;
    double sliderMaxValue = this.maxValue;
    double sliderMinValue = this.minValue;
    int minThumbPos;
    int maxThumbPos;
    int thumbPos;
    Image offScreenImage = null;
    Graphics offGraphics;
    int preValue;
    boolean sliderChangedFlag = false;
    int dispMode = 1;
    protected SliderListener sliderListener;

    public static void main(String[] args) {
        Frame f = new Frame();
        Slider s = new Slider();
        s.setSliderRange(-100.001, 302.345);
        s.setSliderValue(0.0);
        f.setLayout(new BorderLayout());
        f.add("Center", s);
        f.setSize(200, 50);
        f.setVisible(true);
    }

    public Slider() {
        this.setSize(100, 15);
        this.bgColor = Color.lightGray;
        this.thumbColor = Color.lightGray;
        this.barColor = Color.lightGray.darker();
        this.slashColor = Color.black;
        this.setValue(this.minValue);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = color;
        this.repaint();
    }

    public void setThumbColor(Color color) {
        this.thumbColor = color;
        this.repaint();
    }

    public void setBarColor(Color color) {
        this.barColor = color;
        this.repaint();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.minThumbPos = 16;
        this.maxThumbPos = width - 14 - 2 - 1;
        this.adjustThumbPos();
    }

    public void setSlashColor(Color color) {
        this.slashColor = color;
        this.repaint();
    }

    public void setWidth(int w) {
        if (w < 34) {
            w = 34;
        }
        this.setSize(w, this.getSize().height);
        this.repaint();
    }

    public void setHeight(int h) {
        if (h < 6) {
            h = 6;
        }
        this.setSize(this.getSize().width, h);
        this.repaint();
    }

    public void adjustThumbPos() {
        double valDeta = this.maxValue - this.minValue;
        double thumbDeta = this.maxThumbPos - this.minThumbPos;
        this.thumbPos = (int)(Math.round(Math.abs((double)(this.value - this.minValue) / valDeta) * thumbDeta) + (long)this.minThumbPos);
    }

    public void setBaseValue(int val) {
        this.base = val;
        this.repaint();
    }

    public void setDispMode(int val) {
        this.dispMode = val;
        this.repaint();
    }

    public void setSliderRange(double min, double max) {
        this.sliderMaxValue = max;
        this.sliderMinValue = min;
    }

    public void setSliderValue(double val) {
        double ratio = (val - this.sliderMinValue) / (this.sliderMaxValue - this.sliderMinValue);
        int retVal = (int)(ratio * (double)(this.maxValue - this.minValue + 1));
        this.setValue(retVal += this.minValue);
    }

    public double getSliderValue() {
        double delta = this.sliderMaxValue - this.sliderMinValue;
        return this.sliderMinValue + delta * this.getRatio();
    }

    public void setValue(int val) {
        if (val < this.minValue) {
            val = this.minValue;
        }
        if (val > this.maxValue) {
            val = this.maxValue;
        }
        this.value = val;
        this.adjustThumbPos();
        this.repaint();
    }

    public int getValue() {
        return this.value;
    }

    public double getRatio() {
        double retVal = (float)(this.value - this.minValue) / (float)(this.maxValue - this.minValue);
        return retVal;
    }

    public void setMaximum(int num) {
        this.maxValue = num;
        if (this.maxValue < this.minValue) {
            int tmp = this.minValue;
            this.minValue = this.maxValue;
            this.maxValue = tmp;
        }
        this.selfChangedValue();
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public void setMinimum(int num) {
        this.minValue = num;
        if (this.maxValue < this.minValue) {
            int tmp = this.minValue;
            this.minValue = this.maxValue;
            this.maxValue = tmp;
        }
        this.selfChangedValue();
    }

    public int getMinimum() {
        return this.minValue;
    }

    public void selfChangedValue() {
        this.setValue(this.value);
    }

    protected String valString() {
        String valStr;
        if (this.dispMode == 1) {
            valStr = String.valueOf(this.value * this.base);
            valStr = valStr + "%";
        } else {
            valStr = String.valueOf((int)Math.round(this.getSliderValue()));
        }
        return valStr;
    }

    @Override
    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offScreenImage == null) {
            this.offScreenImage = d.width * d.height < 80000 ? this.createImage(800, 100) : this.createImage(d.width, d.height);
            this.offGraphics = this.offScreenImage.getGraphics();
            this.offGraphics.setFont(this.getFont());
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(1, 1, d.width - 2, d.height - 2);
        this.offGraphics.setColor(this.getForeground());
        this.paint(this.offGraphics);
        g.drawImage(this.offScreenImage, 0, 0, null);
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.setColor(this.bgColor);
        g.setColor(this.barColor);
        g.fill3DRect(0, 0, w, h, false);
        g.setColor(this.thumbColor);
        g.fill3DRect(this.thumbPos - 14, 2, 29, h - 4, true);
        g.setColor(this.slashColor);
        g.drawLine(this.thumbPos, 3, this.thumbPos, h - 4);
        g.setColor(Color.red);
        FontMetrics fm = g.getFontMetrics();
        String v = this.valString();
        int hw = fm.stringWidth(v);
        int vh = fm.getHeight();
        g.drawString(v, this.thumbPos - hw / 2, h / 2 + vh / 2);
    }

    public void handleMouseEvent(int x) {
        int w = this.getSize().width;
        this.thumbPos = Math.max(x, this.minThumbPos);
        this.thumbPos = Math.min(this.thumbPos, this.maxThumbPos);
        this.percent = this.thumbPos > this.minThumbPos ? ((double)this.thumbPos - (double)this.minThumbPos) / (double)(this.maxThumbPos - this.minThumbPos) : 0.0;
        this.value = (int)Math.round(this.percent * (double)(this.maxValue - this.minValue)) + this.minValue;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int x = me.getX();
        this.handleMouseEvent(x);
        this.doMouseDown();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        int x = me.getX();
        this.handleMouseEvent(x);
        this.doMouseRelease();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int x = me.getX();
        this.handleMouseEvent(x);
        this.doMouseDrag();
    }

    public void doMouseDrag() {
    }

    public void doMouseDown() {
        this.sliderChangedFlag = false;
        this.preValue = this.getValue();
    }

    public void doMouseRelease() {
        this.setSliderChanged();
    }

    public boolean sliderChanged() {
        return this.sliderChangedFlag;
    }

    public void setSliderChanged() {
        this.sliderChangedFlag = true;
        this.postSliderEvent();
    }

    public void setSliderUnchanged() {
        this.sliderChangedFlag = false;
    }

    public synchronized void addSliderListener(SliderListener l) {
        this.sliderListener = SliderEventMulticaster.add(this.sliderListener, l);
    }

    public synchronized void removeSliderListener(SliderListener l) {
        this.sliderListener = SliderEventMulticaster.remove(this.sliderListener, l);
    }

    protected void postSliderEvent() {
        SliderEvent e = new SliderEvent(this, (int)this.getSliderValue());
        this.processEvent(e);
    }

    @Override
    protected void processEvent(AWTEvent evt) {
        if (evt instanceof SliderEvent) {
            if (this.sliderListener != null) {
                this.sliderListener.sliderStateChanged((SliderEvent)evt);
            }
        } else {
            super.processEvent(evt);
        }
    }
}

