/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.DoubleSlider;
import debuxter.SliderEvent;
import debuxter.SliderListener;
import debuxter.intSlider;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;

public class RecogniserSettings
extends Frame
implements ActionListener,
SliderListener {
    Hashtable<String, Number> properties = new Hashtable();
    intSlider lineTracerSpacingField;
    DoubleSlider pointFinderThreshField;
    static final long serialVersionUID = 20060308L;
    WindowAdapter winAd = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            RecogniserSettings.this.close();
        }
    };

    public RecogniserSettings() {
        this.setDefaults();
        this.makeDialog();
        this.setTitle("Dexter Recogniser Settings");
        this.setResizable(false);
    }

    private void setDefaults() {
        this.setIntProp("LineTracerSpacing", 0);
        this.setDoubleProp("PointFinderThresh", 0.15);
        this.setIntProp("blackThresh", 110);
        this.setIntProp("weightThresh", 50);
        if (this.isVisible()) {
            this.fillInValues();
        }
    }

    public void setProp(String key, Number ob) {
        this.properties.put(key, ob);
    }

    public void setIntProp(String key, int val) {
        this.setProp(key, new Integer(val));
    }

    public void setDoubleProp(String key, double val) {
        this.setProp(key, new Double(val));
    }

    public Object getProp(String key) {
        return this.properties.get(key);
    }

    public int getIntProp(String key) {
        return (Integer)this.getProp(key);
    }

    public double getDoubleProp(String key) {
        return (Double)this.getProp(key);
    }

    public void makeDialog() {
        Panel settings = new Panel();
        GridBagLayout layout = new GridBagLayout();
        Font baseFont = new Font("Helvetica", 0, 10);
        Font boldFont = new Font("Helvetica", 1, 10);
        this.setFont(baseFont);
        this.setLayout(new BorderLayout());
        settings.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        Label l = new Label("Line Tracer Settings");
        l.setFont(boldFont);
        c.gridy = 0;
        c.gridwidth = 0;
        c.anchor = 17;
        layout.setConstraints(l, c);
        settings.add(l);
        l = new Label("Point Spacing (0 for automatic):");
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        layout.setConstraints(l, c);
        settings.add(l);
        this.lineTracerSpacingField = new intSlider(0, 150, this.getIntProp("LineTracerSpacing"));
        this.lineTracerSpacingField.addSliderListener(this);
        c.gridwidth = 0;
        c.anchor = 17;
        layout.setConstraints(this.lineTracerSpacingField, c);
        settings.add(this.lineTracerSpacingField);
        l = new Label("Point Finder Settings");
        l.setFont(boldFont);
        c.gridy = 2;
        c.gridwidth = 0;
        c.anchor = 17;
        layout.setConstraints(l, c);
        settings.add(l);
        l = new Label("Distance Threshold:");
        c.gridy = 3;
        c.gridwidth = 1;
        c.anchor = 17;
        layout.setConstraints(l, c);
        settings.add(l);
        this.pointFinderThreshField = new DoubleSlider(0.0, 0.66, this.getDoubleProp("PointFinderThresh"));
        this.pointFinderThreshField.addSliderListener(this);
        c.gridwidth = 0;
        c.anchor = 17;
        layout.setConstraints(this.pointFinderThreshField, c);
        settings.add(this.pointFinderThreshField);
        settings.validate();
        this.add((Component)settings, "Center");
        Panel buts = new Panel();
        buts.setLayout(new FlowLayout());
        Button defaultsButton = new Button("Defaults");
        buts.add(defaultsButton);
        defaultsButton.addActionListener(this);
        Button closeButton = new Button("Close");
        buts.add(closeButton);
        closeButton.addActionListener(this);
        this.add((Component)buts, "South");
        this.pack();
    }

    public void fillInValues() {
        this.lineTracerSpacingField.setSliderValue(this.getIntProp("LineTracerSpacing"));
        this.pointFinderThreshField.setSliderValue(this.getDoubleProp("PointFinderThresh"));
    }

    public void open() {
        if (this.isShowing()) {
            return;
        }
        this.fillInValues();
        this.setVisible(true);
        this.validate();
        this.addWindowListener(this.winAd);
    }

    public void apply() {
        this.setProp("LineTracerSpacing", new Integer((int)Math.round(this.lineTracerSpacingField.getSliderValue())));
        this.setProp("PointFinderThresh", new Double(this.pointFinderThreshField.getSliderValue()));
    }

    public void close() {
        if (!this.isShowing()) {
            return;
        }
        this.setVisible(false);
        this.removeWindowListener(this.winAd);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Close") {
            this.close();
        }
        if (e.getActionCommand() == "Defaults") {
            this.setDefaults();
            this.fillInValues();
        }
    }

    @Override
    public void sliderStateChanged(SliderEvent e) {
        this.apply();
    }
}

