/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.AlertBox;
import debuxter.ByteGrabber;
import debuxter.ImageWithPoints;
import debuxter.RecogniserSettings;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class Recogniser
extends Thread {
    ImageWithPoints parent;
    Image im;
    int px_h;
    int px_w;
    int px_max;
    byte[] pixels;
    Image deb_buf;
    Graphics deb_gc;
    boolean debug = false;
    int blackThresh = 110;
    int weightThresh = 50;
    int axisLeft;
    int axisRight;
    int axisTop;
    int axisBottom;
    boolean stopMe = false;
    boolean haveCoos = false;
    RecogniserSettings settings;

    public abstract boolean putCoordinate(Point var1);

    protected abstract void recogniseIt() throws Exception;

    protected abstract boolean analyseIt() throws Exception;

    public Recogniser(ImageWithPoints parent, RecogniserSettings settings) {
        this.parent = parent;
        this.settings = settings;
        this.blackThresh = settings.getIntProp("blackThresh");
        this.weightThresh = settings.getIntProp("weightThresh");
    }

    protected final Rectangle findCB(int ind) {
        int pos = 0;
        int cumweight = 0;
        int y = ind / this.px_w;
        int maxweight = 0;
        if (this.pixels[ind] <= this.blackThresh) {
            while (ind < this.px_max) {
                if (this.pixels[ind] > this.blackThresh) {
                    ind -= this.px_w;
                    --y;
                    break;
                }
                ind += this.px_w;
                ++y;
            }
        }
        if (ind >= this.px_max) {
            ind -= this.px_w;
        }
        while (ind >= 0 && this.pixels[ind] <= this.blackThresh) {
            int weight = 127 - this.pixels[ind];
            if (weight > maxweight) {
                maxweight = weight;
            }
            pos += y * weight;
            cumweight += weight;
            ind -= this.px_w;
            --y;
        }
        if (maxweight > 120) {
            maxweight = 127;
        }
        return new Rectangle(cumweight, pos, maxweight, y);
    }

    protected final int[] findxCB(int ind) {
        int pos = 0;
        int cumweight = 0;
        int x = ind % this.px_w;
        int maxweight = 0;
        int xlimit = ind - ind % this.px_w;
        if (this.pixels[ind] <= this.blackThresh) {
            while (ind > xlimit) {
                if (this.pixels[ind] > this.blackThresh) {
                    ++ind;
                    ++x;
                    break;
                }
                --ind;
                --x;
            }
        }
        int leftx = x;
        xlimit += this.px_w;
        while (ind < xlimit && this.pixels[ind] <= this.blackThresh) {
            int weight = 127 - this.pixels[ind];
            if (weight > maxweight) {
                maxweight = weight;
            }
            pos += x * weight;
            cumweight += weight;
            ++ind;
            ++x;
        }
        if (maxweight > 120) {
            maxweight = 127;
        }
        return new int[]{cumweight, pos, maxweight, leftx, x};
    }

    protected boolean nextY(Point curpoint, int targy, int dx) {
        int y = curpoint.y;
        int maxweight = 0;
        int maxpos = 0;
        int maxblack = 0;
        int seenThrough = this.px_h;
        int whiteCount = 0;
        int whiteLim = 3;
        int inity = y;
        if (curpoint.x == this.px_w - 1 || curpoint.x == 0) {
            return false;
        }
        if (this.debug) {
            System.out.println("y target" + targy);
        }
        int ind = y * this.px_w + curpoint.x;
        while (ind < this.px_max) {
            whiteCount = this.pixels[ind] > this.blackThresh ? ++whiteCount : 0;
            if (whiteCount >= whiteLim) {
                ind -= this.px_w;
                --y;
                break;
            }
            ind += this.px_w;
            ++y;
        }
        while (ind > this.px_max) {
            ind -= this.px_w;
        }
        int blackHeight = 0;
        whiteCount = -1;
        while (ind > 0) {
            if (y < seenThrough) {
                whiteCount = this.pixels[ind] > this.blackThresh ? ++whiteCount : 0;
                if (whiteCount >= whiteLim) break;
                ++blackHeight;
                if (this.pixels[ind + dx] < this.blackThresh) {
                    Rectangle res = this.findCB(ind + dx);
                    seenThrough = res.height;
                    if (res.width > maxblack || res.width == maxblack && Math.abs(res.y / res.x - targy) < Math.abs(maxpos - targy)) {
                        maxweight = res.x;
                        maxpos = res.y / res.x;
                        maxblack = res.width;
                    }
                }
            }
            ind -= this.px_w;
            --y;
        }
        if (y > inity) {
            System.out.println("Didn't reach start point at x=" + curpoint.x);
        }
        if (blackHeight > this.px_h / 2 || maxweight / 100 > this.px_h / 2) {
            if (this.debug) {
                System.out.println("Axis Alert");
            }
            return false;
        }
        if (maxweight > this.weightThresh) {
            curpoint.y = maxpos;
            return true;
        }
        return false;
    }

    protected boolean nextX(Point curpoint, int targx, int dy) {
        int x = curpoint.x;
        int maxweight = 0;
        int maxpos = 0;
        int maxblack = 0;
        int seenThrough = 0;
        int whiteCount = 0;
        int whiteLim = 3;
        int initx = x;
        dy *= this.px_w;
        if (curpoint.y == this.px_h - 1 || curpoint.y == 0) {
            return false;
        }
        if (this.debug) {
            System.out.println("xt" + targx);
        }
        int ind = curpoint.y * this.px_w + x;
        int xlimit = ind % this.px_w;
        while (ind > xlimit) {
            whiteCount = this.pixels[ind] > this.blackThresh ? ++whiteCount : 0;
            if (whiteCount >= whiteLim) {
                ++ind;
                ++x;
                break;
            }
            --ind;
            --x;
        }
        xlimit = ind - ind % this.px_w + this.px_w;
        int blackWidth = 0;
        whiteCount = -1;
        while (ind < xlimit) {
            whiteCount = this.pixels[ind] > this.blackThresh ? ++whiteCount : 0;
            if (whiteCount >= whiteLim) break;
            ++blackWidth;
            if (x > seenThrough && this.pixels[ind + dy] < this.blackThresh) {
                int[] res = this.findxCB(ind + dy);
                seenThrough = res[4];
                if (res[2] > maxblack || res[2] == maxblack && Math.abs(res[1] / res[0] - targx) < Math.abs(maxpos - targx)) {
                    maxweight = res[0];
                    maxpos = res[1] / res[0];
                    maxblack = res[2];
                }
            }
            ++ind;
            ++x;
        }
        if (x < initx) {
            System.out.println("Didn't reach start point at y=" + curpoint.y);
        }
        if (blackWidth > this.px_w / 2 || maxweight / 100 > this.px_w / 2) {
            if (this.debug) {
                System.out.println("Axis Alert");
            }
            return false;
        }
        if (maxweight > this.weightThresh) {
            curpoint.x = maxpos;
            return true;
        }
        return false;
    }

    private int xwidth(int ind) {
        int w = 0;
        int limLeft = ind - ind % this.px_w;
        int limRight = limLeft + this.px_w;
        while (this.pixels[ind] < this.blackThresh && ind > limLeft) {
            --ind;
        }
        while (this.pixels[++ind] < this.blackThresh && ++ind < limRight) {
            ++w;
        }
        return w;
    }

    protected boolean analyse() throws Exception {
        int ind;
        int stopat;
        this.px_w = this.im.getWidth(this.parent);
        this.px_h = this.im.getHeight(this.parent);
        if (this.px_w == -1 || this.px_h == -1) {
            throw new Exception("Please wait until image \nis completely retrieved");
        }
        this.px_max = this.px_w * this.px_h;
        this.pixels = new ByteGrabber().retrievePixels(this.im, this.px_w, this.px_h);
        this.axisRight = this.px_w;
        this.axisBottom = this.px_h;
        this.axisLeft = 0;
        this.axisTop = 0;
        for (int ystart = this.px_h / 6; ystart < this.px_h; ystart += this.px_h / 6) {
            stopat = ystart * this.px_w + this.px_w / 4;
            for (ind = ystart * this.px_w; ind < stopat && this.pixels[ind] > this.blackThresh; ++ind) {
            }
            if (this.pixels[ind] > this.blackThresh) continue;
            Rectangle r = this.findCB(ind);
            if (r.width == 0 || r.x / r.width < this.px_h / 4) {
                r = this.findCB(++ind);
            }
            if (r.width == 0 || r.x / r.width <= this.px_h / 4) continue;
            int width = 0;
            while (this.pixels[ind] <= this.blackThresh) {
                ++width;
                ++ind;
            }
            this.axisLeft = ind % this.px_w + width;
            break;
        }
        for (int xstart = this.px_w / 6; xstart < this.px_w; xstart += this.px_w / 6) {
            stopat = (this.px_h - this.px_h / 4) * this.px_w;
            for (ind = xstart + (this.px_h - 1) * this.px_w; ind > stopat && this.pixels[ind] > this.blackThresh; ind -= this.px_w) {
            }
            if (this.pixels[ind] > this.blackThresh) continue;
            int w = this.xwidth(ind);
            if (w < this.px_w / 2) {
                w = this.xwidth(ind -= this.px_w);
            }
            if (w <= this.px_w / 2) continue;
            int height = 0;
            while (this.pixels[ind] <= this.blackThresh) {
                ++height;
                ind -= this.px_w;
            }
            this.axisBottom = ind / this.px_w - height;
            break;
        }
        int stopat2 = this.px_h / 2 * this.px_w - this.px_w / 4;
        for (ind = this.px_h / 2 * this.px_w - 1; ind > stopat2 && this.pixels[ind] > this.blackThresh; --ind) {
        }
        if (this.pixels[ind] <= this.blackThresh) {
            Rectangle r = this.findCB(ind);
            if (r.width == 0 || r.x / r.width < this.px_h / 4) {
                r = this.findCB(++ind);
            }
            if (r.width != 0 && r.x / r.width > this.px_h / 4) {
                int width = 0;
                while (this.pixels[ind] <= this.blackThresh) {
                    ++width;
                    --ind;
                }
                this.axisRight = ind % this.px_w - width;
            }
        }
        stopat2 = this.px_h / 4 * this.px_w;
        for (ind = this.px_w / 2; ind < stopat2 && this.pixels[ind] > this.blackThresh; ind += this.px_w) {
        }
        if (this.pixels[ind] <= this.blackThresh) {
            int w = this.xwidth(ind);
            if (w < this.px_w / 2) {
                w = this.xwidth(ind += this.px_w);
            }
            if (w > this.px_w / 2) {
                int height = 0;
                while (this.pixels[ind] <= this.blackThresh) {
                    ++height;
                    ind += this.px_w;
                }
                this.axisTop = ind / this.px_w + height;
            }
        }
        if (this.debug) {
            System.out.println("detected axis" + this.axisLeft + " " + this.axisRight + " " + this.axisTop + " " + this.axisBottom);
        }
        return this.analyseIt();
    }

    public synchronized void stopRecogniser() {
        this.stopMe = true;
        this.notify();
    }

    protected synchronized boolean waitForCoos() {
        if (this.haveCoos) {
            return true;
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        try {
            try {
                try {
                    if (!this.waitForCoos() || this.stopMe) {
                        throw new Exception("Ignore");
                    }
                    this.im = this.parent.getRecImage();
                    if (this.analyse()) {
                        if (this.stopMe) {
                            throw new Exception("Ignore");
                        }
                    } else {
                        throw new Exception("Could not find start object");
                    }
                    this.recogniseIt();
                    if (this.debug) {
                        System.out.println("Recogniser ends");
                    }
                }
                catch (OutOfMemoryError e) {
                    new AlertBox((Frame)this.parent.parent, "Recogniser failure", "Out of memory.\nPlease try recognising at a lower resolution");
                }
            }
            catch (Exception e) {
                if (!e.getMessage().equals("Ignore")) {
                    if (e.getClass().toString().equals("class java.lang.Exception")) {
                        new AlertBox((Frame)this.parent.parent, "Recogniser failure", e.getMessage());
                    } else {
                        new AlertBox((Frame)this.parent.parent, "Recogniser failure", e.toString() + "\nYou shouldn't get such an insensible message.\nPlease report how you managed to provoke it.");
                    }
                }
                e.printStackTrace();
            }
        }
        finally {
            this.parent.recogniserStopped();
        }
    }
}

