/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;

public class MagGlass
extends Canvas
implements ImageObserver {
    Image im;
    int sx0 = 0;
    int sy0 = 0;
    int sx = 21;
    int sy = 21;
    int imscale = 3;
    int fullx = this.sx * this.imscale;
    int fully = this.sy * this.imscale;
    int halfx = this.fullx / 2;
    int halfy = this.fully / 2;
    boolean active = false;
    Image bufferImage = null;
    Graphics bufGraphics = null;
    static final long serialVersionUID = 20060308L;
    MouseAdapter m = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            MagGlass.this.active = !MagGlass.this.active;
            MagGlass.this.repaint();
        }
    };

    public MagGlass() {
        this((Image)null);
    }

    public MagGlass(Image im) {
        this.im = im;
        this.addMouseListener(this.m);
    }

    public void setImage(Image im) {
        this.im = im;
    }

    @Override
    public synchronized boolean imageUpdate(Image targIm, int infoflags, int x, int y, int width, int height) {
        if (targIm != this.im) {
            return false;
        }
        if ((infoflags & 0x20) != 0) {
            this.repaint();
            return false;
        }
        return true;
    }

    public synchronized void setCoords(Point p) {
        this.sx0 = Math.max(p.x - this.sx / 2, 0);
        this.sy0 = Math.max(p.y - this.sy / 2, 0);
        if (!this.active) {
            return;
        }
        if (this.bufferImage == null) {
            this.bufferImage = this.createImage(this.sx, this.sy);
            if (this.bufferImage != null) {
                this.bufGraphics = this.bufferImage.getGraphics();
            }
        }
        if (this.bufGraphics == null) {
            return;
        }
        this.bufGraphics.drawLine(0, 0, this.sx, this.sy);
        this.bufGraphics.drawImage(this.im, 0, 0, this.sx, this.sy, this.sx0, this.sy0, this.sx0 + this.sx, this.sy0 + this.sy, this);
        this.repaint();
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (!this.active || this.im == null) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.fullx, this.fully);
            g.setColor(this.getForeground());
            int icD = Math.min(this.fullx, this.fully) / 3;
            Point ic0 = new Point(icD, icD);
            g.drawOval(ic0.x - icD / 2, ic0.y - icD / 2, icD, icD);
            g.drawOval(ic0.x - icD / 2, ic0.y - icD / 2, icD - 1, icD - 1);
            int sx = (int)Math.round((double)ic0.x + (double)(icD / 2) / 1.41);
            int sy = (int)Math.round((double)ic0.y + (double)(icD / 2) / 1.41);
            int ex = Math.round(ic0.x + icD);
            int ey = Math.round(ic0.y + icD);
            g.drawLine(sx, sy, ex, ey);
            g.drawLine(sx + 1, sy - 1, ex + 1, ey - 1);
            g.drawLine(sx - 1, sy + 1, ex - 1, ey + 1);
            return;
        }
        if (this.im != null) {
            if (this.bufferImage != null) {
                g.drawImage(this.bufferImage, 0, 0, this.fullx, this.fully, 0, 0, this.sx, this.sy, null);
            }
            g.setColor(Color.green);
            g.drawLine(this.halfx, 0, this.halfx, this.fully);
            g.drawLine(0, this.halfy, this.fullx, this.halfy);
        }
    }

    @Override
    public synchronized void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.fullx, this.fully);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

