/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.AlertBox;
import debuxter.DExtractor;
import debuxter.MainServices;
import debuxter.PlainDataDeliverer;
import debuxter.ScriptImageGetter;
import debuxter.ScrollImScrollBar;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

class Gaucho_w
extends Frame
implements MainServices,
ActionListener,
ComponentListener {
    DExtractor worker;
    String imageURL;
    int scale;
    ScrollImScrollBar sel;
    DExtractor window = null;
    String sourcebib;
    String sourcepage;
    boolean onIndexedDisplay = false;
    ScriptImageGetter imageGetter;
    PlainDataDeliverer dataDeliverer = new PlainDataDeliverer(this);
    static final long serialVersionUID = 20060308L;

    public Gaucho_w(String[] args) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Gaucho_w.this.dispose();
            }
        });
        this.addComponentListener(this);
        ColorModel colormodel = Toolkit.getDefaultToolkit().getColorModel();
        if (colormodel instanceof IndexColorModel) {
            this.onIndexedDisplay = true;
        }
        this.setTitle("Gaucho");
        this.makeMenu();
        this.imageGetter = new ScriptImageGetter(this, args[0]);
        this.sourcebib = args[0];
        this.sourcepage = "1";
        this.scale = 8;
        this.makeContents();
        this.notifyChangedSize();
    }

    protected void makeContents() {
        Image fullpg = this.imageGetter.getImage(this.scale);
        this.sel = new ScrollImScrollBar(this, fullpg, this.onIndexedDisplay);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.sel);
        this.validate();
        this.sel.doLayout();
    }

    protected void makeMenu() {
        MenuBar mb = new MenuBar();
        this.setMenuBar(mb);
        Menu fileMenu = new Menu("File");
        fileMenu.addActionListener(this);
        mb.add(fileMenu);
        MenuItem m = new MenuItem("Quit");
        m.setShortcut(new MenuShortcut(81, false));
        m.setActionCommand("Quit");
        fileMenu.add(m);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Quit") {
            this.closeChild();
            System.exit(0);
        }
    }

    protected void closeChild() {
        if (this.window != null) {
            if (this.window.isShowing()) {
                this.window.closeWin();
            }
            this.window = null;
        }
    }

    @Override
    public void notifySelection(Rectangle bbox) {
        if (bbox.width < 50 || bbox.height < 50) {
            return;
        }
        this.closeChild();
        bbox.x *= this.scale;
        bbox.y *= this.scale;
        bbox.width *= this.scale;
        bbox.height *= this.scale;
        try {
            this.window = new DExtractor(this, bbox, this.sourcebib, this.sourcepage, this.imageGetter, this.dataDeliverer);
        }
        catch (NullPointerException ex) {
            new AlertBox((Frame)this, "Gaucho Error Message", "Image retrieval failed.  Check convert.log.");
            return;
        }
        this.window.setTitle("Dexter");
        this.window.pack();
        this.window.setVisible(true);
    }

    @Override
    public void childClosed() {
        this.window = null;
    }

    @Override
    public void showHelp() {
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.sel == null) {
            return new Dimension(400, 400);
        }
        Dimension ps = this.sel.getPreferredSize();
        Insets insets = this.getInsets();
        return new Dimension((int)(ps.getWidth() + (double)insets.left + (double)insets.right), (int)(ps.getHeight() + (double)insets.top + (double)insets.bottom));
    }

    public void resizeToPreferredSize() {
        Dimension ps = this.getPreferredSize();
        Dimension screens = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension newSize = new Dimension(Math.min(screens.width - 40, Math.max(400, ps.width)), Math.min(screens.height - 40, Math.max(400, ps.height)));
        this.setSize(newSize);
        this.validate();
        this.repaint();
        if (this.isShowing() && this.getLocation().y < 10) {
            this.setLocation(20, 40);
        }
    }

    @Override
    public void notifyChangedSize() {
        this.resizeToPreferredSize();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.notifyChangedSize();
    }
}

