/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.PointFinder;
import java.awt.Point;
import java.awt.Rectangle;

class Feature {
    byte[] tPixels;
    int tWidth;
    int tHeight;
    int[] hheights;
    int[] vwidths;
    int maxWidth;
    int maxHeight;
    Point markPos;
    boolean debug = false;
    int blackThresh;

    public Feature(Rectangle bbox, PointFinder parent) {
        this(bbox, parent, 0);
    }

    public Feature(Rectangle bbox, PointFinder parent, int pad) {
        bbox.x -= pad;
        bbox.y -= pad;
        bbox.width += 2 * pad;
        bbox.height += 2 * pad;
        this.tWidth = bbox.width;
        this.tHeight = bbox.height;
        this.tPixels = new byte[this.tWidth * this.tHeight];
        this.blackThresh = parent.blackThresh;
        this.collect(bbox, parent.pixels, parent.px_w, parent.px_h);
        this.computeProps();
    }

    public void collect(Rectangle bbox, byte[] pixels, int px_w, int px_h) {
        for (int y = 0; y < bbox.height; ++y) {
            int ind = (bbox.y + y) * px_w + bbox.x;
            int x = 0;
            while (x < bbox.width) {
                if (pixels[ind] < 0) {
                    this.tPixels[x + y * bbox.width] = (byte)(-pixels[ind] - 1);
                    pixels[ind] = 127;
                } else {
                    this.tPixels[x + y * bbox.width] = 127;
                }
                ++x;
                ++ind;
            }
        }
    }

    private void computeWidths() {
        this.vwidths = new int[this.tHeight];
        this.maxWidth = 0;
        for (int i = 0; i < this.tHeight; ++i) {
            int ind;
            int stopat = (i + 1) * this.tWidth;
            for (ind = i * this.tWidth; ind < stopat && this.tPixels[ind] > this.blackThresh; ++ind) {
            }
            int left = ind % this.tWidth;
            stopat = i * this.tWidth;
            for (ind = (i + 1) * this.tWidth - 1; ind > stopat && this.tPixels[ind] > this.blackThresh; --ind) {
            }
            int right = ind % this.tWidth;
            int tmp = left < right ? right - left + 1 : 0;
            if (tmp > this.maxWidth) {
                this.maxWidth = tmp;
            }
            this.vwidths[i] = tmp;
        }
    }

    private void computeHeights() {
        this.hheights = new int[this.tWidth];
        this.maxHeight = 0;
        for (int i = 0; i < this.tWidth; ++i) {
            int ind;
            int stopat = this.tHeight * this.tWidth;
            for (ind = i; ind < stopat && this.tPixels[ind] > this.blackThresh; ind += this.tWidth) {
            }
            int upper = ind / this.tWidth;
            stopat = 0;
            for (ind = this.tWidth * (this.tHeight - 1) + i; ind >= stopat && this.tPixels[ind] > this.blackThresh; ind -= this.tWidth) {
            }
            int lower = ind / this.tWidth;
            int tmp = upper < lower ? lower - upper + 1 : 0;
            if (tmp > this.maxHeight) {
                this.maxHeight = tmp;
            }
            this.hheights[i] = tmp;
        }
    }

    int getErrbarWidth(int[] widthary) {
        int mean = 0;
        int maxWidth = 0;
        for (int i = 0; i < widthary.length; ++i) {
            mean += widthary[i];
            if (widthary[i] <= maxWidth) continue;
            maxWidth = widthary[i];
        }
        mean = Math.round((float)mean / (float)widthary.length);
        ++mean;
        int aboveMean = 0;
        int belowMean = 0;
        for (int i = 0; i < widthary.length; ++i) {
            if (widthary[i] < mean) {
                ++belowMean;
                continue;
            }
            ++aboveMean;
        }
        if (belowMean <= 2 * aboveMean) {
            return -1;
        }
        int errMeanNumer = 0;
        int errMeanDenom = 0;
        for (int i = 0; i < widthary.length; ++i) {
            if (widthary[i] >= mean) continue;
            errMeanNumer += widthary[i];
            ++errMeanDenom;
        }
        if (errMeanDenom == 0) {
            return -1;
        }
        int errBarWidth = Math.round((float)errMeanNumer / (float)errMeanDenom);
        if (errBarWidth > maxWidth / 2) {
            return -1;
        }
        return errBarWidth;
    }

    protected int[] findBlob(int[] widthary) {
        int errbarWidth = this.getErrbarWidth(widthary);
        if (errbarWidth < 1) {
            return new int[]{0, widthary.length};
        }
        int maxPos = 0;
        int maxVal = -1;
        for (int i = 0; i < widthary.length; ++i) {
            if (widthary[i] <= maxVal) continue;
            maxPos = i;
            maxVal = widthary[i];
        }
        int featureLimit = Math.max(widthary.length / 15, 2);
        int errbarLimit = errbarWidth + (maxVal - errbarWidth) / 4;
        int left = Math.max(0, maxPos - 1);
        for (int curPos = maxPos - 1; curPos >= 0 && left - curPos <= featureLimit; --curPos) {
            if (widthary[curPos] <= errbarLimit) continue;
            left = curPos;
        }
        int right = Math.min(widthary.length, maxPos + 1);
        for (int curPos = maxPos + 1; curPos < widthary.length && curPos - right <= featureLimit; ++curPos) {
            if (widthary[curPos] <= errbarLimit) continue;
            right = curPos;
        }
        return new int[]{left, right};
    }

    private void computeMarkPos() {
        int meanNum = 0;
        int meanDenom = 0;
        int[] dd = this.findBlob(this.vwidths);
        int limit = this.maxWidth - this.maxWidth / 2;
        for (int i = dd[0]; i < dd[1]; ++i) {
            if (this.vwidths[i] < limit) continue;
            meanNum += i * this.vwidths[i];
            meanDenom += this.vwidths[i];
        }
        int yofs = Math.round((float)meanNum / (float)meanDenom);
        meanNum = 0;
        meanDenom = 0;
        limit = this.maxHeight - this.maxHeight / 2;
        dd = this.findBlob(this.hheights);
        for (int i = dd[0]; i < dd[1]; ++i) {
            if (this.hheights[i] < limit) continue;
            meanNum += i * this.hheights[i];
            meanDenom += this.hheights[i];
        }
        int xofs = Math.round((float)meanNum / (float)meanDenom);
        this.markPos = new Point(xofs, yofs);
    }

    protected void computeProps() {
        this.computeWidths();
        this.computeHeights();
        this.computeMarkPos();
    }
}

