/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.AffineTrafo;
import debuxter.AlertBox;
import debuxter.CantComputeException;
import debuxter.DataDeliverer;
import debuxter.Datapoint;
import debuxter.DoublePoint;
import debuxter.Fmt;
import debuxter.GaugeGauge;
import debuxter.ImageGetter;
import debuxter.ImageWithPoints;
import debuxter.MagGlass;
import debuxter.MainServices;
import debuxter.MissingData;
import debuxter.QuickSort;
import debuxter.RecogniserSettings;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class DExtractor
extends Frame
implements ActionListener,
ComponentListener {
    ImageWithPoints imzone;
    ImageGetter imageGetter;
    DataDeliverer dataDeliverer;
    GaugeGauge hgg;
    GaugeGauge vgg;
    MainServices myparent;
    Color hcolor;
    Color vcolor;
    boolean recogniserRunning = false;
    boolean statusLocked = false;
    Vector<Component> criticalComponents = new Vector();
    Vector<MenuItem> criticalMenuItems = new Vector();
    TextArea results;
    Steeringstuff apanel;
    MagGlass magGlass;
    ScrollPane scrollp = new ScrollPane(1);
    Panel helppanel = new Panel();
    Label rulerLabel;
    TextField fnamefield;
    MenuItem stopRecogniserItem;
    RecogniserSettings recSettings = new RecogniserSettings();
    Rectangle bbox;
    String datasetName;
    String targetFName;
    int scale = 3;
    static final long serialVersionUID = 20060308L;
    AffineTrafo transformation = null;

    DExtractor(MainServices parent, Rectangle bbox, String sourcebib, String sourcepage, ImageGetter imageGetter, DataDeliverer dataDeliverer, Color xAxisColor, Color yAxisColor) {
        this.datasetName = "# Graph from " + sourcebib + ", page " + sourcepage;
        this.targetFName = sourcebib + "." + sourcepage;
        this.imageGetter = imageGetter;
        this.myparent = parent;
        this.bbox = bbox;
        this.dataDeliverer = dataDeliverer;
        this.hcolor = xAxisColor;
        this.vcolor = yAxisColor;
        this.addComponentListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                DExtractor.this.closeWin();
            }
        });
        this.makeDialog();
        this.makeMenu();
        this.imzone.setImage(imageGetter.getImage(this.scale, bbox));
    }

    DExtractor(MainServices parent, Rectangle bbox, String sourcebib, String sourcepage, ImageGetter imageGetter, DataDeliverer dataDeliverer) {
        this(parent, bbox, sourcebib, sourcepage, imageGetter, dataDeliverer, new Color(255, 0, 0), new Color(0, 0, 255));
    }

    protected void makeMenu() {
        MenuBar mb = new MenuBar();
        this.setMenuBar(mb);
        Menu fileMenu = new Menu("File");
        mb.add(fileMenu);
        MenuItem m = new MenuItem("Show Data");
        fileMenu.add(m);
        this.criticalMenuItems.addElement(m);
        m = new MenuItem("Send Data");
        fileMenu.add(m);
        this.criticalMenuItems.addElement(m);
        m = new MenuItem("Save Data");
        fileMenu.add(m);
        this.criticalMenuItems.addElement(m);
        fileMenu.addSeparator();
        m = new MenuItem("Close");
        m.setShortcut(new MenuShortcut(87, false));
        m.setActionCommand("Close");
        fileMenu.add(m);
        fileMenu.addActionListener(this);
        Menu zoomMenu = new Menu("Zoom");
        mb.add(zoomMenu);
        m = new MenuItem("600 dpi");
        zoomMenu.add(m);
        this.criticalMenuItems.addElement(m);
        m = new MenuItem("300 dpi");
        zoomMenu.add(m);
        this.criticalMenuItems.addElement(m);
        m = new MenuItem("200 dpi");
        zoomMenu.add(m);
        this.criticalMenuItems.addElement(m);
        m = new MenuItem("100 dpi");
        zoomMenu.add(m);
        this.criticalMenuItems.addElement(m);
        m = new MenuItem("75 dpi");
        zoomMenu.add(m);
        this.criticalMenuItems.addElement(m);
        zoomMenu.addActionListener(this);
        Menu recMenu = new Menu("Recognize");
        mb.add(recMenu);
        m = new MenuItem("Trace a Line");
        m.setShortcut(new MenuShortcut(84, false));
        m.setActionCommand("Trace a Line");
        recMenu.add(m);
        this.criticalMenuItems.addElement(m);
        m = new MenuItem("Find Points");
        m.setShortcut(new MenuShortcut(66, false));
        m.setActionCommand("Find Points");
        recMenu.add(m);
        this.criticalMenuItems.addElement(m);
        m = new MenuItem("Automatic Axes");
        m.setShortcut(new MenuShortcut(65, false));
        m.setActionCommand("Automatic Axes");
        recMenu.add(m);
        this.criticalMenuItems.addElement(m);
        recMenu.addSeparator();
        m = new MenuItem("Recognizer Settings");
        m.setShortcut(new MenuShortcut(83, false));
        m.setActionCommand("Recognizer Settings");
        recMenu.add(m);
        this.stopRecogniserItem = new MenuItem("Stop Recognizer");
        recMenu.add(this.stopRecogniserItem);
        this.stopRecogniserItem.setEnabled(false);
        recMenu.addSeparator();
        recMenu.add(new MenuItem("Delete all Points"));
        recMenu.addActionListener(this);
        Menu helpMenu = new Menu("Help");
        mb.setHelpMenu(helpMenu);
        helpMenu.add(new MenuItem("About Dexter"));
        helpMenu.add(new MenuItem("Help"));
        helpMenu.addActionListener(this);
    }

    protected void makeDialog() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Button[] actbuts = new Button[]{new Button("Help"), new Button("Show Data"), new Button("Send Data"), new Button("Save Data"), new Button("Close")};
        this.criticalComponents.addElement(actbuts[1]);
        this.criticalComponents.addElement(actbuts[2]);
        this.criticalComponents.addElement(actbuts[3]);
        this.setFont(new Font("Helvetica", 0, 10));
        this.apanel = new Steeringstuff(actbuts, 5, this);
        this.fnamefield = new TextField(this.targetFName, 20);
        this.setLayout(layout);
        this.magGlass = new MagGlass();
        this.hgg = new GaugeGauge("x", this.hcolor, false, this);
        this.vgg = new GaugeGauge("y", this.vcolor, true, this);
        this.results = new TextArea("", 9, 40);
        this.rulerLabel = new Label("        ");
        this.imzone = new ImageWithPoints(this, this.magGlass, this.recSettings);
        this.helppanel.setLayout(new GridBagLayout());
        c.fill = 1;
        c.gridy = 0;
        ((GridBagLayout)this.helppanel.getLayout()).setConstraints(this.apanel, c);
        this.helppanel.add(this.apanel);
        c.gridy = 1;
        ((GridBagLayout)this.helppanel.getLayout()).setConstraints(this.vgg, c);
        this.helppanel.add(this.vgg);
        c.gridy = 2;
        ((GridBagLayout)this.helppanel.getLayout()).setConstraints(this.magGlass, c);
        this.helppanel.add(this.magGlass);
        c.gridheight = 3;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 11;
        layout.setConstraints(this.helppanel, c);
        this.add(this.helppanel);
        c.anchor = 10;
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        layout.setConstraints(this.scrollp, c);
        this.add(this.scrollp);
        this.scrollp.add(this.imzone);
        c.fill = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 1;
        layout.setConstraints(this.hgg, c);
        this.add(this.hgg);
        Panel zwp = new Panel();
        Label lab = new Label("File name:");
        zwp.add(lab);
        zwp.add(this.fnamefield);
        c.gridx = 2;
        this.add(zwp);
        c.fill = 2;
        c.gridx = 1;
        c.gridwidth = 0;
        c.gridy = 2;
        layout.setConstraints(this.results, c);
        this.add(this.results);
        c.fill = 2;
        c.gridx = 1;
        c.gridwidth = 0;
        c.gridy = 3;
        c.gridx = 0;
        this.rulerLabel.setBackground(Color.white);
        layout.setConstraints(this.rulerLabel, c);
        this.add(this.rulerLabel);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Math.max(this.magGlass.getPreferredSize().width, this.apanel.getPreferredSize().width) + this.imzone.getPreferredSize().width + 20, Math.max(this.helppanel.getPreferredSize().height + 20, this.imzone.getPreferredSize().height + 40) + this.hgg.getPreferredSize().height + this.results.getPreferredSize().height + 40 + this.rulerLabel.getPreferredSize().height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(600, 400);
    }

    public synchronized void resizeToPreferredSize() {
        Dimension pS = this.getPreferredSize();
        Dimension screenS = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(Math.min(screenS.width - 40, Math.max(600, pS.width)), Math.min(screenS.height - 40, Math.max(400, pS.height))));
        this.validate();
        this.repaint();
        if (this.isShowing() && this.getLocation().y < 10) {
            this.setLocation(20, 40);
        }
    }

    private void newimagescale(int newscale) {
        this.imzone.newScale(this.scale, newscale);
        Image im = this.imageGetter.getImage(newscale, this.bbox);
        this.imzone.setImage(im);
        this.magGlass.setImage(im);
        this.scale = newscale;
        this.resizeToPreferredSize();
    }

    public void closeWin() {
        this.setVisible(false);
        if (this.recSettings.isShowing()) {
            this.recSettings.close();
        }
        this.myparent.childClosed();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Close") {
            this.closeWin();
        }
        if (e.getActionCommand() == "75 dpi") {
            this.newimagescale(8);
        }
        if (e.getActionCommand() == "100 dpi") {
            this.newimagescale(6);
        }
        if (e.getActionCommand() == "200 dpi") {
            this.newimagescale(3);
        }
        if (e.getActionCommand() == "300 dpi") {
            this.newimagescale(2);
        }
        if (e.getActionCommand() == "600 dpi") {
            this.newimagescale(1);
        }
        if (e.getActionCommand() == "Show Data" || e.getActionCommand() == "Send Data" || e.getActionCommand() == "Save Data") {
            try {
                this.makedata();
            }
            catch (CantComputeException exc) {
                return;
            }
            if (e.getActionCommand() == "Save Data") {
                this.dataDeliverer.deliver(this.results.getText(), this.fnamefield.getText(), 1);
            }
            if (e.getActionCommand() == "Send Data") {
                this.dataDeliverer.deliver(this.results.getText(), this.fnamefield.getText(), 0);
            }
        }
        if (e.getActionCommand() == "Help") {
            this.myparent.showHelp();
        }
        if (e.getActionCommand() == "About Dexter") {
            new AlertBox((Frame)this, "About Dexter", "Dexter -- Data extraction applet\nRelease 0.49\nA part of the NASA Astrophysics Data System\nhttp://adswww.harvard.edu\n");
        }
        if (e.getActionCommand() == "Trace a Line") {
            this.startRecogniser("LineTracer");
        }
        if (e.getActionCommand() == "Find Points") {
            this.startRecogniser("PointFinder");
        }
        if (e.getActionCommand() == "Automatic Axes") {
            this.startRecogniser("AxisFinder");
        }
        if (e.getActionCommand() == "Recognizer Settings") {
            this.recSettings.open();
        }
        if (e.getActionCommand() == "Stop Recognizer") {
            this.stopRecogniser();
        }
        if (e.getActionCommand() == "Delete all Points") {
            this.imzone.delAllPoints();
        }
    }

    protected void enableCritical(boolean enable) {
        Iterator<Serializable> it = this.criticalComponents.iterator();
        while (it.hasNext()) {
            it.next().setEnabled(enable);
        }
        it = this.criticalMenuItems.iterator();
        while (it.hasNext()) {
            ((MenuItem)it.next()).setEnabled(enable);
        }
    }

    protected synchronized void startRecogniser(String recName) {
        if (!this.imzone.startRecogniser(recName)) {
            new AlertBox((Frame)this, "Dexter Error Message", "Unknown Recognizer or\nrecognizer already running.");
            return;
        }
        this.recogniserRunning = true;
        this.enableCritical(false);
        this.stopRecogniserItem.setEnabled(true);
    }

    synchronized void recogniserStopped() {
        this.recogniserRunning = false;
        this.stopRecogniserItem.setEnabled(false);
        this.enableCritical(true);
    }

    synchronized void stopRecogniser() {
        if (this.recogniserRunning) {
            this.imzone.stopRecogniser();
        }
        this.recogniserStopped();
    }

    protected void computeTransform() throws CantComputeException {
        try {
            this.transformation = new AffineTrafo(this.imzone.hgauge.start, this.imzone.vgauge.start, this.imzone.hgauge.end, this.imzone.vgauge.end, this.hgg.getstart(), this.hgg.getend(), this.vgg.getstart(), this.vgg.getend(), this.hgg.isLogAxis(), this.vgg.isLogAxis());
        }
        catch (NumberFormatException e) {
            this.transformation = null;
            throw new CantComputeException("You must fill out both horizontal and vertical\n gauge number fields with sensible values");
        }
        catch (NullPointerException e) {
            this.transformation = null;
            throw new CantComputeException("Both axes must be defined before value\nreadout is possible.\n  Click and drag to define axes.");
        }
        catch (MissingData e) {
            this.transformation = null;
            throw new CantComputeException(e.getMessage());
        }
    }

    private void makedata_orth() {
        boolean needVertBars = false;
        boolean needHorizBars = false;
        try {
            this.computeTransform();
        }
        catch (CantComputeException e) {
            new AlertBox((Frame)this, "Dexter Error", e.getMessage());
            return;
        }
        Object[] points = this.imzone.getPoints();
        QuickSort.getInstance().sort(points, 0, points.length - 1, points[0]);
        for (int i = 0; i < points.length; ++i) {
            Object pt = points[i];
            needHorizBars |= ((Datapoint)pt).hasHorizErrBars();
            needVertBars |= ((Datapoint)pt).hasVertErrBars();
        }
        this.results.setText(this.datasetName + "\n");
        int sigFigX = this.hgg.computeUsefulSignificantDigits();
        int sigFigY = this.vgg.computeUsefulSignificantDigits();
        for (int i = 0; i < points.length; ++i) {
            this.results.append(((Datapoint)points[i]).getRepr(needHorizBars, needVertBars, sigFigX, sigFigY));
        }
    }

    public void makedata() {
        this.makedata_orth();
    }

    public DoublePoint transformPhysicalToLogical(Point coo) {
        DoublePoint pt = new DoublePoint(coo);
        if (this.transformation != null) {
            pt = this.transformation.transformPhysicalToLogical(coo);
        }
        return pt;
    }

    public void displayMousePos(Point mousePos) {
        if (this.statusLocked) {
            return;
        }
        DoublePoint pt = this.transformPhysicalToLogical(mousePos);
        String posTx = Fmt.fmt(pt.getX(), 4, this.hgg.computeUsefulSignificantDigits()) + " / " + Fmt.fmt(pt.getY(), 4, this.vgg.computeUsefulSignificantDigits());
        if (this.recogniserRunning) {
            posTx = posTx + " Recog. running";
        }
        this.rulerLabel.setText(posTx);
    }

    public boolean allocStatusLine(String msg) {
        if (this.statusLocked) {
            return false;
        }
        this.statusLocked = true;
        this.rulerLabel.setText(msg);
        return true;
    }

    public void releaseStatusLine() {
        this.statusLocked = false;
        this.rulerLabel.setText("");
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.resizeToPreferredSize();
    }

    class Steeringstuff
    extends Panel {
        int numbut;
        Button[] buttons;
        static final long serialVersionUID = 20060308L;

        Steeringstuff(Button[] buttons_p, int numbut_p, ActionListener l) {
            this.numbut = numbut_p;
            this.buttons = buttons_p;
            this.setLayout(new GridLayout(this.numbut, 1));
            for (int i = 0; i < this.numbut; ++i) {
                this.add(this.buttons[i]);
                this.buttons[i].addActionListener(l);
            }
        }
    }
}

