/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.swing;

import java.awt.Component;
import java.awt.Container;
import javax.swing.Spring;
import javax.swing.SpringLayout;

public final class SpringUtilities {
    private SpringUtilities() {
    }

    public static void makeGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout.Constraints cons;
        int i;
        if (!(parent.getLayout() instanceof SpringLayout)) {
            throw new IllegalArgumentException("The first argument to makeGrid must use SpringLayout.");
        }
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Spring xPadSpring = Spring.constant(xPad);
        Spring yPadSpring = Spring.constant(yPad);
        Spring initialXSpring = Spring.constant(initialX);
        Spring initialYSpring = Spring.constant(initialY);
        int max = rows * cols;
        Spring maxWidthSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        Spring maxHeightSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        for (i = 1; i < max; ++i) {
            cons = layout.getConstraints(parent.getComponent(i));
            maxWidthSpring = Spring.max(maxWidthSpring, cons.getWidth());
            maxHeightSpring = Spring.max(maxHeightSpring, cons.getHeight());
        }
        for (i = 0; i < max; ++i) {
            cons = layout.getConstraints(parent.getComponent(i));
            cons.setWidth(maxWidthSpring);
            cons.setHeight(maxHeightSpring);
        }
        SpringLayout.Constraints lastConstraints = null;
        SpringLayout.Constraints lastRowConstraints = null;
        for (int i2 = 0; i2 < max; ++i2) {
            SpringLayout.Constraints constraints = layout.getConstraints(parent.getComponent(i2));
            if (i2 % cols == 0) {
                lastRowConstraints = lastConstraints;
                constraints.setX(initialXSpring);
            } else {
                constraints.setX(Spring.sum(lastConstraints.getConstraint("East"), xPadSpring));
            }
            if (i2 / cols == 0) {
                constraints.setY(initialYSpring);
            } else {
                constraints.setY(Spring.sum(lastRowConstraints.getConstraint("South"), yPadSpring));
            }
            lastConstraints = constraints;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", Spring.sum(Spring.constant(yPad), lastConstraints.getConstraint("South")));
        pCons.setConstraint("East", Spring.sum(Spring.constant(xPad), lastConstraints.getConstraint("East")));
    }

    public static void makeCompactGrid(Container parent, int rows, int columns, int initialX, int initialY, int xPad, int yPad) {
        if (!(parent.getLayout() instanceof SpringLayout)) {
            throw new IllegalArgumentException("The first argument to makeCompactGrid must use SpringLayout.");
        }
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < columns; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, SpringUtilities.getConstraintsForCell(r, c, parent, columns).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = SpringUtilities.getConstraintsForCell(r, c, parent, columns);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < columns; ++c) {
                height = Spring.max(height, SpringUtilities.getConstraintsForCell(r, c, parent, columns).getHeight());
            }
            for (c = 0; c < columns; ++c) {
                SpringLayout.Constraints constraints = SpringUtilities.getConstraintsForCell(r, c, parent, columns);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        SpringLayout.Constraints parentConstraints = layout.getConstraints(parent);
        parentConstraints.setConstraint("South", y);
        parentConstraints.setConstraint("East", x);
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }
}

