/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.uncommons.maths.demo.DistributionPanel;
import org.uncommons.maths.demo.GraphPanel;
import org.uncommons.maths.demo.ProbabilityDistribution;
import org.uncommons.maths.demo.RNGPanel;
import org.uncommons.swing.SwingBackgroundTask;

public class RandomDemo
extends JFrame {
    private final DistributionPanel distributionPanel = new DistributionPanel();
    private final RNGPanel rngPanel = new RNGPanel();
    private final GraphPanel graphPanel = new GraphPanel();

    public RandomDemo() {
        super("Uncommons Maths - Random Numbers Demo");
        this.setLayout(new BorderLayout());
        this.add((Component)this.createControls(), "West");
        this.add((Component)this.graphPanel, "Center");
        this.setDefaultCloseOperation(3);
        this.setSize(700, 500);
        this.setMinimumSize(new Dimension(500, 250));
        this.setVisible(true);
    }

    private JComponent createControls() {
        Box controls = new Box(1);
        controls.add(this.distributionPanel);
        controls.add(this.rngPanel);
        JButton executeButton = new JButton("Go");
        executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RandomDemo.this.setCursor(Cursor.getPredefinedCursor(3));
                new SwingBackgroundTask<GraphData>(){
                    private ProbabilityDistribution distribution;

                    @Override
                    protected GraphData performTask() {
                        this.distribution = RandomDemo.this.distributionPanel.createProbabilityDistribution();
                        Map<Double, Double> observedValues = this.distribution.generateValues(RandomDemo.this.rngPanel.getIterations(), RandomDemo.this.rngPanel.getRNG());
                        Map<Double, Double> expectedValues = this.distribution.getExpectedValues();
                        return new GraphData(observedValues, expectedValues, this.distribution.getExpectedMean(), this.distribution.getExpectedStandardDeviation());
                    }

                    @Override
                    protected void postProcessing(GraphData data) {
                        RandomDemo.this.graphPanel.generateGraph(this.distribution.getDescription(), data.getObservedValues(), data.getExpectedValues(), data.getExpectedMean(), data.getExpectedStandardDeviation(), this.distribution.isDiscrete());
                        RandomDemo.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }.execute();
            }
        });
        controls.add(executeButton);
        return controls;
    }

    public static void main(String[] args) {
        RandomDemo s = new RandomDemo();
    }

    private static class GraphData {
        private final Map<Double, Double> observedValues;
        private final Map<Double, Double> expectedValues;
        private final double expectedMean;
        private final double expectedStandardDeviation;

        public GraphData(Map<Double, Double> observedValues, Map<Double, Double> expectedValues, double expectedMean, double expectedStandardDeviation) {
            this.observedValues = observedValues;
            this.expectedValues = expectedValues;
            this.expectedMean = expectedMean;
            this.expectedStandardDeviation = expectedStandardDeviation;
        }

        public Map<Double, Double> getObservedValues() {
            return this.observedValues;
        }

        public Map<Double, Double> getExpectedValues() {
            return this.expectedValues;
        }

        public double getExpectedMean() {
            return this.expectedMean;
        }

        public double getExpectedStandardDeviation() {
            return this.expectedStandardDeviation;
        }
    }
}

