/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.demo;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.uncommons.maths.Maths;
import org.uncommons.maths.demo.ProbabilityDistribution;
import org.uncommons.maths.random.PoissonGenerator;

class PoissonDistribution
extends ProbabilityDistribution {
    private final double mean;

    public PoissonDistribution(double mean) {
        this.mean = mean;
    }

    @Override
    public Map<Double, Double> getExpectedValues() {
        double p;
        HashMap<Double, Double> values = new HashMap<Double, Double>();
        int index = 0;
        do {
            p = this.getExpectedProbability(index);
            values.put(Double.valueOf(index), p);
            ++index;
        } while (p > 0.001);
        return values;
    }

    private double getExpectedProbability(int events) {
        BigDecimal kFactorial = new BigDecimal(Maths.bigFactorial(events));
        double numerator = Math.exp(-this.mean) * Math.pow(this.mean, events);
        return new BigDecimal(numerator).divide(kFactorial, RoundingMode.HALF_UP).doubleValue();
    }

    protected PoissonGenerator createValueGenerator(Random rng) {
        return new PoissonGenerator(this.mean, rng);
    }

    @Override
    public double getExpectedMean() {
        return this.mean;
    }

    @Override
    public double getExpectedStandardDeviation() {
        return Math.sqrt(this.mean);
    }

    @Override
    public String getDescription() {
        return "Poisson Distribution (\u03bb = " + this.mean + ")";
    }

    @Override
    public boolean isDiscrete() {
        return true;
    }
}

