/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.demo;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import org.uncommons.maths.demo.BinomialDistribution;
import org.uncommons.maths.demo.ParametersPanel;
import org.uncommons.swing.SpringUtilities;

class BinomialParametersPanel
extends ParametersPanel {
    private final SpinnerNumberModel trialsNumberModel = new SpinnerNumberModel(50, 1, 100, 1);
    private final SpinnerNumberModel probabilityNumberModel = new SpinnerNumberModel(0.5, 0.0, 1.0, 0.01);

    public BinomialParametersPanel() {
        JPanel wrapper = new JPanel(new SpringLayout());
        wrapper.add(new JLabel("No. Trials: "));
        wrapper.add(new JSpinner(this.trialsNumberModel));
        wrapper.add(new JLabel("Probability: "));
        wrapper.add(new JSpinner(this.probabilityNumberModel));
        SpringUtilities.makeCompactGrid(wrapper, 4, 1, 6, 6, 6, 6);
        this.add((Component)wrapper, "North");
    }

    @Override
    public BinomialDistribution createProbabilityDistribution() {
        return new BinomialDistribution(this.trialsNumberModel.getNumber().intValue(), this.probabilityNumberModel.getNumber().doubleValue());
    }
}

