/*
 * Decompiled with CFR 0.152.
 */
package jminhep.clcontrol;

import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import jminhep.clcontrol.Global;
import jminhep.clcontrol.Thread1;
import jminhep.gui.SetEnv;

public class TableOptions
extends JPanel {
    public static final long serialVersionUID = 45132L;
    private boolean DEBUG = false;
    protected String[] columnToolTips = new String[]{"Show centers / seeds", null};
    public JTable table = new JTable(new MyTableModel()){
        private static final long serialVersionUID = 1L;

        @Override
        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int colIndex = this.columnAtPoint(p);
            int realColumnIndex = this.convertColumnIndexToModel(colIndex);
            if (realColumnIndex == 0) {
                tip = "Show centers seeds";
            }
            return tip;
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new JTableHeader(this.columnModel){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    int index = this.columnModel.getColumnIndexAtX(p.x);
                    int realIndex = this.columnModel.getColumn(index).getModelIndex();
                    return TableOptions.this.columnToolTips[realIndex];
                }
            };
        }
    };

    public TableOptions() {
        super(new GridLayout(1, 0));
        int hh = (int)(0.069 * (double)SetEnv.SizeY / 2.6);
        this.table.setRowHeight(hh);
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(0);
        column.setPreferredWidth(130);
        column.setMinWidth(100);
        column.setMaxWidth(500);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(40);
        column.setMinWidth(50);
        column.setMaxWidth(500);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add(scrollPane);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("TableToolTipsDemo");
        frame.setDefaultCloseOperation(3);
        TableOptions newContentPane = new TableOptions();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableOptions.createAndShowGUI();
            }
        });
    }

    class MyTableModel
    extends AbstractTableModel {
        public static final long serialVersionUID = 41313L;
        private String[] columnNames = new String[]{"Display options", "Set"};
        private Object[][] data = new Object[][]{{"Show centers", new Boolean(false)}, {"Show seeds", new Boolean(false)}};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (Global.doneAnalysis) {
                if (TableOptions.this.DEBUG) {
                    System.out.println("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
                }
                this.data[row][col] = value;
                this.fireTableCellUpdated(row, col);
                Global.ShowCenters = (Boolean)this.data[0][1];
                Global.ShowSeeds = (Boolean)this.data[1][1];
                Thread1 run = new Thread1("Update plot");
                if (!run.Alive()) {
                    run.Start();
                }
                if (TableOptions.this.DEBUG) {
                    System.out.println("New value of data:");
                    this.printDebugData();
                }
            }
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < numCols; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

