/*
 * Decompiled with CFR 0.152.
 */
package jminhep.clcontrol;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jminhep.gui.FontChooser;
import jminhep.gui.SetEnv;

public class SummaryPad
extends JFrame {
    private static final long serialVersionUID = 1L;
    public padPanel pad;
    private JFileChooser mFileChooser = new JFileChooser(".");
    public JTextArea mEditArea;
    private Action mOpenAction;
    private Action mSaveAction;
    private Action mExitAction;
    private Action mFonts;

    public static void main(String[] args) {
        new SummaryPad().setVisible(true);
    }

    public SummaryPad() {
        this.createActions();
        this.pad = new padPanel();
        this.setContentPane(this.pad);
        this.setJMenuBar(this.createMenuBar());
        this.setTitle("Summary Pad");
        this.setVisible(false);
        this.pack();
    }

    public void NotShow() {
        this.setVisible(false);
    }

    public void Show() {
        this.setVisible(true);
    }

    public void Set(String s) {
        this.mEditArea.setText(s);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = menuBar.add(new JMenu("File"));
        fileMenu.add(this.mOpenAction);
        fileMenu.add(this.mSaveAction);
        fileMenu.add(this.mFonts);
        fileMenu.addSeparator();
        fileMenu.add(this.mExitAction);
        return menuBar;
    }

    private void createActions() {
        this.mOpenAction = new AbstractAction("Open..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int retval = SummaryPad.this.mFileChooser.showOpenDialog(SummaryPad.this);
                if (retval == 0) {
                    File f = SummaryPad.this.mFileChooser.getSelectedFile();
                    try {
                        FileReader reader = new FileReader(f);
                        SummaryPad.this.mEditArea.read(reader, "");
                    }
                    catch (IOException ioex) {
                        System.out.println(e);
                    }
                }
            }
        };
        this.mSaveAction = new AbstractAction("Save"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int retval = SummaryPad.this.mFileChooser.showSaveDialog(SummaryPad.this);
                if (retval == 0) {
                    File f = SummaryPad.this.mFileChooser.getSelectedFile();
                    try {
                        FileWriter writer = new FileWriter(f);
                        SummaryPad.this.mEditArea.write(writer);
                    }
                    catch (IOException ioex) {
                        System.out.println(e);
                    }
                }
            }
        };
        this.mExitAction = new AbstractAction("Exit"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryPad.this.NotShow();
            }
        };
        this.mFonts = new AbstractAction("Fonts"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Font f = FontChooser.showDialog(SummaryPad.this, "Choose font", SummaryPad.this.mEditArea.getFont());
                if (f != null) {
                    SummaryPad.this.mEditArea.setFont(f);
                }
            }
        };
    }

    public class padPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        padPanel() {
            SummaryPad.this.mEditArea = new JTextArea(40, 40);
            SummaryPad.this.mEditArea.setFont(SetEnv.FontBold);
            SummaryPad.this.mEditArea.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            JScrollPane scrollingText = new JScrollPane(SummaryPad.this.mEditArea);
            SummaryPad.this.Set("Summary is not filled yet");
            this.setLayout(new BorderLayout());
            this.add((Component)scrollingText, "Center");
        }
    }
}

