/*
 * Decompiled with CFR 0.152.
 */
package jminhep.algorithms;

import java.util.HashSet;
import java.util.Iterator;
import jminhep.cluster.DataHolder;
import jminhep.cluster.DataPoint;
import jminhep.cluster.Get;
import jminhep.gui.SetEnv;
import jminhep.utils.ArrayOps;
import org.apache.commons.math3.util.FastMath;

public class HierarchicalAlg {
    public static final double MAXVAL = 1.0E12;
    private double[][] indat;
    private int[] outputPoints;
    private int[] assignment;
    private int nrow;
    private int ncol;
    private double compactness;
    private int Ierr = 0;
    private double[][] clusterCenters;
    private int[][] tclusters;
    private int numClusters;
    private double[][] diss;
    private String description;
    private DataHolder cMeans;
    private DataHolder data;

    public HierarchicalAlg(DataHolder data) {
        this.data = data;
        this.nrow = data.getSize();
        this.ncol = data.getDimention();
        SetEnv.NRow = this.nrow;
        SetEnv.Dim = this.ncol;
        this.Ierr = 0;
        this.compactness = 0.0;
        this.Ierr = 0;
        this.numClusters = 0;
        this.description = "Hierarchical clustering algorithm";
        this.indat = new double[this.nrow][this.ncol];
        this.tclusters = new int[this.nrow][this.nrow];
        for (int i = 0; i < this.nrow; ++i) {
            DataPoint dp = data.getRow(i);
            for (int i2 = 0; i2 < this.ncol; ++i2) {
                this.indat[i][i2] = dp.getAttribute(i2);
            }
        }
    }

    public int getError() {
        return this.Ierr;
    }

    public double getCompactness() {
        return this.compactness;
    }

    public void setClusters(int N) {
        if (N > this.nrow) {
            System.out.println("Too many clusters! Set to number of points");
            N = this.nrow;
        }
        this.numClusters = N;
    }

    public int getClusters() {
        return this.numClusters;
    }

    public void getResult() {
        int j;
        this.assignment = new int[this.nrow];
        this.clusterCenters = new double[this.numClusters][this.ncol];
        if (this.numClusters == 0) {
            System.out.println("Number of clusters was set to 0");
            System.exit(0);
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i1 = 0; i1 < this.nrow; ++i1) {
            int ii = this.tclusters[this.numClusters - 1][i1];
            set.add(new Integer(ii));
        }
        int N = 0;
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            int itake = (Integer)itr.next();
            for (int i1 = 0; i1 < this.nrow; ++i1) {
                if (this.tclusters[this.numClusters - 1][i1] != itake) continue;
                this.assignment[i1] = N;
            }
            ++N;
        }
        for (int i = 0; i < this.nrow; ++i) {
            DataPoint dp = this.data.getRow(i);
            dp.assignToCluster(this.assignment[i]);
        }
        this.outputPoints = new int[this.numClusters];
        for (j = 0; j < this.numClusters; ++j) {
            for (int i = 0; i < this.ncol; ++i) {
                this.clusterCenters[j][i] = 0.0;
            }
        }
        for (j = 0; j < this.numClusters; ++j) {
            this.outputPoints[j] = 0;
            for (int i = 0; i < this.nrow; ++i) {
                if (this.assignment[i] != j) continue;
                int n = j;
                this.outputPoints[n] = this.outputPoints[n] + 1;
                for (int m = 0; m < this.ncol; ++m) {
                    this.clusterCenters[j][m] = this.clusterCenters[j][m] + this.indat[i][m];
                }
            }
        }
        for (j = 0; j < this.numClusters; ++j) {
            for (int m = 0; m < this.ncol; ++m) {
                this.clusterCenters[j][m] = this.clusterCenters[j][m] / (double)this.outputPoints[j];
            }
        }
        this.compactness = Get.compactness(this.indat, this.assignment, this.numClusters, this.clusterCenters);
    }

    public DataHolder getCenters() {
        this.cMeans = new DataHolder();
        for (int i = 0; i < this.numClusters; ++i) {
            double[] a = new double[this.ncol];
            for (int j = 0; j < this.ncol; ++j) {
                a[j] = this.clusterCenters[i][j];
            }
            DataPoint c = new DataPoint(a, this.ncol);
            this.cMeans.add(c);
        }
        return this.cMeans;
    }

    public int[] getNumberPoints() {
        return this.outputPoints;
    }

    public static double[][] calcDissim(int nrow, int ncol, double[] mass, double[][] A) {
        int i2;
        int i1;
        double[][] Adiss = new double[nrow][nrow];
        for (i1 = 0; i1 < nrow; ++i1) {
            for (i2 = 0; i2 < nrow; ++i2) {
                Adiss[i1][i2] = 0.0;
            }
        }
        for (i1 = 0; i1 < nrow; ++i1) {
            for (i2 = 0; i2 < i1; ++i2) {
                for (int j = 0; j < ncol; ++j) {
                    double[] dArray = Adiss[i1];
                    int n = i2;
                    dArray[n] = dArray[n] + 0.5 * FastMath.pow((double)(A[i1][j] - A[i2][j]), (double)2.0);
                }
                Adiss[i2][i1] = Adiss[i1][i2];
            }
        }
        return Adiss;
    }

    public static void getNNs(int nrow, int[] flag, double[][] diss, int[] nn, double[] nndiss) {
        for (int i1 = 0; i1 < nrow; ++i1) {
            if (flag[i1] != 1) continue;
            int minobs = -1;
            double mindist = 1.0E12;
            for (int i2 = 0; i2 < nrow; ++i2) {
                if (!(diss[i1][i2] < mindist) || i1 == i2) continue;
                mindist = diss[i1][i2];
                minobs = i2;
            }
            nn[i1] = minobs + 1;
            nndiss[i1] = mindist;
        }
    }

    public static void calClustMat(int nrow, int[][] clusters, int clust1, int clust2, int ncl) {
        if (clust1 == 0 || clust2 == 0) {
            for (int j = 0; j < nrow; ++j) {
                for (int i = 0; i < nrow; ++i) {
                    clusters[i][j] = 0;
                }
            }
            for (int i = 0; i < nrow; ++i) {
                clusters[i][ncl - 1] = i + 1;
            }
            return;
        }
        int ncl1 = ncl - 1;
        for (int i = 0; i < nrow; ++i) {
            clusters[i][ncl1] = clusters[i][ncl];
            if (clusters[i][ncl1] != clust2) continue;
            clusters[i][ncl1] = clust1;
        }
    }

    public static String getSpaces(int n) {
        StringBuffer sb = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public void run() {
        this.runHC();
        this.getResult();
    }

    public void runBest() {
        this.runHC();
        int iter = 1 + this.nrow / 2;
        double[] selec = new double[iter];
        for (int j = 0; j < iter; ++j) {
            selec[j] = Double.MAX_VALUE;
        }
        int[] clus = new int[iter];
        int N = 0;
        for (int j = 0; j < iter; ++j) {
            int nclus = 2 + j;
            this.setClusters(nclus);
            this.getResult();
            selec[j] = this.compactness;
            clus[j] = nclus;
            ++N;
            if (j > 5 && selec[j - 1] < selec[j] && selec[j - 2] < selec[j - 1]) break;
        }
        int ibest = ArrayOps.findSmallest(selec, N);
        this.setClusters(clus[ibest]);
        this.getResult();
        this.description = "Hierarchical clustering algorithm, best estimate";
    }

    private void runHC() {
        int[][] clusters = new int[this.nrow][this.nrow];
        int[] nn = new int[this.nrow];
        int[] flag = new int[this.nrow];
        double[] nndiss = new double[this.nrow];
        double[] clcard = new double[this.nrow];
        double[] mass = new double[this.nrow];
        int ncl = this.nrow;
        for (int i = 0; i < this.nrow; ++i) {
            flag[i] = 1;
            clcard[i] = 1.0;
            mass[i] = 1.0;
        }
        this.diss = new double[this.nrow][this.nrow];
        this.diss = HierarchicalAlg.calcDissim(this.nrow, this.ncol, mass, this.indat);
        HierarchicalAlg.getNNs(this.nrow, flag, this.diss, nn, nndiss);
        int clust1 = 0;
        int clust2 = 0;
        int cl1 = 0;
        int cl2 = 0;
        HierarchicalAlg.calClustMat(this.nrow, clusters, clust1, clust2, ncl);
        do {
            int i;
            int minobs = -1;
            double mindist = 1.0E12;
            for (i = 0; i < this.nrow; ++i) {
                if (flag[i] != 1 || !(nndiss[i] < mindist)) continue;
                mindist = nndiss[i];
                minobs = i;
            }
            if (minobs < nn[minobs]) {
                clust1 = minobs + 1;
                clust2 = nn[minobs];
            }
            if (minobs > nn[minobs]) {
                clust2 = minobs + 1;
                clust1 = nn[minobs];
            }
            HierarchicalAlg.calClustMat(this.nrow, clusters, clust1, clust2, --ncl);
            cl1 = clust1 - 1;
            cl2 = clust2 - 1;
            for (i = 0; i < this.nrow; ++i) {
                if (i == cl1 || i == cl2 || flag[i] != 1) continue;
                this.diss[cl1][i] = (mass[cl1] + mass[i]) / (mass[cl1] + mass[cl2] + mass[i]) * this.diss[cl1][i] + (mass[cl2] + mass[i]) / (mass[cl1] + mass[cl2] + mass[i]) * this.diss[cl2][i] - mass[i] / (mass[cl1] + mass[cl2] + mass[i]) * this.diss[cl1][cl2];
                this.diss[i][cl1] = this.diss[cl1][i];
            }
            clcard[cl1] = clcard[cl1] + clcard[cl2];
            mass[cl1] = mass[cl1] + mass[cl2];
            for (i = 0; i < this.nrow; ++i) {
                this.diss[cl2][i] = 1.0E12;
                this.diss[i][cl2] = this.diss[cl2][i];
                flag[cl2] = 0;
                nndiss[cl2] = 1.0E12;
                mass[cl2] = 0.0;
            }
            HierarchicalAlg.getNNs(this.nrow, flag, this.diss, nn, nndiss);
        } while (ncl > 1);
        for (int i1 = 0; i1 < this.nrow; ++i1) {
            for (int i2 = 0; i2 < this.nrow; ++i2) {
                this.tclusters[i2][i1] = clusters[i1][i2];
            }
        }
    }

    public String getName() {
        return this.description;
    }
}

