/*
 * Decompiled with CFR 0.152.
 */
package jminhep.algorithms;

import java.util.Random;
import jminhep.cluster.DataHolder;
import jminhep.cluster.DataPoint;
import jminhep.cluster.Get;
import jminhep.gui.SetEnv;
import jminhep.utils.ArrayOps;
import org.apache.commons.math3.util.FastMath;

public class FuzzyCMeansAlg {
    private double[][] indat;
    private int nrow;
    private int ncol;
    private int Ierr = 0;
    private DataHolder cMeans;
    private int maxIterations;
    private int numClusters;
    private double fuzziness;
    private double[][] membership;
    private int iteration;
    private double j = 1000000.0;
    private double epsilon;
    private long position;
    private double[][] clusterCenters;
    private double[] aPixel;
    private int[] assignment;
    private String description;
    private Random generator;
    private DataHolder data;
    private double probClusters;

    public FuzzyCMeansAlg(DataHolder data) {
        this.data = data;
        this.nrow = data.getSize();
        this.ncol = data.getDimention();
        SetEnv.NRow = this.nrow;
        SetEnv.Dim = this.ncol;
        this.Ierr = 0;
        this.numClusters = 3;
        this.probClusters = 0.68;
        this.description = "Fuzzy C-means clustering";
        this.indat = new double[this.nrow][this.ncol];
        this.aPixel = new double[this.ncol];
        this.assignment = new int[this.nrow];
        this.clusterCenters = new double[this.numClusters][this.ncol];
        this.membership = new double[this.nrow][this.numClusters];
        for (int i = 0; i < this.nrow; ++i) {
            DataPoint dp = data.getRow(i);
            for (int i2 = 0; i2 < this.ncol; ++i2) {
                this.indat[i][i2] = dp.getAttribute(i2);
            }
        }
    }

    public void setClusters(int N) {
        if (N > this.nrow) {
            System.out.println("Too many clusters! Set to number of points");
            N = this.nrow;
        }
        this.numClusters = N;
    }

    public int getClusters() {
        return this.numClusters;
    }

    public double[][] getMembeship() {
        return this.membership;
    }

    public void setOptions(int maxIterations, double epsilon, double fuzziness) {
        this.maxIterations = maxIterations;
        this.fuzziness = fuzziness;
        this.epsilon = epsilon;
    }

    public void delete() {
        this.numClusters = 0;
        this.maxIterations = 0;
        this.fuzziness = 0.0;
        this.epsilon = 0.0;
        this.nrow = 0;
        this.ncol = 0;
        this.indat = null;
        this.clusterCenters = null;
        this.membership = null;
        this.generator = null;
        this.aPixel = null;
    }

    public void setProb(double probClusters) {
        this.probClusters = probClusters;
    }

    public DataHolder getCenters() {
        this.cMeans = new DataHolder();
        for (int i = 0; i < this.numClusters; ++i) {
            double[] a = new double[this.ncol];
            for (int j = 0; j < this.ncol; ++j) {
                a[j] = this.clusterCenters[i][j];
            }
            DataPoint c = new DataPoint(a, this.ncol);
            this.cMeans.add(c);
        }
        return this.cMeans;
    }

    public int[] getAssignments() {
        return this.assignment;
    }

    public int[] getNumberPoints() {
        int[] a = new int[this.numClusters];
        for (int c = 0; c < this.numClusters; ++c) {
            int nn = 0;
            for (int h = 0; h < this.nrow; ++h) {
                if (!(this.membership[h][c] > this.probClusters)) continue;
                ++nn;
            }
            a[c] = nn;
        }
        return a;
    }

    public void runBest() {
        int iter = 1 + this.nrow / 2;
        double[] selec = new double[iter];
        for (int j = 0; j < iter; ++j) {
            selec[j] = Double.MAX_VALUE;
        }
        int[] clus = new int[iter];
        int N = 0;
        for (int j = 0; j < iter; ++j) {
            int nclus = 2 + j;
            this.setClusters(nclus);
            this.run();
            selec[j] = this.getCompactness();
            clus[j] = nclus;
            ++N;
            if (j > 5 && selec[j - 1] < selec[j] && selec[j - 2] < selec[j - 1]) break;
        }
        int ibest = ArrayOps.findSmallest(selec, N);
        this.numClusters = clus[ibest];
        this.description = "Fuzzy C-means clustering: Best estimate";
        this.run();
    }

    public void run() {
        this.iteration = 0;
        this.generator = new Random();
        for (int h = 0; h < this.nrow; ++h) {
            int c;
            double sum = 0.0;
            for (c = 0; c < this.numClusters; ++c) {
                this.membership[h][c] = (double)0.01f + this.generator.nextDouble();
                sum += this.membership[h][c];
            }
            c = 0;
            while (c < this.numClusters) {
                double[] dArray = this.membership[h];
                int n = c++;
                dArray[n] = dArray[n] / sum;
            }
        }
        this.position = 0L;
        double lastJ = this.calculateObjectiveFunction();
        this.iteration = 0;
        while (this.iteration < this.maxIterations) {
            this.calculateClusterCentersFromMFs();
            this.calculateMFsFromClusterCenters();
            this.j = this.calculateObjectiveFunction();
            if (FastMath.abs((double)(lastJ - this.j)) < this.epsilon) break;
            lastJ = this.j;
            ++this.iteration;
        }
        this.position = this.getSize();
        for (int h = 0; h < this.nrow; ++h) {
            this.assignment[h] = -1;
        }
        for (int c = 0; c < this.numClusters; ++c) {
            for (int h = 0; h < this.nrow; ++h) {
                if (!(this.membership[h][c] > this.probClusters)) continue;
                this.assignment[h] = c;
            }
        }
        for (int i = 0; i < this.nrow; ++i) {
            DataPoint dp = this.data.getRow(i);
            dp.assignToCluster(this.assignment[i]);
        }
    }

    private void calculateClusterCentersFromMFs() {
        for (int b = 0; b < this.ncol; ++b) {
            for (int c = 0; c < this.numClusters; ++c) {
                double bottom = 0.0;
                double top = 0.0;
                for (int h = 0; h < this.nrow; ++h) {
                    top += FastMath.pow((double)this.membership[h][c], (double)this.fuzziness) * this.indat[h][b];
                    bottom += FastMath.pow((double)this.membership[h][c], (double)this.fuzziness);
                }
                this.clusterCenters[c][b] = top / bottom;
            }
        }
    }

    private void calculateMFsFromClusterCenters() {
        for (int c = 0; c < this.numClusters; ++c) {
            for (int h = 0; h < this.nrow; ++h) {
                for (int b = 0; b < this.ncol; ++b) {
                    this.aPixel[b] = this.indat[h][b];
                }
                double top = Get.calcDistance(this.aPixel, this.clusterCenters[c]);
                double sumTerms = 0.0;
                for (int ck = 0; ck < this.numClusters; ++ck) {
                    double thisDistance = Get.calcDistance(this.aPixel, this.clusterCenters[ck]);
                    sumTerms += FastMath.pow((double)(top / thisDistance), (double)(2.0 / (this.fuzziness - 1.0)));
                }
                this.membership[h][c] = 1.0 / sumTerms;
                this.position += (long)(this.ncol + this.numClusters);
            }
        }
    }

    private double calculateObjectiveFunction() {
        double j = 0.0;
        for (int h = 0; h < this.nrow; ++h) {
            for (int c = 0; c < this.numClusters; ++c) {
                for (int b = 0; b < this.ncol; ++b) {
                    this.aPixel[b] = this.indat[h][b];
                }
                double distancePixelToCluster = Get.calcDistance(this.aPixel, this.clusterCenters[c]);
                j += distancePixelToCluster * FastMath.pow((double)this.membership[h][c], (double)this.fuzziness);
                this.position += (long)(2 * this.ncol);
            }
        }
        return j;
    }

    public long getSize() {
        return this.maxIterations;
    }

    public long getPosition() {
        return this.position;
    }

    public boolean isFinished() {
        return this.position == this.getSize();
    }

    public double getPartitionCoefficient() {
        double pc = 0.0;
        for (int h = 0; h < this.nrow; ++h) {
            for (int c = 0; c < this.numClusters; ++c) {
                pc += this.membership[h][c] * this.membership[h][c];
            }
        }
        return pc /= (double)this.nrow;
    }

    public double getPartitionEntropy() {
        double pe = 0.0;
        for (int h = 0; h < this.nrow; ++h) {
            for (int c = 0; c < this.numClusters; ++c) {
                pe += this.membership[h][c] * FastMath.log((double)this.membership[h][c]);
            }
        }
        pe = -pe / (double)this.nrow;
        return pe;
    }

    public int getError() {
        return this.Ierr;
    }

    public double getCompactness() {
        double cs = 0.0;
        for (int h = 0; h < this.nrow; ++h) {
            for (int b = 0; b < this.ncol; ++b) {
                this.aPixel[b] = this.indat[h][b];
            }
            for (int c = 0; c < this.numClusters; ++c) {
                double distancePixelToCluster = Get.calcSquaredDistance(this.aPixel, this.clusterCenters[c]);
                cs += this.membership[h][c] * this.membership[h][c] * distancePixelToCluster * distancePixelToCluster;
            }
        }
        cs /= (double)this.nrow;
        double minDist = Double.MAX_VALUE;
        for (int c1 = 0; c1 < this.numClusters - 1; ++c1) {
            for (int c2 = c1 + 1; c2 < this.numClusters; ++c2) {
                double distance = Get.calcSquaredDistance(this.clusterCenters[c1], this.clusterCenters[c2]);
                minDist = FastMath.min((double)minDist, (double)distance);
            }
        }
        return cs /= minDist * minDist;
    }

    public String getName() {
        return this.description;
    }
}

