/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.matrixx.impl.AStridedMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Tools;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.AArrayVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.DoubleArrays;

public final class StridedMatrixViewVector
extends AArrayVector {
    private static final long serialVersionUID = 5807998427323932401L;
    private final int offset;
    private final int rowStride;
    private final int colStride;
    private final int rows;
    private final int cols;

    private StridedMatrixViewVector(double[] data, int offset, int rows, int cols, int rowStride, int colStride) {
        super(Tools.toInt(rows * cols), data);
        this.offset = offset;
        this.rows = rows;
        this.cols = cols;
        this.rowStride = rowStride;
        this.colStride = colStride;
    }

    public StridedMatrixViewVector(AStridedMatrix m) {
        this(m.getArray(), m.getArrayOffset(), m.rowCount(), m.columnCount(), m.rowStride(), m.columnStride());
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public StridedMatrixViewVector exactClone() {
        double[] data = (double[])this.data.clone();
        return new StridedMatrixViewVector(data, this.offset, this.rows, this.cols, this.rowStride, this.colStride);
    }

    @Override
    protected int index(int i) {
        int r = i / this.cols;
        int c = i % this.cols;
        return this.offset + r * this.rowStride + c * this.colStride;
    }

    @Override
    public double get(int i) {
        this.checkIndex(i);
        return this.unsafeGet(i);
    }

    @Override
    public void set(int i, double value) {
        this.checkIndex(i);
        this.unsafeSet(i, value);
    }

    @Override
    public void set(AVector v) {
        v.checkLength(this.length);
        for (int i = 0; i < this.rows; ++i) {
            v.copyTo(i * this.cols, this.data, this.offset + this.rowStride * i, this.cols, this.colStride);
        }
    }

    @Override
    public double unsafeGet(int i) {
        return this.data[this.index(i)];
    }

    @Override
    public void unsafeSet(int i, double value) {
        this.data[this.index((int)i)] = value;
    }

    @Override
    public double dotProduct(double[] xs, int offset) {
        double result = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            result += DoubleArrays.dotProduct(xs, offset, this.data, this.offset + i * this.rowStride, this.colStride, this.cols);
            offset += this.cols;
        }
        return result;
    }

    @Override
    public double elementSum() {
        double result = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            result += DoubleArrays.elementSum(this.data, this.offset + i * this.rowStride, this.colStride, this.cols);
        }
        return result;
    }

    @Override
    public void applyOp(Op op) {
        for (int i = 0; i < this.rows; ++i) {
            op.applyTo(this.data, this.offset + i * this.rowStride, this.colStride, this.cols);
        }
    }

    @Override
    public void getElements(double[] dest, int destOffset) {
        for (int i = 0; i < this.rows; ++i) {
            DoubleArrays.copy(this.data, this.offset + i * this.rowStride, this.colStride, dest, destOffset, this.cols);
            destOffset += this.cols;
        }
    }

    @Override
    public void addToArray(double[] dest, int destOffset) {
        int srcOffset = this.offset;
        for (int i = 0; i < this.rows; ++i) {
            DoubleArrays.add(this.data, srcOffset + i * this.rowStride, this.colStride, dest, destOffset + i * this.cols, this.cols);
        }
    }

    @Override
    public AVector subVector(int start, int length) {
        this.checkRange(start, length);
        if (length % this.cols == 0 && length % this.cols == 0) {
            int newRows = length / this.cols;
            if (newRows == 0) {
                return Vector0.INSTANCE;
            }
            if (newRows == this.rows) {
                return this;
            }
            int rowStart = start / this.cols;
            int newOffset = this.offset + rowStart * this.rowStride;
            if (newRows == 1) {
                return Vectorz.wrapStrided(this.data, newOffset, this.cols, this.colStride);
            }
            return new StridedMatrixViewVector(this.data, newOffset, newRows, this.cols, this.rowStride, this.colStride);
        }
        return super.subVector(start, length);
    }
}

