/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.util.Arrays;
import mikera.randomz.Hash;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.impl.ADenseArrayVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.DoubleArrays;

public final class ArraySubVector
extends ADenseArrayVector {
    private static final long serialVersionUID = 1262951505515197105L;
    private final int offset;

    private ArraySubVector(double[] values) {
        this(values, 0, values.length);
    }

    private ArraySubVector(double[] data, int offset, int length) {
        super(length, data);
        this.offset = offset;
    }

    public static ArraySubVector wrap(double[] values) {
        return new ArraySubVector(values);
    }

    public static ArraySubVector wrap(double[] data, int offset, int length) {
        return new ArraySubVector(data, offset, length);
    }

    public ArraySubVector(ADenseArrayVector source, int offset, int length) {
        super(length, source.getArray());
        source.checkRange(offset, length);
        this.offset = source.getArrayOffset() + offset;
    }

    @Override
    public double get(int i) {
        this.checkIndex(i);
        return this.data[this.offset + i];
    }

    @Override
    public void set(int i, double value) {
        this.checkIndex(i);
        this.data[this.offset + i] = value;
    }

    @Override
    public void fill(double value) {
        Arrays.fill(this.data, this.offset, this.offset + this.length, value);
    }

    @Override
    public double unsafeGet(int i) {
        return this.data[this.offset + i];
    }

    @Override
    public void unsafeSet(int i, double value) {
        this.data[this.offset + i] = value;
    }

    @Override
    public void add(AVector v) {
        this.checkSameLength(v);
        v.addToArray(this.data, this.offset);
    }

    @Override
    public void addMultiple(AVector v, double factor) {
        this.checkSameLength(v);
        v.addMultipleToArray(factor, this.data, this.offset);
    }

    @Override
    public void addAt(int i, double v) {
        assert (i >= 0 && i < this.length);
        int n = i + this.offset;
        this.data[n] = this.data[n] + v;
    }

    @Override
    public void applyOp(Op op) {
        op.applyTo(this.data, this.offset, this.length);
    }

    @Override
    public void abs() {
        DoubleArrays.abs(this.data, this.offset, this.length);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.length; ++i) {
            hashCode = 31 * hashCode + Hash.hashCode(this.data[this.offset + i]);
        }
        return hashCode;
    }

    @Override
    public int getArrayOffset() {
        return this.offset;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public AVector subVector(int start, int length) {
        int len = this.checkRange(start, length);
        if (length == 0) {
            return Vector0.INSTANCE;
        }
        if (len == length) {
            return this;
        }
        return ArraySubVector.wrap(this.data, this.offset + start, length);
    }

    @Override
    public void setElements(double[] src, int srcOffset) {
        System.arraycopy(src, srcOffset, this.data, this.offset, this.length);
    }

    @Override
    public ArraySubVector exactClone() {
        return new ArraySubVector((double[])this.data.clone(), this.offset, this.length);
    }

    @Override
    protected int index(int i) {
        return this.offset + i;
    }
}

