/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.util.Iterator;
import mikera.arrayz.Arrayz;
import mikera.arrayz.INDArray;
import mikera.arrayz.impl.IStridedArray;
import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.impl.AStridedMatrix;
import mikera.matrixx.impl.StridedMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Op2;
import mikera.vectorz.Vector;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.AArrayVector;
import mikera.vectorz.impl.ADenseArrayVector;
import mikera.vectorz.impl.IndexedArrayVector;
import mikera.vectorz.impl.IndexedElementVisitor;
import mikera.vectorz.impl.StridedElementIterator;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public abstract class AStridedVector
extends AArrayVector
implements IStridedArray {
    private static final long serialVersionUID = -7239429584755803950L;

    protected AStridedVector(int length, double[] data) {
        super(length, data);
    }

    @Override
    public final double[] getArray() {
        return this.data;
    }

    @Override
    public abstract int getArrayOffset();

    public abstract int getStride();

    @Override
    public AStridedVector ensureMutable() {
        if (this.isFullyMutable()) {
            return this;
        }
        return this.clone();
    }

    @Override
    public boolean isRangeZero(int start, int length) {
        int stride = this.getStride();
        int offset = this.getArrayOffset() + start * stride;
        return DoubleArrays.isZero(this.data, offset, length, stride);
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        return DoubleArrays.dotProduct(data, offset, this.getArray(), this.getArrayOffset(), this.getStride(), this.length());
    }

    @Override
    public double dotProduct(AVector v) {
        this.checkLength(v.length());
        return v.dotProduct(this.getArray(), this.getArrayOffset(), this.getStride());
    }

    @Override
    public double elementSum() {
        return DoubleArrays.elementSum(this.getArray(), this.getArrayOffset(), this.getStride(), this.length());
    }

    @Override
    public double elementProduct() {
        int len = this.length();
        double[] array = this.getArray();
        int offset = this.getArrayOffset();
        int stride = this.getStride();
        double result = 1.0;
        for (int i = 0; i < len; ++i) {
            result *= array[offset + i * stride];
        }
        return result;
    }

    @Override
    public double elementMax() {
        int len = this.length();
        double[] array = this.getArray();
        int offset = this.getArrayOffset();
        int stride = this.getStride();
        double max = -1.7976931348623157E308;
        for (int i = 0; i < len; ++i) {
            double d = array[offset + i * stride];
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    @Override
    public double elementMin() {
        int len = this.length();
        double[] array = this.getArray();
        int offset = this.getArrayOffset();
        int stride = this.getStride();
        double min = Double.MAX_VALUE;
        for (int i = 0; i < len; ++i) {
            double d = array[offset + i * stride];
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    @Override
    public INDArray broadcast(int ... shape) {
        int dims = shape.length;
        if (dims == 0) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast((INDArray)this, shape));
        }
        if (dims == 1) {
            if (shape[0] != this.length()) {
                throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast((INDArray)this, shape));
            }
            return this;
        }
        if (dims == 2) {
            int rc = shape[0];
            int cc = shape[1];
            if (cc != this.length()) {
                throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast((INDArray)this, shape));
            }
            return Matrixx.wrapStrided(this.getArray(), rc, cc, this.getArrayOffset(), 0, this.getStride());
        }
        if (shape[dims - 1] != this.length()) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast((INDArray)this, shape));
        }
        int[] newStrides = new int[dims];
        newStrides[dims - 1] = this.getStride();
        return Arrayz.wrapStrided(this.getArray(), this.getArrayOffset(), shape, newStrides);
    }

    @Override
    public AStridedMatrix broadcastLike(AMatrix target) {
        if (this.length() == target.columnCount()) {
            return StridedMatrix.wrap(this.getArray(), target.rowCount(), this.length(), this.getArrayOffset(), 0, this.getStride());
        }
        throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast((INDArray)this, target));
    }

    @Override
    public AVector selectView(int ... inds) {
        int n = inds.length;
        int[] ix = new int[n];
        int off = this.getArrayOffset();
        int stride = this.getStride();
        for (int i = 0; i < n; ++i) {
            ix[i] = off + stride * inds[i];
        }
        return IndexedArrayVector.wrap(this.getArray(), ix);
    }

    @Override
    public Vector clone() {
        return Vector.create(this);
    }

    @Override
    public abstract void set(AVector var1);

    @Override
    public abstract void setElements(double[] var1, int var2);

    @Override
    public abstract void setElements(int var1, double[] var2, int var3, int var4);

    @Override
    public void add(int offset, AVector a, int aOffset, int length) {
        double[] tdata = this.getArray();
        int stride = this.getStride();
        int toffset = this.getArrayOffset() + offset * stride;
        a.subVector(aOffset, length).addToArray(tdata, toffset, stride);
    }

    @Override
    public abstract void addAt(int var1, double var2);

    @Override
    public void addToArray(int offset, double[] destData, int destOffset, int length) {
        int thisStride = this.getStride();
        int thisOffset = this.getArrayOffset() + offset * thisStride;
        DoubleArrays.add(this.data, thisOffset, thisStride, destData, destOffset, length);
    }

    @Override
    public void addMultipleToArray(double factor, int offset, double[] destData, int destOffset, int length) {
        int thisStride = this.getStride();
        int thisOffset = this.getArrayOffset() + offset * thisStride;
        DoubleArrays.addMultiple(destData, destOffset, this.data, thisOffset, thisStride, length, factor);
    }

    @Override
    public void addToArray(double[] dest, int destOffset, int destStride) {
        int stride = this.getStride();
        double[] tdata = this.getArray();
        int toffset = this.getArrayOffset();
        for (int i = 0; i < this.length; ++i) {
            int n = destOffset + i * destStride;
            dest[n] = dest[n] + tdata[toffset + i * stride];
        }
    }

    @Override
    public abstract void applyOp(Op var1);

    @Override
    public final Vector applyOpCopy(Op op) {
        double[] da = this.toDoubleArray();
        op.applyTo(da);
        return Vector.wrap(da);
    }

    @Override
    public double reduce(Op2 op, double init) {
        int stride = this.getStride();
        int offset = this.getArrayOffset();
        return op.reduce(init, this.data, offset, this.length, stride);
    }

    @Override
    public double reduce(Op2 op) {
        return DoubleArrays.reduce(op, this.data, this.getArrayOffset(), this.length, this.getStride());
    }

    @Override
    public void copyTo(int offset, double[] dest, int destOffset, int length, int stride) {
        int thisStride = this.getStride();
        int thisOffset = this.getArrayOffset();
        for (int i = offset; i < length; ++i) {
            dest[destOffset + i * stride] = this.data[thisOffset + i * thisStride];
        }
    }

    @Override
    public boolean hasUncountable() {
        int stride = this.getStride();
        int offset = this.getArrayOffset();
        for (int i = 0; i < this.length; ++i) {
            double v = this.data[offset + i * stride];
            if (!Vectorz.isUncountable(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double[] asDoubleArray() {
        if (this.isPackedArray()) {
            return this.getArray();
        }
        return null;
    }

    @Override
    public boolean isPackedArray() {
        return this.getStride() == 1 && this.getArrayOffset() == 0 && this.getArray().length == this.length();
    }

    @Override
    public int[] getStrides() {
        return new int[]{this.getStride()};
    }

    @Override
    public Iterator<Double> iterator() {
        return new StridedElementIterator(this.getArray(), this.getArrayOffset(), this.length(), this.getStride());
    }

    @Override
    public int getStride(int dimension) {
        if (dimension != 0) {
            throw new IllegalArgumentException(ErrorMessages.invalidDimension(this, dimension));
        }
        return this.getStride();
    }

    @Override
    public double elementSquaredSum() {
        return DoubleArrays.elementSquaredSum(this.data, this.getArrayOffset(), this.length, this.getStride());
    }

    @Override
    public void getElements(double[] dest, int destOffset) {
        int offset = this.getArrayOffset();
        int stride = this.getStride();
        for (int i = 0; i < this.length; ++i) {
            dest[destOffset + i] = this.data[offset + i * stride];
        }
    }

    @Override
    public void getElements(double[] dest, int destOffset, int[] indices) {
        int n = indices.length;
        int offset = this.getArrayOffset();
        int stride = this.getStride();
        for (int i = 0; i < n; ++i) {
            dest[destOffset + i] = this.data[offset + stride * indices[i]];
        }
    }

    @Override
    public boolean equals(AVector v) {
        if (this == v) {
            return true;
        }
        int len = this.length();
        if (len != v.length()) {
            return false;
        }
        if (v instanceof ADenseArrayVector) {
            ADenseArrayVector dav = (ADenseArrayVector)v;
            return this.equalsArray(dav.getArray(), dav.getArrayOffset());
        }
        int stride = this.getStride();
        int di = this.getArrayOffset();
        for (int i = 0; i < len; ++i) {
            if (this.data[di + i * stride] == v.unsafeGet(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsArray(double[] vs, int offset) {
        int stride = this.getStride();
        int di = this.getArrayOffset();
        for (int i = 0; i < this.length; ++i) {
            if (vs[offset + i] != this.data[di]) {
                return false;
            }
            di += stride;
        }
        return true;
    }

    @Override
    public double visitNonZero(IndexedElementVisitor elementVisitor) {
        return DoubleArrays.visitNonZero(elementVisitor, this.getArray(), this.getArrayOffset(), this.length(), this.getStride());
    }

    @Override
    public void validate() {
        if (this.length > 0) {
            int offset = this.getArrayOffset();
            if (offset < 0 || offset >= this.data.length) {
                throw new VectorzException("offset out of bounds: " + offset);
            }
            int lastIndex = offset + this.getStride() * (this.length - 1);
            if (lastIndex < 0 || lastIndex >= this.data.length) {
                throw new VectorzException("lastIndex out of bounds: " + lastIndex);
            }
        }
        super.validate();
    }
}

