/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.util.Arrays;
import mikera.indexz.Index;
import mikera.vectorz.AScalar;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector1;
import mikera.vectorz.impl.ASparseVector;
import mikera.vectorz.impl.ImmutableScalar;
import mikera.vectorz.util.IntArrays;

public abstract class ASingleElementVector
extends ASparseVector {
    private static final long serialVersionUID = -5246190958486810285L;
    protected final int index;

    protected ASingleElementVector(int index, int length) {
        super(length);
        this.index = index;
    }

    protected abstract double value();

    protected final int index() {
        return this.index;
    }

    @Override
    public final boolean isMutable() {
        return false;
    }

    @Override
    public final boolean isElementConstrained() {
        return true;
    }

    @Override
    public abstract double dotProduct(AVector var1);

    @Override
    public double dotProduct(double[] data, int offset) {
        return this.value() * data[offset + this.index()];
    }

    @Override
    public int nonSparseElementCount() {
        return 1;
    }

    @Override
    public AVector nonSparseValues() {
        return Vector1.of(this.value());
    }

    @Override
    public Index nonSparseIndex() {
        return Index.of(this.index);
    }

    @Override
    public long nonZeroCount() {
        return this.value() == 0.0 ? 0L : 1L;
    }

    @Override
    public void getElements(double[] dest, int offset) {
        Arrays.fill(dest, offset, offset + this.length, 0.0);
        dest[offset + this.index()] = this.value();
    }

    @Override
    public AScalar slice(int i) {
        this.checkIndex(i);
        if (i == this.index) {
            return ImmutableScalar.create(this.value());
        }
        return ImmutableScalar.ZERO;
    }

    @Override
    public abstract boolean equals(AVector var1);

    @Override
    public int[] nonZeroIndices() {
        if (this.value() == 0.0) {
            return IntArrays.EMPTY_INT_ARRAY;
        }
        return new int[]{this.index};
    }
}

