/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.arrayz.INDArray;
import mikera.vectorz.AVector;
import mikera.vectorz.Op2;
import mikera.vectorz.impl.ADenseArrayVector;
import mikera.vectorz.impl.ASizedVector;
import mikera.vectorz.impl.AStridedVector;
import mikera.vectorz.util.ErrorMessages;

public abstract class AJoinedVector
extends ASizedVector {
    private static final long serialVersionUID = -1931862469605499077L;

    public AJoinedVector(int length) {
        super(length);
    }

    @Override
    public abstract int componentCount();

    @Override
    public abstract AVector getComponent(int var1);

    @Override
    public abstract AJoinedVector withComponents(INDArray ... var1);

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isMutable() {
        long n = this.componentCount();
        int i = 0;
        while ((long)i < n) {
            AVector v = this.getComponent(i);
            if (v.isMutable()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setElements(double[] values, int offset) {
        long n = this.componentCount();
        int i = 0;
        while ((long)i < n) {
            AVector v = this.getComponent(i);
            v.setElements(values, offset);
            offset += v.length();
            ++i;
        }
    }

    @Override
    public void copyTo(AVector dest, int offset) {
        long n = this.componentCount();
        int j = 0;
        while ((long)j < n) {
            AVector v = this.getComponent(j);
            dest.subVector(offset, v.length()).set(v);
            ++j;
        }
    }

    @Override
    public void copyTo(int offset, AVector dest, int destOffset, int length) {
        if (dest instanceof AStridedVector) {
            AStridedVector sv = (AStridedVector)dest;
            if (!sv.isFullyMutable()) {
                throw new IllegalArgumentException("Destination vector is not mutable");
            }
            int stride = sv.getStride();
            this.copyTo(offset, sv.getArray(), sv.getArrayOffset() + destOffset * stride, length, stride);
        } else {
            this.subVector(offset, length).copyTo(dest, destOffset);
        }
    }

    @Override
    public void copyTo(int offset, double[] dest, int destOffset, int length) {
        long n = this.componentCount();
        int vstart = 0;
        int i = 0;
        while ((long)i < n) {
            int send;
            AVector v = this.getComponent(i);
            int vlen = v.length();
            int sstart = Math.max(offset, vstart);
            if (sstart < (send = Math.min(offset + length, vstart + vlen))) {
                v.copyTo(sstart - vstart, dest, destOffset + (sstart - offset), send - sstart);
            } else if (vstart >= offset + length) {
                return;
            }
            vstart += vlen;
            ++i;
        }
    }

    @Override
    public void copyTo(int offset, double[] dest, int destOffset, int length, int stride) {
        long n = this.componentCount();
        int vstart = 0;
        int i = 0;
        while ((long)i < n) {
            int send;
            AVector v = this.getComponent(i);
            int vlen = v.length();
            int sstart = Math.max(offset, vstart);
            if (sstart < (send = Math.min(offset + length, vstart + vlen))) {
                v.copyTo(sstart - vstart, dest, destOffset + stride * (sstart - offset), send - sstart, stride);
            } else if (vstart >= offset + length) {
                return;
            }
            vstart += vlen;
            ++i;
        }
    }

    @Override
    public boolean equals(AVector a) {
        if (this == a) {
            return true;
        }
        if (this.length() != a.length()) {
            return false;
        }
        if (a instanceof ADenseArrayVector) {
            ADenseArrayVector dav = (ADenseArrayVector)a;
            return this.equalsArray(dav.getArray(), dav.getArrayOffset());
        }
        long n = this.componentCount();
        int offset = 0;
        int i = 0;
        while ((long)i < n) {
            int length;
            AVector v = this.getComponent(i);
            if (!v.equals(a.subVector(offset, length = v.length()))) {
                return false;
            }
            offset += length;
            ++i;
        }
        return true;
    }

    @Override
    public boolean equalsArray(double[] values, int offset) {
        long n = this.componentCount();
        int i = 0;
        while ((long)i < n) {
            AVector v = this.getComponent(i);
            if (!v.equalsArray(values, offset)) {
                return false;
            }
            offset += v.length();
            ++i;
        }
        return true;
    }

    @Override
    public void scaleAdd(double factor, AVector b, double bfactor, double constant) {
        long n = this.componentCount();
        int offset = 0;
        int i = 0;
        while ((long)i < n) {
            AVector v = this.getComponent(i);
            int length = v.length();
            v.scaleAdd(factor, b.subVector(offset, length), bfactor, constant);
            offset += length;
            ++i;
        }
    }

    @Override
    public double elementSquaredSum() {
        long n = this.componentCount();
        double result = 0.0;
        int i = 0;
        while ((long)i < n) {
            AVector v = this.getComponent(i);
            result += v.elementSquaredSum();
            ++i;
        }
        return result;
    }

    @Override
    public double elementSum() {
        long n = this.componentCount();
        double result = 0.0;
        int i = 0;
        while ((long)i < n) {
            AVector v = this.getComponent(i);
            result += v.elementSum();
            ++i;
        }
        return result;
    }

    @Override
    public boolean isZero() {
        long n = this.componentCount();
        int i = 0;
        while ((long)i < n) {
            AVector v = this.getComponent(i);
            if (!v.isZero()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean hasUncountable() {
        long n = this.componentCount();
        int i = 0;
        while ((long)i < n) {
            AVector v = this.getComponent(i);
            if (!v.hasUncountable()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        long n = this.componentCount();
        double result = 0.0;
        int i = 0;
        while ((long)i < n) {
            AVector v = this.getComponent(i);
            result += v.dotProduct(data, offset);
            offset += v.length();
            ++i;
        }
        return result;
    }

    @Override
    public double dotProduct(double[] data, int offset, int stride) {
        long n = this.componentCount();
        double result = 0.0;
        int i = 0;
        while ((long)i < n) {
            AVector v = this.getComponent(i);
            result += v.dotProduct(data, offset, stride);
            offset += stride * v.length();
            ++i;
        }
        return result;
    }

    @Override
    public void applyOp(Op2 op, AVector b) {
        long n = this.componentCount();
        this.checkSameLength(b);
        int offset = 0;
        int i = 0;
        while ((long)i < n) {
            AVector v = this.getComponent(i);
            int vlen = v.length();
            v.applyOp(op, b.subVector(offset, vlen));
            offset += vlen;
            ++i;
        }
    }

    @Override
    public void setSparse(double value) {
        long n = this.componentCount();
        int i = 0;
        while ((long)i < n) {
            this.getComponent(i).setSparse(value);
            ++i;
        }
    }

    @Override
    public void addSparse(double value) {
        long n = this.componentCount();
        int i = 0;
        while ((long)i < n) {
            this.getComponent(i).addSparse(value);
            ++i;
        }
    }

    @Override
    public double reduce(Op2 op, double init) {
        long n = this.componentCount();
        double result = init;
        int i = 0;
        while ((long)i < n) {
            AVector v = this.getComponent(i);
            result = v.reduce(op, result);
            ++i;
        }
        return result;
    }

    @Override
    public double reduce(Op2 op) {
        AVector v;
        long n = this.componentCount();
        int i = 0;
        double result = Double.NaN;
        while ((long)i < n) {
            v = this.getComponent(i);
            if (v.length() != 0) {
                result = v.reduce(op);
                break;
            }
            ++i;
        }
        if ((long)(++i) > n) {
            throw new IllegalArgumentException(ErrorMessages.zeroElementReduce(this));
        }
        while ((long)i < n) {
            v = this.getComponent(i);
            result = v.reduce(op, result);
            ++i;
        }
        return result;
    }
}

