/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mikera.arrayz.Arrayz;
import mikera.arrayz.INDArray;
import mikera.arrayz.ISparse;
import mikera.arrayz.impl.AbstractArray;
import mikera.arrayz.impl.IDense;
import mikera.arrayz.impl.JoinedArray;
import mikera.arrayz.impl.SliceArray;
import mikera.indexz.AIndex;
import mikera.indexz.Index;
import mikera.matrixx.IMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.algo.Definite;
import mikera.matrixx.algo.Determinant;
import mikera.matrixx.algo.Inverse;
import mikera.matrixx.algo.Multiplications;
import mikera.matrixx.algo.Rank;
import mikera.matrixx.impl.ADenseArrayMatrix;
import mikera.matrixx.impl.ARectangularMatrix;
import mikera.matrixx.impl.AStridedMatrix;
import mikera.matrixx.impl.IdentityMatrix;
import mikera.matrixx.impl.ImmutableMatrix;
import mikera.matrixx.impl.MatrixBandView;
import mikera.matrixx.impl.MatrixColumnList;
import mikera.matrixx.impl.MatrixColumnView;
import mikera.matrixx.impl.MatrixElementIterator;
import mikera.matrixx.impl.MatrixRowIterator;
import mikera.matrixx.impl.MatrixRowList;
import mikera.matrixx.impl.MatrixRowView;
import mikera.matrixx.impl.SparseColumnMatrix;
import mikera.matrixx.impl.SparseRowMatrix;
import mikera.matrixx.impl.SubMatrixView;
import mikera.matrixx.impl.TransposedMatrix;
import mikera.matrixx.impl.ZeroMatrix;
import mikera.randomz.Hash;
import mikera.transformz.AAffineTransform;
import mikera.transformz.AffineMN;
import mikera.transformz.impl.IdentityTranslation;
import mikera.util.Maths;
import mikera.vectorz.AScalar;
import mikera.vectorz.AVector;
import mikera.vectorz.IOperator;
import mikera.vectorz.Op;
import mikera.vectorz.Op2;
import mikera.vectorz.Tools;
import mikera.vectorz.Vector;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.ADenseArrayVector;
import mikera.vectorz.impl.MatrixViewVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.IntArrays;
import mikera.vectorz.util.VectorzException;

public abstract class AMatrix
extends AbstractArray<AVector>
implements IMatrix {
    private static final long serialVersionUID = 4854869374064155441L;

    @Override
    public abstract double get(int var1, int var2);

    @Override
    public abstract void set(int var1, int var2, double var3);

    @Override
    public final double get(int row) {
        throw new VectorzException("1D get not supported on matrix!");
    }

    @Override
    public final double get() {
        throw new VectorzException("0D get not supported on matrix!");
    }

    @Override
    public void set(int row, double value) {
        throw new VectorzException("1D get not supported on matrix!");
    }

    @Override
    public final void set(double value) {
        this.fill(value);
    }

    @Override
    public void fill(double value) {
        int len = this.rowCount();
        for (int i = 0; i < len; ++i) {
            this.getRowView(i).fill(value);
        }
    }

    public void unsafeSet(int i, int j, double value) {
        this.set(i, j, value);
    }

    public double unsafeGet(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public void clamp(double min, double max) {
        int len = this.rowCount();
        for (int i = 0; i < len; ++i) {
            this.getRowView(i).clamp(min, max);
        }
    }

    @Override
    public void pow(double exponent) {
        int len = this.rowCount();
        for (int i = 0; i < len; ++i) {
            AVector v = this.getRowView(i);
            v.pow(exponent);
        }
    }

    @Override
    public void square() {
        int len = this.rowCount();
        for (int i = 0; i < len; ++i) {
            this.getRowView(i).square();
        }
    }

    @Override
    public void set(int[] indexes, double value) {
        if (indexes.length != 2) {
            throw new VectorzException("" + indexes.length + "D set not supported on AMatrix");
        }
        this.set(indexes[0], indexes[1], value);
    }

    @Override
    public void set(long[] indexes, double value) {
        if (indexes.length != 2) {
            throw new VectorzException("" + indexes.length + "D set not supported on AMatrix");
        }
        this.set(Tools.toInt(indexes[0]), Tools.toInt(indexes[1]), value);
    }

    @Override
    public final int dimensionality() {
        return 2;
    }

    public final int inputDimensions() {
        return this.columnCount();
    }

    public final int outputDimensions() {
        return this.rowCount();
    }

    @Override
    public long elementCount() {
        return (long)this.rowCount() * (long)this.columnCount();
    }

    @Override
    public final AVector slice(int row) {
        return this.getRowView(row);
    }

    @Override
    public AVector slice(int dimension, int index) {
        this.checkDimension(dimension);
        return dimension == 0 ? this.getRowView(index) : this.getColumnView(index);
    }

    @Override
    public int sliceCount() {
        return this.rowCount();
    }

    @Override
    public final List<AVector> getSlices() {
        return this.getRows();
    }

    @Override
    public List<AVector> getRows() {
        return new MatrixRowList(this);
    }

    @Override
    public List<AVector> getColumns() {
        return new MatrixColumnList(this);
    }

    @Override
    public final List<AVector> getSlices(int dimension) {
        this.checkDimension(dimension);
        return dimension == 0 ? this.getRows() : this.getColumns();
    }

    @Override
    public List<INDArray> getSliceViews() {
        int rc = this.rowCount();
        ArrayList<INDArray> al = new ArrayList<INDArray>(rc);
        for (int i = 0; i < rc; ++i) {
            al.add(this.getRowView(i));
        }
        return al;
    }

    @Override
    public INDArray join(INDArray a, int dimension) {
        if (a instanceof AMatrix) {
            // empty if block
        }
        return JoinedArray.join(this, a, dimension);
    }

    @Override
    public int[] getShape() {
        return new int[]{this.rowCount(), this.columnCount()};
    }

    @Override
    public int[] getShapeClone() {
        return new int[]{this.rowCount(), this.columnCount()};
    }

    @Override
    public int getShape(int dim) {
        if (dim == 0) {
            return this.rowCount();
        }
        if (dim == 1) {
            return this.columnCount();
        }
        throw new IndexOutOfBoundsException(ErrorMessages.invalidDimension(this, dim));
    }

    @Override
    public long[] getLongShape() {
        return new long[]{this.rowCount(), this.columnCount()};
    }

    @Override
    public double get(int ... indexes) {
        assert (indexes.length == 2);
        return this.get(indexes[0], indexes[1]);
    }

    @Override
    public final double get(AIndex ix) {
        if (ix.length() != 2) {
            throw new IllegalArgumentException(ErrorMessages.invalidIndex((INDArray)this, ix));
        }
        return this.get(ix.get(0), ix.get(1));
    }

    @Override
    public double getElement(long i) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (i < 0L || i >= (long)(rc * cc)) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidElementIndex(this, i));
        }
        return this.unsafeGet((int)(i / (long)cc), (int)(i % (long)cc));
    }

    public AVector getLeadingDiagonal() {
        return this.getBand(0);
    }

    public AAffineTransform toAffineTransform() {
        return new AffineMN(this, IdentityTranslation.create(this.rowCount()));
    }

    @Override
    public boolean isIdentity() {
        int cc;
        int rc = this.rowCount();
        if (rc != (cc = this.columnCount())) {
            return false;
        }
        for (int i = 0; i < rc; ++i) {
            AVector v = this.getRow(i);
            if (v.unsafeGet(i) != 1.0) {
                return false;
            }
            if (!v.isRangeZero(0, i)) {
                return false;
            }
            if (v.isRangeZero(i + 1, cc - i - 1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSquare() {
        return this.rowCount() == this.columnCount();
    }

    public boolean isOrthogonal() {
        return this.isOrthogonal(1.0E-7);
    }

    public boolean isOrthogonal(double tolerance) {
        if (!this.isSquare()) {
            return false;
        }
        int n = this.rowCount();
        List<AVector> cols = this.getColumns();
        for (int i = 0; i < n; ++i) {
            AVector a = cols.get(i);
            if (!a.isUnitLengthVector(tolerance)) {
                return false;
            }
            for (int j = i + 1; j < n; ++j) {
                double val = a.dotProduct(cols.get(j));
                if (!(Math.abs(val) > tolerance)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasOrthonormalColumns() {
        return this.getTranspose().innerProduct(this).epsilonEquals(IdentityMatrix.create(this.columnCount()));
    }

    public boolean hasOrthonormalRows() {
        return this.innerProduct(this.getTranspose()).epsilonEquals(IdentityMatrix.create(this.rowCount()));
    }

    @Override
    public INDArray reshape(int ... dimensions) {
        int ndims = dimensions.length;
        if (ndims == 1) {
            return this.toVector().subVector(0, dimensions[0]);
        }
        if (ndims == 2) {
            return Matrixx.createFromVector(this.asVector(), dimensions[0], dimensions[1]);
        }
        return Arrayz.createFromVector(this.toVector(), dimensions);
    }

    public Matrix reshape(int rows, int cols) {
        return Matrixx.createFromVector(this.asVector(), rows, cols);
    }

    @Override
    public AMatrix reorder(int[] order) {
        return this.reorder(0, order);
    }

    @Override
    public AMatrix reorder(int dim, int[] order) {
        int n = order.length;
        switch (dim) {
            case 0: {
                if (n == 0) {
                    return ZeroMatrix.create(0, this.columnCount());
                }
                if (IntArrays.isRange(order)) {
                    return this.subMatrix(order[0], n, 0, this.columnCount());
                }
                ArrayList<AVector> al = new ArrayList<AVector>(n);
                for (int si : order) {
                    al.add(this.slice(si));
                }
                return SparseRowMatrix.wrap(al);
            }
            case 1: {
                if (n == 0) {
                    return ZeroMatrix.create(this.rowCount(), 0);
                }
                if (IntArrays.isRange(order)) {
                    return this.subMatrix(0, this.rowCount(), order[0], n);
                }
                ArrayList<AVector> al = new ArrayList<AVector>(n);
                for (int si : order) {
                    al.add(this.slice(1, si));
                }
                return SparseColumnMatrix.wrap(al);
            }
        }
        throw new IndexOutOfBoundsException(ErrorMessages.invalidDimension(this, dim));
    }

    @Override
    public AMatrix subMatrix(int rowStart, int rows, int colStart, int cols) {
        if (rows == 0 || cols == 0) {
            return ZeroMatrix.create(rows, cols);
        }
        return new SubMatrixView(this, rowStart, colStart, rows, cols);
    }

    @Override
    public final AMatrix subArray(int[] offsets, int[] shape) {
        if (offsets.length != 2) {
            throw new IllegalArgumentException(ErrorMessages.invalidIndex((INDArray)this, offsets));
        }
        if (shape.length != 2) {
            throw new IllegalArgumentException(ErrorMessages.illegalSize(shape));
        }
        return this.subMatrix(offsets[0], shape[0], offsets[1], shape[1]);
    }

    @Override
    public INDArray rotateView(int dimension, int shift) {
        int n = this.getShape(dimension);
        if (n == 0) {
            return this;
        }
        if ((shift = Maths.mod(shift, n)) == 0) {
            return this;
        }
        int[] off = new int[2];
        int[] shp = this.getShapeClone();
        shp[dimension] = shift;
        AMatrix right = this.subArray(off, shp);
        shp[dimension] = n - shift;
        off[dimension] = shift;
        AMatrix left = this.subArray(off, shp);
        return left.join(right, dimension);
    }

    @Override
    public void transform(AVector source, AVector dest) {
        if (source instanceof Vector && dest instanceof Vector) {
            this.transform((Vector)source, (Vector)dest);
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (source.length() != cc) {
            throw new IllegalArgumentException(ErrorMessages.wrongSourceLength(source));
        }
        if (dest.length() != rc) {
            throw new IllegalArgumentException(ErrorMessages.wrongDestLength(dest));
        }
        for (int row = 0; row < rc; ++row) {
            dest.unsafeSet(row, this.rowDotProduct(row, source));
        }
    }

    public void transform(Vector source, Vector dest) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (source.length() != cc) {
            throw new IllegalArgumentException(ErrorMessages.wrongSourceLength(source));
        }
        if (dest.length() != rc) {
            throw new IllegalArgumentException(ErrorMessages.wrongDestLength(dest));
        }
        for (int row = 0; row < rc; ++row) {
            dest.unsafeSet(row, this.rowDotProduct(row, source));
        }
    }

    @Override
    public void transformInPlace(AVector v) {
        if (v instanceof ADenseArrayVector) {
            this.transformInPlace((ADenseArrayVector)v);
            return;
        }
        double[] temp = new double[v.length()];
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (v.length() != rc) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, (INDArray)v));
        }
        if (rc != cc) {
            throw new UnsupportedOperationException("Cannot transform in place with a non-square transformation");
        }
        for (int row = 0; row < rc; ++row) {
            temp[row] = this.getRow(row).dotProduct(v);
        }
        v.setElements(temp);
    }

    public void transformInPlace(ADenseArrayVector v) {
        double[] temp = new double[v.length()];
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (v.length() != rc) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, (INDArray)v));
        }
        if (rc != cc) {
            throw new UnsupportedOperationException("Cannot transform in place with a non-square transformation");
        }
        double[] data = v.getArray();
        int offset = v.getArrayOffset();
        for (int row = 0; row < rc; ++row) {
            temp[row] = this.getRow(row).dotProduct(data, offset);
        }
        v.setElements(temp);
    }

    @Override
    public AVector getRow(int row) {
        return this.getRowView(row);
    }

    @Override
    public AVector getColumn(int column) {
        return this.getColumnView(column);
    }

    @Override
    public AVector getRowView(int row) {
        return new MatrixRowView(this, row);
    }

    @Override
    public AVector getColumnView(int column) {
        return new MatrixColumnView(this, column);
    }

    @Override
    public AVector getRowClone(int row) {
        int cc = this.columnCount();
        Vector result = Vector.createLength(cc);
        this.copyRowTo(row, result.getArray(), 0);
        return result;
    }

    @Override
    public AVector getColumnClone(int column) {
        int rc = this.rowCount();
        Vector result = Vector.createLength(rc);
        this.copyColumnTo(column, result.getArray(), 0);
        return result;
    }

    public void set(AMatrix a) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        a.checkShape(rc, cc);
        for (int i = 0; i < rc; ++i) {
            this.setRow(i, a.getRow(i));
        }
    }

    @Override
    public void set(INDArray a) {
        if (a instanceof AMatrix) {
            this.set((AMatrix)a);
            return;
        }
        if (a instanceof AVector) {
            this.set((AVector)a);
            return;
        }
        if (a instanceof AScalar) {
            this.set(a.get());
            return;
        }
        super.set(a);
    }

    public void set(AVector v) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).set(v);
        }
    }

    @Override
    public void set(Object o) {
        if (o instanceof INDArray) {
            this.set((INDArray)o);
        } else if (o instanceof Number) {
            this.set(((Number)o).doubleValue());
        } else {
            this.set(Matrixx.toMatrix(o));
        }
    }

    @Override
    public void getElements(double[] dest, int offset) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            this.copyRowTo(i, dest, offset + i * cc);
        }
    }

    @Override
    public final void setElements(double ... values) {
        int vl = values.length;
        if ((long)vl != this.elementCount()) {
            throw new IllegalArgumentException("Incorrect number of elements in array: " + vl);
        }
        this.setElements(values, 0);
    }

    @Override
    public final void setMultiple(INDArray a, double b) {
        if (a instanceof AMatrix) {
            this.setMultiple((AMatrix)a, b);
        } else {
            switch (a.dimensionality()) {
                case 1: {
                    this.setMultiple(a.asVector(), b);
                    return;
                }
                case 0: {
                    this.fill(a.get() * b);
                    return;
                }
            }
        }
        super.setMultiple(a, b);
    }

    @Override
    public void setMultiple(INDArray a, INDArray b) {
        if (a instanceof AMatrix) {
            if (b instanceof AMatrix) {
                this.setMultiple((AMatrix)a, (AMatrix)b);
                return;
            }
            if (b.dimensionality() == 0) {
                this.setMultiple((AMatrix)a, b.get());
            } else {
                this.set((AMatrix)a);
                this.multiply(b);
            }
        } else {
            this.set(a);
            this.multiply(b);
        }
    }

    public void setMultiple(AMatrix a, AMatrix b) {
        this.set(a);
        this.multiply(b);
    }

    public final void setMultiple(AMatrix a, double b) {
        this.set(a);
        this.scale(b);
    }

    public final void setMultiple(AVector a, double b) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).setMultiple(a, b);
        }
    }

    @Override
    public void setElements(double[] values, int offset) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            this.slice(i).setElements(values, offset + i * cc);
        }
    }

    @Override
    public abstract boolean isFullyMutable();

    @Override
    public boolean isMutable() {
        return this.isFullyMutable();
    }

    @Override
    public boolean isElementConstrained() {
        return false;
    }

    @Override
    public AMatrix clone() {
        return Matrix.create(this);
    }

    @Override
    public AMatrix copy() {
        if (this.isMutable()) {
            return this.clone();
        }
        return this;
    }

    @Override
    public AMatrix sparseClone() {
        return Matrixx.createSparse(this);
    }

    @Override
    public AMatrix ensureMutable() {
        if (this.isFullyMutable() && !this.isView()) {
            return this;
        }
        return this.clone();
    }

    public double determinant() {
        return Determinant.calculate(this);
    }

    public int rank() {
        return Rank.compute(this);
    }

    public AMatrix toMutableMatrix() {
        return Matrixx.create(this);
    }

    @Override
    public void transposeInPlace() {
        int dims = this.checkSquare();
        for (int i = 0; i < dims; ++i) {
            AVector row = this.getRowView(i);
            AVector col = this.getColumnView(i);
            for (int j = i + 1; j < dims; ++j) {
                double vc;
                double vr = row.unsafeGet(j);
                if (vr == (vc = col.unsafeGet(j))) continue;
                row.unsafeSet(j, vc);
                col.unsafeSet(j, vr);
            }
        }
    }

    @Override
    public AMatrix getTranspose() {
        return this.getTransposeView();
    }

    @Override
    public AMatrix getTransposeView() {
        return TransposedMatrix.wrap(this);
    }

    @Override
    public AMatrix getTransposeCopy() {
        return this.copy().getTranspose();
    }

    public void add(AMatrix m) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        m.checkShape(rc, cc);
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).add(m.getRow(i));
        }
    }

    public void add(AVector v) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).add(v);
        }
    }

    public void sub(AVector v) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).sub(v);
        }
    }

    @Override
    public final void scaleAdd(double factor, double constant) {
        this.multiply(factor);
        this.add(constant);
    }

    @Override
    public void scaleAdd(double factor, INDArray b, double bfactor, double constant) {
        this.scaleAdd(factor, constant);
        this.addMultiple(b, bfactor);
    }

    @Override
    public void multiply(double factor) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).multiply(factor);
        }
    }

    @Override
    public AMatrix multiplyCopy(double factor) {
        AMatrix r = this.clone();
        r.multiply(factor);
        return r;
    }

    @Override
    public AMatrix divideCopy(double d) {
        AMatrix r = this.clone();
        r.multiply(1.0 / d);
        return r;
    }

    @Override
    public double elementSum() {
        int rc = this.rowCount();
        double result = 0.0;
        for (int i = 0; i < rc; ++i) {
            result += this.getRow(i).elementSum();
        }
        return result;
    }

    @Override
    public double elementSquaredSum() {
        int rc = this.rowCount();
        double result = 0.0;
        for (int i = 0; i < rc; ++i) {
            result += this.getRow(i).elementSquaredSum();
        }
        return result;
    }

    @Override
    public Iterator<Double> elementIterator() {
        return new MatrixElementIterator(this);
    }

    @Override
    public boolean isBoolean() {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            if (this.getRow(i).isBoolean()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long nonZeroCount() {
        long result = 0L;
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            result += this.getRow(i).nonZeroCount();
        }
        return result;
    }

    public void sub(AMatrix m) {
        this.addMultiple(m, -1.0);
    }

    public AMatrix subCopy(AMatrix m) {
        AMatrix r = this.clone();
        r.addMultiple(m, -1.0);
        return r;
    }

    @Override
    public void negate() {
        this.multiply(-1.0);
    }

    @Override
    public void reciprocal() {
        int sc = this.rowCount();
        for (int i = 0; i < sc; ++i) {
            this.getRowView(i).reciprocal();
        }
    }

    @Override
    public void abs() {
        int sc = this.rowCount();
        for (int i = 0; i < sc; ++i) {
            this.getRowView(i).abs();
        }
    }

    @Override
    public void sqrt() {
        int sc = this.rowCount();
        for (int i = 0; i < sc; ++i) {
            this.getRowView(i).sqrt();
        }
    }

    @Override
    public void log() {
        int sc = this.rowCount();
        for (int i = 0; i < sc; ++i) {
            this.getRowView(i).log();
        }
    }

    @Override
    public void exp() {
        int sc = this.rowCount();
        for (int i = 0; i < sc; ++i) {
            this.getRowView(i).exp();
        }
    }

    @Override
    public void signum() {
        int sc = this.rowCount();
        for (int i = 0; i < sc; ++i) {
            this.getRowView(i).signum();
        }
    }

    public void multiply(AMatrix m) {
        int rc = this.rowCount();
        this.checkSameShape(m);
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).multiply(m.getRow(i));
        }
    }

    public void divide(AMatrix m) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        m.checkShape(rc, cc);
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).divide(m.getRow(i));
        }
    }

    public void mul(AMatrix a) {
        this.composeWith(a);
    }

    public void multiplyRow(int i, double factor) {
        this.getRowView(i).multiply(factor);
    }

    public void addRowMultiple(int src, int dst, double factor) {
        if (src == dst) {
            this.getRowView(dst).scale(1.0 + factor);
        } else {
            this.getRowView(dst).addMultiple(this.getRow(src), factor);
        }
    }

    @Override
    public void addInnerProduct(INDArray a, INDArray b) {
        if (a instanceof AMatrix) {
            this.addInnerProduct((AMatrix)a, b);
        } else {
            super.addInnerProduct(a, b);
        }
    }

    @Override
    public final void addInnerProduct(AMatrix a, INDArray b) {
        if (b instanceof AMatrix) {
            this.addInnerProduct(a, (AMatrix)b);
        } else {
            super.addInnerProduct(a, b);
        }
    }

    public void addInnerProduct(AMatrix a, AMatrix b) {
        this.add(a.innerProduct(b));
    }

    @Override
    public void addOuterProduct(INDArray a, INDArray b) {
        if (a instanceof AVector && b instanceof AVector) {
            this.addOuterProduct((AVector)a, (AVector)b);
        } else {
            super.addOuterProduct(a, b);
        }
    }

    @Override
    public void addOuterProductSparse(INDArray a, INDArray b) {
        if (a instanceof AVector && b instanceof AVector) {
            this.addOuterProductSparse((AVector)a, (AVector)b);
        } else {
            super.addOuterProductSparse(a, b);
        }
    }

    public void addOuterProductSparse(AVector a, AVector b) {
        int rc = a.length();
        int cc = b.length();
        this.checkShape(rc, cc);
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).addMultipleSparse(b, a.get(i));
        }
    }

    public void addOuterProduct(AVector a, AVector b) {
        int rc = this.rowCount();
        a.checkLength(rc);
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).addMultiple(b, a.unsafeGet(i));
        }
    }

    @Override
    public void addSparse(INDArray a) {
        if (a instanceof AMatrix) {
            this.addSparse((AMatrix)a);
            return;
        }
        int adims = a.dimensionality();
        if (adims == 0) {
            this.addSparse(a.get());
        } else if (adims == 1) {
            this.addSparse(a.asVector());
        } else {
            super.addSparse(a);
        }
    }

    public void addSparse(AVector a) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).addSparse(a);
        }
    }

    @Override
    public final void setSparse(INDArray a) {
        int dims = a.dimensionality();
        if (dims == 0) {
            this.setSparse(a.get());
        } else if (dims == 1) {
            this.setSparse(a.asVector());
        } else if (dims == 2) {
            this.setSparse(Matrixx.toMatrix(a));
        } else {
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast(a, this));
        }
    }

    public void setSparse(AMatrix a) {
        this.set(a);
    }

    @Override
    public void addToArray(double[] data, int offset) {
        int cc = this.columnCount();
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRow(i).addToArray(data, offset + i * cc);
        }
    }

    public void swapRows(int i, int j) {
        if (i == j) {
            return;
        }
        AVector a = this.getRowView(i);
        AVector b = this.getRowView(j);
        Vectorz.swap(a, b);
    }

    public void swapColumns(int i, int j) {
        if (i == j) {
            return;
        }
        AVector a = this.getColumnView(i);
        AVector b = this.getColumnView(j);
        Vectorz.swap(a, b);
    }

    public void composeWith(AMatrix a) {
        AMatrix t = this.innerProduct(a);
        this.set(t);
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public void addMultiple(INDArray src, double factor) {
        int srcDims = src.dimensionality();
        if (srcDims == 0) {
            this.add(factor * src.get());
        } else if (srcDims == 1) {
            this.addMultiple(src.asVector(), factor);
        } else {
            this.addMultiple(src.broadcastLike(this), factor);
        }
    }

    public void addMultiple(AVector v, double factor) {
        if (factor == 0.0) {
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        v.checkLength(cc);
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).addMultiple(v, factor);
        }
    }

    public void addMultiple(AMatrix m, double factor) {
        if (factor == 0.0) {
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        m.checkShape(rc, cc);
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).addMultiple(m.getRow(i), factor);
        }
    }

    @Override
    public Iterator<AVector> iterator() {
        return new MatrixRowIterator(this);
    }

    @Override
    public final boolean epsilonEquals(INDArray a, double epsilon) {
        if (a instanceof AMatrix) {
            return this.epsilonEquals((AMatrix)a, epsilon);
        }
        if (a.dimensionality() != 2) {
            return false;
        }
        int sc = this.rowCount();
        if (a.sliceCount() != sc) {
            return false;
        }
        for (int i = 0; i < sc; ++i) {
            AVector s = this.getRow(i);
            if (s.epsilonEquals(a.slice(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AMatrix) {
            return this.equals((AMatrix)o);
        }
        if (o instanceof INDArray) {
            return this.equals((INDArray)o);
        }
        return false;
    }

    public boolean equals(AMatrix a) {
        if (a == this) {
            return true;
        }
        if (a instanceof ADenseArrayMatrix) {
            return a.equals(this);
        }
        if (!a.isSameShape(this)) {
            return false;
        }
        return this.equalsByRows(a);
    }

    @Override
    public boolean equalsArray(double[] data, int offset) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            if (this.getRow(i).equalsArray(data, offset + i * cc)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean elementsEqual(double value) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            if (this.getRow(i).elementsEqual(value)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsTranspose(AMatrix a) {
        int rc = this.rowCount();
        if (rc != a.columnCount()) {
            return false;
        }
        int cc = this.columnCount();
        if (cc != a.rowCount()) {
            return false;
        }
        for (int i = 0; i < rc; ++i) {
            if (this.getRow(i).equals(a.getColumn(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(INDArray v) {
        if (v instanceof AMatrix) {
            return this.equals((AMatrix)v);
        }
        if (!this.isSameShape(v)) {
            return false;
        }
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            if (this.getRow(i).equals(v.slice(i))) continue;
            return false;
        }
        return true;
    }

    public final boolean epsilonEquals(AMatrix a) {
        return this.epsilonEquals(a, 1.0E-7);
    }

    public boolean epsilonEquals(AMatrix a, double epsilon) {
        if (a == this) {
            return true;
        }
        int sc = this.rowCount();
        if (a.rowCount() != sc) {
            return false;
        }
        for (int i = 0; i < sc; ++i) {
            AVector s = this.getRow(i);
            if (s.epsilonEquals(a.getRow(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    protected boolean equalsByRows(AMatrix m) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            if (this.getRow(i).equals(m.getRow(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.elementCount() > 10000L) {
            Index shape = Index.create(this.getShape());
            return "Large matrix with shape: " + shape.toString();
        }
        return this.toStringFull();
    }

    @Override
    public String toStringFull() {
        StringBuilder sb = new StringBuilder();
        int rc = this.rowCount();
        sb.append("[");
        for (int i = 0; i < rc; ++i) {
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append(this.getRow(i).toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                hashCode = 31 * hashCode + Hash.hashCode(this.unsafeGet(i, j));
            }
        }
        return hashCode;
    }

    @Override
    public AVector asVector() {
        int rc = this.rowCount();
        if (rc == 0) {
            return Vector0.INSTANCE;
        }
        if (rc == 1) {
            return this.getRowView(0);
        }
        int cc = this.columnCount();
        if (cc == 1) {
            return this.getColumnView(0);
        }
        return new MatrixViewVector(this);
    }

    @Override
    public List<Double> asElementList() {
        return this.asVector().asElementList();
    }

    @Override
    public AMatrix innerProduct(AMatrix a) {
        return Multiplications.multiply(this, a);
    }

    @Override
    public Vector innerProduct(Vector v) {
        int cc = this.columnCount();
        int rc = this.rowCount();
        v.checkLength(cc);
        Vector r = Vector.createLength(rc);
        for (int i = 0; i < rc; ++i) {
            r.unsafeSet(i, this.rowDotProduct(i, v));
        }
        return r;
    }

    @Override
    public AVector innerProduct(AVector v) {
        int cc = this.columnCount();
        int rc = this.rowCount();
        v.checkLength(cc);
        Vector r = Vector.createLength(rc);
        for (int i = 0; i < rc; ++i) {
            r.unsafeSet(i, this.rowDotProduct(i, v));
        }
        return r;
    }

    @Override
    public final AMatrix innerProduct(AScalar s) {
        return this.innerProduct(s.get());
    }

    @Override
    public final AMatrix innerProduct(double d) {
        return this.multiplyCopy(d);
    }

    public AMatrix transposeInnerProduct(AMatrix s) {
        if (s instanceof Matrix) {
            return this.transposeInnerProduct((Matrix)s);
        }
        if (this.isSparse()) {
            AMatrix t = this.getTranspose();
            if (t instanceof TransposedMatrix) {
                t = t.sparseClone();
            }
            return t.innerProduct(s);
        }
        Matrix t = this.toMatrixTranspose();
        return t.innerProduct(s);
    }

    public AMatrix transposeInnerProduct(Matrix s) {
        Matrix r = this.toMatrixTranspose();
        return Multiplications.multiply(r, (AMatrix)s);
    }

    @Override
    public INDArray innerProduct(INDArray a) {
        if (a instanceof AVector) {
            return this.innerProduct((AVector)a);
        }
        if (a instanceof AMatrix) {
            return this.innerProduct((AMatrix)a);
        }
        if (a instanceof AScalar) {
            return this.innerProduct((AScalar)a);
        }
        if (a.dimensionality() <= 2) {
            return this.innerProduct(Arrayz.create(a));
        }
        int rc = this.rowCount();
        List<AVector> al = this.getRows();
        ArrayList<INDArray> rl = new ArrayList<INDArray>(rc);
        for (AVector v : al) {
            rl.add(v.innerProduct(a));
        }
        return SliceArray.create(rl);
    }

    @Override
    public INDArray outerProduct(INDArray a) {
        ArrayList<INDArray> al = new ArrayList<INDArray>(this.sliceCount());
        for (AVector s : this) {
            al.add(s.outerProduct(a));
        }
        return Arrayz.create(al);
    }

    public double rowDotProduct(int i, AVector a) {
        return this.getRow(i).dotProduct(a);
    }

    @Override
    public AMatrix inverse() {
        return Inverse.calculate(this);
    }

    @Override
    public double trace() {
        int rc = Math.min(this.rowCount(), this.columnCount());
        double result = 0.0;
        for (int i = 0; i < rc; ++i) {
            result += this.unsafeGet(i, i);
        }
        return result;
    }

    @Override
    public double diagonalProduct() {
        int rc = Math.min(this.rowCount(), this.columnCount());
        double result = 1.0;
        for (int i = 0; i < rc; ++i) {
            result *= this.unsafeGet(i, i);
        }
        return result;
    }

    @Override
    public boolean isInvertible() {
        return this.isSquare() && this.determinant() != 0.0;
    }

    @Override
    public Vector toVector() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        Vector v = Vector.createLength(rc * cc);
        this.getElements(v.getArray(), 0);
        return v;
    }

    public Matrix toMatrix() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        return Matrix.wrap(rc, cc, this.toDoubleArray());
    }

    public Matrix toMatrixTranspose() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        return Matrix.wrap(cc, rc, this.getTranspose().toDoubleArray());
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        int n = this.rowCount();
        for (int i = 0; i < n; ++i) {
            this.getRow(i).toDoubleBuffer(dest);
        }
    }

    @Override
    public double[] toDoubleArray() {
        double[] result = DoubleArrays.createStorage(this.rowCount(), this.columnCount());
        this.getElements(result, 0);
        return result;
    }

    @Override
    public double[][] toNestedDoubleArrays() {
        int rc = this.rowCount();
        double[][] result = new double[rc][];
        int i = 0;
        for (AVector row : this.getSlices()) {
            result[i++] = row.toDoubleArray();
        }
        return result;
    }

    public AVector[] toSliceArray() {
        int n = this.sliceCount();
        AVector[] result = new AVector[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.slice(i);
        }
        return result;
    }

    @Override
    public double[] asDoubleArray() {
        return null;
    }

    @Override
    public void applyOp(Op op) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).applyOp(op);
        }
    }

    @Override
    public final void setApplyOp(Op op, INDArray a) {
        if (a instanceof AMatrix) {
            this.setApplyOp(op, (AMatrix)a);
        } else {
            super.setApplyOp(op, a);
        }
    }

    public void setApplyOp(Op op, AMatrix a) {
        this.checkSameShape(a);
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).setApplyOp(op, a.getRow(i));
        }
    }

    @Override
    public AMatrix applyOpCopy(Op op) {
        AMatrix r = this.clone();
        r.applyOp(op);
        return r;
    }

    @Override
    public void applyOp(Op2 op, INDArray b) {
        int dims = b.dimensionality();
        if (dims == 0) {
            this.applyOp(op, b.get());
        } else if (dims == 1) {
            this.applyOp(op, b.asVector());
        } else {
            this.applyOp(op, b.broadcastLike(this));
        }
    }

    public void applyOp(Op2 op, AMatrix b) {
        this.checkSameShape(b);
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).applyOp(op, b.getRow(i));
        }
    }

    public void applyOp(Op2 op, AVector b) {
        b.checkLength(this.columnCount());
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).applyOp(op, b);
        }
    }

    @Override
    public void applyOp(Op2 op, double b) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).applyOp(op, b);
        }
    }

    @Override
    public void applyOp(IOperator op) {
        if (op instanceof Op) {
            this.applyOp((Op)op);
            return;
        }
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).applyOp(op);
        }
    }

    @Override
    public double reduce(Op2 op, double init) {
        int rc = this.rowCount();
        double result = init;
        for (int i = 0; i < rc; ++i) {
            result = this.getRow(i).reduce(op, result);
        }
        return result;
    }

    @Override
    public double reduce(Op2 op) {
        int rc = this.rowCount();
        double result = this.getRow(0).reduce(op);
        for (int i = 1; i < rc; ++i) {
            result = this.getRow(i).reduce(op, result);
        }
        return result;
    }

    @Override
    public AVector reduceSlices(Op2 op) {
        int rc = this.rowCount();
        Vector result = Vector.createLength(rc);
        for (int i = 0; i < rc; ++i) {
            ((AVector)result).unsafeSet(i, this.getRow(i).reduce(op));
        }
        return result;
    }

    @Override
    public AVector reduceSlices(Op2 op, double init) {
        int rc = this.rowCount();
        Vector result = Vector.createLength(rc);
        for (int i = 0; i < rc; ++i) {
            ((AVector)result).unsafeSet(i, this.getRow(i).reduce(op, init));
        }
        return result;
    }

    @Override
    public void add(INDArray a) {
        if (a instanceof AMatrix) {
            this.add((AMatrix)a);
        } else if (a instanceof AVector) {
            this.add((AVector)a);
        } else {
            int dims = a.dimensionality();
            if (dims > 2) {
                throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
            }
            if (dims == 0) {
                this.add(a.get());
            } else if (dims == 1) {
                this.add(Vectorz.toVector(a));
            } else if (dims == 2) {
                this.add(Matrixx.toMatrix(a));
            }
        }
    }

    public void multiply(AVector v) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).multiply(v);
        }
    }

    @Override
    public void multiply(INDArray a) {
        if (a instanceof AMatrix) {
            this.multiply((AMatrix)a);
        } else if (a instanceof AVector) {
            this.multiply((AVector)a);
        } else {
            int dims = a.dimensionality();
            if (dims == 0) {
                this.multiply(a.get());
            } else if (dims == 1) {
                this.multiply(Vectorz.toVector(a));
            } else if (dims == 2) {
                this.multiply(Matrixx.toMatrix(a));
            } else {
                throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
            }
        }
    }

    public void divide(AVector v) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).divide(v);
        }
    }

    @Override
    public void divide(INDArray a) {
        if (a instanceof AMatrix) {
            this.divide((AMatrix)a);
        } else if (a instanceof AVector) {
            this.divide((AVector)a);
        } else {
            int dims = a.dimensionality();
            int rc = this.rowCount();
            if (dims == 0) {
                this.divide(a.get());
            } else if (dims == 1) {
                for (int i = 0; i < rc; ++i) {
                    this.slice(i).divide(a);
                }
            } else if (dims == 2) {
                for (int i = 0; i < rc; ++i) {
                    this.slice(i).divide(a.slice(i));
                }
            } else {
                throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
            }
        }
    }

    @Override
    public void divide(double factor) {
        this.multiply(1.0 / factor);
    }

    @Override
    public void sub(INDArray a) {
        if (a instanceof AMatrix) {
            this.sub((AMatrix)a);
        } else if (a instanceof AVector) {
            this.sub((AVector)a);
        } else {
            int dims = a.dimensionality();
            if (dims == 0) {
                this.sub(a.get());
            } else if (dims == 1) {
                this.sub(Vectorz.toVector(a));
            } else if (dims == 2) {
                this.sub(Matrixx.toMatrix(a));
            }
        }
    }

    @Override
    public void add(double d) {
        if (d == 0.0) {
            return;
        }
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRowView(i).add(d);
        }
    }

    @Override
    public void addAt(int i, int j, double d) {
        this.unsafeSet(i, j, this.unsafeGet(i, j) + d);
    }

    @Override
    public INDArray broadcast(int ... targetShape) {
        int tdims = targetShape.length;
        if (tdims < 2) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast((INDArray)this, targetShape));
        }
        if (2 == tdims) {
            this.checkShape(targetShape[0], targetShape[1]);
            return this;
        }
        this.checkShape(targetShape[tdims - 2], targetShape[tdims - 1]);
        INDArray s = this.broadcast(Arrays.copyOfRange(targetShape, 1, tdims));
        return SliceArray.repeat(s, targetShape[0]);
    }

    @Override
    public INDArray broadcastLike(INDArray target) {
        if (target instanceof AMatrix) {
            return this.broadcastLike((AMatrix)target);
        }
        return this.broadcast(target.getShape());
    }

    @Override
    public AMatrix broadcastLike(AMatrix target) {
        this.checkSameShape(target);
        return this;
    }

    @Override
    public INDArray broadcastCloneLike(INDArray target) {
        INDArray r = this;
        if (target.dimensionality() > 2) {
            r = r.broadcastLike(target);
        }
        return r.clone();
    }

    @Override
    public INDArray broadcastCopyLike(INDArray target) {
        INDArray r = this.copy();
        if (target.dimensionality() > 2) {
            r = r.broadcastLike(target);
        }
        return r;
    }

    @Override
    public boolean isZero() {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            if (this.getRow(i).isZero()) continue;
            return false;
        }
        return true;
    }

    public boolean isPositiveDefinite() {
        return Definite.isPositiveDefinite(this);
    }

    @Override
    public boolean isDiagonal() {
        int cc;
        int rc = this.rowCount();
        if (rc != (cc = this.columnCount())) {
            return false;
        }
        for (int i = 0; i < rc; ++i) {
            AVector r = this.getRow(i);
            if (!r.isRangeZero(0, i - 1)) {
                return false;
            }
            if (r.isRangeZero(i + 1, cc - i - 1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSameShape(INDArray a) {
        if (a instanceof AMatrix) {
            return this.isSameShape((AMatrix)a);
        }
        if (a.dimensionality() != 2) {
            return false;
        }
        if (this.getShape(0) != a.getShape(0)) {
            return false;
        }
        return this.getShape(1) == a.getShape(1);
    }

    public boolean isSameShape(AMatrix a) {
        return this.rowCount() == a.rowCount() && this.columnCount() == a.columnCount();
    }

    @Override
    public boolean isRectangularDiagonal() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            AVector r = this.getRow(i);
            if (i < cc) {
                if (!r.isRangeZero(0, i - 1)) {
                    return false;
                }
                if (r.isRangeZero(i + 1, cc - i - 1)) continue;
                return false;
            }
            if (r.isZero()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSymmetric() {
        int cc;
        int rc = this.rowCount();
        if (rc != (cc = this.columnCount())) {
            return false;
        }
        for (int i = 0; i < rc; ++i) {
            if (this.getRow(i).equals(this.getColumn(i))) continue;
            return false;
        }
        return true;
    }

    public final boolean isHermitian() {
        return this.isSymmetric();
    }

    public boolean isUpperTriangular() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 1; i < rc; ++i) {
            if (this.getRow(i).isRangeZero(0, Math.min(i, cc))) continue;
            return false;
        }
        return true;
    }

    public boolean isLowerTriangular() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            int start = Math.min(cc, i + 1);
            if (this.getRow(i).isRangeZero(start, cc - start)) continue;
            return false;
        }
        return true;
    }

    public int upperBandwidthLimit() {
        return this.columnCount() - 1;
    }

    public int lowerBandwidthLimit() {
        return this.rowCount() - 1;
    }

    public int bandLength(int band) {
        return AMatrix.bandLength(this.rowCount(), this.columnCount(), band);
    }

    public final int bandStartRow(int band) {
        return band < 0 ? -band : 0;
    }

    public final int bandStartColumn(int band) {
        return band > 0 ? band : 0;
    }

    protected static final int bandLength(int rc, int cc, int band) {
        if (band > 0) {
            return band < cc ? Math.min(rc, cc - band) : 0;
        }
        return (band = -band) < rc ? Math.min(cc, rc - band) : 0;
    }

    public final int bandIndex(int i, int j) {
        return j - i;
    }

    public final int bandPosition(int i, int j) {
        return Math.min(i, j);
    }

    public int upperBandwidth() {
        for (int w = this.upperBandwidthLimit(); w > 0; --w) {
            if (this.getBand(w).isZero()) continue;
            return w;
        }
        return 0;
    }

    public int lowerBandwidth() {
        for (int w = this.lowerBandwidthLimit(); w > 0; --w) {
            if (this.getBand(-w).isZero()) continue;
            return w;
        }
        return 0;
    }

    @Override
    public AVector getBand(int band) {
        return MatrixBandView.create(this, band);
    }

    public AVector getBandWrapped(int band) {
        int cc;
        AVector result = Vector0.INSTANCE;
        int rc = this.rowCount();
        if (rc < (cc = this.columnCount())) {
            int si = band % rc;
            if (si > 0) {
                si -= rc;
            }
            while (si < cc) {
                result = ((AVector)result).join(this.getBand(si));
                si += rc;
            }
        } else {
            if (cc == 0) {
                return result;
            }
            int si = band % cc;
            if (si < 0) {
                si += cc;
            }
            while (si > -rc) {
                result = ((AVector)result).join(this.getBand(si));
                si -= cc;
            }
        }
        return result;
    }

    public void setRow(int i, AVector row) {
        this.getRowView(i).set(row);
    }

    public void replaceRow(int i, AVector row) {
        throw new UnsupportedOperationException("replaceRow not supported for " + this.getClass() + ". Consider using an AVectorMatrix or SparseRowMatrix instance instead.");
    }

    public void replaceColumn(int i, AVector row) {
        throw new UnsupportedOperationException("replaceColumn not supported for " + this.getClass() + ". Consider using a SparseColumnMatrix instance instead.");
    }

    public void setColumn(int i, AVector col) {
        this.getColumnView(i).set(col);
    }

    @Override
    public abstract AMatrix exactClone();

    @Override
    public INDArray immutable() {
        if (!this.isMutable()) {
            return this;
        }
        return ImmutableMatrix.create(this);
    }

    @Override
    public AMatrix mutable() {
        if (this.isFullyMutable()) {
            return this;
        }
        return this.clone();
    }

    @Override
    public AMatrix sparse() {
        if (this instanceof ISparse) {
            return this;
        }
        return Matrixx.createSparse(this);
    }

    @Override
    public AMatrix dense() {
        if (this instanceof IDense) {
            return this;
        }
        return Matrix.create(this);
    }

    @Override
    public final Matrix denseClone() {
        return Matrix.create(this);
    }

    @Override
    public void validate() {
        if ((long)this.rowCount() * (long)this.columnCount() != this.elementCount()) {
            throw new VectorzException("Invalid Array shape?");
        }
        super.validate();
    }

    public void copyRowTo(int i, double[] dest, int destOffset) {
        int cc = this.columnCount();
        for (int j = 0; j < cc; ++j) {
            dest[destOffset + j] = this.unsafeGet(i, j);
        }
    }

    public void copyColumnTo(int j, double[] dest, int destOffset) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            dest[destOffset + i] = this.unsafeGet(i, j);
        }
    }

    @Override
    public final INDArray addCopy(INDArray a) {
        if (a instanceof AMatrix) {
            return this.addCopy((AMatrix)a);
        }
        switch (a.dimensionality()) {
            case 0: {
                return this.addCopy(a.get());
            }
            case 1: {
                return this.addCopy(a.asVector());
            }
        }
        INDArray r = this.broadcastCloneLike(a);
        r.add(a);
        return r;
    }

    @Override
    public AMatrix addCopy(AMatrix a) {
        AMatrix result = a.clone();
        result.add(this);
        return result;
    }

    @Override
    public AMatrix addCopy(AVector v) {
        int rc = this.rowCount();
        AMatrix result = this.clone();
        for (int i = 0; i < rc; ++i) {
            result.getRowView(i).add(v);
        }
        return result;
    }

    @Override
    public AMatrix addCopy(double d) {
        AMatrix result = this.clone();
        result.add(d);
        return result;
    }

    public Matrix addCopy(AStridedMatrix a) {
        this.checkSameShape(a);
        Matrix result = a.clone();
        this.addToArray(result.data, 0);
        return result;
    }

    @Override
    public boolean hasUncountable() {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            if (!this.getRow(i).hasUncountable()) continue;
            return true;
        }
        return false;
    }

    public int checkSquare() {
        int rc = this.rowCount();
        if (rc != this.columnCount()) {
            throw new UnsupportedOperationException(ErrorMessages.nonSquareMatrix(this));
        }
        return rc;
    }

    protected int checkRowCount(int expected) {
        int rc = this.rowCount();
        if (rc != expected) {
            throw new IllegalArgumentException("Unexpected row count: " + rc + " expected: " + expected);
        }
        return rc;
    }

    protected int checkColumnCount(int expected) {
        int cc = this.columnCount();
        if (cc != expected) {
            throw new IllegalArgumentException("Unexpected column count: " + cc + " expected: " + expected);
        }
        return cc;
    }

    @Override
    protected final void checkDimension(int dimension) {
        if (dimension < 0 || dimension >= 2) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidDimension(this, dimension));
        }
    }

    protected void checkSameShape(AMatrix m) {
        if (this.rowCount() != m.rowCount() || this.columnCount() != m.columnCount()) {
            throw new IndexOutOfBoundsException(ErrorMessages.mismatch(this, m));
        }
    }

    protected void checkSameShape(ARectangularMatrix m) {
        if (this.rowCount() != m.rowCount() || this.columnCount() != m.columnCount()) {
            throw new IndexOutOfBoundsException(ErrorMessages.mismatch(this, m));
        }
    }

    protected void checkShape(int rows, int cols) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (rc != rows || cc != cols) {
            throw new IllegalArgumentException("Unexpected shape: [" + cc + "," + rc + "] expected: [" + rows + "," + cols + "]");
        }
    }

    protected void checkIndex(int i, int j) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (i < 0 || i >= rc || j < 0 || j >= cc) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex((INDArray)this, i, j));
        }
    }

    public int checkColumn(int column) {
        int cc = this.columnCount();
        if (column < 0 || column >= cc) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidSlice(this, 1, column));
        }
        return cc;
    }

    public int checkRow(int row) {
        int rc = this.rowCount();
        if (row < 0 || row >= rc) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidSlice(this, 0, row));
        }
        return rc;
    }

    @Override
    public void add2(AMatrix a, AMatrix b) {
        this.add(a);
        this.add(b);
    }
}

