/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.xml;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectReference;
import org.neodatis.odb.core.layers.layer2.meta.SessionMetaModel;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.oid.OIDFactory;
import org.neodatis.odb.impl.core.layers.layer3.engine.Dummy;
import org.neodatis.odb.impl.tool.ObjectTool;
import org.neodatis.tool.ConsoleLogger;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLImporter
implements ContentHandler {
    private static final String LOG_ID = "XMLImporter";
    private static final int STATE_UNKNOWN = 0;
    private static final int STATE_CLASS_INFO = 1;
    private static final int STATE_OBJECTS = 2;
    private static final int STATE_OBJECT = 3;
    private static final int STATE_ATTRIBUTE = 4;
    private static final int STATE_ATTRIBUTE_COLLECTION = 5;
    private static final int STATE_ATTRIBUTE_ARRAY = 6;
    private static final int STATE_ATTRIBUTE_MAP = 7;
    private static final int STATE_ODB = 8;
    private IStorageEngine storageEngine;
    private MetaModel metaModel;
    private ClassInfo ci;
    private IOdbList<ClassAttributeInfo> classAttributeInfo;
    private int state;
    private NonNativeObjectInfo nnoi;
    private List objectInfos;
    private OID objectId;
    private OID objectClassId;
    private List attributeCollection;
    private String realClassName;
    private Map attributeMap;
    private Object[] attributeArray;
    private int arrayIndex;
    private int currentLevel;
    private OID maxObjectId;
    private int fileFormatVersion;
    private int attributeId;
    private int nbObjects;
    private ILogger externalLogger;

    public XMLImporter(IStorageEngine storageEngine) {
        this.storageEngine = storageEngine;
    }

    public XMLImporter(ODB odb) {
        this.storageEngine = Dummy.getEngine(odb);
    }

    public void importFile(String directory, String filename) throws Exception {
        String fullFileName = directory + "/" + filename;
        this.info("Importing file " + fullFileName);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        XMLReader xmlReader = factory.newSAXParser().getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.parse(fullFileName);
        this.storageEngine.commit();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String tagName, Attributes attributes) throws SAXException {
        ++this.currentLevel;
        try {
            if (tagName.equals("odb")) {
                this.state = 8;
                try {
                    this.maxObjectId = OIDFactory.buildObjectOID(Long.parseLong(attributes.getValue("max-oid")));
                    this.reserveIds(this.maxObjectId, false);
                }
                catch (IOException e) {
                    throw new ODBRuntimeException(NeoDatisError.XML_RESERVING_IDS.addParameter(this.maxObjectId), (Throwable)e);
                }
                try {
                    String version = attributes.getValue("file-format-version");
                    this.fileFormatVersion = version == null || version.length() == 0 ? 8 : Integer.parseInt(version);
                }
                catch (Exception e) {
                    this.fileFormatVersion = 8;
                }
                return;
            }
            if (tagName.equals("meta-model")) {
                this.metaModel = new SessionMetaModel();
                this.info("Importing Meta Model");
                return;
            }
            if (tagName.equals("class")) {
                this.nbObjects = 0;
                this.state = 1;
                String classId = attributes.getValue("id");
                String name = attributes.getValue("name");
                if (this.fileFormatVersion >= 9) {
                    this.ci = new ClassInfo(name, "");
                } else {
                    String packageName = attributes.getValue("package");
                    String fullClassName = packageName + "." + name;
                    this.ci = new ClassInfo(fullClassName, "");
                }
                this.ci.setId(OIDFactory.buildClassOID(Long.parseLong(classId)));
                this.classAttributeInfo = new OdbArrayList<ClassAttributeInfo>();
                this.info(". Importing class " + this.ci.getFullClassName());
                return;
            }
            if (tagName.equals("attribute") && this.state == 1) {
                String id = attributes.getValue("id");
                String name = attributes.getValue("name");
                String type = attributes.getValue("type");
                String isEnum = attributes.getValue("is-enum");
                ClassAttributeInfo cai = new ClassAttributeInfo(Integer.parseInt(id), name, type, null);
                if (isEnum != null && isEnum.equals("true")) {
                    cai = new ClassAttributeInfo(Integer.parseInt(id), name, ODBType.ENUM.getName(), null);
                    ODBType odbType = cai.getAttributeType().copy();
                    odbType.setName(type);
                    cai.setAttributeType(odbType);
                    cai.setFullClassName(type);
                }
                if (cai.getAttributeType().isArray()) {
                    String arrayOfWhat = attributes.getValue("array-of");
                    cai.getAttributeType().setSubType(ODBType.getFromName(arrayOfWhat));
                    cai.setAttributeType(cai.getAttributeType().copy());
                }
                this.classAttributeInfo.add(cai);
                return;
            }
            if (tagName.equals("objects")) {
                this.state = 2;
                this.objectInfos = new ArrayList();
                return;
            }
            if (tagName.equals("object") && this.state == 2) {
                this.state = 3;
                String sObjectId = attributes.getValue("oid");
                this.objectId = OIDFactory.buildObjectOID(Long.parseLong(sObjectId));
                String sObjectClassId = attributes.getValue("class-id");
                this.objectClassId = OIDFactory.buildClassOID(Long.parseLong(sObjectClassId));
                this.nnoi = new NonNativeObjectInfo(this.metaModel.getClassInfoFromId(this.objectClassId));
                this.nnoi.setOid(this.objectId);
                ++this.nbObjects;
                if (this.nbObjects % 1000 == 0) {
                    this.info(". " + this.nbObjects + " objects");
                }
                return;
            }
            if (tagName.equals("attribute") && this.state == 3) {
                ODBType type;
                ClassAttributeInfo cai;
                ClassInfo ci;
                this.state = 4;
                String id = attributes.getValue("id");
                this.attributeId = Integer.parseInt(id);
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                String encoding = OdbConfiguration.getDatabaseCharacterEncoding();
                if (value != null) {
                    value = encoding == null || encoding.equals("no-encoding") ? URLDecoder.decode(value) : URLDecoder.decode(value, encoding);
                }
                String objectRefId = attributes.getValue("ref-oid");
                String sIsNull = attributes.getValue("is-null");
                boolean isNull = false;
                if (sIsNull != null) {
                    isNull = true;
                }
                if ((ci = this.metaModel.getClassInfoFromId(this.objectClassId)) == null) {
                    System.out.println("ci is null");
                }
                if ((cai = ci.getAttributeInfoFromId(this.attributeId)) == null) {
                    System.out.println("cai is null");
                }
                if (((type = cai.getAttributeType()).isArrayOrCollection() || type.isMap()) && !isNull) {
                    this.nnoi.setAttributeValue(this.attributeId, new NullNativeObjectInfo(type.getId()));
                    if (type.isCollection()) {
                        this.state = 5;
                    }
                    if (type.isArray()) {
                        this.state = 6;
                    }
                    if (type.isMap()) {
                        this.state = 7;
                    }
                } else {
                    AbstractObjectInfo aoi = null;
                    if (objectRefId != null) {
                        aoi = new ObjectReference(OIDFactory.buildObjectOID(Long.parseLong(objectRefId)));
                        this.nnoi.setAttributeValue(this.attributeId, aoi);
                    } else if (isNull) {
                        if (type.isNonNative()) {
                            this.nnoi.setAttributeValue(this.attributeId, new NonNativeNullObjectInfo(ci));
                        } else {
                            this.nnoi.setAttributeValue(this.attributeId, new NullNativeObjectInfo(type.getId()));
                        }
                    } else {
                        ClassInfo attributeCi = null;
                        if (type.isEnum()) {
                            attributeCi = this.metaModel.getClassInfo(cai.getFullClassname(), true);
                        }
                        aoi = ObjectTool.stringToObjectInfo(type.getId(), value, ObjectTool.ID_CALLER_IS_XML, attributeCi);
                        this.nnoi.setAttributeValue(this.attributeId, aoi);
                    }
                }
                return;
            }
            if (tagName.equals("collection") && this.state == 5) {
                int size = Integer.parseInt(attributes.getValue("size"));
                this.attributeCollection = new ArrayList(size);
                this.realClassName = attributes.getValue("native-class-name");
                return;
            }
            if (tagName.equals("array") && this.state == 6) {
                int size = Integer.parseInt(attributes.getValue("size"));
                this.attributeArray = new Object[size];
                this.arrayIndex = 0;
                this.realClassName = attributes.getValue("array-of");
                return;
            }
            if (tagName.equals("map") && this.state == 7) {
                int size = Integer.parseInt(attributes.getValue("size"));
                this.attributeMap = new OdbHashMap(size);
                this.realClassName = attributes.getValue("native-class-name");
                return;
            }
            if (tagName.equals("element") && this.state == 5) {
                String objectRefId = attributes.getValue("ref-oid");
                if (objectRefId != null) {
                    this.attributeCollection.add(new ObjectReference(OIDFactory.buildObjectOID(Long.parseLong(objectRefId))));
                } else {
                    String value = attributes.getValue("value");
                    ODBType type = ODBType.getFromName(attributes.getValue("type"));
                    this.attributeCollection.add(ObjectTool.stringToObjectInfo(type.getId(), value, ObjectTool.ID_CALLER_IS_XML, null));
                }
                return;
            }
            if (tagName.equals("element") && this.state == 6) {
                String objectRefId = attributes.getValue("ref-oid");
                if (objectRefId != null) {
                    this.attributeArray[this.arrayIndex++] = new ObjectReference(OIDFactory.buildObjectOID(Long.parseLong(objectRefId)));
                } else {
                    String value = attributes.getValue("value");
                    ODBType type = ODBType.getFromName(this.realClassName);
                    this.attributeArray[this.arrayIndex++] = ObjectTool.stringToObjectInfo(type.getId(), value, ObjectTool.ID_CALLER_IS_XML, null);
                }
                return;
            }
            if (tagName.equals("element") && this.state == 7) {
                String v;
                String keyRefId = attributes.getValue("key-id");
                String objectRefId = attributes.getValue("ref-oid");
                AbstractObjectInfo key = null;
                AbstractObjectInfo value = null;
                if (keyRefId != null) {
                    key = new ObjectReference(OIDFactory.buildObjectOID(Long.parseLong(keyRefId)));
                } else {
                    v = attributes.getValue("key");
                    String keyType = attributes.getValue("key-type");
                    ODBType type = ODBType.getFromName(keyType);
                    key = ObjectTool.stringToObjectInfo(type.getId(), v, ObjectTool.ID_CALLER_IS_XML, null);
                    if (type.isEnum()) {
                        String ciId = attributes.getValue("enum-class-oid");
                        EnumNativeObjectInfo anoi = (EnumNativeObjectInfo)key;
                        anoi.setEnumClassInfo(this.metaModel.getClassInfoFromId(OIDFactory.buildClassOID(Long.parseLong(ciId))));
                    }
                }
                if (objectRefId != null) {
                    value = new ObjectReference(OIDFactory.buildObjectOID(Long.parseLong(objectRefId)));
                } else {
                    v = attributes.getValue("value");
                    ODBType type = ODBType.getFromName(attributes.getValue("value-type"));
                    value = ObjectTool.stringToObjectInfo(type.getId(), v, ObjectTool.ID_CALLER_IS_XML, null);
                }
                this.attributeMap.put(key, value);
                return;
            }
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.IMPORT_ERROR.addParameter(this.storageEngine.getBaseIdentification().getIdentification()), (Throwable)e);
        }
    }

    private void reserveIds(OID maxOid, boolean onlyFirstBlock) throws IOException {
        long nbOids = maxOid.getObjectId();
        this.info("Allocating " + nbOids + " OIDs (Object IDs)");
        if (onlyFirstBlock) {
            if (nbOids > (long)OdbConfiguration.getNB_IDS_PER_BLOCK()) {
                nbOids = OdbConfiguration.getNB_IDS_PER_BLOCK();
            }
        } else if (nbOids <= (long)OdbConfiguration.getNB_IDS_PER_BLOCK()) {
            return;
        }
        this.storageEngine.getObjectWriter().getIdManager().reserveIds(nbOids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String tagName) throws SAXException {
        try {
            if (tagName.equals("class")) {
                this.ci.setAttributes(this.classAttributeInfo);
                this.metaModel.addClass(this.ci);
                this.state = 0;
                if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                    DLogger.debug("Class " + this.ci.getFullClassName() + " created");
                }
                return;
            }
            if (tagName.equals("meta-model")) {
                this.state = 0;
                this.info("Persisting Meta Model");
                this.storageEngine.setMetaModel(this.metaModel);
                this.info(". Meta Model persisted. " + this.metaModel.getNumberOfClasses() + " classes");
                return;
            }
            if (tagName.equals("object") && this.state == 3) {
                try {
                    this.storageEngine.getObjectWriter().writeNonNativeObjectInfo(this.nnoi.getOid(), this.nnoi, -1L, false, true);
                    if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                        this.info("Object of type " + this.nnoi.getClassInfo().getFullClassName() + " with oid " + this.nnoi.getOid() + " created");
                    }
                }
                catch (Exception e) {
                    throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("in XmlImporter.endElement.writeObjectInfo"), (Throwable)e);
                }
                this.state = 2;
                return;
            }
            if (tagName.equals("attribute") && this.state == 4) {
                this.state = 3;
                return;
            }
            if (tagName.equals("collection") && this.state == 5) {
                CollectionObjectInfo coi = new CollectionObjectInfo(this.attributeCollection);
                coi.setRealCollectionClassName(this.realClassName);
                this.nnoi.setAttributeValue(this.attributeId, coi);
                this.state = 4;
                this.attributeCollection = null;
                this.attributeId = -1;
                return;
            }
            if (tagName.equals("array") && this.state == 6) {
                ArrayObjectInfo aoi = new ArrayObjectInfo(this.attributeArray);
                aoi.setRealArrayComponentClassName(this.realClassName);
                aoi.setOdbType(aoi.getOdbType().copy());
                aoi.getOdbType().setSubType(ODBType.getFromName(this.realClassName));
                this.nnoi.setAttributeValue(this.attributeId, aoi);
                this.state = 4;
                this.attributeArray = null;
                this.attributeId = -1;
                return;
            }
            if (tagName.equals("map") && this.state == 7) {
                MapObjectInfo moi = new MapObjectInfo(this.attributeMap, this.realClassName);
                this.nnoi.setAttributeValue(this.attributeId, moi);
                this.state = 4;
                this.attributeMap = null;
                this.attributeId = -1;
                return;
            }
        }
        finally {
            --this.currentLevel;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    public void setExternalLogger(ILogger logger) {
        this.externalLogger = logger;
    }

    public void logToConsole() {
        this.externalLogger = new ConsoleLogger();
    }

    protected void info(Object o) {
        if (this.externalLogger != null) {
            this.externalLogger.info(o);
        }
    }
}

