/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.transaction;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.odb.impl.core.transaction.Cache;
import org.neodatis.tool.wrappers.OdbThread;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class LazyCache
extends Cache {
    private ReferenceQueue queue = new ReferenceQueue();
    private OdbThread queueThread;

    protected LazyCache(ISession session) {
        super(session, "lazy");
    }

    @Override
    protected void init(ISession session, String name) {
        this.name = name;
        this.session = session;
        this.objects = new OdbHashMap();
        this.oids = new WeakHashMap();
        this.unconnectedZoneOids = new WeakHashMap();
        this.objectInfoPointersCacheFromOid = new WeakHashMap();
        this.insertingObjects = new WeakHashMap();
        this.readingObjectInfo = new WeakHashMap();
        this.objectPositionsByIds = new WeakHashMap();
    }

    @Override
    public void addObject(OID oid, Object object, ObjectInfoHeader objectInfoHeader) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        if (this.checkHeaderPosition() && objectInfoHeader.getPosition() == -1L) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NEGATIVE_POSITION.addParameter("Adding OIH with position = -1"));
        }
        if ((long)this.objects.size() > OdbConfiguration.getMaxNumberOfObjectInCache()) {
            this.manageFullCache();
        }
        this.objects.put(new SoftReference<Object>(object, this.queue), oid);
    }

    @Override
    public void addObjectInfo(ObjectInfoHeader objectInfoHeader) {
        if (objectInfoHeader.getOid() == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        if (objectInfoHeader.getClassInfoId() == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_OBJECT_INFO_HEADER_WITHOUT_CLASS_ID.addParameter(objectInfoHeader.getOid()));
        }
        if ((long)this.objectInfoPointersCacheFromOid.size() > OdbConfiguration.getMaxNumberOfObjectInCache()) {
            this.manageFullCache();
        }
        nbObjects = this.objects.size();
        nbOids = this.oids.size();
        nbOih = this.objectInfoPointersCacheFromOid.size();
    }

    @Override
    public ObjectInfoHeader getObjectInfoHeaderFromOid(OID oid, boolean throwExceptionIfNotFound) {
        ObjectInfoHeader oih = null;
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        Object o = this.objectInfoPointersCacheFromOid.get(new WeakReference<OID>(oid));
        WeakReference wr = (WeakReference)o;
        if (wr == null && throwExceptionIfNotFound) {
            throw new ODBRuntimeException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST_IN_CACHE.addParameter(oid));
        }
        oih = (ObjectInfoHeader)wr.get();
        return oih;
    }

    @Override
    protected void manageFullCache() {
        if (!OdbConfiguration.automaticallyIncreaseCacheSize()) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_IS_FULL.addParameter(this.objectInfoPointersCacheFromOid.size()).addParameter(OdbConfiguration.getMaxNumberOfObjectInCache()));
        }
        OdbConfiguration.setMaxNumberOfObjectInCache((long)((double)OdbConfiguration.getMaxNumberOfObjectInCache() * 1.2));
    }

    @Override
    public OID getOid(Object object, boolean throwExceptionIfNotFound) {
        OID oid;
        WeakReference wr = (WeakReference)this.objects.get(object);
        if (wr != null && (oid = (OID)wr.get()) != null) {
            return oid;
        }
        if (throwExceptionIfNotFound) {
            throw new ODBRuntimeException(NeoDatisError.OBJECT_DOES_NOT_EXIST_IN_CACHE);
        }
        return StorageEngineConstant.NULL_OBJECT_ID;
    }

    @Override
    public Object getObjectWithOid(OID oid) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID.addParameter(oid));
        }
        Object o = this.oids.get(new WeakReference<OID>(oid));
        if (o != null) {
            o = ((WeakReference)o).get();
        }
        return o;
    }

    @Override
    public ObjectInfoHeader getObjectInfoHeaderFromObject(Object object, boolean throwExceptionIfNotFound) {
        WeakReference wkOid = (WeakReference)this.objects.get(object);
        if (wkOid == null) {
            if (throwExceptionIfNotFound) {
                throw new ODBRuntimeException(NeoDatisError.OBJECT_DOES_NOT_EXIST_IN_CACHE.addParameter(object.toString()));
            }
            return null;
        }
        OID oid = (OID)wkOid.get();
        Reference wkOIH = null;
        if (wkOIH == null) {
            if (throwExceptionIfNotFound) {
                throw new ODBRuntimeException(NeoDatisError.OBJECT_DOES_NOT_EXIST_IN_CACHE.addParameter(object.toString()));
            }
            return null;
        }
        ObjectInfoHeader oih = (ObjectInfoHeader)wkOIH.get();
        if (oih == null && throwExceptionIfNotFound) {
            throw new ODBRuntimeException(NeoDatisError.OBJECT_DOES_NOT_EXIST_IN_CACHE.addParameter(object.toString()));
        }
        return oih;
    }

    @Override
    protected boolean checkHeaderPosition() {
        return false;
    }

    public ReferenceQueue getQueue() {
        return this.queue;
    }
}

